/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.search.SearchTrackingComponent;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class AlfrescoModelsDiff
extends DeclarativeWebScript {
    protected static final Log logger = LogFactory.getLog(AlfrescoModelsDiff.class);
    private static final String MSG_IO_EXCEPTION = "IO exception parsing request ";
    private static final String MSG_JSON_EXCEPTION = "Unable to fetch model changes from ";
    private SearchTrackingComponent searchTrackingComponent;

    public void setSearchTrackingComponent(SearchTrackingComponent searchTrackingComponent) {
        this.searchTrackingComponent = searchTrackingComponent;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        try {
            Map<String, Object> model = this.buildModel(req);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Result: \n\tRequest: " + req + "\n\tModel: " + model));
            }
            return model;
        }
        catch (IOException e) {
            this.setExceptionResponse(req, status, MSG_IO_EXCEPTION, 500, e);
            return null;
        }
        catch (JSONException e) {
            this.setExceptionResponse(req, status, MSG_JSON_EXCEPTION, 400, (Exception)((Object)e));
            return null;
        }
    }

    private void setExceptionResponse(WebScriptRequest req, Status responseStatus, String responseMessage, int statusCode, Exception e) {
        String message = responseMessage + req;
        if (logger.isDebugEnabled()) {
            logger.warn((Object)message, (Throwable)e);
        } else {
            logger.warn((Object)message);
        }
        responseStatus.setCode(statusCode, message);
        responseStatus.setException((Throwable)e);
    }

    private Map<String, Object> buildModel(WebScriptRequest req) throws JSONException, IOException {
        HashMap<String, Object> model = new HashMap<String, Object>(1, 1.0f);
        Content content = req.getContent();
        if (content == null) {
            throw new WebScriptException("Failed to convert request to String");
        }
        JSONObject o = new JSONObject(content.getContent());
        JSONArray jsonModels = o.getJSONArray("models");
        HashMap<QName, Long> models = new HashMap<QName, Long>(jsonModels.length());
        for (int i = 0; i < jsonModels.length(); ++i) {
            JSONObject jsonModel = jsonModels.getJSONObject(i);
            models.put(QName.createQName((String)jsonModel.getString("name")), jsonModel.getLong("checksum"));
        }
        List diffs = this.searchTrackingComponent.getModelDiffs(models);
        model.put("diffs", diffs);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Result: \n\tRequest: " + req + "\n\tModel: " + model));
        }
        return model;
    }
}

