/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.rendition.patch;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class PatchThumbnailsAsRenditionsGet
extends DeclarativeWebScript {
    private static Log logger = LogFactory.getLog(PatchThumbnailsAsRenditionsGet.class);
    private static final StoreRef SPACES_STORE = new StoreRef("workspace", "SpacesStore");
    private static final String QUERY = "TYPE:\"" + ContentModel.TYPE_THUMBNAIL + "\" AND NOT ASPECT:\"" + RenditionModel.ASPECT_VISIBLE_RENDITION + "\" AND NOT ASPECT:\"" + RenditionModel.ASPECT_HIDDEN_RENDITION + "\"";
    private NodeService nodeService;
    private RenditionService renditionService;
    private SearchService searchService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        if (logger.isInfoEnabled()) {
            logger.debug((Object)"Patching legacy thumbnails by applying appropriate rendition aspect");
        }
        List resultNodeRefs = null;
        try (ResultSet types = null;){
            types = this.searchService.query(SPACES_STORE, "lucene", QUERY);
            resultNodeRefs = types.getNodeRefs();
        }
        long patchedNodeRefs = 0L;
        for (NodeRef nodeRef : resultNodeRefs) {
            if (!this.nodeService.exists(nodeRef) || this.renditionService.isRendition(nodeRef)) continue;
            ChildAssociationRef sourceNode = this.renditionService.getSourceNode(nodeRef);
            ChildAssociationRef primaryParent = this.nodeService.getPrimaryParent(nodeRef);
            QName aspectToApply = primaryParent.getParentRef().equals((Object)sourceNode.getParentRef()) ? RenditionModel.ASPECT_HIDDEN_RENDITION : RenditionModel.ASPECT_VISIBLE_RENDITION;
            if (logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Applying aspect ").append(aspectToApply).append(" to node ").append(nodeRef);
                logger.debug((Object)msg.toString());
            }
            this.nodeService.addAspect(nodeRef, aspectToApply, null);
            ++patchedNodeRefs;
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("patchedNodeCount", new Long(patchedNodeRefs));
        return model;
    }
}

