/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.quickshare;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.QuickShareModel;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.web.scripts.quickshare.AbstractQuickShareContent;
import org.alfresco.repo.web.scripts.quickshare.ShareContentPost;
import org.alfresco.service.cmr.quickshare.InvalidSharedIdException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class UnshareContentDelete
extends AbstractQuickShareContent {
    private static final Log logger = LogFactory.getLog(ShareContentPost.class);
    private NodeService nodeService;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        if (!this.isEnabled()) {
            throw new WebScriptException(403, "QuickShare is disabled system-wide");
        }
        Map params = req.getServiceMatch().getTemplateVars();
        String sharedId = (String)params.get("shared_id");
        if (sharedId == null) {
            throw new WebScriptException(400, "A valid sharedId must be specified !");
        }
        try {
            Pair pair = this.quickShareService.getTenantNodeRefFromSharedId(sharedId);
            String networkTenantDomain = (String)pair.getFirst();
            TenantUtil.runAsSystemTenant(() -> {
                this.checkIfCanDeleteSharedLink(sharedId);
                this.quickShareService.unshareContent(sharedId);
                return null;
            }, (String)networkTenantDomain);
            HashMap<String, Object> model = new HashMap<String, Object>(1);
            model.put("success", Boolean.TRUE);
            return model;
        }
        catch (InvalidSharedIdException ex) {
            logger.error((Object)("Unable to find: " + sharedId));
            throw new WebScriptException(404, "Unable to find: " + sharedId);
        }
        catch (InvalidNodeRefException inre) {
            logger.error((Object)("Unable to find: " + sharedId + " [" + inre.getNodeRef() + "]"));
            throw new WebScriptException(404, "Unable to find: " + sharedId);
        }
    }

    private void checkIfCanDeleteSharedLink(String sharedId) {
        String sharedBy;
        NodeRef nodeRef = (NodeRef)this.quickShareService.getTenantNodeRefFromSharedId(sharedId).getSecond();
        if (!this.quickShareService.canDeleteSharedLink(nodeRef, sharedBy = (String)((Object)this.nodeService.getProperty(nodeRef, QuickShareModel.PROP_QSHARE_SHAREDBY)))) {
            throw new WebScriptException(403, "Can't perform unshare action: " + sharedId);
        }
    }
}

