/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.quickshare;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.thumbnail.script.ScriptThumbnail;
import org.alfresco.repo.thumbnail.script.ScriptThumbnailService;
import org.alfresco.repo.web.scripts.quickshare.QuickShareContentGet;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Scriptable;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class QuickShareThumbnailContentGet
extends QuickShareContentGet {
    private static final Log logger = LogFactory.getLog(QuickShareContentGet.class);
    private ThumbnailService thumbnailService;
    private ScriptThumbnailService scriptThumbnailService;
    private ServiceRegistry serviceRegistry;

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    public void setScriptThumbnailService(ScriptThumbnailService scriptThumbnailService) {
        this.scriptThumbnailService = scriptThumbnailService;
    }

    public void setServiceRegistry(ServiceRegistry services) {
        this.serviceRegistry = services;
    }

    @Override
    protected void executeImpl(NodeRef nodeRef, Map<String, String> templateVars, WebScriptRequest req, WebScriptResponse res, Map<String, Object> model, boolean attach) throws IOException {
        String thumbnailName = templateVars.get("thumbnailname");
        if (thumbnailName == null) {
            logger.error((Object)("Thumbnail name was not provided: " + nodeRef));
            throw new WebScriptException(404, "Unable to find " + nodeRef);
        }
        if (model == null) {
            model = new HashMap<String, Object>(1);
        }
        if (req.getParameter("lastModified") != null) {
            model.put("allowBrowserToCache", "true");
        } else {
            model.put("allowBrowserToCache", "false");
        }
        NodeRef thumbnailNodeRef = this.thumbnailService.getThumbnailByName(nodeRef, ContentModel.PROP_CONTENT, thumbnailName);
        if (thumbnailNodeRef == null) {
            boolean qc = false;
            boolean fc = false;
            String c = req.getParameter("c");
            if (c != null) {
                if (c.equals("queue")) {
                    qc = true;
                } else if (c.equals("force")) {
                    fc = true;
                }
            }
            boolean ph = false;
            String phString = req.getParameter("ph");
            if (phString != null) {
                ph = new Boolean(phString);
            }
            Scriptable scope = new BaseScopableProcessorExtension().getScope();
            ScriptNode node = new ScriptNode(nodeRef, this.serviceRegistry, scope);
            if (fc) {
                ScriptThumbnail thumbnailNode = node.createThumbnail(thumbnailName, false);
                if (thumbnailNode != null) {
                    thumbnailNodeRef = thumbnailNode.getNodeRef();
                }
            } else if (qc) {
                node.createThumbnail(thumbnailName, true);
            }
            if (thumbnailNodeRef == null) {
                if (ph) {
                    String phPath = null;
                    ContentData contentData = (ContentData)this.serviceRegistry.getNodeService().getProperty(nodeRef, ContentModel.PROP_CONTENT);
                    if (contentData != null) {
                        phPath = this.scriptThumbnailService.getMimeAwarePlaceHolderResourcePath(thumbnailName, contentData.getMimetype());
                    }
                    if (phPath == null) {
                        throw new WebScriptException(404, "Thumbnail was not found and no place holder resource set for '" + thumbnailName + "'");
                    }
                    model.put("contentPath", phPath);
                } else {
                    throw new WebScriptException(404, "Thumbnail was not found");
                }
            }
        }
        attach = Boolean.valueOf(req.getParameter("a"));
        super.executeImpl(thumbnailNodeRef, templateVars, req, res, model, attach);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("QuickShare - retrieved thumbnail content: " + thumbnailNodeRef + " [" + nodeRef + "," + thumbnailName + "]"));
        }
    }
}

