/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.person;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.person.PersonServiceImpl;
import org.alfresco.repo.tenant.TenantDomainMismatchException;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.servlet.FormData;

public class UserCSVUploadPost
extends DeclarativeWebScript {
    protected static final QName[] COLUMNS = new QName[]{ContentModel.PROP_USERNAME, ContentModel.PROP_FIRSTNAME, ContentModel.PROP_LASTNAME, ContentModel.PROP_EMAIL, null, ContentModel.PROP_PASSWORD, ContentModel.PROP_ORGANIZATION, ContentModel.PROP_JOBTITLE, ContentModel.PROP_LOCATION, ContentModel.PROP_TELEPHONE, ContentModel.PROP_MOBILE, ContentModel.PROP_SKYPE, ContentModel.PROP_INSTANTMSG, ContentModel.PROP_GOOGLEUSERNAME, ContentModel.PROP_COMPANYADDRESS1, ContentModel.PROP_COMPANYADDRESS2, ContentModel.PROP_COMPANYADDRESS3, ContentModel.PROP_COMPANYPOSTCODE, ContentModel.PROP_COMPANYTELEPHONE, ContentModel.PROP_COMPANYFAX, ContentModel.PROP_COMPANYEMAIL};
    private static final String ERROR_BAD_FORM = "person.err.userCSV.invalidForm";
    private static final String ERROR_NO_FILE = "person.err.userCSV.noFile";
    private static final String ERROR_CORRUPT_FILE = "person.err.userCSV.corruptFile";
    private static final String ERROR_GENERAL = "person.err.userCSV.general";
    private static final String ERROR_BLANK_COLUMN = "person.err.userCSV.blankColumn";
    private static final String MSG_CREATED = "person.msg.userCSV.created";
    private static final String MSG_EXISTING = "person.msg.userCSV.existing";
    private static Log logger = LogFactory.getLog(UserCSVUploadPost.class);
    private MutableAuthenticationService authenticationService;
    private AuthorityService authorityService;
    private PersonService personService;
    private TenantService tenantService;
    private DictionaryService dictionaryService;
    private RetryingTransactionHelper retryingTransactionHelper;

    public void setAuthenticationService(MutableAuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status) {
        final ArrayList<Map<QName, String>> users = new ArrayList<Map<QName, String>>();
        final ResourceBundle rb = this.getResources();
        FormData form = (FormData)req.parseContent();
        if (form == null || !form.getIsMultiPart()) {
            throw new ResourceBundleWebScriptException(400, rb, ERROR_BAD_FORM);
        }
        boolean processed = false;
        for (FormData.FormField field : form.getFields()) {
            if (!field.getIsFile()) continue;
            this.processUpload(field.getInputStream(), field.getFilename(), users);
            processed = true;
            break;
        }
        if (!processed) {
            throw new ResourceBundleWebScriptException(400, rb, ERROR_NO_FILE);
        }
        boolean sendEmails = true;
        if (req.getParameter("email") != null) {
            sendEmails = Boolean.parseBoolean(req.getParameter("email"));
        }
        if (form.hasField("email")) {
            sendEmails = Boolean.parseBoolean(((String[])form.getParameters().get("email"))[0]);
        }
        final MutableInt totalUsers = new MutableInt(0);
        final MutableInt addedUsers = new MutableInt(0);
        final HashMap results = new HashMap();
        final boolean doSendEmails = sendEmails;
        RetryingTransactionHelper.RetryingTransactionCallback<Void> work = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                try {
                    UserCSVUploadPost.this.doAddUsers(totalUsers, addedUsers, results, users, rb, doSendEmails);
                    return null;
                }
                catch (Throwable t) {
                    UserTransaction userTrx = RetryingTransactionHelper.getActiveUserTransaction();
                    if (userTrx != null && userTrx.getStatus() != 1) {
                        try {
                            userTrx.setRollbackOnly();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    throw t;
                }
            }
        };
        try {
            this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)work);
        }
        catch (Throwable t) {
            if (t instanceof WebScriptException) {
                throw (WebScriptException)t;
            }
            throw new ResourceBundleWebScriptException(200, rb, ERROR_GENERAL, t);
        }
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("totalUsers", totalUsers);
        model.put("addedUsers", addedUsers);
        model.put("users", results);
        return model;
    }

    private void doAddUsers(MutableInt totalUsers, MutableInt addedUsers, Map<String, String> results, List<Map<QName, String>> users, ResourceBundle rb, boolean sendEmails) {
        for (Map<QName, String> user : users) {
            totalUsers.setValue(totalUsers.intValue() + 1);
            String username = user.get(ContentModel.PROP_USERNAME);
            try {
                username = PersonServiceImpl.updateUsernameForTenancy((String)username, (TenantService)this.tenantService);
            }
            catch (TenantDomainMismatchException e) {
                throw new ResourceBundleWebScriptException(200, rb, ERROR_GENERAL, e);
            }
            if (this.personService.personExists(username)) {
                results.put(username, rb.getString(MSG_EXISTING));
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Not creating user as already exists: " + username + " for " + user));
                continue;
            }
            String password = user.get(ContentModel.PROP_PASSWORD);
            user.remove(ContentModel.PROP_PASSWORD);
            try {
                this.personService.createPerson(user);
                this.authenticationService.createAuthentication(username, password.toCharArray());
                if (sendEmails) {
                    this.personService.notifyPerson(username, password);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Creating user from upload: " + username + " for " + user));
                }
                String msg = MessageFormat.format(rb.getString(MSG_CREATED), user.get(ContentModel.PROP_EMAIL));
                results.put(username, msg);
                addedUsers.setValue(addedUsers.intValue() + 1);
            }
            catch (Throwable t) {
                throw new ResourceBundleWebScriptException(200, rb, ERROR_GENERAL, t);
            }
        }
    }

    protected void processUpload(InputStream input, String filename, List<Map<QName, String>> users) {
        try {
            if (filename != null && filename.length() > 0) {
                if (filename.endsWith(".csv")) {
                    this.processCSVUpload(input, users);
                    return;
                }
                if (filename.endsWith(".xls")) {
                    this.processXLSUpload(input, users);
                    return;
                }
                if (filename.endsWith(".xlsx")) {
                    this.processXLSXUpload(input, users);
                    return;
                }
            }
            this.processCSVUpload(input, users);
        }
        catch (IOException e) {
            throw new ResourceBundleWebScriptException(200, this.getResources(), ERROR_CORRUPT_FILE, e);
        }
    }

    protected void processCSVUpload(InputStream input, List<Map<QName, String>> users) throws IOException {
        CSVFormat format = CSVFormat.EXCEL;
        InputStreamReader reader = new InputStreamReader(input, Charset.forName("UTF-8"));
        CSVParser csv = format.parse((Reader)reader);
        String[][] data = (String[][])csv.getRecords().stream().map(record -> {
            ArrayList recordValues = new ArrayList();
            record.iterator().forEachRemaining(recordValues::add);
            return (String[])recordValues.toArray(String[]::new);
        }).toArray(x$0 -> new String[x$0][]);
        if (data.length > 0) {
            this.processSpreadsheetUpload(data, users);
        }
    }

    protected void processXLSUpload(InputStream input, List<Map<QName, String>> users) throws IOException {
        HSSFWorkbook wb = new HSSFWorkbook(input);
        this.processSpreadsheetUpload((Workbook)wb, users);
    }

    protected void processXLSXUpload(InputStream input, List<Map<QName, String>> users) throws IOException {
        XSSFWorkbook wb = new XSSFWorkbook(input);
        this.processSpreadsheetUpload((Workbook)wb, users);
    }

    private void processSpreadsheetUpload(Workbook wb, List<Map<QName, String>> users) throws IOException {
        if (wb.getNumberOfSheets() > 1) {
            logger.info((Object)("Uploaded Excel file has " + wb.getNumberOfSheets() + " sheets, ignoring  all except the first one"));
        }
        int firstRow = 0;
        Sheet s = wb.getSheetAt(0);
        DataFormatter df = new DataFormatter();
        String[][] data = new String[s.getLastRowNum() + 1][];
        PaneInformation pane = s.getPaneInformation();
        if (pane != null && pane.isFreezePane() && pane.getHorizontalSplitTopRow() > 0) {
            firstRow = pane.getHorizontalSplitTopRow();
            logger.debug((Object)("Skipping excel freeze header of " + firstRow + " rows"));
        }
        for (int row = firstRow; row <= s.getLastRowNum(); ++row) {
            Row r = s.getRow(row);
            if (r == null) continue;
            String[] d = new String[COLUMNS.length];
            for (int cn = 0; cn < COLUMNS.length; ++cn) {
                Cell cell = r.getCell(cn);
                if (cell == null || cell.getCellType() == CellType.BLANK) continue;
                d[cn] = df.formatCellValue(cell);
            }
            data[row] = d;
        }
        this.processSpreadsheetUpload(data, users);
    }

    private void processSpreadsheetUpload(String[][] data, List<Map<QName, String>> users) {
        ArrayList<String> usernameIsUsername = new ArrayList<String>();
        usernameIsUsername.add("username");
        usernameIsUsername.add("user name");
        PropertyDefinition unPD = this.dictionaryService.getProperty(ContentModel.PROP_USERNAME);
        if (unPD != null) {
            if (unPD.getTitle((MessageLookup)this.dictionaryService) != null) {
                usernameIsUsername.add(unPD.getTitle((MessageLookup)this.dictionaryService).toLowerCase());
            }
            if (unPD.getDescription((MessageLookup)this.dictionaryService) != null) {
                usernameIsUsername.add(unPD.getDescription((MessageLookup)this.dictionaryService).toLowerCase());
            }
        }
        for (int lineNumber = 0; lineNumber < data.length; ++lineNumber) {
            String username;
            HashMap<QName, String> user = new HashMap<QName, String>();
            String[] userData = data[lineNumber];
            if (userData == null || userData.length == 0 || userData.length == 1 && userData[0].trim().length() == 0) continue;
            boolean required = true;
            for (int i = 0; i < COLUMNS.length; ++i) {
                if (COLUMNS[i] == null) {
                    required = false;
                    continue;
                }
                String value = null;
                if (userData.length > i) {
                    value = userData[i];
                }
                if (value == null || value.length() == 0) {
                    if (!required) continue;
                    throw new ResourceBundleWebScriptException(200, this.getResources(), ERROR_BLANK_COLUMN, COLUMNS[i].getLocalName(), i + 1, lineNumber + 1);
                }
                user.put(COLUMNS[i], value);
            }
            if (!user.containsKey(ContentModel.PROP_PASSWORD)) {
                user.put(ContentModel.PROP_PASSWORD, "");
            }
            if (usernameIsUsername.contains(username = ((String)user.get(ContentModel.PROP_USERNAME)).toLowerCase())) continue;
            users.add(user);
        }
    }

    protected static class ResourceBundleWebScriptException
    extends WebScriptException {
        private String message;

        public ResourceBundleWebScriptException(int status, ResourceBundle rb, String msgId, Object ... args) {
            super(status, msgId, args);
            this.buildMessageIfPossible(rb, msgId, args);
        }

        public ResourceBundleWebScriptException(int status, ResourceBundle rb, String msgId) {
            super(status, msgId);
            this.buildMessageIfPossible(rb, msgId, new Object[0]);
        }

        public ResourceBundleWebScriptException(int status, ResourceBundle rb, String msgId, Throwable cause) {
            super(status, msgId, cause);
            this.buildMessageIfPossible(rb, msgId, new Object[0]);
        }

        public String getMessage() {
            return this.message;
        }

        private void buildMessageIfPossible(ResourceBundle rb, String msgId, Object ... args) {
            String msg = rb.getString(msgId);
            if (msg != null) {
                this.message = args == null || args.length == 0 ? msg : MessageFormat.format(msg, args);
            }
            if (this.getCause() != null) {
                this.message = this.message + "\n" + this.getCause().getMessage();
            }
        }
    }
}

