/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.facet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.impl.solr.facet.FacetQNameUtils;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetProperties;
import org.alfresco.repo.web.scripts.facet.AbstractSolrFacetConfigAdminWebScript;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class SolrFacetConfigAdminPost
extends AbstractSolrFacetConfigAdminWebScript {
    private static final Log logger = LogFactory.getLog(SolrFacetConfigAdminPost.class);

    @Override
    protected Map<String, Object> unprotectedExecuteImpl(WebScriptRequest req, Status status, Cache cache) {
        try {
            SolrFacetProperties fp = this.parseRequestForFacetProperties(req);
            this.facetService.createFacetNode(fp);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Created facet node: " + fp));
            }
        }
        catch (Throwable t) {
            throw new WebScriptException(400, "Could not save the facet configuration.", t);
        }
        return new HashMap<String, Object>();
    }

    private SolrFacetProperties parseRequestForFacetProperties(WebScriptRequest req) {
        JSONObject json = null;
        try {
            json = new JSONObject(new JSONTokener(req.getContent().getContent()));
            String filterID = json.getString("filterID");
            this.validateFilterID(filterID);
            String facetQNameStr = json.getString("facetQName");
            QName facetQName = FacetQNameUtils.createQName((String)facetQNameStr, (NamespacePrefixResolver)this.namespaceService);
            String displayName = json.getString("displayName");
            String displayControl = json.getString("displayControl");
            int maxFilters = json.getInt("maxFilters");
            int hitThreshold = json.getInt("hitThreshold");
            int minFilterValueLength = json.getInt("minFilterValueLength");
            String sortBy = json.getString("sortBy");
            String scope = this.getValue(String.class, json.opt("scope"), "ALL");
            boolean isEnabled = this.getValue(Boolean.class, json.opt("isEnabled"), false);
            JSONArray scopedSitesJsonArray = this.getValue(JSONArray.class, json.opt("scopedSites"), null);
            Set<String> scopedSites = this.getScopedSites(scopedSitesJsonArray);
            JSONObject customPropJsonObj = this.getValue(JSONObject.class, json.opt("customProperties"), null);
            Set<SolrFacetProperties.CustomProperties> customProps = this.getCustomProperties(customPropJsonObj);
            SolrFacetProperties fp = new SolrFacetProperties.Builder().filterID(filterID).facetQName(facetQName).displayName(displayName).displayControl(displayControl).maxFilters(maxFilters).hitThreshold(hitThreshold).minFilterValueLength(minFilterValueLength).sortBy(sortBy).scope(scope).isEnabled(Boolean.valueOf(isEnabled)).scopedSites(scopedSites).customProperties(customProps).build();
            return fp;
        }
        catch (IOException e) {
            throw new WebScriptException(400, "Could not read content from req.", (Throwable)e);
        }
        catch (JSONException e) {
            throw new WebScriptException(400, "Could not parse JSON from req.", (Throwable)e);
        }
    }
}

