/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.facet;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.search.impl.solr.facet.SolrFacetProperties;
import org.alfresco.repo.web.scripts.facet.AbstractSolrFacetConfigAdminWebScript;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class SolrFacetConfigAdminGet
extends AbstractSolrFacetConfigAdminWebScript {
    private static final Log logger = LogFactory.getLog(SolrFacetConfigAdminGet.class);

    @Override
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        return this.unprotectedExecuteImpl(req, status, cache);
    }

    @Override
    protected Map<String, Object> unprotectedExecuteImpl(WebScriptRequest req, Status status, Cache cache) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        String filterID = (String)templateVars.get("filterID");
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        if (filterID == null) {
            model.put("filters", this.facetService.getFacets());
        } else {
            SolrFacetProperties fp = this.facetService.getFacet(filterID);
            if (fp == null) {
                throw new WebScriptException(404, "Filter not found");
            }
            model.put("filter", fp);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieved all available facets: " + model.values()));
        }
        return model;
    }
}

