/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.content;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.filestore.FileContentReader;
import org.alfresco.repo.web.scripts.MimeTypeUtil;
import org.alfresco.repo.web.util.HttpRangeProcessor;
import org.alfresco.rest.framework.resource.content.CacheDirective;
import org.alfresco.service.cmr.repository.ArchivedIOException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.QName;
import org.alfresco.sync.repo.events.EventPublisher;
import org.alfresco.util.TempFileProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.attachment.Rfc5987Util;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.springframework.util.FileCopyUtils;

public class ContentStreamer
implements ResourceLoaderAware {
    private static final Log logger = LogFactory.getLog(ContentStreamer.class);
    public static final String KEY_ALLOW_BROWSER_TO_CACHE = "allowBrowserToCache";
    public static final String KEY_CACHE_DIRECTIVE = "cacheDirective";
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.US);
    private static final String HEADER_CONTENT_RANGE = "Content-Range";
    private static final String HEADER_CONTENT_LENGTH = "Content-Length";
    private static final String HEADER_ACCEPT_RANGES = "Accept-Ranges";
    private static final String HEADER_RANGE = "Range";
    private static final String HEADER_USER_AGENT = "User-Agent";
    protected NodeService nodeService;
    protected ContentService contentService;
    protected MimetypeService mimetypeService;
    protected ResourceLoader resourceLoader;
    protected EventPublisher eventPublisher;
    protected SiteService siteService;

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void streamContent(WebScriptRequest req, WebScriptResponse res, File file, Long modifiedTime, boolean attach, String attachFileName, Map<String, Object> model) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving content from file " + file.getAbsolutePath() + " (attach: " + attach + ")"));
        }
        String filePath = file.getAbsolutePath();
        String mimetype = "application/octet-stream";
        int extIndex = filePath.lastIndexOf(46);
        if (extIndex != -1) {
            mimetype = this.mimetypeService.getMimetype(filePath.substring(extIndex + 1));
        }
        FileContentReader reader = new FileContentReader(file);
        reader.setMimetype(mimetype);
        reader.setEncoding("UTF-8");
        long lastModified = modifiedTime == null ? file.lastModified() : modifiedTime.longValue();
        Date lastModifiedDate = new Date(lastModified);
        this.streamContentImpl(req, res, (ContentReader)reader, null, null, attach, lastModifiedDate, String.valueOf(lastModifiedDate.getTime()), attachFileName, model);
    }

    public void streamContent(WebScriptRequest req, WebScriptResponse res, NodeRef nodeRef, QName propertyQName, boolean attach, String attachFileName, Map<String, Object> model) throws IOException {
        ContentReader reader;
        Date modified;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving content from node ref " + nodeRef.toString() + " (property: " + propertyQName.toString() + ") (attach: " + attach + ")"));
        }
        if ((modified = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED)) != null) {
            long modifiedSince = -1L;
            String modifiedSinceStr = req.getHeader("If-Modified-Since");
            if (modifiedSinceStr != null) {
                long modDate;
                block7: {
                    try {
                        modifiedSince = dateFormat.parse(modifiedSinceStr).getTime();
                    }
                    catch (Throwable e) {
                        if (!logger.isInfoEnabled()) break block7;
                        logger.info((Object)("Browser sent badly-formatted If-Modified-Since header: " + modifiedSinceStr));
                    }
                }
                if (modifiedSince > 0L && (modDate = modified.getTime() / 1000L * 1000L) <= modifiedSince) {
                    res.setStatus(304);
                    return;
                }
            }
        }
        if ((reader = this.contentService.getReader(nodeRef, propertyQName)) == null || !reader.exists()) {
            throw new WebScriptException(404, "Unable to locate content for node ref " + nodeRef + " (property: " + propertyQName.toString() + ")");
        }
        this.streamContentImpl(req, res, reader, nodeRef, propertyQName, attach, modified, modified == null ? null : Long.toString(modified.getTime()), attachFileName, model);
    }

    public void streamContent(WebScriptRequest req, WebScriptResponse res, String resourcePath, boolean attach, Map<String, Object> model) throws IOException {
        this.streamContent(req, res, resourcePath, attach, null, model);
    }

    protected void streamContent(WebScriptRequest req, WebScriptResponse res, String resourcePath, boolean attach, String attachFileName, Map<String, Object> model) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Retrieving content from resource path " + resourcePath + " (attach: " + attach + ")"));
        }
        String ext = "";
        int extIndex = resourcePath.lastIndexOf(46);
        if (extIndex != -1) {
            ext = resourcePath.substring(extIndex);
        }
        StringBuilder sb = new StringBuilder("classpath:").append(resourcePath);
        String classpathResource = sb.toString();
        long resourceLastModified = this.resourceLoader.getResource(classpathResource).lastModified();
        File file = TempFileProvider.createTempFile((String)"streamContent-", (String)ext);
        InputStream is = this.resourceLoader.getResource(classpathResource).getInputStream();
        FileOutputStream os = new FileOutputStream(file);
        FileCopyUtils.copy((InputStream)is, (OutputStream)os);
        this.streamContent(req, res, file, resourceLastModified, attach, attachFileName, model);
    }

    public void streamContentImpl(WebScriptRequest req, WebScriptResponse res, ContentReader reader, NodeRef nodeRef, QName propertyQName, boolean attach, Date modified, String eTag, String attachFileName, Map<String, Object> model) throws IOException {
        block14: {
            this.setAttachment(req, res, attach, attachFileName);
            String mimetype = MimeTypeUtil.determineMimetype(reader, req, this.mimetypeService);
            res.setHeader(HEADER_ACCEPT_RANGES, "bytes");
            try {
                boolean processedRange = false;
                String range = req.getHeader(HEADER_CONTENT_RANGE);
                long size = reader.getSize();
                String encoding = reader.getEncoding();
                if (range == null) {
                    range = req.getHeader(HEADER_RANGE);
                }
                if (range != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Found content range header: " + range));
                    }
                    if (range.length() > 6) {
                        if (range.indexOf(44) != -1 && (nodeRef == null || propertyQName == null)) {
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)"Multi-range only supported for nodeRefs");
                            }
                        } else {
                            HttpRangeProcessor rangeProcessor = new HttpRangeProcessor(this.contentService);
                            processedRange = rangeProcessor.processRange(res, reader, range.substring(6), nodeRef, propertyQName, mimetype, req.getHeader(HEADER_USER_AGENT));
                        }
                    }
                }
                if (!processedRange) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Sending complete file content...");
                    }
                    res.setContentType(mimetype);
                    res.setContentEncoding(encoding);
                    res.setHeader(HEADER_CONTENT_RANGE, "bytes 0-" + Long.toString(size - 1L) + "/" + Long.toString(size));
                    res.setHeader(HEADER_CONTENT_LENGTH, Long.toString(size));
                    this.setResponseCache(res, modified, eTag, model);
                    reader.getContent(res.getOutputStream());
                }
            }
            catch (SocketException e1) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Client aborted stream read:\n\tcontent: " + reader));
                }
            }
            catch (ArchivedIOException e2) {
                throw e2;
            }
            catch (ContentIOException e3) {
                if (!logger.isInfoEnabled()) break block14;
                logger.info((Object)("Client aborted stream read:\n\tcontent: " + reader));
            }
        }
    }

    public void setAttachment(WebScriptRequest req, WebScriptResponse res, boolean attach, String attachFileName) {
        if (attach) {
            Object headerValue = "attachment";
            if (attachFileName != null && attachFileName.length() > 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Attaching content using filename: " + attachFileName));
                }
                if (req == null) {
                    headerValue = (String)headerValue + "; filename*=UTF-8''" + this.encodeFilename(attachFileName) + "; filename=\"" + this.filterNameForQuotedString(attachFileName) + "\"";
                } else {
                    String userAgent = req.getHeader(HEADER_USER_AGENT);
                    boolean isLegacy = null != userAgent && (userAgent.contains("MSIE 8") || userAgent.contains("MSIE 7"));
                    headerValue = isLegacy ? (String)headerValue + "; filename=\"" + this.encodeFilename(attachFileName) : (String)headerValue + "; filename=\"" + this.filterNameForQuotedString(attachFileName) + "\"; filename*=UTF-8''" + this.encodeFilename(attachFileName);
                }
            }
            res.setHeader("Content-Disposition", (String)headerValue);
        }
    }

    private String encodeFilename(String attachFileName) {
        try {
            return Rfc5987Util.encode((String)attachFileName);
        }
        catch (UnsupportedEncodingException e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)(e.getMessage() + " Changing encoder from Rfc5987Util to java.net.URLEncoder."));
            }
            return URLEncoder.encode(attachFileName, StandardCharsets.UTF_8);
        }
    }

    protected String filterNameForQuotedString(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (this.isValidQuotedStringHeaderParamChar(c)) {
                sb.append(c);
                continue;
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    protected boolean isValidQuotedStringHeaderParamChar(char c) {
        return c < '\u0100' && c != '\u007f' && c != '\"' && c > '\u001f';
    }

    protected void setResponseCache(WebScriptResponse res, Date modified, String eTag, Map<String, Object> model) {
        Object obj;
        Cache cache = new Cache();
        if (model != null && (obj = model.get(KEY_CACHE_DIRECTIVE)) instanceof CacheDirective) {
            CacheDirective cacheDirective = (CacheDirective)obj;
            cache.setNeverCache(cacheDirective.isNeverCache());
            cache.setMustRevalidate(cacheDirective.isMustRevalidate());
            cache.setMaxAge(cacheDirective.getMaxAge());
            cache.setLastModified(cacheDirective.getLastModified());
            cache.setETag(cacheDirective.getETag());
            cache.setIsPublic(cacheDirective.isPublic());
        } else if (model == null || !this.getBooleanValue(model.get(KEY_ALLOW_BROWSER_TO_CACHE))) {
            cache.setNeverCache(false);
            cache.setMustRevalidate(true);
            cache.setMaxAge(Long.valueOf(0L));
            cache.setLastModified(modified);
            cache.setETag(eTag);
        } else {
            cache.setNeverCache(false);
            cache.setMustRevalidate(false);
            cache.setMaxAge(Long.valueOf(31536000L));
            cache.setLastModified(modified);
            cache.setETag(eTag);
        }
        res.setCache(cache);
    }

    private boolean getBooleanValue(Object obj) {
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        return Boolean.TRUE.equals(obj);
    }
}

