/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.blogs;

import java.io.IOException;
import java.util.Map;
import org.alfresco.repo.model.Repository;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.activities.ActivityService;
import org.alfresco.service.cmr.blog.BlogPostInfo;
import org.alfresco.service.cmr.blog.BlogService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONStringer;
import org.json.JSONWriter;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public abstract class AbstractBlogWebScript
extends DeclarativeWebScript {
    protected static final String CONTAINER = "container";
    protected static final String CONTENT = "content";
    protected static final String DATA = "data";
    protected static final String DRAFT = "draft";
    protected static final String EXTERNAL_BLOG_CONFIG = "externalBlogConfig";
    protected static final String POST = "post";
    protected static final String ITEM = "item";
    protected static final String NODE = "node";
    protected static final String PAGE = "page";
    protected static final String SITE = "site";
    protected static final String TAGS = "tags";
    protected static final String TITLE = "title";
    private static Log logger = LogFactory.getLog(AbstractBlogWebScript.class);
    protected Repository repository;
    protected BlogService blogService;
    protected NodeService nodeService;
    protected SiteService siteService;
    protected ActivityService activityService;
    protected ServiceRegistry services;

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setBlogService(BlogService blogService) {
        this.blogService = blogService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setActivityService(ActivityService activityService) {
        this.activityService = activityService;
    }

    protected void addActivityEntry(String event, BlogPostInfo blog, SiteInfo site, WebScriptRequest req, JSONObject json, NodeRef nodeRef) {
        if (site == null) {
            logger.info((Object)("Unable to add activity entry for blog " + event + " as no site given"));
            return;
        }
        Object page = req.getParameter(PAGE);
        if (page == null && json != null && json.containsKey((Object)PAGE)) {
            page = (String)json.get((Object)PAGE);
        }
        if (page == null) {
            page = "blog-postview";
        }
        if (((String)page).indexOf(63) == -1) {
            page = (String)page + "?postId=" + blog.getSystemName();
        }
        String title = blog.getTitle();
        try {
            JSONWriter jsonWriter = new JSONStringer().object().key(TITLE).value((Object)title).key(PAGE).value(page);
            if (nodeRef != null) {
                jsonWriter.key("nodeRef").value((Object)nodeRef.toString());
            }
            String data = jsonWriter.endObject().toString();
            this.activityService.postActivity("org.alfresco.blog.post-" + event, site.getShortName(), "blog", data);
        }
        catch (Exception e) {
            logger.warn((Object)("Error adding blog post " + event + " to activities feed"), (Throwable)e);
        }
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        Map templateVars = req.getServiceMatch().getTemplateVars();
        if (templateVars == null) {
            String error = "No parameters supplied";
            throw new WebScriptException(400, error);
        }
        JSONObject json = null;
        String contentType = req.getContentType();
        if (contentType != null && contentType.indexOf(59) != -1) {
            contentType = contentType.substring(0, contentType.indexOf(59));
        }
        if ("application/json".equals(contentType)) {
            JSONParser parser = new JSONParser();
            try {
                json = (JSONObject)parser.parse(req.getContent().getContent());
            }
            catch (IOException io) {
                throw new WebScriptException(400, "Invalid JSON: " + io.getMessage());
            }
            catch (ParseException pe) {
                throw new WebScriptException(400, "Invalid JSON: " + pe.getMessage());
            }
        }
        NodeRef nodeRef = null;
        SiteInfo site = null;
        BlogPostInfo blog = null;
        if (templateVars.containsKey(SITE)) {
            String siteName = (String)templateVars.get(SITE);
            site = this.siteService.getSite(siteName);
            if (site == null) {
                String error = "Could not find site: " + siteName;
                throw new WebScriptException(404, error);
            }
            if (templateVars.containsKey("path")) {
                String name = (String)templateVars.get("path");
                blog = this.blogService.getBlogPost(siteName, name);
                if (blog == null) {
                    String error = "Could not find blog '" + name + "' for site '" + site.getShortName() + "'";
                    throw new WebScriptException(404, error);
                }
                nodeRef = blog.getNodeRef();
            } else if (this.siteService.hasContainer(siteName, "blog")) {
                nodeRef = this.siteService.getContainer(siteName, "blog");
            }
        } else if (templateVars.containsKey("store_type") && templateVars.containsKey("store_id") && templateVars.containsKey("id")) {
            NodeRef maybeSite;
            NodeRef container;
            StoreRef store = new StoreRef((String)templateVars.get("store_type"), (String)templateVars.get("store_id"));
            nodeRef = new NodeRef(store, (String)templateVars.get("id"));
            if (!this.nodeService.exists(nodeRef)) {
                String error = "Could not find node: " + nodeRef;
                throw new WebScriptException(404, error);
            }
            blog = this.blogService.getForNodeRef(nodeRef);
            if (blog != null && (container = blog.getContainerNodeRef()) != null && (maybeSite = this.nodeService.getPrimaryParent(container).getParentRef()) != null) {
                site = this.siteService.getSite(maybeSite);
            }
        } else {
            String error = "Unsupported template parameters found";
            throw new WebScriptException(400, error);
        }
        return this.executeImpl(site, nodeRef, blog, req, json, status, cache);
    }

    protected abstract Map<String, Object> executeImpl(SiteInfo var1, NodeRef var2, BlogPostInfo var3, WebScriptRequest var4, JSONObject var5, Status var6, Cache var7);
}

