/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.bean;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.model.filefolder.HiddenAspect;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.web.scripts.bean.BaseRemoteStore;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderUtil;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.URLDecoder;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ADMRemoteStore
extends BaseRemoteStore {
    private static final Log logger = LogFactory.getLog(ADMRemoteStore.class);
    private static final String SURF_CONFIG = "surf-config";
    private static final String PATH_COMPONENTS = "components";
    private static final String PATH_PAGES = "pages";
    private static final String PATH_USER = "user";
    private static final String PATH_SITE = "site";
    private static final String USER_CONFIG = ".*\\.user~(.*)~.*";
    private static final String USER_CONFIG_PATTERN = ".*\\.user~(.*)~.*".replaceAll("\\.\\*", "*").replace("\\", "");
    private static final Pattern USER_PATTERN_1 = Pattern.compile(".*/components/.*\\.user~(.*)~.*");
    private static final Pattern USER_PATTERN_2 = Pattern.compile(".*/pages/user/(.*?)(/.*)?$");
    private static final Pattern SITE_PATTERN_1 = Pattern.compile(".*/components/.*\\.site~(.*)~.*");
    private static final Pattern SITE_PATTERN_2 = Pattern.compile(".*/pages/site/(.*?)(/.*)?$");
    protected NodeService nodeService;
    protected NodeService unprotNodeService;
    protected FileFolderService fileFolderService;
    protected NamespaceService namespaceService;
    protected SiteService siteService;
    protected ContentService contentService;
    protected HiddenAspect hiddenAspect;
    protected PermissionService permissionService;
    protected OwnableService ownableService;
    private BehaviourFilter behaviourFilter;
    private static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setUnprotectedNodeService(NodeService nodeService) {
        this.unprotNodeService = nodeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setHiddenAspect(HiddenAspect hiddenAspect) {
        this.hiddenAspect = hiddenAspect;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    @Override
    protected void lastModified(final WebScriptResponse res, String store, final String path) throws IOException {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                String encpath = BaseRemoteStore.encodePath(path);
                FileInfo fileInfo = ADMRemoteStore.this.resolveFilePath(encpath);
                if (fileInfo == null) {
                    throw new WebScriptException("Unable to locate file: " + encpath);
                }
                Writer out = res.getWriter();
                out.write(Long.toString(fileInfo.getModifiedDate().getTime()));
                out.close();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("lastModified: " + Long.toString(fileInfo.getModifiedDate().getTime())));
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected void getDocument(final WebScriptResponse res, String store, final String path) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                block17: {
                    String encpath = BaseRemoteStore.encodePath(path);
                    FileInfo fileInfo = ADMRemoteStore.this.resolveFilePath(encpath);
                    if (fileInfo == null || fileInfo.isFolder()) {
                        res.setStatus(404);
                        return null;
                    }
                    try {
                        ContentReader reader = ADMRemoteStore.this.contentService.getReader(fileInfo.getNodeRef(), ContentModel.PROP_CONTENT);
                        if (reader == null || !reader.exists()) {
                            throw new WebScriptException("No content found for file: " + encpath);
                        }
                        String mimetype = reader.getMimetype();
                        if (mimetype == null || mimetype.length() == 0) {
                            mimetype = "application/octet-stream";
                            int extIndex = encpath.lastIndexOf(46);
                            if (extIndex != -1) {
                                String ext = encpath.substring(extIndex + 1);
                                String mt = (String)ADMRemoteStore.this.mimetypeService.getMimetypesByExtension().get(ext);
                                if (mt != null) {
                                    mimetype = mt;
                                }
                            }
                        }
                        res.setContentType(mimetype);
                        res.setContentEncoding(reader.getEncoding());
                        SimpleDateFormat formatter = new SimpleDateFormat(ADMRemoteStore.PATTERN_RFC1123, Locale.US);
                        formatter.setTimeZone(GMT);
                        res.setHeader("Last-Modified", formatter.format(fileInfo.getModifiedDate()));
                        res.setHeader("Content-Length", Long.toString(reader.getSize()));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("getDocument: " + fileInfo.toString()));
                        }
                        try {
                            reader.getContent(res.getOutputStream());
                        }
                        catch (SocketException e1) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("Client aborted stream read:\n\tnode: " + encpath + "\n\tcontent: " + reader));
                            }
                        }
                        catch (ContentIOException e2) {
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)("Client aborted stream read:\n\tnode: " + encpath + "\n\tcontent: " + reader));
                            }
                        }
                        catch (Throwable err) {
                            if (err.getCause() instanceof SocketException) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("Client aborted stream read:\n\tnode: " + encpath + "\n\tcontent: " + reader));
                                }
                                break block17;
                            }
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)err.getMessage());
                            }
                            res.setStatus(500);
                        }
                    }
                    catch (AccessDeniedException ae) {
                        res.setStatus(401);
                    }
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected void hasDocument(final WebScriptResponse res, String store, final String path) throws IOException {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                String encpath = BaseRemoteStore.encodePath(path);
                FileInfo fileInfo = ADMRemoteStore.this.resolveFilePath(encpath);
                Writer out = res.getWriter();
                out.write(Boolean.toString(fileInfo != null && !fileInfo.isFolder()));
                out.close();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("hasDocument: " + Boolean.toString(fileInfo != null && !fileInfo.isFolder())));
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected void createDocument(WebScriptResponse res, String store, String path, InputStream content) {
        try {
            this.writeDocument(path, content);
        }
        catch (AccessDeniedException ae) {
            res.setStatus(401);
            throw ae;
        }
        catch (FileExistsException feeErr) {
            res.setStatus(409);
            throw feeErr;
        }
    }

    @Override
    protected void createDocuments(WebScriptResponse res, String store, InputStream in) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(in);
            Element docEl = document.getDocumentElement();
            Transformer transformer = (Transformer)ADMRemoteStore.transformer.get();
            for (Node n = docEl.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!(n instanceof Element)) continue;
                String path = ((Element)n).getAttribute("path");
                Document doc = documentBuilder.newDocument();
                for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (!(child instanceof Element)) continue;
                    doc.appendChild(doc.importNode(child, true));
                    break;
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream(512);
                transformer.transform(new DOMSource(doc), new StreamResult(out));
                out.close();
                this.writeDocument(path, new ByteArrayInputStream(out.toByteArray()));
            }
        }
        catch (AccessDeniedException ae) {
            res.setStatus(401);
            throw ae;
        }
        catch (FileExistsException feeErr) {
            res.setStatus(409);
            throw feeErr;
        }
        catch (Exception e) {
            logger.error((Object)e);
            res.setStatus(500);
            throw new AlfrescoRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    protected void writeDocument(final String path, final InputStream content) {
        final String encpath = ADMRemoteStore.encodePath(path);
        final int off = encpath.lastIndexOf(47);
        if (off != -1) {
            String runAsUser = this.getPathRunAsUser(path);
            AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void doWork() throws Exception {
                    FileInfo parentFolder = ADMRemoteStore.this.resolveNodePath(encpath, true, false);
                    if (parentFolder == null) {
                        throw new IllegalStateException("Unable to aquire parent folder reference for path: " + path);
                    }
                    NodeRef parentFolderRef = parentFolder.getNodeRef();
                    ADMRemoteStore.this.behaviourFilter.disableBehaviour(parentFolderRef, ContentModel.ASPECT_AUDITABLE);
                    try {
                        String name = encpath.substring(off + 1);
                        if (ADMRemoteStore.this.nodeService.getChildByName(parentFolderRef, ContentModel.ASSOC_CONTAINS, name) == null) {
                            FileInfo fileInfo = ADMRemoteStore.this.fileFolderService.create(parentFolderRef, name, ContentModel.TYPE_CONTENT);
                            NodeRef nodeRef = fileInfo.getNodeRef();
                            ADMRemoteStore.this.ownableService.setOwner(nodeRef, AuthenticationUtil.getAdminUserName());
                            HashMap<QName, Boolean> aspectProperties = new HashMap<QName, Boolean>(1, 1.0f);
                            aspectProperties.put(ContentModel.PROP_IS_INDEXED, false);
                            ADMRemoteStore.this.unprotNodeService.addAspect(nodeRef, ContentModel.ASPECT_INDEX_CONTROL, aspectProperties);
                            ContentWriter writer = ADMRemoteStore.this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
                            writer.guessMimetype(fileInfo.getName());
                            writer.putContent(content);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("createDocument: " + fileInfo.toString()));
                            }
                        } else {
                            ContentWriter writer = ADMRemoteStore.this.contentService.getWriter(ADMRemoteStore.this.nodeService.getChildByName(parentFolderRef, ContentModel.ASSOC_CONTAINS, name), ContentModel.PROP_CONTENT, true);
                            writer.guessMimetype(name);
                            writer.putContent(content);
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("createDocument (updated): " + name));
                            }
                        }
                    }
                    finally {
                        ADMRemoteStore.this.behaviourFilter.enableBehaviour(parentFolderRef, ContentModel.ASPECT_AUDITABLE);
                    }
                    return null;
                }
            }, (String)runAsUser);
        }
    }

    protected String getPathRunAsUser(String path) {
        String runAsUser = AuthenticationUtil.getFullyAuthenticatedUser();
        String userId = null;
        Matcher matcher = USER_PATTERN_1.matcher(path);
        if (matcher.matches()) {
            userId = matcher.group(1);
        } else {
            matcher = USER_PATTERN_2.matcher(path);
            if (matcher.matches()) {
                userId = matcher.group(1);
            }
        }
        if (userId != null && userId.equals(runAsUser)) {
            runAsUser = AuthenticationUtil.getSystemUserName();
        }
        return runAsUser;
    }

    @Override
    protected void updateDocument(final WebScriptResponse res, String store, final String path, final InputStream content) {
        String runAsUser = this.getPathRunAsUser(path);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                String encpath = BaseRemoteStore.encodePath(path);
                FileInfo fileInfo = ADMRemoteStore.this.resolveFilePath(encpath);
                if (fileInfo == null || fileInfo.isFolder()) {
                    res.setStatus(404);
                    return null;
                }
                try {
                    ContentWriter writer = ADMRemoteStore.this.contentService.getWriter(fileInfo.getNodeRef(), ContentModel.PROP_CONTENT, true);
                    writer.putContent(content);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("updateDocument: " + fileInfo.toString()));
                    }
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                    throw ae;
                }
                return null;
            }
        }, (String)runAsUser);
    }

    @Override
    protected void deleteDocument(final WebScriptResponse res, String store, String path) {
        String encpath = ADMRemoteStore.encodePath(path);
        final FileInfo fileInfo = this.resolveFilePath(encpath);
        if (fileInfo == null || fileInfo.isFolder()) {
            res.setStatus(404);
            return;
        }
        String runAsUser = this.getPathRunAsUser(path);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                try {
                    NodeRef fileRef = fileInfo.getNodeRef();
                    ADMRemoteStore.this.nodeService.addAspect(fileRef, ContentModel.ASPECT_TEMPORARY, null);
                    NodeRef parentFolderRef = ADMRemoteStore.this.unprotNodeService.getPrimaryParent(fileRef).getParentRef();
                    ADMRemoteStore.this.behaviourFilter.disableBehaviour(parentFolderRef, ContentModel.ASPECT_AUDITABLE);
                    try {
                        ADMRemoteStore.this.nodeService.deleteNode(fileRef);
                    }
                    finally {
                        ADMRemoteStore.this.behaviourFilter.enableBehaviour(parentFolderRef, ContentModel.ASPECT_AUDITABLE);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("deleteDocument: " + fileInfo.toString()));
                    }
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                    throw ae;
                }
                return null;
            }
        }, (String)runAsUser);
    }

    @Override
    protected void listDocuments(final WebScriptResponse res, String store, final String path, final boolean recurse) throws IOException {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void doWork() throws Exception {
                res.setContentType("text/plain;charset=UTF-8");
                String encpath = BaseRemoteStore.encodePath(path);
                FileInfo fileInfo = ADMRemoteStore.this.resolveNodePath(encpath, false, true);
                if (fileInfo == null || !fileInfo.isFolder()) {
                    res.setStatus(404);
                    return null;
                }
                try {
                    ADMRemoteStore.this.outputFileNodes(res.getWriter(), fileInfo, ADMRemoteStore.this.aquireSurfConfigRef(encpath, false), "*", recurse);
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                }
                finally {
                    res.getWriter().close();
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected void listDocuments(final WebScriptResponse res, String store, final String path, final String pattern) throws IOException {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void doWork() throws Exception {
                String filePattern;
                res.setContentType("text/plain;charset=UTF-8");
                if (pattern == null || pattern.length() == 0) {
                    filePattern = "*";
                } else {
                    StringBuilder buf = new StringBuilder(pattern.length());
                    StringTokenizer t = new StringTokenizer(pattern, "*");
                    while (t.hasMoreTokens()) {
                        buf.append(BaseRemoteStore.encodePath(t.nextToken()));
                        if (!t.hasMoreTokens()) continue;
                        buf.append('*');
                    }
                    filePattern = buf.toString().replace("\\", "\\\\");
                }
                String encpath = BaseRemoteStore.encodePath(path);
                FileInfo fileInfo = ADMRemoteStore.this.resolveNodePath(encpath, filePattern, false, true);
                if (fileInfo == null || !fileInfo.isFolder()) {
                    res.setStatus(404);
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("listDocuments() pattern: " + filePattern));
                }
                try {
                    ADMRemoteStore.this.outputFileNodes(res.getWriter(), fileInfo, ADMRemoteStore.this.aquireSurfConfigRef(encpath + "/" + filePattern, false), filePattern, false);
                }
                catch (AccessDeniedException ae) {
                    res.setStatus(401);
                }
                finally {
                    res.getWriter().close();
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private FileInfo resolveFilePath(String path) {
        return this.resolveNodePath(path, false, false);
    }

    private FileInfo resolveNodePath(String path, boolean create, boolean isFolder) {
        return this.resolveNodePath(path, null, create, isFolder);
    }

    private FileInfo resolveNodePath(String path, String pattern, boolean create, boolean isFolder) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resolving path: " + path));
        }
        String adminUserName = AuthenticationUtil.getAdminUserName();
        FileInfo result = null;
        if (path != null) {
            ArrayList<String> pathElements = new ArrayList<String>(4);
            StringTokenizer t = new StringTokenizer(path, "/");
            if (t.countTokens() >= 3) {
                t.nextToken();
                t.nextToken();
                while (t.hasMoreTokens()) {
                    pathElements.add(t.nextToken());
                }
                NodeRef surfConfigRef = this.aquireSurfConfigRef(path + (String)(pattern != null ? "/" + pattern : ""), create);
                try {
                    if (surfConfigRef != null) {
                        if (create) {
                            ArrayList<String> folders = isFolder ? pathElements : pathElements.subList(0, pathElements.size() - 1);
                            ArrayList<FileFolderUtil.PathElementDetails> folderDetails = new ArrayList<FileFolderUtil.PathElementDetails>(pathElements.size());
                            HashMap<QName, Boolean> prop = new HashMap<QName, Boolean>(2);
                            prop.put(ContentModel.PROP_IS_INDEXED, false);
                            prop.put(ContentModel.PROP_IS_CONTENT_INDEXED, false);
                            for (String element : folders) {
                                Map aspects = Collections.singletonMap(ContentModel.ASPECT_INDEX_CONTROL, prop);
                                folderDetails.add(new FileFolderUtil.PathElementDetails(element, aspects));
                            }
                            LinkedHashSet allCreatedFolders = new LinkedHashSet();
                            result = FileFolderUtil.makeFolders((FileFolderService)this.fileFolderService, (NodeService)this.nodeService, (NodeRef)surfConfigRef, folderDetails, (QName)ContentModel.TYPE_FOLDER, (BehaviourFilter)this.behaviourFilter, new HashSet<QName>(Arrays.asList(ContentModel.ASPECT_AUDITABLE)), allCreatedFolders);
                            for (NodeRef nodeRef : allCreatedFolders) {
                                this.ownableService.setOwner(nodeRef, adminUserName);
                            }
                        } else {
                            result = this.fileFolderService.resolveNamePath(surfConfigRef, pathElements);
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private NodeRef aquireSurfConfigRef(String path, boolean create) {
        boolean debug = logger.isDebugEnabled();
        String userId = null;
        String siteName = null;
        if (debug) {
            Matcher matcher = USER_PATTERN_1.matcher(path);
            if (matcher.matches()) {
                userId = matcher.group(1);
            } else {
                matcher = USER_PATTERN_2.matcher(path);
                if (matcher.matches()) {
                    userId = matcher.group(1);
                } else {
                    matcher = SITE_PATTERN_1.matcher(path);
                    if (matcher.matches()) {
                        siteName = matcher.group(1);
                    } else {
                        matcher = SITE_PATTERN_2.matcher(path);
                        if (matcher.matches()) {
                            siteName = matcher.group(1);
                        }
                    }
                }
            }
        } else {
            Matcher matcher = SITE_PATTERN_1.matcher(path);
            if (matcher.matches()) {
                siteName = matcher.group(1);
            } else {
                matcher = SITE_PATTERN_2.matcher(path);
                if (matcher.matches()) {
                    siteName = matcher.group(1);
                }
            }
        }
        NodeRef surfConfigRef = null;
        if (siteName != null) {
            NodeRef siteRef;
            if (debug) {
                logger.debug((Object)("...resolved site path id: " + siteName));
            }
            if ((siteRef = this.getSiteNodeRef(siteName)) != null) {
                surfConfigRef = this.getSurfConfigNodeRef(siteRef, create);
            }
        } else {
            if (debug) {
                if (userId != null) {
                    logger.debug((Object)("...resolved user path id: " + userId));
                } else {
                    logger.debug((Object)"...resolved to generic path.");
                }
            }
            surfConfigRef = this.getSurfConfigNodeRef(this.getRootNodeRef(), create);
        }
        return surfConfigRef;
    }

    private NodeRef getSurfConfigNodeRef(NodeRef rootRef) {
        return this.getSurfConfigNodeRef(rootRef, false);
    }

    protected NodeRef getSurfConfigNodeRef(NodeRef rootRef, boolean create) {
        NodeRef surfConfigRef = this.unprotNodeService.getChildByName(rootRef, ContentModel.ASSOC_CONTAINS, SURF_CONFIG);
        if (create && surfConfigRef == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"'surf-config' folder not found under path, creating...");
            }
            QName assocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)SURF_CONFIG);
            HashMap<QName, String> properties = new HashMap<QName, String>(1, 1.0f);
            properties.put(ContentModel.PROP_NAME, SURF_CONFIG);
            ChildAssociationRef ref = this.unprotNodeService.createNode(rootRef, ContentModel.ASSOC_CONTAINS, assocQName, ContentModel.TYPE_FOLDER, properties);
            surfConfigRef = ref.getChildRef();
            this.hiddenAspect.hideNode(ref.getChildRef(), false, false, false);
            this.permissionService.setInheritParentPermissions(surfConfigRef, false);
            String siteName = this.siteService.getSiteShortName(rootRef);
            if (siteName != null) {
                this.ownableService.setOwner(surfConfigRef, AuthenticationUtil.getAdminUserName());
                String siteManagerGroup = this.siteService.getSiteRoleGroup(siteName, "SiteManager");
                this.permissionService.setPermission(surfConfigRef, siteManagerGroup, "SiteManager", true);
            }
        }
        return surfConfigRef;
    }

    protected NodeRef getGlobalComponentsNodeRef() {
        NodeRef result = null;
        NodeRef surfRef = this.getSurfConfigNodeRef(this.siteService.getSiteRoot());
        if (surfRef != null) {
            result = this.nodeService.getChildByName(surfRef, ContentModel.ASSOC_CONTAINS, PATH_COMPONENTS);
        }
        return result;
    }

    protected NodeRef getGlobalUserFolderNodeRef() {
        NodeRef pagesRef;
        NodeRef result = null;
        NodeRef surfRef = this.getSurfConfigNodeRef(this.siteService.getSiteRoot());
        if (surfRef != null && (pagesRef = this.nodeService.getChildByName(surfRef, ContentModel.ASSOC_CONTAINS, PATH_PAGES)) != null) {
            result = this.nodeService.getChildByName(pagesRef, ContentModel.ASSOC_CONTAINS, PATH_USER);
        }
        return result;
    }

    protected String buildUserConfigSearchPattern(String userName) {
        return USER_CONFIG_PATTERN.replace("(*)", ADMRemoteStore.encodePath(userName));
    }

    private NodeRef getRootNodeRef() {
        return this.siteService.getSiteRoot();
    }

    private NodeRef getSiteNodeRef(String shortName) {
        SiteInfo siteInfo = this.siteService.getSite(shortName);
        return siteInfo != null ? siteInfo.getNodeRef() : null;
    }

    private void outputFileNodes(Writer out, FileInfo fileInfo, NodeRef surfConfigRef, String pattern, boolean recurse) throws IOException {
        if (surfConfigRef != null) {
            boolean debug = logger.isDebugEnabled();
            PagingResults<FileInfo> files = this.getFileNodes(fileInfo, pattern, recurse);
            HashMap<NodeRef, String> nameCache = new HashMap<NodeRef, String>();
            for (FileInfo file : files.getPage()) {
                StringBuilder displayPath = new StringBuilder(64);
                NodeRef ref = this.unprotNodeService.getPrimaryParent(file.getNodeRef()).getParentRef();
                while (!ref.equals((Object)surfConfigRef)) {
                    String name = (String)nameCache.get(ref);
                    if (name == null) {
                        name = (String)((Object)this.unprotNodeService.getProperty(ref, ContentModel.PROP_NAME));
                        nameCache.put(ref, name);
                    }
                    displayPath.insert(0, '/');
                    displayPath.insert(0, name);
                    ref = this.unprotNodeService.getPrimaryParent(ref).getParentRef();
                }
                out.write("/alfresco/site-data/");
                out.write(URLDecoder.decode((String)displayPath.toString()));
                out.write(URLDecoder.decode((String)file.getName()));
                out.write(10);
                if (!debug) continue;
                logger.debug((Object)("   /alfresco/site-data/" + displayPath.toString() + file.getName()));
            }
        }
    }

    protected PagingResults<FileInfo> getFileNodes(FileInfo fileInfo, String pattern, boolean recurse) {
        return this.fileFolderService.list(fileInfo.getNodeRef(), true, false, pattern, null, null, new PagingRequest(Integer.MAX_VALUE));
    }
}

