/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.web.scripts.audit.AbstractAuditWebScript;
import org.alfresco.service.cmr.audit.AuditQueryParameters;
import org.alfresco.service.cmr.audit.AuditService;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class AuditEntryDelete
extends AbstractAuditWebScript {
    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(7);
        Long id = this.getId(req);
        if (id == null) {
            throw new WebScriptException(400, "audit.err.entry.id.notProvided");
        }
        final ArrayList auditEntryIds = new ArrayList();
        AuditQueryParameters params = new AuditQueryParameters();
        AuditService.AuditQueryCallback callback = new AuditService.AuditQueryCallback(){

            public boolean valuesRequired() {
                return false;
            }

            public boolean handleAuditEntry(Long entryId, String applicationName, String user, long time, Map<String, Serializable> values) {
                auditEntryIds.add(entryId);
                return false;
            }

            public boolean handleAuditEntryError(Long entryId, String errorMsg, Throwable error) {
                return true;
            }
        };
        params.setToId(id);
        params.setFromId(id);
        this.auditService.auditQuery(callback, params, 1);
        if (auditEntryIds.size() > 0) {
            int deleted = this.auditService.clearAudit(auditEntryIds);
            model.put("deleted", deleted);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Result: \n\tRequest: " + req + "\n\tModel: " + model));
            }
            return model;
        }
        throw new WebScriptException(404, "audit.err.entry.id.notfound", new Object[]{id});
    }
}

