/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.heartbeat.HBBaseDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class RenditionsDataCollector
extends HBBaseDataCollector
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(RenditionsDataCollector.class);
    private DescriptorDAO currentRepoDescriptorDAO;
    private final Map<ThumbnailDefinition, Map<String, AtomicInteger>> renditionRequests = new ConcurrentHashMap<ThumbnailDefinition, Map<String, AtomicInteger>>();

    public RenditionsDataCollector(String collectorId, String collectorVersion, String cronExpression, HeartBeatJobScheduler hbJobScheduler) {
        super(collectorId, collectorVersion, cronExpression, hbJobScheduler);
    }

    public void setCurrentRepoDescriptorDAO(DescriptorDAO currentRepoDescriptorDAO) {
        this.currentRepoDescriptorDAO = currentRepoDescriptorDAO;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)((Object)this), (String)"currentRepoDescriptorDAO", (Object)this.currentRepoDescriptorDAO);
    }

    public void recordRenditionRequest(ThumbnailDefinition rendition, String sourceMimetype) {
        this.renditionRequests.computeIfAbsent(rendition, k -> new ConcurrentHashMap()).computeIfAbsent(sourceMimetype, k -> new AtomicInteger()).incrementAndGet();
    }

    public List<HBData> collectData() {
        LinkedList<HBData> collectedData = new LinkedList<HBData>();
        String systemId = this.currentRepoDescriptorDAO.getDescriptor().getId();
        String collectorId = this.getCollectorId();
        String collectorVersion = this.getCollectorVersion();
        Date timestamp = new Date();
        for (ThumbnailDefinition rendition : this.renditionRequests.keySet()) {
            String renditionName = rendition.getName();
            String targetMimetype = rendition.getMimetype();
            for (Map.Entry<String, AtomicInteger> entry : this.renditionRequests.remove(rendition).entrySet()) {
                String sourceMimetype = entry.getKey();
                AtomicInteger count = entry.getValue();
                HashMap<String, Object> values = new HashMap<String, Object>();
                values.put("rendition", renditionName);
                values.put("count", count.intValue());
                values.put("sourceMimetype", sourceMimetype);
                values.put("targetMimetype", targetMimetype);
                collectedData.add(new HBData(systemId, collectorId, collectorVersion, timestamp, values));
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)(renditionName + " " + count + " " + sourceMimetype + " " + targetMimetype));
            }
        }
        return collectedData;
    }
}

