/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.runtime.Clock;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.DelegationState;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.rest.api.tests.PersonInfo;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.MemberOfSite;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.alfresco.rest.workflow.api.model.ProcessInfo;
import org.alfresco.rest.workflow.api.tests.EnterpriseWorkflowTestApi;
import org.alfresco.rest.workflow.api.tests.WorkflowApiClient;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ISO8601DateFormat;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.http.HttpStatus;

@Category(value={OwnJVMTestsCategory.class})
public class TaskWorkflowApiTest
extends EnterpriseWorkflowTestApi {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTaskById() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String otherPerson = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        RequestContext otherContext = new RequestContext(requestContext.getNetworkId(), otherPerson);
        Calendar createdCal = Calendar.getInstance();
        createdCal.set(14, 0);
        Clock actiClock = this.activitiProcessEngine.getProcessEngineConfiguration().getClock();
        actiClock.setCurrentTime(createdCal.getTime());
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            final Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Calendar dueDateCal = Calendar.getInstance();
            dueDateCal.set(14, 0);
            dueDateCal.add(6, 1);
            Date dueDate = dueDateCal.getTime();
            task.setDescription("This is a test description");
            task.setAssignee(requestContext.getRunAsUser());
            task.setOwner("john");
            task.setDueDate(dueDate);
            this.activitiProcessEngine.getTaskService().saveTask(task);
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject taskJSONObject = tasksClient.findTaskById(task.getId());
            Assert.assertNotNull((Object)taskJSONObject);
            Assert.assertEquals((Object)task.getId(), (Object)taskJSONObject.get((Object)"id"));
            Assert.assertEquals((Object)processInstance.getId(), (Object)taskJSONObject.get((Object)"processId"));
            Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)taskJSONObject.get((Object)"processDefinitionId"));
            Assert.assertEquals((Object)"adhocTask", (Object)taskJSONObject.get((Object)"activityDefinitionId"));
            Assert.assertEquals((Object)"Adhoc Task", (Object)taskJSONObject.get((Object)"name"));
            Assert.assertEquals((Object)"This is a test description", (Object)taskJSONObject.get((Object)"description"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)taskJSONObject.get((Object)"assignee"));
            Assert.assertEquals((Object)"john", (Object)taskJSONObject.get((Object)"owner"));
            Assert.assertEquals((Object)dueDate, (Object)this.parseDate(taskJSONObject, "dueAt"));
            Assert.assertEquals((Object)createdCal.getTime(), (Object)this.parseDate(taskJSONObject, "startedAt"));
            Assert.assertEquals((Object)2L, (Object)taskJSONObject.get((Object)"priority"));
            Assert.assertEquals((Object)"wf:adhocTask", (Object)taskJSONObject.get((Object)"formResourceKey"));
            Assert.assertNull((Object)taskJSONObject.get((Object)"endedAt"));
            Assert.assertNull((Object)taskJSONObject.get((Object)"durationInMs"));
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), null);
            taskJSONObject = tasksClient.findTaskById(task.getId());
            Assert.assertNotNull((Object)taskJSONObject);
            Assert.assertEquals((Object)task.getId(), (Object)taskJSONObject.get((Object)"id"));
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), requestContext.getRunAsUser());
            this.activitiProcessEngine.getTaskService().setOwner(task.getId(), requestContext.getRunAsUser());
            this.activitiProcessEngine.getTaskService().delegateTask(task.getId(), otherContext.getRunAsUser());
            taskJSONObject = tasksClient.findTaskById(task.getId());
            Assert.assertNotNull((Object)taskJSONObject);
            Assert.assertEquals((Object)task.getId(), (Object)taskJSONObject.get((Object)"id"));
            Assert.assertEquals((Object)otherContext.getRunAsUser(), (Object)taskJSONObject.get((Object)"assignee"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)taskJSONObject.get((Object)"owner"));
            this.activitiProcessEngine.getTaskService().resolveTask(task.getId());
            taskJSONObject = tasksClient.findTaskById(task.getId());
            Assert.assertNotNull((Object)taskJSONObject);
            Assert.assertEquals((Object)task.getId(), (Object)taskJSONObject.get((Object)"id"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)taskJSONObject.get((Object)"assignee"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)taskJSONObject.get((Object)"owner"));
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TaskWorkflowApiTest.this.activitiProcessEngine.getTaskService().complete(task.getId());
                    return null;
                }
            }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
            taskJSONObject = tasksClient.findTaskById(task.getId());
            Assert.assertNotNull((Object)taskJSONObject);
            Assert.assertEquals((Object)task.getId(), (Object)taskJSONObject.get((Object)"id"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)taskJSONObject.get((Object)"assignee"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)taskJSONObject.get((Object)"owner"));
            Assert.assertNotNull((Object)taskJSONObject.get((Object)"endedAt"));
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTaskByIdAuthorization() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String initiator = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        ProcessInstance processInstance = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            try {
                tasksClient.findTaskById(task.getId());
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), requestContext.getRunAsUser());
            JSONObject jsonObject = tasksClient.findTaskById(task.getId());
            Assert.assertNotNull((Object)jsonObject);
            String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
            jsonObject = tasksClient.findTaskById(task.getId());
            Assert.assertNotNull((Object)jsonObject);
            RepoService.TestNetwork anotherNetwork = this.getOtherNetwork(requestContext.getNetworkId());
            tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + anotherNetwork.getId();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
            try {
                tasksClient.findTaskById(task.getId());
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    @Test
    public void testGetUnexistingTaskById() throws Exception {
        this.initApiClientWithTestUser();
        WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
        try {
            tasksClient.findTaskById("unexisting");
            Assert.fail((String)"Exception expected");
        }
        catch (PublicApiException expected) {
            Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
            this.assertErrorSummary("The entity with id: unexisting was not found", expected.getHttpResponse());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateTask() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String otherPerson = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        RequestContext otherContext = new RequestContext(requestContext.getNetworkId(), otherPerson);
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        RequestContext adminContext = new RequestContext(requestContext.getNetworkId(), tenantAdmin);
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            Calendar dueDateCal = Calendar.getInstance();
            dueDateCal.set(14, 0);
            dueDateCal.add(6, 1);
            Date dueDate = dueDateCal.getTime();
            JSONObject taskBody = new JSONObject();
            taskBody.put((Object)"name", (Object)"Updated name");
            taskBody.put((Object)"description", (Object)"Updated description");
            taskBody.put((Object)"dueAt", (Object)this.formatDate(dueDate));
            taskBody.put((Object)"priority", (Object)1234);
            taskBody.put((Object)"assignee", (Object)"john");
            taskBody.put((Object)"owner", (Object)"james");
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.addAll(Arrays.asList("name", "description", "dueAt", "priority", "assignee", "owner"));
            JSONObject result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"Updated name", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)"Updated description", (Object)result.get((Object)"description"));
            Assert.assertEquals((long)1234L, (long)Integer.valueOf(result.get((Object)"priority").toString()).intValue());
            Assert.assertEquals((Object)"john", (Object)result.get((Object)"assignee"));
            Assert.assertEquals((Object)"james", (Object)result.get((Object)"owner"));
            Assert.assertEquals((Object)dueDate, (Object)this.parseDate(result, "dueAt"));
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Assert.assertEquals((Object)"Updated name", (Object)task.getName());
            Assert.assertEquals((Object)"Updated description", (Object)task.getDescription());
            Assert.assertEquals((long)1234L, (long)task.getPriority());
            Assert.assertEquals((Object)"john", (Object)task.getAssignee());
            Assert.assertEquals((Object)"james", (Object)task.getOwner());
            Assert.assertEquals((Object)dueDate, (Object)task.getDueDate());
            taskBody = new JSONObject();
            taskBody.put((Object)"owner", (Object)adminContext.getRunAsUser());
            selectedFields = new ArrayList();
            selectedFields.addAll(Arrays.asList("owner"));
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)adminContext.getRunAsUser(), (Object)result.get((Object)"owner"));
            taskBody = new JSONObject();
            taskBody.put((Object)"owner", (Object)requestContext.getRunAsUser());
            selectedFields = new ArrayList();
            selectedFields.addAll(Arrays.asList("owner"));
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)result.get((Object)"owner"));
            taskBody = new JSONObject();
            taskBody.put((Object)"owner", (Object)otherContext.getRunAsUser());
            selectedFields = new ArrayList();
            selectedFields.addAll(Arrays.asList("owner"));
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)otherContext.getRunAsUser(), (Object)result.get((Object)"owner"));
            dueDateCal.add(6, 1);
            dueDate = dueDateCal.getTime();
            taskBody = new JSONObject();
            taskBody.put((Object)"dueAt", (Object)this.formatDate(dueDate));
            selectedFields = new ArrayList();
            selectedFields.addAll(Arrays.asList("dueAt"));
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)dueDate, (Object)this.parseDate(result, "dueAt"));
            dueDateCal.add(6, -1);
            dueDate = dueDateCal.getTime();
            taskBody = new JSONObject();
            taskBody.put((Object)"dueAt", (Object)this.formatDate(dueDate));
            selectedFields = new ArrayList();
            selectedFields.addAll(Arrays.asList("dueAt"));
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)dueDate, (Object)this.parseDate(result, "dueAt"));
            dueDateCal = Calendar.getInstance();
            dueDateCal.set(14, 0);
            dueDate = dueDateCal.getTime();
            taskBody = new JSONObject();
            taskBody.put((Object)"dueAt", (Object)this.formatDate(dueDate));
            selectedFields = new ArrayList();
            selectedFields.addAll(Arrays.asList("dueAt"));
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)dueDate, (Object)this.parseDate(result, "dueAt"));
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateTaskMnt13276() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String initiatorId = requestContext.getRunAsUser();
        ProcessInfo processInfo = this.startReviewPooledProcess(requestContext);
        final List persons = (List)this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<RepoService.TestPerson>>(){

            public List<RepoService.TestPerson> execute() throws Throwable {
                ArrayList<RepoService.TestPerson> persons = new ArrayList<RepoService.TestPerson>();
                String temp = "_" + System.currentTimeMillis();
                persons.add(TaskWorkflowApiTest.this.currentNetwork.createUser(new PersonInfo("user0", "user0", "user0" + temp, "password", null, "skype", "location", "telephone", "mob", "instant", "google")));
                persons.add(TaskWorkflowApiTest.this.currentNetwork.createUser(new PersonInfo("user1", "user1", "user1" + temp, "password", null, "skype", "location", "telephone", "mob", "instant", "google")));
                persons.add(TaskWorkflowApiTest.this.currentNetwork.createUser(new PersonInfo("user2", "user2", "user2" + temp, "password", null, "skype", "location", "telephone", "mob", "instant", "google")));
                return persons;
            }
        }, false, true);
        final MemberOfSite memberOfSite = this.currentNetwork.getSiteMemberships(initiatorId).get(0);
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        RepoService.TestSite initiatorSite = (RepoService.TestSite)memberOfSite.getSite();
                        initiatorSite.inviteToSite(((RepoService.TestPerson)persons.get(0)).getId(), memberOfSite.getRole());
                        initiatorSite.inviteToSite(((RepoService.TestPerson)persons.get(1)).getId(), memberOfSite.getRole());
                        initiatorSite.inviteToSite(((RepoService.TestPerson)persons.get(2)).getId(), SiteRole.SiteConsumer == memberOfSite.getRole() ? SiteRole.SiteCollaborator : SiteRole.SiteConsumer);
                        return null;
                    }
                }, (String)AuthenticationUtil.getAdminUserName(), (String)TaskWorkflowApiTest.this.currentNetwork.getId());
                return null;
            }
        }, false, true);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInfo.getId())).singleResult();
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject taskBody = new JSONObject();
            taskBody.put((Object)"name", (Object)"Updated name by user in group");
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.addAll(Arrays.asList("name"));
            requestContext.setRunAsUser(((RepoService.TestPerson)persons.get(0)).getId());
            JSONObject result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"Updated name by user in group", (Object)result.get((Object)"name"));
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInfo.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Assert.assertEquals((Object)"Updated name by user in group", (Object)task.getName());
            try {
                taskBody.put((Object)"name", (Object)"Updated name by user not in group");
                requestContext.setRunAsUser(((RepoService.TestPerson)persons.get(2)).getId());
                tasksClient.updateTask(task.getId(), taskBody, selectedFields);
                Assert.fail((String)"User not from group should not see items.");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
            TaskService taskService = this.activitiProcessEngine.getTaskService();
            task = (Task)((TaskQuery)taskService.createTaskQuery().processInstanceId(processInfo.getId())).singleResult();
            taskService.setAssignee(task.getId(), ((RepoService.TestPerson)persons.get(1)).getId());
            try {
                taskBody = new JSONObject();
                taskBody.put((Object)"name", (Object)"Updated name by user in group for claimed task");
                selectedFields.addAll(Arrays.asList("name"));
                requestContext.setRunAsUser(((RepoService.TestPerson)persons.get(0)).getId());
                result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
                Assert.fail((String)"User from group should not see items for claimed task by another user.");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInfo.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processInfo.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAssociationDefinitionExtraction() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String delegatee = "wbpm_delegatee";
        final String user = requestContext.getRunAsUser();
        final String networkId = requestContext.getNetworkId();
        final ActivitiScriptNode person = (ActivitiScriptNode)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<ActivitiScriptNode>(){

            public ActivitiScriptNode doWork() throws Exception {
                return TaskWorkflowApiTest.this.getPersonNodeRef(user);
            }
        }, (String)user, (String)networkId);
        ProcessInstance processInstance = (ProcessInstance)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<ProcessInstance>(){

            public ProcessInstance doWork() throws Exception {
                TaskWorkflowApiTest.this.deployProcessDefinition("workflow/testCustomDelegatee.bpmn20.xml");
                String processDefinitionKey = "@" + networkId + "@myProcess";
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put("bpm_assignee", person);
                variables.put("wf_notifyMe", Boolean.FALSE);
                variables.put("initiator", person);
                return TaskWorkflowApiTest.this.activitiProcessEngine.getRuntimeService().startProcessInstanceByKey(processDefinitionKey, "myProcessKey", variables);
            }
        }, (String)user, (String)networkId);
        Task activeTask = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
        Assert.assertNotNull((Object)activeTask);
        try {
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONArray variablesArray = new JSONArray();
            JSONObject variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"wbpm_delegatee");
            variableBody.put((Object)"value", (Object)user);
            variableBody.put((Object)"scope", (Object)"local");
            variablesArray.add((Object)variableBody);
            try {
                JSONObject response = tasksClient.createTaskVariables(activeTask.getId(), variablesArray);
                Assert.assertNotNull((Object)response);
                JSONObject variable = (JSONObject)response.get((Object)"entry");
                Assert.assertEquals((Object)"wbpm_delegatee", (Object)variable.get((Object)"name"));
                Assert.assertEquals((Object)"d:noderef", (Object)variable.get((Object)"type"));
                Assert.assertEquals((Object)person.getNodeRef().getId(), (Object)variable.get((Object)"value"));
                response = this.publicApiClient.processesClient().getProcessvariables(processInstance.getId());
                Assert.assertNotNull((Object)response);
                Assert.assertTrue((String)"wbpm_delegatee variable was not set", (boolean)response.toJSONString().contains("wbpm_delegatee"));
                JSONArray entries = (JSONArray)response.get((Object)"entries");
                for (Object entry : entries) {
                    variable = (JSONObject)((JSONObject)entry).get((Object)"entry");
                    if (!variable.get((Object)"name").equals("wbpm_delegatee")) continue;
                    Assert.assertEquals((Object)"cm:person", (Object)variable.get((Object)"type"));
                    Assert.assertEquals((Object)user, (Object)variable.get((Object)"value"));
                }
            }
            catch (PublicApiException ex) {
                Assert.fail((String)("Unexpected result " + ex));
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateTaskAuthorization() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String initiator = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        ProcessInstance processInstance = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject taskBody = new JSONObject();
            taskBody.put((Object)"name", (Object)"Updated name");
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.addAll(Arrays.asList("name"));
            try {
                tasksClient.updateTask(task.getId(), taskBody, selectedFields);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), requestContext.getRunAsUser());
            taskBody.put((Object)"name", (Object)"Updated name by assignee");
            JSONObject result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"Updated name by assignee", (Object)result.get((Object)"name"));
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Assert.assertEquals((Object)"Updated name by assignee", (Object)task.getName());
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), null);
            this.activitiProcessEngine.getTaskService().setOwner(task.getId(), requestContext.getRunAsUser());
            taskBody.put((Object)"name", (Object)"Updated name by owner");
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"Updated name by owner", (Object)result.get((Object)"name"));
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Assert.assertEquals((Object)"Updated name by owner", (Object)task.getName());
            taskBody.put((Object)"name", (Object)"Updated name by initiator");
            requestContext.setRunAsUser(initiator);
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"Updated name by initiator", (Object)result.get((Object)"name"));
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Assert.assertEquals((Object)"Updated name by initiator", (Object)task.getName());
            String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
            taskBody.put((Object)"name", (Object)"Updated name by admin");
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"Updated name by admin", (Object)result.get((Object)"name"));
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Assert.assertEquals((Object)"Updated name by admin", (Object)task.getName());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    @Test
    public void testUpdateUnexistingTask() throws Exception {
        this.initApiClientWithTestUser();
        WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
        try {
            JSONObject taskBody = new JSONObject();
            taskBody.put((Object)"name", (Object)"Updated name");
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.addAll(Arrays.asList("name"));
            tasksClient.updateTask("unexisting", taskBody, selectedFields);
            Assert.fail((String)"Exception expected");
        }
        catch (PublicApiException expected) {
            Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
            this.assertErrorSummary("The entity with id: unexisting was not found", expected.getHttpResponse());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateTaskInvalidProperty() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            ArrayList<String> selectedFields;
            JSONObject taskBody;
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            try {
                taskBody = new JSONObject();
                selectedFields = new ArrayList<String>();
                selectedFields.add("unexisting");
                tasksClient.updateTask(task.getId(), taskBody, selectedFields);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("The property selected for update does not exist for this resource: unexisting", expected.getHttpResponse());
            }
            try {
                taskBody = new JSONObject();
                selectedFields = new ArrayList();
                selectedFields.add("id");
                tasksClient.updateTask(task.getId(), taskBody, selectedFields);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("The property selected for update is read-only: id", expected.getHttpResponse());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClaimTask() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String initiator = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        ProcessInstance processInstance = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject taskBody = new JSONObject();
            taskBody.put((Object)"state", (Object)"claimed");
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.addAll(Arrays.asList("state", "assignee"));
            try {
                tasksClient.updateTask(task.getId(), taskBody, selectedFields);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
            List<MemberOfSite> memberships = this.getTestFixture().getNetwork(requestContext.getNetworkId()).getSiteMemberships(requestContext.getRunAsUser());
            Assert.assertTrue((memberships.size() > 0 ? 1 : 0) != 0);
            MemberOfSite memberOfSite = memberships.get(0);
            String group = "GROUP_site_" + memberOfSite.getSiteId() + "_" + memberOfSite.getRole().name();
            this.activitiProcessEngine.getTaskService().addCandidateGroup(task.getId(), group);
            try {
                tasksClient.updateTask(task.getId(), taskBody, selectedFields);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.CONFLICT.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("The task is already claimed by another user.", expected.getHttpResponse());
            }
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), null);
            taskBody = new JSONObject();
            taskBody.put((Object)"state", (Object)"claimed");
            JSONObject result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)result.get((Object)"assignee"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)((Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(task.getId())).singleResult()).getAssignee());
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)result.get((Object)"assignee"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)((Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(task.getId())).singleResult()).getAssignee());
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), null);
            this.activitiProcessEngine.getTaskService().deleteGroupIdentityLink(task.getId(), group, "candidate");
            this.activitiProcessEngine.getTaskService().addCandidateUser(task.getId(), requestContext.getRunAsUser());
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)result.get((Object)"assignee"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)((Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(task.getId())).singleResult()).getAssignee());
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), null);
            this.activitiProcessEngine.getTaskService().setOwner(task.getId(), requestContext.getRunAsUser());
            this.activitiProcessEngine.getTaskService().deleteUserIdentityLink(task.getId(), requestContext.getRunAsUser(), "candidate");
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)result.get((Object)"assignee"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)((Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(task.getId())).singleResult()).getAssignee());
            String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), null);
            this.activitiProcessEngine.getTaskService().deleteUserIdentityLink(task.getId(), requestContext.getRunAsUser(), "candidate");
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)tenantAdmin, (Object)result.get((Object)"assignee"));
            Assert.assertEquals((Object)tenantAdmin, (Object)((Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(task.getId())).singleResult()).getAssignee());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnClaimTask() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String user = requestContext.getRunAsUser();
        String initiator = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        ProcessInstance processInstance = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject taskBody = new JSONObject();
            taskBody.put((Object)"state", (Object)"unclaimed");
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.addAll(Arrays.asList("state"));
            try {
                tasksClient.updateTask(task.getId(), taskBody, selectedFields);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
            requestContext.setRunAsUser(initiator);
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), null);
            JSONObject result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertNull((Object)result.get((Object)"assignee"));
            Assert.assertNull((Object)((Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(task.getId())).singleResult()).getAssignee());
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), user);
            requestContext.setRunAsUser(user);
            Assert.assertNotNull((Object)((Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(task.getId())).singleResult()).getAssignee());
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertNull((Object)result.get((Object)"assignee"));
            Assert.assertNull((Object)((Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(task.getId())).singleResult()).getAssignee());
            this.activitiProcessEngine.getTaskService().setOwner(task.getId(), user);
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), initiator);
            Assert.assertNotNull((Object)((Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(task.getId())).singleResult()).getAssignee());
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertNull((Object)result.get((Object)"assignee"));
            Assert.assertNull((Object)((Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(task.getId())).singleResult()).getAssignee());
            String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), initiator);
            this.activitiProcessEngine.getTaskService().deleteUserIdentityLink(task.getId(), requestContext.getRunAsUser(), "candidate");
            Assert.assertNotNull((Object)((Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(task.getId())).singleResult()).getAssignee());
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertNull((Object)result.get((Object)"assignee"));
            Assert.assertNull((Object)((Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(task.getId())).singleResult()).getAssignee());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompleteTask() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String user = requestContext.getRunAsUser();
        String initiator = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        ProcessInstance processCompleteAsAssignee = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        ProcessInstance processCompleteAsOwner = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        ProcessInstance processCompleteAsInitiator = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        ProcessInstance processCompleteAsAdmin = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        ProcessInstance processCompleteWithVariables = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        try {
            Task asAssigneeTask = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processCompleteAsAssignee.getId())).singleResult();
            Task asOwnerTask = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processCompleteAsOwner.getId())).singleResult();
            Task asInitiatorTask = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processCompleteAsInitiator.getId())).singleResult();
            Task asAdminTask = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processCompleteAsAdmin.getId())).singleResult();
            Task withVariablesTask = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processCompleteWithVariables.getId())).singleResult();
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject taskBody = new JSONObject();
            taskBody.put((Object)"state", (Object)"completed");
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.addAll(Arrays.asList("state"));
            try {
                tasksClient.updateTask(asAssigneeTask.getId(), taskBody, selectedFields);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
            this.activitiProcessEngine.getTaskService().setAssignee(asAssigneeTask.getId(), user);
            JSONObject result = tasksClient.updateTask(asAssigneeTask.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"completed", (Object)result.get((Object)"state"));
            Assert.assertNotNull((Object)result.get((Object)"endedAt"));
            Assert.assertNull((Object)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(asAssigneeTask.getId())).singleResult());
            requestContext.setRunAsUser(initiator);
            this.activitiProcessEngine.getTaskService().setAssignee(asInitiatorTask.getId(), null);
            result = tasksClient.updateTask(asInitiatorTask.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"completed", (Object)result.get((Object)"state"));
            Assert.assertNotNull((Object)result.get((Object)"endedAt"));
            Assert.assertNull((Object)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(asInitiatorTask.getId())).singleResult());
            requestContext.setRunAsUser(user);
            asOwnerTask.setOwner(user);
            this.activitiProcessEngine.getTaskService().saveTask(asOwnerTask);
            result = tasksClient.updateTask(asOwnerTask.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"completed", (Object)result.get((Object)"state"));
            Assert.assertNotNull((Object)result.get((Object)"endedAt"));
            Assert.assertNull((Object)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(asOwnerTask.getId())).singleResult());
            String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
            asAdminTask.setOwner(null);
            this.activitiProcessEngine.getTaskService().saveTask(asAdminTask);
            result = tasksClient.updateTask(asAdminTask.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"completed", (Object)result.get((Object)"state"));
            Assert.assertNotNull((Object)result.get((Object)"endedAt"));
            Assert.assertNull((Object)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(asAdminTask.getId())).singleResult());
            requestContext.setRunAsUser(initiator);
            this.activitiProcessEngine.getTaskService().setAssignee(withVariablesTask.getId(), null);
            JSONArray variablesArray = new JSONArray();
            JSONObject variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"newGlobalVariable");
            variableBody.put((Object)"value", (Object)1234);
            variableBody.put((Object)"scope", (Object)"global");
            variablesArray.add((Object)variableBody);
            variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"newLocalVariable");
            variableBody.put((Object)"value", (Object)5678);
            variableBody.put((Object)"scope", (Object)"local");
            variablesArray.add((Object)variableBody);
            taskBody.put((Object)"variables", (Object)variablesArray);
            selectedFields.add("variables");
            result = tasksClient.updateTask(withVariablesTask.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"completed", (Object)result.get((Object)"state"));
            Assert.assertNotNull((Object)result.get((Object)"endedAt"));
            Assert.assertNull((Object)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().taskId(withVariablesTask.getId())).singleResult());
            HistoricTaskInstance historyTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.activitiProcessEngine.getHistoryService().createHistoricTaskInstanceQuery().taskId(withVariablesTask.getId())).includeProcessVariables()).includeTaskLocalVariables()).singleResult();
            Assert.assertEquals((Object)1234, historyTask.getProcessVariables().get("newGlobalVariable"));
            Assert.assertEquals((Object)5678, historyTask.getTaskLocalVariables().get("newLocalVariable"));
            Assert.assertNotNull((String)"The outcome should not be null for completed task.", historyTask.getTaskLocalVariables().get("bpm_outcome"));
            JSONObject variables = tasksClient.findTaskVariables(withVariablesTask.getId());
            Assert.assertNotNull((Object)variables);
            JSONObject list = (JSONObject)variables.get((Object)"list");
            Assert.assertNotNull((Object)list);
            JSONArray entries = (JSONArray)list.get((Object)"entries");
            Assert.assertNotNull((Object)entries);
            boolean foundGlobal = false;
            boolean foundLocal = false;
            for (Object entry : entries) {
                JSONObject variableObject = (JSONObject)((JSONObject)entry).get((Object)"entry");
                if ("newGlobalVariable".equals(variableObject.get((Object)"name"))) {
                    Assert.assertEquals((Object)1234L, (Object)variableObject.get((Object)"value"));
                    foundGlobal = true;
                    continue;
                }
                if (!"newLocalVariable".equals(variableObject.get((Object)"name"))) continue;
                Assert.assertEquals((Object)5678L, (Object)variableObject.get((Object)"value"));
                foundLocal = true;
            }
            Assert.assertTrue((boolean)foundGlobal);
            Assert.assertTrue((boolean)foundLocal);
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processCompleteAsAssignee, processCompleteAsAdmin, processCompleteAsInitiator, processCompleteAsOwner, processCompleteWithVariables);
            throw throwable;
        }
        this.cleanupProcessInstance(processCompleteAsAssignee, processCompleteAsAdmin, processCompleteAsInitiator, processCompleteAsOwner, processCompleteWithVariables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelegateTask() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String user = requestContext.getRunAsUser();
        String initiator = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        ProcessInstance processInstance = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject taskBody = new JSONObject();
            taskBody.put((Object)"state", (Object)"delegated");
            taskBody.put((Object)"assignee", (Object)initiator);
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.addAll(Arrays.asList("state", "assignee"));
            try {
                tasksClient.updateTask(task.getId(), taskBody, selectedFields);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), user);
            taskBody = new JSONObject();
            taskBody.put((Object)"state", (Object)"delegated");
            selectedFields = new ArrayList();
            selectedFields.addAll(Arrays.asList("state"));
            try {
                tasksClient.updateTask(task.getId(), taskBody, selectedFields);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("When delegating a task, assignee should be selected and provided in the request.", expected.getHttpResponse());
            }
            taskBody.put((Object)"state", (Object)"delegated");
            taskBody.put((Object)"assignee", (Object)initiator);
            selectedFields = new ArrayList();
            selectedFields.addAll(Arrays.asList("state", "assignee"));
            Assert.assertNull((Object)task.getDelegationState());
            JSONObject result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"delegated", (Object)result.get((Object)"state"));
            Assert.assertEquals((Object)initiator, (Object)result.get((Object)"assignee"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)result.get((Object)"owner"));
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertEquals((Object)DelegationState.PENDING, (Object)task.getDelegationState());
            Assert.assertEquals((Object)initiator, (Object)task.getAssignee());
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)task.getOwner());
            task.setDelegationState(null);
            task.setOwner(requestContext.getRunAsUser());
            task.setAssignee(null);
            this.activitiProcessEngine.getTaskService().saveTask(task);
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"delegated", (Object)result.get((Object)"state"));
            Assert.assertEquals((Object)initiator, (Object)result.get((Object)"assignee"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)result.get((Object)"owner"));
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertEquals((Object)DelegationState.PENDING, (Object)task.getDelegationState());
            Assert.assertEquals((Object)initiator, (Object)task.getAssignee());
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)task.getOwner());
            task.setDelegationState(null);
            task.setOwner(null);
            task.setAssignee(null);
            this.activitiProcessEngine.getTaskService().saveTask(task);
            requestContext.setRunAsUser(initiator);
            taskBody.put((Object)"assignee", (Object)user);
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"delegated", (Object)result.get((Object)"state"));
            Assert.assertEquals((Object)user, (Object)result.get((Object)"assignee"));
            Assert.assertEquals((Object)initiator, (Object)result.get((Object)"owner"));
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertEquals((Object)DelegationState.PENDING, (Object)task.getDelegationState());
            Assert.assertEquals((Object)user, (Object)task.getAssignee());
            Assert.assertEquals((Object)initiator, (Object)task.getOwner());
            String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
            task.setDelegationState(null);
            task.setOwner(null);
            task.setAssignee(null);
            this.activitiProcessEngine.getTaskService().saveTask(task);
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            requestContext.setRunAsUser(tenantAdmin);
            taskBody.put((Object)"assignee", (Object)user);
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"delegated", (Object)result.get((Object)"state"));
            Assert.assertEquals((Object)user, (Object)result.get((Object)"assignee"));
            Assert.assertEquals((Object)tenantAdmin, (Object)result.get((Object)"owner"));
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertEquals((Object)DelegationState.PENDING, (Object)task.getDelegationState());
            Assert.assertEquals((Object)user, (Object)task.getAssignee());
            Assert.assertEquals((Object)tenantAdmin, (Object)task.getOwner());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    @Test
    public void testSetOutcome() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInfo processInf = this.startReviewPooledProcess(requestContext);
        Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInf.getId())).singleResult();
        WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
        this.activitiProcessEngine.getTaskService().saveTask(task);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("select", "state,variables");
        HttpResponse response = tasksClient.update("tasks", task.getId(), null, null, "{\"state\":\"completed\",\"variables\":[{\"name\":\"wf_reviewOutcome\",\"value\":\"Approve\",\"scope\":\"local\"},{\"name\":\"bpm_comment\",\"value\":\"approved by me\",\"scope\":\"local\"}]}", params, "Failed to update task", 200);
        HistoricTaskInstance historyTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.activitiProcessEngine.getHistoryService().createHistoricTaskInstanceQuery().taskId(task.getId())).includeProcessVariables()).includeTaskLocalVariables()).singleResult();
        String outcome = (String)historyTask.getTaskLocalVariables().get("bpm_outcome");
        Assert.assertEquals((Object)"Approve", (Object)outcome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResolveTask() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String user = requestContext.getRunAsUser();
        String initiator = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        ProcessInstance processInstance = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject taskBody = new JSONObject();
            taskBody.put((Object)"state", (Object)"resolved");
            taskBody.put((Object)"assignee", (Object)initiator);
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.addAll(Arrays.asList("state", "assignee"));
            try {
                tasksClient.updateTask(task.getId(), taskBody, selectedFields);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
            task.delegate(user);
            this.activitiProcessEngine.getTaskService().saveTask(task);
            taskBody.put((Object)"state", (Object)"resolved");
            taskBody.put((Object)"assignee", (Object)initiator);
            selectedFields = new ArrayList();
            selectedFields.addAll(Arrays.asList("state", "assignee"));
            JSONObject result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"resolved", (Object)result.get((Object)"state"));
            Assert.assertEquals((Object)initiator, (Object)result.get((Object)"assignee"));
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
            Assert.assertEquals((Object)initiator, (Object)task.getAssignee());
            HistoricTaskInstance historyTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.activitiProcessEngine.getHistoryService().createHistoricTaskInstanceQuery().taskId(task.getId())).includeProcessVariables()).includeTaskLocalVariables()).singleResult();
            Assert.assertNotNull((String)"The outcome should not be null for resolved task.", historyTask.getTaskLocalVariables().get("bpm_outcome"));
            task.setDelegationState(null);
            task.setOwner(requestContext.getRunAsUser());
            task.setAssignee(null);
            this.activitiProcessEngine.getTaskService().saveTask(task);
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"resolved", (Object)result.get((Object)"state"));
            Assert.assertEquals((Object)user, (Object)result.get((Object)"assignee"));
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
            Assert.assertEquals((Object)user, (Object)task.getAssignee());
            task.setDelegationState(null);
            task.setOwner(null);
            task.setAssignee(null);
            this.activitiProcessEngine.getTaskService().saveTask(task);
            requestContext.setRunAsUser(initiator);
            taskBody.put((Object)"assignee", (Object)user);
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"resolved", (Object)result.get((Object)"state"));
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
            String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
            task.setDelegationState(null);
            task.setOwner(initiator);
            task.setAssignee(null);
            this.activitiProcessEngine.getTaskService().saveTask(task);
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            requestContext.setRunAsUser(tenantAdmin);
            taskBody.put((Object)"assignee", (Object)user);
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"resolved", (Object)result.get((Object)"state"));
            Assert.assertEquals((Object)initiator, (Object)result.get((Object)"assignee"));
            task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertEquals((Object)DelegationState.RESOLVED, (Object)task.getDelegationState());
            Assert.assertEquals((Object)initiator, (Object)task.getAssignee());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskStateTransitions() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInfo processInstance = this.startAdhocProcess(requestContext, null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject taskBody = new JSONObject();
            taskBody.put((Object)"state", (Object)"claimed");
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.addAll(Arrays.asList("state", "assignee"));
            JSONObject result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"claimed", (Object)result.get((Object)"state"));
            taskBody = new JSONObject();
            taskBody.put((Object)"state", (Object)"unclaimed");
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertEquals((Object)"unclaimed", (Object)result.get((Object)"state"));
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangeDueDate() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject taskObject = tasksClient.findTaskById(task.getId());
            Assert.assertNull((Object)taskObject.get((Object)"dueAt"));
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.addAll(Arrays.asList("name", "description", "dueAt", "priority", "assignee", "owner"));
            JSONObject taskBody = new JSONObject();
            String dueAt = this.formatDate(new Date());
            taskBody.put((Object)"dueAt", (Object)dueAt);
            JSONObject result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertNotNull((Object)result.get((Object)"dueAt"));
            taskObject = tasksClient.findTaskById(task.getId());
            Assert.assertNotNull((Object)taskObject.get((Object)"dueAt"));
            taskBody = new JSONObject();
            taskBody.put((Object)"dueAt", taskObject.get((Object)"dueAt"));
            result = tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            Assert.assertNotNull((Object)result.get((Object)"dueAt"));
            taskObject = tasksClient.findTaskById(task.getId());
            Assert.assertNotNull((Object)taskObject.get((Object)"dueAt"));
            JSONObject variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"bpm_workflowDueDate");
            variableBody.put((Object)"value", (Object)this.formatDate(new Date()));
            variableBody.put((Object)"type", (Object)"d:date");
            variableBody.put((Object)"scope", (Object)"global");
            tasksClient.updateTaskVariable(task.getId(), "bpm_workflowDueDate", variableBody);
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTasks() throws Exception {
        Calendar createdCal = Calendar.getInstance();
        createdCal.set(14, 0);
        Clock actiClock = this.activitiProcessEngine.getProcessEngineConfiguration().getClock();
        actiClock.setCurrentTime(createdCal.getTime());
        RequestContext requestContext = this.initApiClientWithTestUser();
        String otherPerson = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        RequestContext otherContext = new RequestContext(requestContext.getNetworkId(), otherPerson);
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Calendar dueDateCal = Calendar.getInstance();
            dueDateCal.set(14, 0);
            dueDateCal.add(6, 1);
            Date dueDate = dueDateCal.getTime();
            task.setDescription("This is a test description");
            task.setAssignee(requestContext.getRunAsUser());
            task.setOwner("john");
            task.setDueDate(dueDate);
            this.activitiProcessEngine.getTaskService().saveTask(task);
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject taskListJSONObject = tasksClient.findTasks(null);
            Assert.assertNotNull((Object)taskListJSONObject);
            JSONArray jsonEntries = (JSONArray)taskListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)1L, (long)jsonEntries.size());
            JSONObject taskJSONObject = (JSONObject)((JSONObject)jsonEntries.get(0)).get((Object)"entry");
            Assert.assertNotNull((Object)taskJSONObject);
            Assert.assertEquals((Object)task.getId(), (Object)taskJSONObject.get((Object)"id"));
            Assert.assertEquals((Object)processInstance.getId(), (Object)taskJSONObject.get((Object)"processId"));
            Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)taskJSONObject.get((Object)"processDefinitionId"));
            Assert.assertEquals((Object)"adhocTask", (Object)taskJSONObject.get((Object)"activityDefinitionId"));
            Assert.assertEquals((Object)"Adhoc Task", (Object)taskJSONObject.get((Object)"name"));
            Assert.assertEquals((Object)"This is a test description", (Object)taskJSONObject.get((Object)"description"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)taskJSONObject.get((Object)"assignee"));
            Assert.assertEquals((Object)"john", (Object)taskJSONObject.get((Object)"owner"));
            Assert.assertEquals((Object)dueDate, (Object)this.parseDate(taskJSONObject, "dueAt"));
            Assert.assertEquals((Object)createdCal.getTime().toString(), (Object)this.parseDate(taskJSONObject, "startedAt").toString());
            Assert.assertEquals((Object)createdCal.getTime(), (Object)this.parseDate(taskJSONObject, "startedAt"));
            Assert.assertEquals((Object)2L, (Object)taskJSONObject.get((Object)"priority"));
            Assert.assertEquals((Object)"wf:adhocTask", (Object)taskJSONObject.get((Object)"formResourceKey"));
            Assert.assertNull((Object)taskJSONObject.get((Object)"endedAt"));
            Assert.assertNull((Object)taskJSONObject.get((Object)"durationInMs"));
            this.publicApiClient.setRequestContext(otherContext);
            taskListJSONObject = tasksClient.findTasks(null);
            Assert.assertNotNull((Object)taskListJSONObject);
            jsonEntries = (JSONArray)taskListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)0L, (long)jsonEntries.size());
            this.publicApiClient.setRequestContext(requestContext);
            JSONObject taskBody = new JSONObject();
            taskBody.put((Object)"assignee", (Object)otherContext.getRunAsUser());
            ArrayList<String> selectedFields = new ArrayList<String>();
            selectedFields.addAll(Arrays.asList("assignee"));
            tasksClient.updateTask(task.getId(), taskBody, selectedFields);
            this.publicApiClient.setRequestContext(otherContext);
            taskListJSONObject = tasksClient.findTasks(null);
            Assert.assertNotNull((Object)taskListJSONObject);
            jsonEntries = (JSONArray)taskListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)1L, (long)jsonEntries.size());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTasksWithParams() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String otherPerson = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        RequestContext otherContext = new RequestContext(requestContext.getNetworkId(), otherPerson);
        Calendar taskCreated = Calendar.getInstance();
        taskCreated.set(14, 0);
        String businessKey = UUID.randomUUID().toString();
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), businessKey);
        ProcessInfo otherInstance = this.startReviewPooledProcess(otherContext);
        try {
            final Task completedTask = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)completedTask);
            Task reviewPooledTask = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(otherInstance.getId())).singleResult();
            Assert.assertNotNull((Object)reviewPooledTask);
            Assert.assertNotNull((String)"Due date was not set for review pooled task.", (Object)reviewPooledTask.getDueDate());
            String anotherUserId = UUID.randomUUID().toString();
            Calendar completedTaskDue = Calendar.getInstance();
            completedTaskDue.add(10, 1);
            completedTaskDue.set(14, 0);
            completedTask.setOwner(requestContext.getRunAsUser());
            completedTask.setPriority(3);
            completedTask.setDueDate(completedTaskDue.getTime());
            completedTask.setAssignee(anotherUserId);
            completedTask.setName("Another task name");
            completedTask.setDescription("This is another test description");
            this.activitiProcessEngine.getTaskService().saveTask(completedTask);
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TaskWorkflowApiTest.this.activitiProcessEngine.getTaskService().complete(completedTask.getId());
                    return null;
                }
            }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
            Task activeTask = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)activeTask);
            Calendar activeTaskDue = Calendar.getInstance();
            activeTaskDue.add(10, 2);
            activeTaskDue.set(14, 0);
            activeTask.setDueDate(activeTaskDue.getTime());
            activeTask.setName("Task name");
            activeTask.setDescription("This is a test description");
            activeTask.setOwner(requestContext.getRunAsUser());
            activeTask.setPriority(2);
            activeTask.setAssignee(requestContext.getRunAsUser());
            this.activitiProcessEngine.getTaskService().saveTask(activeTask);
            this.activitiProcessEngine.getTaskService().addCandidateUser(activeTask.getId(), anotherUserId);
            this.activitiProcessEngine.getTaskService().addCandidateGroup(activeTask.getId(), "sales");
            this.activitiProcessEngine.getTaskService().setVariableLocal(activeTask.getId(), "numberVar", (Object)10);
            Task otherTask = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(otherInstance.getId())).singleResult();
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("where", "(status = 'active' AND processId = '" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, false, activeTask.getId());
            params.clear();
            params.put("where", "(status = 'completed' AND processId = '" + processInstance.getId() + "')");
            params.put("orderBy", "dueAt DESC");
            this.assertTasksPresentInTaskQuery(params, tasksClient, false, completedTask.getId());
            params.clear();
            params.put("where", "(status = 'any' AND processId = '" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, false, activeTask.getId(), completedTask.getId());
            params.clear();
            params.put("where", "(processId = '" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, false, activeTask.getId());
            params.clear();
            params.put("where", "(status = 'alfrescorocks')");
            try {
                tasksClient.findTasks(params);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Invalid status parameter: alfrescorocks", expected.getHttpResponse());
            }
            params.clear();
            params.put("where", "(status = 'active' AND assignee = '" + requestContext.getRunAsUser() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.put("where", "(status = 'completed' AND assignee = '" + anotherUserId + "')");
            params.put("orderBy", "endedAt");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.put("where", "(status = 'any' AND assignee = '" + anotherUserId + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.clear();
            params.put("where", "(status = 'active' AND owner = '" + requestContext.getRunAsUser() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.put("where", "(status = 'completed' AND owner = '" + requestContext.getRunAsUser() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.put("where", "(status = 'any' AND owner = '" + requestContext.getRunAsUser() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId(), completedTask.getId());
            params.clear();
            params.put("where", "(status = 'active' AND candidateUser = '" + anotherUserId + "')");
            Assert.assertEquals((long)0L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
            this.activitiProcessEngine.getTaskService().setAssignee(activeTask.getId(), null);
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.clear();
            params.put("where", "(status = 'active' AND candidateUser = '" + otherContext.getRunAsUser() + "')");
            Assert.assertEquals((long)1L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
            params.clear();
            params.put("where", "(status = 'completed' AND candidateUser = '" + anotherUserId + "')");
            try {
                tasksClient.findTasks(params);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Filtering on candidateUser is only allowed in combination with status-parameter 'active'", expected.getHttpResponse());
            }
            params.clear();
            params.put("where", "(status = 'any' AND candidateUser = '" + anotherUserId + "')");
            try {
                tasksClient.findTasks(params);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Filtering on candidateUser is only allowed in combination with status-parameter 'active'", expected.getHttpResponse());
            }
            params.clear();
            params.put("where", "(status = 'active' AND candidateGroup = 'sales' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.clear();
            params.put("where", "(status = 'completed' AND candidateGroup = 'sales' AND processId='" + processInstance.getId() + "')");
            try {
                tasksClient.findTasks(params);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Filtering on candidateGroup is only allowed in combination with status-parameter 'active'", expected.getHttpResponse());
            }
            params.clear();
            params.put("where", "(status = 'any' AND candidateGroup = 'sales' AND processId='" + processInstance.getId() + "')");
            try {
                tasksClient.findTasks(params);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Filtering on candidateGroup is only allowed in combination with status-parameter 'active'", expected.getHttpResponse());
            }
            params.clear();
            params.put("where", "(status = 'active' AND name = 'Task name' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.clear();
            params.put("where", "(status = 'completed' AND name = 'Another task name' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.clear();
            params.put("where", "(status = 'any' AND name = 'Another task name' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.clear();
            params.put("where", "(status = 'active' AND description = 'This is a test description' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.clear();
            params.put("where", "(status = 'completed' AND description = 'This is another test description' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.clear();
            params.put("where", "(status = 'any' AND description = 'This is another test description' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.clear();
            params.put("where", "(status = 'active' AND priority = 2 AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.put("where", "(status = 'completed' AND priority = 3 AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.put("where", "(status = 'any' AND priority = 3 AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.clear();
            params.put("where", "(status = 'active' AND processBusinessKey = '" + businessKey + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.clear();
            params.put("where", "(status = 'completed' AND processBusinessKey = '" + businessKey + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.clear();
            params.put("where", "(status = 'any' AND processBusinessKey = '" + businessKey + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId(), activeTask.getId());
            params.clear();
            params.put("where", "(status = 'any' AND processBusinessKey MATCHES('" + businessKey + "'))");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId(), activeTask.getId());
            params.clear();
            params.put("where", "(status = 'any' AND processBusinessKey MATCHES('" + businessKey.substring(0, businessKey.length() - 2) + "%'))");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId(), activeTask.getId());
            params.clear();
            params.put("where", "(status = 'active' AND activityDefinitionId = 'verifyTaskDone' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.clear();
            params.put("where", "(status = 'completed' AND activityDefinitionId = 'adhocTask' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.clear();
            params.put("where", "(status = 'any' AND activityDefinitionId = 'adhocTask' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.clear();
            params.put("where", "(status = 'active' AND processDefinitionId = '" + processInstance.getProcessDefinitionId() + "' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.clear();
            params.put("where", "(status = 'completed' AND processDefinitionId = '" + processInstance.getProcessDefinitionId() + "' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.clear();
            params.put("where", "(status = 'any' AND processDefinitionId = '" + processInstance.getProcessDefinitionId() + "' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId(), completedTask.getId());
            params.clear();
            params.put("where", "(status = 'active' AND processDefinitionName = 'Adhoc Activiti Process' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.clear();
            params.put("where", "(status = 'completed' AND processDefinitionName = 'Adhoc Activiti Process' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.clear();
            params.put("where", "(status = 'any' AND processDefinitionName = 'Adhoc Activiti Process' AND processId='" + processInstance.getId() + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId(), completedTask.getId());
            params.clear();
            params.put("where", "(status = 'active' AND dueAt = '" + ISO8601DateFormat.format((Date)activeTaskDue.getTime()) + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.clear();
            params.put("where", "(status = 'completed' AND dueAt = '" + ISO8601DateFormat.format((Date)completedTaskDue.getTime()) + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.clear();
            params.put("where", "(status = 'any' AND dueAt = '" + ISO8601DateFormat.format((Date)completedTaskDue.getTime()) + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            Calendar compareCal = Calendar.getInstance();
            compareCal.set(14, 0);
            compareCal.add(6, -1);
            params.clear();
            params.put("where", "(status = 'active' AND startedAt > '" + ISO8601DateFormat.format((Date)compareCal.getTime()) + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId(), otherTask.getId());
            params.clear();
            params.put("where", "(status = 'completed' AND startedAt > '" + ISO8601DateFormat.format((Date)compareCal.getTime()) + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId());
            params.clear();
            params.put("where", "(status = 'any' AND startedAt > '" + ISO8601DateFormat.format((Date)compareCal.getTime()) + "')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, completedTask.getId(), activeTask.getId(), otherTask.getId());
            params.clear();
            params.put("where", "(status = 'any' AND startedAt < '" + ISO8601DateFormat.format((Date)compareCal.getTime()) + "')");
            Assert.assertEquals((long)0L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
            params.clear();
            params.put("where", "(variables/local/numberVar > 'd:int 5')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.clear();
            params.put("where", "(variables/local/numberVar > 'd:int 10')");
            Assert.assertEquals((long)0L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
            params.clear();
            params.put("where", "(variables/local/numberVar >= 'd_int 10')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.clear();
            params.put("where", "(variables/local/numberVar >= 'd:int 11')");
            Assert.assertEquals((long)0L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
            params.clear();
            params.put("where", "(variables/local/numberVar <= 'd:int 10')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.clear();
            params.put("where", "(variables/local/numberVar <= 'd:int 9')");
            Assert.assertEquals((long)0L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
            params.clear();
            params.put("where", "(variables/local/numberVar < 'd_int 15')");
            this.assertTasksPresentInTaskQuery(params, tasksClient, activeTask.getId());
            params.clear();
            params.put("where", "(variables/local/numberVar < 'd:int 10')");
            Assert.assertEquals((long)0L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
            params.clear();
            params.put("where", "(variables/global/numberVar > 'd:int 5')");
            Assert.assertEquals((long)0L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
            params.clear();
            params.put("where", "(variables/numberVar > 'd:int 5')");
            Assert.assertEquals((long)0L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
            params.clear();
            params.put("where", "(variables/bpm_dueDate = 'd:datetime " + ISO8601DateFormat.format((Date)new Date()) + "')");
            Assert.assertEquals((long)0L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
            params.clear();
            params.put("where", "(variables/bpm_dueDate = 'd:datetime 2013-09-15T12:22:31.866+0000')");
            Assert.assertEquals((long)0L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
            params.clear();
            params.put("where", "(variables/bpm_dueDate > 'd:datetime 2013-09-15T12:22:31.866+0000')");
            Assert.assertEquals((long)0L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
            params.clear();
            params.put("where", "(dueAt = '" + ISO8601DateFormat.format((Date)reviewPooledTask.getDueDate()) + "')");
            Assert.assertEquals((long)1L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
            params.clear();
            params.put("where", "(variables/bpm_comment MATCHES ('test%'))");
            Assert.assertEquals((long)0L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
            params.clear();
            params.put("where", "(status = 'any' OR candidateGroup = 'sales')");
            try {
                tasksClient.findTasks(params);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
            }
            params.clear();
            params.put("where", "(status = 'completed' AND processDefinitionName = 'Adhoc Activiti Process')");
            JSONObject response = this.publicApiClient.processesClient().getTasks(processInstance.getId(), params);
            Assert.assertNotNull((Object)response);
            JSONObject paginationJSON = (JSONObject)response.get((Object)"pagination");
            Assert.assertEquals((Object)1L, (Object)paginationJSON.get((Object)"count"));
            params.clear();
            params.put("where", "(status = 'any' AND variables/numberVar < 'd:int 5')");
            Assert.assertEquals((long)0L, (long)this.getResultSizeForTaskQuery(params, tasksClient));
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance.getId(), otherInstance.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance.getId(), otherInstance.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTasksWithPaging() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ArrayList<ProcessInstance> startedProcesses = new ArrayList<ProcessInstance>();
        try {
            int numberOfTasks = 6;
            for (int i = 0; i < numberOfTasks; ++i) {
                startedProcesses.add(this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null));
            }
            String processDefinitionId = ((ProcessInstance)startedProcesses.get(0)).getProcessDefinitionId();
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("where", "(processDefinitionId = '" + processDefinitionId + "' AND includeProcessVariables = true AND includeTaskVariables = true)");
            JSONObject taskListJSONObject = tasksClient.findTasks(params);
            Assert.assertNotNull((Object)taskListJSONObject);
            JSONObject paginationJSON = (JSONObject)taskListJSONObject.get((Object)"pagination");
            Assert.assertEquals((Object)6L, (Object)paginationJSON.get((Object)"count"));
            Assert.assertEquals((Object)6L, (Object)paginationJSON.get((Object)"totalItems"));
            Assert.assertEquals((Object)0L, (Object)paginationJSON.get((Object)"skipCount"));
            Assert.assertEquals((Object)false, (Object)paginationJSON.get((Object)"hasMoreItems"));
            JSONArray jsonEntries = (JSONArray)taskListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)6L, (long)jsonEntries.size());
            this.validateVariables((JSONObject)jsonEntries.get(0), requestContext);
            params.clear();
            params.put("maxItems", "3");
            params.put("where", "(processDefinitionId = '" + processDefinitionId + "' AND includeProcessVariables = true AND includeTaskVariables = true)");
            taskListJSONObject = tasksClient.findTasks(params);
            Assert.assertNotNull((Object)taskListJSONObject);
            paginationJSON = (JSONObject)taskListJSONObject.get((Object)"pagination");
            Assert.assertEquals((Object)3L, (Object)paginationJSON.get((Object)"count"));
            Assert.assertEquals((Object)6L, (Object)paginationJSON.get((Object)"totalItems"));
            Assert.assertEquals((Object)0L, (Object)paginationJSON.get((Object)"skipCount"));
            Assert.assertEquals((Object)true, (Object)paginationJSON.get((Object)"hasMoreItems"));
            jsonEntries = (JSONArray)taskListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)3L, (long)jsonEntries.size());
            this.validateVariables((JSONObject)jsonEntries.get(0), requestContext);
            params.clear();
            params.put("skipCount", "2");
            params.put("where", "(processDefinitionId = '" + processDefinitionId + "' AND includeProcessVariables = true AND includeTaskVariables = true)");
            taskListJSONObject = tasksClient.findTasks(params);
            Assert.assertNotNull((Object)taskListJSONObject);
            paginationJSON = (JSONObject)taskListJSONObject.get((Object)"pagination");
            Assert.assertEquals((Object)4L, (Object)paginationJSON.get((Object)"count"));
            Assert.assertEquals((Object)6L, (Object)paginationJSON.get((Object)"totalItems"));
            Assert.assertEquals((Object)2L, (Object)paginationJSON.get((Object)"skipCount"));
            Assert.assertEquals((Object)false, (Object)paginationJSON.get((Object)"hasMoreItems"));
            jsonEntries = (JSONArray)taskListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)4L, (long)jsonEntries.size());
            params.clear();
            params.put("maxItems", "3");
            params.put("skipCount", "2");
            params.put("where", "(processDefinitionId = '" + processDefinitionId + "' AND includeProcessVariables = true AND includeTaskVariables = true)");
            taskListJSONObject = tasksClient.findTasks(params);
            Assert.assertNotNull((Object)taskListJSONObject);
            paginationJSON = (JSONObject)taskListJSONObject.get((Object)"pagination");
            Assert.assertEquals((Object)3L, (Object)paginationJSON.get((Object)"count"));
            Assert.assertEquals((Object)6L, (Object)paginationJSON.get((Object)"totalItems"));
            Assert.assertEquals((Object)2L, (Object)paginationJSON.get((Object)"skipCount"));
            Assert.assertEquals((Object)true, (Object)paginationJSON.get((Object)"hasMoreItems"));
            jsonEntries = (JSONArray)taskListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)3L, (long)jsonEntries.size());
            params.clear();
            params.put("maxItems", "3");
            params.put("skipCount", "4");
            params.put("where", "(processDefinitionId = '" + processDefinitionId + "' AND includeProcessVariables = true AND includeTaskVariables = true)");
            taskListJSONObject = tasksClient.findTasks(params);
            Assert.assertNotNull((Object)taskListJSONObject);
            paginationJSON = (JSONObject)taskListJSONObject.get((Object)"pagination");
            Assert.assertEquals((Object)2L, (Object)paginationJSON.get((Object)"count"));
            Assert.assertEquals((Object)6L, (Object)paginationJSON.get((Object)"totalItems"));
            Assert.assertEquals((Object)4L, (Object)paginationJSON.get((Object)"skipCount"));
            Assert.assertEquals((Object)false, (Object)paginationJSON.get((Object)"hasMoreItems"));
            jsonEntries = (JSONArray)taskListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)2L, (long)jsonEntries.size());
        }
        finally {
            this.cleanupProcessInstance(startedProcesses.toArray(new ProcessInstance[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTasksWithPagingAndVariablesLimit() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ArrayList<ProcessInstance> startedProcesses = new ArrayList<ProcessInstance>();
        try {
            int numberOfTasks = 15;
            for (int i = 0; i < numberOfTasks; ++i) {
                startedProcesses.add(this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null));
            }
            TaskService taskService = this.activitiProcessEngine.getTaskService();
            ArrayList<Task> taskList = new ArrayList<Task>();
            for (int i = 0; i < numberOfTasks; ++i) {
                Task task = (Task)((TaskQuery)taskService.createTaskQuery().processInstanceId(((ProcessInstance)startedProcesses.get(i)).getProcessInstanceId())).singleResult();
                taskService.setPriority(task.getId(), (i + 1) * 10);
                taskService.setVariableLocal(task.getId(), "test1", (Object)"test1");
                taskList.add(task);
            }
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("where", "(includeProcessVariables = true AND includeTaskVariables = true)");
            JSONObject taskListJSONObject = tasksClient.findTasks(params);
            Assert.assertNotNull((Object)taskListJSONObject);
            JSONObject paginationJSON = (JSONObject)taskListJSONObject.get((Object)"pagination");
            Assert.assertEquals((Object)15L, (Object)paginationJSON.get((Object)"count"));
            Assert.assertEquals((Object)15L, (Object)paginationJSON.get((Object)"totalItems"));
            Assert.assertEquals((Object)0L, (Object)paginationJSON.get((Object)"skipCount"));
            Assert.assertEquals((Object)false, (Object)paginationJSON.get((Object)"hasMoreItems"));
            JSONArray jsonEntries = (JSONArray)taskListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)15L, (long)jsonEntries.size());
            params.clear();
            params.put("skipCount", "5");
            params.put("where", "(includeProcessVariables = true AND includeTaskVariables = true)");
            taskListJSONObject = tasksClient.findTasks(params);
            Assert.assertNotNull((Object)taskListJSONObject);
            paginationJSON = (JSONObject)taskListJSONObject.get((Object)"pagination");
            Assert.assertEquals((Object)10L, (Object)paginationJSON.get((Object)"count"));
            Assert.assertEquals((Object)15L, (Object)paginationJSON.get((Object)"totalItems"));
            Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"skipCount"));
            Assert.assertEquals((Object)false, (Object)paginationJSON.get((Object)"hasMoreItems"));
            jsonEntries = (JSONArray)taskListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)10L, (long)jsonEntries.size());
            params.clear();
            params.put("maxItems", "10");
            params.put("where", "(includeProcessVariables = true AND includeTaskVariables = true)");
            taskListJSONObject = tasksClient.findTasks(params);
            Assert.assertNotNull((Object)taskListJSONObject);
            paginationJSON = (JSONObject)taskListJSONObject.get((Object)"pagination");
            Assert.assertEquals((Object)10L, (Object)paginationJSON.get((Object)"count"));
            Assert.assertEquals((Object)15L, (Object)paginationJSON.get((Object)"totalItems"));
            Assert.assertEquals((Object)0L, (Object)paginationJSON.get((Object)"skipCount"));
            Assert.assertEquals((Object)true, (Object)paginationJSON.get((Object)"hasMoreItems"));
            jsonEntries = (JSONArray)taskListJSONObject.get((Object)"entries");
            Assert.assertEquals((long)10L, (long)jsonEntries.size());
        }
        finally {
            this.cleanupProcessInstance(startedProcesses.toArray(new ProcessInstance[0]));
        }
    }

    protected void validateVariables(JSONObject entry, RequestContext requestContext) {
        JSONObject taskObject = (JSONObject)entry.get((Object)"entry");
        JSONArray variables = (JSONArray)taskObject.get((Object)"variables");
        boolean foundInitiator = false;
        boolean foundAssignee = false;
        boolean foundPercentageComplete = false;
        boolean foundReassignable = false;
        for (int i = 0; i < variables.size(); ++i) {
            JSONObject variableJSON = (JSONObject)variables.get(i);
            if ("initiator".equals(variableJSON.get((Object)"name"))) {
                Assert.assertEquals((Object)"d:noderef", (Object)variableJSON.get((Object)"type"));
                Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)variableJSON.get((Object)"value"));
                foundInitiator = true;
                continue;
            }
            if ("bpm_assignee".equals(variableJSON.get((Object)"name"))) {
                Assert.assertEquals((Object)"cm:person", (Object)variableJSON.get((Object)"type"));
                Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)variableJSON.get((Object)"value"));
                foundAssignee = true;
                continue;
            }
            if ("bpm_percentComplete".equals(variableJSON.get((Object)"name"))) {
                Assert.assertEquals((Object)"d:int", (Object)variableJSON.get((Object)"type"));
                Assert.assertEquals((Object)0L, (Object)variableJSON.get((Object)"value"));
                foundPercentageComplete = true;
                continue;
            }
            if (!"bpm_reassignable".equals(variableJSON.get((Object)"name"))) continue;
            Assert.assertEquals((Object)"d:boolean", (Object)variableJSON.get((Object)"type"));
            Assert.assertEquals((Object)Boolean.TRUE, (Object)variableJSON.get((Object)"value"));
            foundReassignable = true;
        }
        Assert.assertTrue((boolean)foundInitiator);
        Assert.assertTrue((boolean)foundAssignee);
        Assert.assertTrue((boolean)foundPercentageComplete);
        Assert.assertTrue((boolean)foundReassignable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTasksWithSorting() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ArrayList<ProcessInstance> startedProcesses = new ArrayList<ProcessInstance>();
        try {
            int numberOfTasks = 6;
            for (int i = 0; i < numberOfTasks; ++i) {
                startedProcesses.add(this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null));
            }
            ArrayList<Task> taskList = new ArrayList<Task>();
            for (int i = 0; i < numberOfTasks; ++i) {
                Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(((ProcessInstance)startedProcesses.get(i)).getProcessInstanceId())).singleResult();
                this.activitiProcessEngine.getTaskService().setPriority(task.getId(), (i + 1) * 10);
                taskList.add(task);
            }
            this.activitiProcessEngine.getTaskService().setPriority(((Task)taskList.get(numberOfTasks - 1)).getId(), 1);
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("where", "(processDefinitionId = '" + ((ProcessInstance)startedProcesses.get(0)).getProcessDefinitionId() + "')");
            params.put("orderBy", "priority ASC");
            JSONObject tasksResponseJSON = tasksClient.findTasks(params);
            JSONObject paginationJSON = (JSONObject)tasksResponseJSON.get((Object)"pagination");
            Assert.assertEquals((Object)6L, (Object)paginationJSON.get((Object)"count"));
            Assert.assertEquals((Object)6L, (Object)paginationJSON.get((Object)"totalItems"));
            JSONArray tasksListJSON = (JSONArray)tasksResponseJSON.get((Object)"entries");
            Assert.assertEquals((long)6L, (long)tasksListJSON.size());
            JSONObject taskJSON = (JSONObject)((JSONObject)tasksListJSON.get(0)).get((Object)"entry");
            Assert.assertEquals((Object)((Task)taskList.get(numberOfTasks - 1)).getId(), (Object)taskJSON.get((Object)"id"));
            taskJSON = (JSONObject)((JSONObject)tasksListJSON.get(1)).get((Object)"entry");
            Assert.assertEquals((Object)((Task)taskList.get(0)).getId(), (Object)taskJSON.get((Object)"id"));
            taskJSON = (JSONObject)((JSONObject)tasksListJSON.get(2)).get((Object)"entry");
            Assert.assertEquals((Object)((Task)taskList.get(1)).getId(), (Object)taskJSON.get((Object)"id"));
            taskJSON = (JSONObject)((JSONObject)tasksListJSON.get(3)).get((Object)"entry");
            Assert.assertEquals((Object)((Task)taskList.get(2)).getId(), (Object)taskJSON.get((Object)"id"));
            taskJSON = (JSONObject)((JSONObject)tasksListJSON.get(4)).get((Object)"entry");
            Assert.assertEquals((Object)((Task)taskList.get(3)).getId(), (Object)taskJSON.get((Object)"id"));
            taskJSON = (JSONObject)((JSONObject)tasksListJSON.get(5)).get((Object)"entry");
            Assert.assertEquals((Object)((Task)taskList.get(4)).getId(), (Object)taskJSON.get((Object)"id"));
            params.put("orderBy", "priority DESC");
            tasksResponseJSON = tasksClient.findTasks(params);
            paginationJSON = (JSONObject)tasksResponseJSON.get((Object)"pagination");
            Assert.assertEquals((Object)6L, (Object)paginationJSON.get((Object)"count"));
            Assert.assertEquals((Object)6L, (Object)paginationJSON.get((Object)"totalItems"));
            tasksListJSON = (JSONArray)tasksResponseJSON.get((Object)"entries");
            Assert.assertEquals((long)6L, (long)tasksListJSON.size());
            taskJSON = (JSONObject)((JSONObject)tasksListJSON.get(0)).get((Object)"entry");
            Assert.assertEquals((Object)((Task)taskList.get(4)).getId(), (Object)taskJSON.get((Object)"id"));
            taskJSON = (JSONObject)((JSONObject)tasksListJSON.get(1)).get((Object)"entry");
            Assert.assertEquals((Object)((Task)taskList.get(3)).getId(), (Object)taskJSON.get((Object)"id"));
            taskJSON = (JSONObject)((JSONObject)tasksListJSON.get(2)).get((Object)"entry");
            Assert.assertEquals((Object)((Task)taskList.get(2)).getId(), (Object)taskJSON.get((Object)"id"));
            taskJSON = (JSONObject)((JSONObject)tasksListJSON.get(3)).get((Object)"entry");
            Assert.assertEquals((Object)((Task)taskList.get(1)).getId(), (Object)taskJSON.get((Object)"id"));
            taskJSON = (JSONObject)((JSONObject)tasksListJSON.get(4)).get((Object)"entry");
            Assert.assertEquals((Object)((Task)taskList.get(0)).getId(), (Object)taskJSON.get((Object)"id"));
            taskJSON = (JSONObject)((JSONObject)tasksListJSON.get(5)).get((Object)"entry");
            Assert.assertEquals((Object)((Task)taskList.get(numberOfTasks - 1)).getId(), (Object)taskJSON.get((Object)"id"));
            params.put("orderBy", "dueAt DESC");
            tasksResponseJSON = tasksClient.findTasks(params);
            tasksListJSON = (JSONArray)tasksResponseJSON.get((Object)"entries");
            Assert.assertEquals((long)6L, (long)tasksListJSON.size());
        }
        finally {
            this.cleanupProcessInstance(startedProcesses.toArray(new ProcessInstance[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTasksAuthorization() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String initiator = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        ProcessInstance processInstance = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("processId", processInstance.getId());
            JSONObject resultingTasks = tasksClient.findTasks(params);
            Assert.assertNotNull((Object)resultingTasks);
            JSONArray jsonEntries = (JSONArray)resultingTasks.get((Object)"entries");
            Assert.assertNotNull((Object)jsonEntries);
            Assert.assertEquals((long)0L, (long)jsonEntries.size());
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), requestContext.getRunAsUser());
            resultingTasks = tasksClient.findTasks(params);
            Assert.assertNotNull((Object)resultingTasks);
            jsonEntries = (JSONArray)resultingTasks.get((Object)"entries");
            Assert.assertNotNull((Object)jsonEntries);
            Assert.assertEquals((long)1L, (long)jsonEntries.size());
            String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
            resultingTasks = tasksClient.findTasks(params);
            Assert.assertNotNull((Object)resultingTasks);
            jsonEntries = (JSONArray)resultingTasks.get((Object)"entries");
            Assert.assertNotNull((Object)jsonEntries);
            Assert.assertEquals((long)1L, (long)jsonEntries.size());
            RepoService.TestNetwork anotherNetwork = this.getOtherNetwork(requestContext.getNetworkId());
            tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + anotherNetwork.getId();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
            resultingTasks = tasksClient.findTasks(params);
            Assert.assertNotNull((Object)resultingTasks);
            jsonEntries = (JSONArray)resultingTasks.get((Object)"entries");
            Assert.assertNotNull((Object)jsonEntries);
            Assert.assertEquals((long)0L, (long)jsonEntries.size());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTaskCandidates() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            this.activitiProcessEngine.getTaskService().addCandidateUser(task.getId(), "testuser");
            this.activitiProcessEngine.getTaskService().addCandidateUser(task.getId(), "testuser2");
            this.activitiProcessEngine.getTaskService().addCandidateGroup(task.getId(), "testgroup");
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject taskCandidatesJSONObject = tasksClient.findTaskCandidates(task.getId());
            Assert.assertNotNull((Object)taskCandidatesJSONObject);
            JSONArray candidateArrayJSON = (JSONArray)((JSONObject)taskCandidatesJSONObject.get((Object)"list")).get((Object)"entries");
            Assert.assertEquals((long)3L, (long)candidateArrayJSON.size());
            boolean testUser1Found = false;
            boolean testUser2Found = false;
            boolean testGroupFound = false;
            for (int i = 0; i < candidateArrayJSON.size(); ++i) {
                JSONObject entry = (JSONObject)((JSONObject)candidateArrayJSON.get(i)).get((Object)"entry");
                if ("group".equals(entry.get((Object)"candidateType"))) {
                    testGroupFound = true;
                    Assert.assertEquals((Object)"testgroup", (Object)entry.get((Object)"candidateId"));
                    continue;
                }
                if (!"user".equals(entry.get((Object)"candidateType"))) continue;
                if ("testuser".equals(entry.get((Object)"candidateId"))) {
                    testUser1Found = true;
                    continue;
                }
                if (!"testuser2".equals(entry.get((Object)"candidateId"))) continue;
                testUser2Found = true;
            }
            Assert.assertTrue((boolean)testUser1Found);
            Assert.assertTrue((boolean)testUser2Found);
            Assert.assertTrue((boolean)testGroupFound);
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTaskVariablesAuthentication() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String initiator = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        ProcessInstance processInstance = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            try {
                tasksClient.findTaskVariables(task.getId());
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), requestContext.getRunAsUser());
            JSONObject jsonObject = tasksClient.findTaskVariables(task.getId());
            Assert.assertNotNull((Object)jsonObject);
            String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
            jsonObject = tasksClient.findTaskVariables(task.getId());
            Assert.assertNotNull((Object)jsonObject);
            RepoService.TestNetwork anotherNetwork = this.getOtherNetwork(requestContext.getNetworkId());
            tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + anotherNetwork.getId();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
            try {
                tasksClient.findTaskVariables(task.getId());
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTaskVariables() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Map actualLocalVariables = this.activitiProcessEngine.getTaskService().getVariablesLocal(task.getId());
            Map actualGlobalVariables = this.activitiProcessEngine.getRuntimeService().getVariables(processInstance.getId());
            Assert.assertEquals((long)5L, (long)actualGlobalVariables.size());
            Assert.assertEquals((long)8L, (long)actualLocalVariables.size());
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject variables = tasksClient.findTaskVariables(task.getId());
            Assert.assertNotNull((Object)variables);
            JSONObject list = (JSONObject)variables.get((Object)"list");
            Assert.assertNotNull((Object)list);
            JSONArray entries = (JSONArray)list.get((Object)"entries");
            Assert.assertNotNull((Object)entries);
            JSONObject pagination = (JSONObject)list.get((Object)"pagination");
            Assert.assertNotNull((Object)pagination);
            Assert.assertEquals((Object)12L, (Object)pagination.get((Object)"count"));
            Assert.assertEquals((Object)12L, (Object)pagination.get((Object)"totalItems"));
            Assert.assertEquals((Object)0L, (Object)pagination.get((Object)"skipCount"));
            Assert.assertFalse((boolean)((Boolean)pagination.get((Object)"hasMoreItems")));
            Assert.assertEquals((long)(actualLocalVariables.size() + actualGlobalVariables.size() - 1), (long)entries.size());
            ArrayList<JSONObject> localResults = new ArrayList<JSONObject>();
            ArrayList<JSONObject> globalResults = new ArrayList<JSONObject>();
            HashSet expectedLocalVars = new HashSet();
            expectedLocalVars.addAll(actualLocalVariables.keySet());
            HashSet expectedGlobalVars = new HashSet();
            expectedGlobalVars.addAll(actualGlobalVariables.keySet());
            expectedGlobalVars.remove("_tenant_domain");
            HashMap<String, JSONObject> entriesByName = new HashMap<String, JSONObject>();
            for (int i = 0; i < entries.size(); ++i) {
                JSONObject entry = (JSONObject)((JSONObject)entries.get(i)).get((Object)"entry");
                Assert.assertNotNull((Object)entry);
                Assert.assertNotNull((Object)entry.get((Object)"scope"));
                Assert.assertNotNull((Object)entry.get((Object)"name"));
                Assert.assertNotNull((Object)entry.get((Object)"type"));
                if (!entry.get((Object)"name").equals("bpm_hiddenTransitions")) {
                    Assert.assertNotNull((Object)entry.get((Object)"value"));
                }
                if ("local".equals(entry.get((Object)"scope"))) {
                    localResults.add(entry);
                    expectedLocalVars.remove(entry.get((Object)"name"));
                } else if ("global".equals(entry.get((Object)"scope"))) {
                    globalResults.add(entry);
                    expectedGlobalVars.remove(entry.get((Object)"name"));
                }
                entriesByName.put((String)entry.get((Object)"name"), entry);
            }
            Assert.assertEquals((long)4L, (long)globalResults.size());
            Assert.assertEquals((long)8L, (long)localResults.size());
            Assert.assertEquals((long)0L, (long)expectedGlobalVars.size());
            Assert.assertEquals((long)0L, (long)expectedLocalVars.size());
            JSONObject var = (JSONObject)entriesByName.get("bpm_percentComplete");
            Assert.assertNotNull((Object)var);
            Assert.assertEquals((Object)"d:int", (Object)var.get((Object)"type"));
            Assert.assertEquals((Object)0L, (Object)var.get((Object)"value"));
            var = (JSONObject)entriesByName.get("bpm_reassignable");
            Assert.assertNotNull((Object)var);
            Assert.assertEquals((Object)"d:boolean", (Object)var.get((Object)"type"));
            Assert.assertEquals((Object)Boolean.TRUE, (Object)var.get((Object)"value"));
            var = (JSONObject)entriesByName.get("bpm_status");
            Assert.assertNotNull((Object)var);
            Assert.assertEquals((Object)"d:text", (Object)var.get((Object)"type"));
            Assert.assertEquals((Object)"Not Yet Started", (Object)var.get((Object)"value"));
            var = (JSONObject)entriesByName.get("bpm_assignee");
            Assert.assertNotNull((Object)var);
            Assert.assertEquals((Object)"cm:person", (Object)var.get((Object)"type"));
            String userName = requestContext.getRunAsUser();
            Assert.assertEquals((Object)userName, (Object)var.get((Object)"value"));
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateTaskVariablesPresentInModel() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Map actualLocalVariables = this.activitiProcessEngine.getTaskService().getVariablesLocal(task.getId());
            Map actualGlobalVariables = this.activitiProcessEngine.getRuntimeService().getVariables(processInstance.getId());
            Assert.assertEquals((long)5L, (long)actualGlobalVariables.size());
            Assert.assertEquals((long)8L, (long)actualLocalVariables.size());
            JSONObject variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"bpm_percentComplete");
            variableBody.put((Object)"value", (Object)20);
            variableBody.put((Object)"type", (Object)"d:int");
            variableBody.put((Object)"scope", (Object)"global");
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject resultEntry = tasksClient.updateTaskVariable(task.getId(), "bpm_percentComplete", variableBody);
            Assert.assertNotNull((Object)resultEntry);
            JSONObject result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"bpm_percentComplete", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)20L, (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:int", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)"global", (Object)result.get((Object)"scope"));
            Assert.assertEquals((Object)20, (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processInstance.getId(), "bpm_percentComplete"));
            variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"bpm_percentComplete");
            variableBody.put((Object)"value", (Object)30);
            variableBody.put((Object)"scope", (Object)"local");
            result = resultEntry = tasksClient.updateTaskVariable(task.getId(), "bpm_percentComplete", variableBody);
            Assert.assertNotNull((Object)resultEntry);
            result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"bpm_percentComplete", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)30L, (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:int", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)"local", (Object)result.get((Object)"scope"));
            Assert.assertEquals((Object)30, (Object)this.activitiProcessEngine.getTaskService().getVariable(task.getId(), "bpm_percentComplete"));
            Assert.assertEquals((Object)20, (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processInstance.getId(), "bpm_percentComplete"));
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateTaskVariablesExplicitTyped() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Map actualLocalVariables = this.activitiProcessEngine.getTaskService().getVariablesLocal(task.getId());
            Map actualGlobalVariables = this.activitiProcessEngine.getRuntimeService().getVariables(processInstance.getId());
            Assert.assertEquals((long)5L, (long)actualGlobalVariables.size());
            Assert.assertEquals((long)8L, (long)actualLocalVariables.size());
            JSONObject variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"newVariable");
            variableBody.put((Object)"value", (Object)1234L);
            variableBody.put((Object)"type", (Object)"d:long");
            variableBody.put((Object)"scope", (Object)"global");
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject resultEntry = tasksClient.updateTaskVariable(task.getId(), "newVariable", variableBody);
            Assert.assertNotNull((Object)resultEntry);
            JSONObject result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"newVariable", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)1234L, (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:long", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)"global", (Object)result.get((Object)"scope"));
            Assert.assertEquals((Object)1234L, (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processInstance.getId(), "newVariable"));
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateTaskVariablesNoExplicitType() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Map actualLocalVariables = this.activitiProcessEngine.getTaskService().getVariablesLocal(task.getId());
            Map actualGlobalVariables = this.activitiProcessEngine.getRuntimeService().getVariables(processInstance.getId());
            Assert.assertEquals((long)5L, (long)actualGlobalVariables.size());
            Assert.assertEquals((long)8L, (long)actualLocalVariables.size());
            JSONObject variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"newVariable");
            variableBody.put((Object)"value", (Object)1234);
            variableBody.put((Object)"scope", (Object)"global");
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject resultEntry = tasksClient.updateTaskVariable(task.getId(), "newVariable", variableBody);
            Assert.assertNotNull((Object)resultEntry);
            JSONObject result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"newVariable", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)1234L, (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:int", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)"global", (Object)result.get((Object)"scope"));
            Assert.assertEquals((Object)1234, (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processInstance.getId(), "newVariable"));
            variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"newVariable");
            variableBody.put((Object)"value", (Object)Boolean.TRUE);
            variableBody.put((Object)"scope", (Object)"local");
            resultEntry = tasksClient.updateTaskVariable(task.getId(), "newVariable", variableBody);
            Assert.assertNotNull((Object)resultEntry);
            result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"newVariable", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)Boolean.TRUE, (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:boolean", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)"local", (Object)result.get((Object)"scope"));
            Assert.assertEquals((Object)Boolean.TRUE, (Object)this.activitiProcessEngine.getTaskService().getVariable(task.getId(), "newVariable"));
            variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"newVariable");
            variableBody.put((Object)"value", (Object)"test value");
            variableBody.put((Object)"scope", (Object)"global");
            resultEntry = tasksClient.updateTaskVariable(task.getId(), "newVariable", variableBody);
            Assert.assertNotNull((Object)resultEntry);
            result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"newVariable", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)"test value", (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:text", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)"global", (Object)result.get((Object)"scope"));
            Assert.assertEquals((Object)"test value", (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processInstance.getId(), "newVariable"));
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateTaskVariablesExceptions() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            JSONObject variableBody = new JSONObject();
            variableBody.put((Object)"value", (Object)1234);
            variableBody.put((Object)"scope", (Object)"global");
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            try {
                tasksClient.updateTaskVariable(task.getId(), "newVariable", variableBody);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Variable name is required.", expected.getHttpResponse());
            }
            variableBody = new JSONObject();
            variableBody.put((Object)"value", (Object)1234);
            variableBody.put((Object)"name", (Object)"newVariable");
            try {
                tasksClient.updateTaskVariable(task.getId(), "newVariable", variableBody);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Variable scope is required and can only be 'local' or 'global'.", expected.getHttpResponse());
            }
            variableBody = new JSONObject();
            variableBody.put((Object)"value", (Object)1234);
            variableBody.put((Object)"name", (Object)"newVariable");
            variableBody.put((Object)"scope", (Object)"any");
            try {
                tasksClient.updateTaskVariable(task.getId(), "newVariable", variableBody);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Variable scope is required and can only be 'local' or 'global'.", expected.getHttpResponse());
            }
            variableBody = new JSONObject();
            variableBody.put((Object)"value", (Object)1234);
            variableBody.put((Object)"name", (Object)"newVariable");
            variableBody.put((Object)"scope", (Object)"illegal");
            try {
                tasksClient.updateTaskVariable(task.getId(), "newVariable", variableBody);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Illegal value for variable scope: 'illegal'.", expected.getHttpResponse());
            }
            variableBody = new JSONObject();
            variableBody.put((Object)"value", (Object)1234);
            variableBody.put((Object)"name", (Object)"newVariable");
            variableBody.put((Object)"scope", (Object)"local");
            variableBody.put((Object)"type", (Object)"d:unexisting");
            try {
                tasksClient.updateTaskVariable(task.getId(), "newVariable", variableBody);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Unsupported type of variable: 'd:unexisting'.", expected.getHttpResponse());
            }
            variableBody = new JSONObject();
            variableBody.put((Object)"value", (Object)1234);
            variableBody.put((Object)"name", (Object)"newVariable");
            variableBody.put((Object)"scope", (Object)"local");
            variableBody.put((Object)"type", (Object)" 12unexisting");
            try {
                tasksClient.updateTaskVariable(task.getId(), "newVariable", variableBody);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Unsupported type of variable: ' 12unexisting'.", expected.getHttpResponse());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateTaskVariableWithWrongType() throws Exception {
        final RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInfo processRest = this.startParallelReviewProcess(requestContext);
        try {
            List tasks = ((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processRest.getId())).list();
            Assert.assertNotNull((Object)tasks);
            String taskId = ((Task)tasks.get(0)).getId();
            JSONObject variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"wf_requiredApprovePercent");
            variableJson.put((Object)"value", (Object)55.99);
            variableJson.put((Object)"type", (Object)"d:double");
            variableJson.put((Object)"scope", (Object)"global");
            try {
                this.publicApiClient.tasksClient().updateTaskVariable(taskId, "wf_requiredApprovePercent", variableJson);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)e.getHttpResponse().getStatusCode());
            }
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"wf_requiredApprovePercent");
            variableJson.put((Object)"value", (Object)55.99);
            variableJson.put((Object)"type", (Object)"d:int");
            variableJson.put((Object)"scope", (Object)"global");
            JSONObject resultEntry = this.publicApiClient.tasksClient().updateTaskVariable(taskId, "wf_requiredApprovePercent", variableJson);
            Assert.assertNotNull((Object)resultEntry);
            JSONObject result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"wf_requiredApprovePercent", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)55L, (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:int", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)55, (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processRest.getId(), "wf_requiredApprovePercent"));
            JSONObject taskVariables = this.publicApiClient.tasksClient().findTaskVariables(taskId);
            Assert.assertNotNull((Object)taskVariables);
            JSONObject list = (JSONObject)taskVariables.get((Object)"list");
            Assert.assertNotNull((Object)list);
            HashMap<String, JSONObject> variablesByName = new HashMap<String, JSONObject>();
            JSONObject entry = null;
            JSONArray entries = (JSONArray)list.get((Object)"entries");
            Assert.assertNotNull((Object)entries);
            for (int i = 0; i < entries.size(); ++i) {
                entry = (JSONObject)entries.get(i);
                Assert.assertNotNull((Object)entry);
                entry = (JSONObject)entry.get((Object)"entry");
                Assert.assertNotNull((Object)entry);
                variablesByName.put((String)entry.get((Object)"name"), entry);
            }
            JSONObject approvePercentObject = (JSONObject)variablesByName.get("wf_requiredApprovePercent");
            Assert.assertNotNull((Object)approvePercentObject);
            Assert.assertEquals((Object)55L, (Object)approvePercentObject.get((Object)"value"));
            Assert.assertEquals((Object)"d:int", (Object)approvePercentObject.get((Object)"type"));
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"testVariable");
            variableJson.put((Object)"value", (Object)"text");
            variableJson.put((Object)"type", (Object)"d:text");
            variableJson.put((Object)"scope", (Object)"local");
            resultEntry = this.publicApiClient.tasksClient().updateTaskVariable(taskId, "testVariable", variableJson);
            Assert.assertNotNull((Object)resultEntry);
            result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"testVariable", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)"text", (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:text", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)"text", (Object)this.activitiProcessEngine.getTaskService().getVariable(taskId, "testVariable"));
            variableJson = new JSONObject();
            variableJson.put((Object)"name", (Object)"testVariable");
            variableJson.put((Object)"value", (Object)123);
            variableJson.put((Object)"type", (Object)"d:int");
            variableJson.put((Object)"scope", (Object)"local");
            resultEntry = this.publicApiClient.tasksClient().updateTaskVariable(taskId, "testVariable", variableJson);
            Assert.assertNotNull((Object)resultEntry);
            result = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"testVariable", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)123L, (Object)result.get((Object)"value"));
            Assert.assertEquals((Object)"d:int", (Object)result.get((Object)"type"));
            Assert.assertEquals((Object)123, (Object)this.activitiProcessEngine.getTaskService().getVariable(taskId, "testVariable"));
            final JSONObject updateAssigneesJson = new JSONObject();
            updateAssigneesJson.put((Object)"name", (Object)"bpm_assignees");
            updateAssigneesJson.put((Object)"type", (Object)"d:noderef");
            updateAssigneesJson.put((Object)"scope", (Object)"global");
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    JSONArray assigneeArray = new JSONArray();
                    assigneeArray.add((Object)requestContext.getRunAsUser());
                    updateAssigneesJson.put((Object)"value", (Object)assigneeArray);
                    return null;
                }
            }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
            resultEntry = this.publicApiClient.tasksClient().updateTaskVariable(taskId, "bpm_assignees", updateAssigneesJson);
            Assert.assertNotNull((Object)resultEntry);
            final JSONObject updateAssigneeResult = (JSONObject)resultEntry.get((Object)"entry");
            Assert.assertEquals((Object)"bpm_assignees", (Object)updateAssigneeResult.get((Object)"name"));
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    JSONArray assigneeArray = (JSONArray)updateAssigneeResult.get((Object)"value");
                    Assert.assertNotNull((Object)assigneeArray);
                    Assert.assertEquals((long)1L, (long)assigneeArray.size());
                    return null;
                }
            }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
            Assert.assertEquals((Object)"d:noderef", (Object)updateAssigneeResult.get((Object)"type"));
            final JSONObject updateAssigneeJson = new JSONObject();
            updateAssigneeJson.put((Object)"name", (Object)"bpm_assignees");
            updateAssigneeJson.put((Object)"type", (Object)"d:noderef");
            updateAssigneeJson.put((Object)"scope", (Object)"global");
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    updateAssigneeJson.put((Object)"value", (Object)requestContext.getRunAsUser());
                    return null;
                }
            }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
            try {
                this.publicApiClient.tasksClient().updateTaskVariable(taskId, "bpm_assignees", updateAssigneeJson);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)HttpStatus.BAD_REQUEST.value(), (long)e.getHttpResponse().getStatusCode());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processRest.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processRest.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpdateTaskVariablesAuthentication() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String initiator = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        ProcessInstance processInstance = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        try {
            JSONObject variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"newVariable");
            variableBody.put((Object)"value", (Object)1234);
            variableBody.put((Object)"scope", (Object)"global");
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            try {
                tasksClient.updateTaskVariable(task.getId(), "newVariable", variableBody);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), requestContext.getRunAsUser());
            JSONObject jsonObject = tasksClient.updateTaskVariable(task.getId(), "newVariable", variableBody);
            Assert.assertNotNull((Object)jsonObject);
            String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
            jsonObject = tasksClient.updateTaskVariable(task.getId(), "newVariable", variableBody);
            Assert.assertNotNull((Object)jsonObject);
            RepoService.TestNetwork anotherNetwork = this.getOtherNetwork(requestContext.getNetworkId());
            tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + anotherNetwork.getId();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
            try {
                jsonObject = tasksClient.updateTaskVariable(task.getId(), "newVariable", variableBody);
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTaskVariablesPresentInModel() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Map actualLocalVariables = this.activitiProcessEngine.getTaskService().getVariablesLocal(task.getId());
            Map actualGlobalVariables = this.activitiProcessEngine.getRuntimeService().getVariables(processInstance.getId());
            Assert.assertEquals((long)5L, (long)actualGlobalVariables.size());
            Assert.assertEquals((long)8L, (long)actualLocalVariables.size());
            JSONArray variablesArray = new JSONArray();
            JSONObject variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"bpm_percentComplete");
            variableBody.put((Object)"value", (Object)20);
            variableBody.put((Object)"type", (Object)"d:int");
            variableBody.put((Object)"scope", (Object)"global");
            variablesArray.add((Object)variableBody);
            variableBody = new JSONObject();
            variableBody.put((Object)"name", (Object)"bpm_workflowPriority");
            variableBody.put((Object)"value", (Object)50);
            variableBody.put((Object)"type", (Object)"d:int");
            variableBody.put((Object)"scope", (Object)"local");
            variablesArray.add((Object)variableBody);
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject result = tasksClient.createTaskVariables(task.getId(), variablesArray);
            Assert.assertNotNull((Object)result);
            JSONObject resultObject = (JSONObject)result.get((Object)"list");
            JSONArray resultList = (JSONArray)resultObject.get((Object)"entries");
            Assert.assertEquals((long)2L, (long)resultList.size());
            JSONObject firstResultObject = (JSONObject)((JSONObject)resultList.get(0)).get((Object)"entry");
            Assert.assertEquals((Object)"bpm_percentComplete", (Object)firstResultObject.get((Object)"name"));
            Assert.assertEquals((Object)20L, (Object)firstResultObject.get((Object)"value"));
            Assert.assertEquals((Object)"d:int", (Object)firstResultObject.get((Object)"type"));
            Assert.assertEquals((Object)"global", (Object)firstResultObject.get((Object)"scope"));
            Assert.assertEquals((Object)20, (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processInstance.getId(), "bpm_percentComplete"));
            JSONObject secondResultObject = (JSONObject)((JSONObject)resultList.get(1)).get((Object)"entry");
            Assert.assertEquals((Object)"bpm_workflowPriority", (Object)secondResultObject.get((Object)"name"));
            Assert.assertEquals((Object)50L, (Object)secondResultObject.get((Object)"value"));
            Assert.assertEquals((Object)"d:int", (Object)secondResultObject.get((Object)"type"));
            Assert.assertEquals((Object)"local", (Object)secondResultObject.get((Object)"scope"));
            Assert.assertEquals((Object)50, (Object)this.activitiProcessEngine.getTaskService().getVariable(task.getId(), "bpm_workflowPriority"));
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTaskVariablesRawVariableTypes() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Calendar dateCal = Calendar.getInstance();
            HashMap<String, Object> variablesToSet = new HashMap<String, Object>();
            variablesToSet.put("testVarString", "string");
            variablesToSet.put("testVarInteger", 1234);
            variablesToSet.put("testVarLong", 123456789L);
            variablesToSet.put("testVarDouble", 1234.5678);
            variablesToSet.put("testVarFloat", Float.valueOf(1234.0f));
            variablesToSet.put("testVarBoolean", Boolean.TRUE);
            variablesToSet.put("testVarDate", dateCal.getTime());
            variablesToSet.put("testVarQName", ContentModel.TYPE_AUTHORITY);
            variablesToSet.put("testVarNodeRef", new ActivitiScriptNode(new NodeRef("workspace:///testNode"), this.serviceRegistry));
            variablesToSet.put("testVarRawNodeRef", new NodeRef("workspace:///testNode"));
            this.activitiProcessEngine.getTaskService().setVariablesLocal(task.getId(), variablesToSet);
            Map actualLocalVariables = this.activitiProcessEngine.getTaskService().getVariablesLocal(task.getId());
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject variables = tasksClient.findTaskVariables(task.getId(), Collections.singletonMap("where", "(scope = local)"));
            Assert.assertNotNull((Object)variables);
            JSONObject list = (JSONObject)variables.get((Object)"list");
            Assert.assertNotNull((Object)list);
            JSONArray entries = (JSONArray)list.get((Object)"entries");
            Assert.assertNotNull((Object)entries);
            JSONObject pagination = (JSONObject)list.get((Object)"pagination");
            Assert.assertNotNull((Object)pagination);
            Assert.assertEquals((long)actualLocalVariables.size(), (long)((Long)pagination.get((Object)"count")).intValue());
            Assert.assertEquals((long)actualLocalVariables.size(), (long)((Long)pagination.get((Object)"totalItems")).intValue());
            Assert.assertEquals((Object)0L, (Object)pagination.get((Object)"skipCount"));
            Assert.assertFalse((boolean)((Boolean)pagination.get((Object)"hasMoreItems")));
            Assert.assertEquals((long)actualLocalVariables.size(), (long)entries.size());
            HashMap<String, JSONObject> entriesByName = new HashMap<String, JSONObject>();
            for (int i = 0; i < entries.size(); ++i) {
                JSONObject var = (JSONObject)entries.get(i);
                entriesByName.put((String)((JSONObject)var.get((Object)"entry")).get((Object)"name"), (JSONObject)var.get((Object)"entry"));
            }
            JSONObject var = (JSONObject)entriesByName.get("testVarString");
            Assert.assertNotNull((Object)var);
            Assert.assertEquals((Object)"d:text", (Object)var.get((Object)"type"));
            Assert.assertEquals((Object)"string", (Object)var.get((Object)"value"));
            var = (JSONObject)entriesByName.get("testVarInteger");
            Assert.assertNotNull((Object)var);
            Assert.assertEquals((Object)"d:int", (Object)var.get((Object)"type"));
            Assert.assertEquals((Object)1234L, (Object)var.get((Object)"value"));
            var = (JSONObject)entriesByName.get("testVarLong");
            Assert.assertNotNull((Object)var);
            Assert.assertEquals((Object)"d:long", (Object)var.get((Object)"type"));
            Assert.assertEquals((Object)123456789L, (Object)var.get((Object)"value"));
            var = (JSONObject)entriesByName.get("testVarDouble");
            Assert.assertNotNull((Object)var);
            Assert.assertEquals((Object)"d:double", (Object)var.get((Object)"type"));
            Assert.assertEquals((Object)1234.5678, (Object)var.get((Object)"value"));
            var = (JSONObject)entriesByName.get("testVarFloat");
            Assert.assertNotNull((Object)var);
            Assert.assertEquals((Object)"d:float", (Object)var.get((Object)"type"));
            Assert.assertEquals((Object)1234.0, (Object)var.get((Object)"value"));
            var = (JSONObject)entriesByName.get("testVarBoolean");
            Assert.assertNotNull((Object)var);
            Assert.assertEquals((Object)"d:boolean", (Object)var.get((Object)"type"));
            Assert.assertEquals((Object)Boolean.TRUE, (Object)var.get((Object)"value"));
            var = (JSONObject)entriesByName.get("testVarDate");
            Assert.assertNotNull((Object)var);
            Assert.assertEquals((Object)"d:datetime", (Object)var.get((Object)"type"));
            Assert.assertEquals((Object)dateCal.getTime(), (Object)this.parseDate(var, "value"));
            var = (JSONObject)entriesByName.get("testVarQName");
            Assert.assertNotNull((Object)var);
            Assert.assertEquals((Object)"d:qname", (Object)var.get((Object)"type"));
            Assert.assertEquals((Object)"cm:authority", (Object)var.get((Object)"value"));
            var = (JSONObject)entriesByName.get("testVarRawNodeRef");
            Assert.assertNotNull((Object)var);
            Assert.assertEquals((Object)"d:noderef", (Object)var.get((Object)"type"));
            Assert.assertEquals((Object)"workspace:///testNode", (Object)var.get((Object)"value"));
            var = (JSONObject)entriesByName.get("testVarNodeRef");
            Assert.assertNotNull((Object)var);
            Assert.assertEquals((Object)"d:noderef", (Object)var.get((Object)"type"));
            Assert.assertEquals((Object)"workspace:///testNode", (Object)var.get((Object)"value"));
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTaskVariablesScoped() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            Map actualLocalVariables = this.activitiProcessEngine.getTaskService().getVariablesLocal(task.getId());
            Map actualGlobalVariables = this.activitiProcessEngine.getRuntimeService().getVariables(processInstance.getId());
            Assert.assertEquals((long)5L, (long)actualGlobalVariables.size());
            Assert.assertEquals((long)8L, (long)actualLocalVariables.size());
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject variables = tasksClient.findTaskVariables(task.getId(), Collections.singletonMap("where", "(scope = local)"));
            Assert.assertNotNull((Object)variables);
            JSONObject list = (JSONObject)variables.get((Object)"list");
            Assert.assertNotNull((Object)list);
            JSONArray entries = (JSONArray)list.get((Object)"entries");
            Assert.assertNotNull((Object)entries);
            JSONObject pagination = (JSONObject)list.get((Object)"pagination");
            Assert.assertNotNull((Object)pagination);
            Assert.assertEquals((Object)8L, (Object)pagination.get((Object)"count"));
            Assert.assertEquals((Object)8L, (Object)pagination.get((Object)"totalItems"));
            Assert.assertEquals((Object)0L, (Object)pagination.get((Object)"skipCount"));
            Assert.assertFalse((boolean)((Boolean)pagination.get((Object)"hasMoreItems")));
            Assert.assertEquals((long)actualLocalVariables.size(), (long)entries.size());
            HashSet expectedLocalVars = new HashSet();
            expectedLocalVars.addAll(actualLocalVariables.keySet());
            for (int i = 0; i < entries.size(); ++i) {
                JSONObject entry = (JSONObject)((JSONObject)entries.get(i)).get((Object)"entry");
                Assert.assertNotNull((Object)entry);
                Assert.assertEquals((Object)"local", (Object)entry.get((Object)"scope"));
                Assert.assertNotNull((Object)entry.get((Object)"name"));
                Assert.assertNotNull((Object)entry.get((Object)"type"));
                if (!entry.get((Object)"name").equals("bpm_hiddenTransitions")) {
                    Assert.assertNotNull((Object)entry.get((Object)"value"));
                }
                expectedLocalVars.remove(entry.get((Object)"name"));
            }
            Assert.assertEquals((long)0L, (long)expectedLocalVars.size());
            variables = tasksClient.findTaskVariables(task.getId(), Collections.singletonMap("where", "(scope = global)"));
            Assert.assertNotNull((Object)variables);
            list = (JSONObject)variables.get((Object)"list");
            Assert.assertNotNull((Object)list);
            entries = (JSONArray)list.get((Object)"entries");
            Assert.assertNotNull((Object)entries);
            pagination = (JSONObject)list.get((Object)"pagination");
            Assert.assertNotNull((Object)pagination);
            Assert.assertEquals((Object)4L, (Object)pagination.get((Object)"count"));
            Assert.assertEquals((Object)4L, (Object)pagination.get((Object)"totalItems"));
            Assert.assertEquals((Object)0L, (Object)pagination.get((Object)"skipCount"));
            Assert.assertFalse((boolean)((Boolean)pagination.get((Object)"hasMoreItems")));
            Assert.assertEquals((long)(actualGlobalVariables.size() - 1), (long)entries.size());
            HashSet expectedGlobalVars = new HashSet();
            expectedGlobalVars.addAll(actualGlobalVariables.keySet());
            expectedGlobalVars.remove("_tenant_domain");
            for (int i = 0; i < entries.size(); ++i) {
                JSONObject entry = (JSONObject)((JSONObject)entries.get(i)).get((Object)"entry");
                Assert.assertNotNull((Object)entry);
                Assert.assertEquals((Object)"global", (Object)entry.get((Object)"scope"));
                Assert.assertNotNull((Object)entry.get((Object)"name"));
                Assert.assertNotNull((Object)entry.get((Object)"type"));
                Assert.assertNotNull((Object)entry.get((Object)"value"));
                expectedGlobalVars.remove(entry.get((Object)"name"));
            }
            Assert.assertEquals((long)0L, (long)expectedGlobalVars.size());
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTaskVariablesReview() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInfo processInstance = this.startParallelReviewProcess(requestContext);
        try {
            Task task = (Task)((TaskQuery)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).taskAssignee(requestContext.getRunAsUser())).singleResult();
            Assert.assertNotNull((Object)task);
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject variables = tasksClient.findTaskVariables(task.getId());
            Assert.assertNotNull((Object)variables);
            JSONObject list = (JSONObject)variables.get((Object)"list");
            Assert.assertNotNull((Object)list);
            JSONArray entries = (JSONArray)list.get((Object)"entries");
            Assert.assertNotNull((Object)entries);
            JSONObject pagination = (JSONObject)list.get((Object)"pagination");
            Assert.assertNotNull((Object)pagination);
            Assert.assertEquals((Object)42L, (Object)pagination.get((Object)"count"));
            Assert.assertEquals((Object)42L, (Object)pagination.get((Object)"totalItems"));
            Assert.assertEquals((Object)0L, (Object)pagination.get((Object)"skipCount"));
            Assert.assertFalse((boolean)((Boolean)pagination.get((Object)"hasMoreItems")));
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteTaskVariable() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        this.activitiProcessEngine.getRuntimeService().setVariable(processInstance.getId(), "overlappingVariable", (Object)"Value set in process");
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            this.activitiProcessEngine.getTaskService().setVariableLocal(task.getId(), "myVariable", (Object)"This is a variable");
            this.activitiProcessEngine.getTaskService().setVariableLocal(task.getId(), "overlappingVariable", (Object)"Value set in task");
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            tasksClient.deleteTaskVariable(task.getId(), "myVariable");
            Assert.assertFalse((boolean)this.activitiProcessEngine.getTaskService().hasVariableLocal(task.getId(), "myVariable"));
            tasksClient.deleteTaskVariable(task.getId(), "overlappingVariable");
            Assert.assertFalse((boolean)this.activitiProcessEngine.getTaskService().hasVariableLocal(task.getId(), "overlappingVariable"));
            Assert.assertTrue((boolean)this.activitiProcessEngine.getRuntimeService().hasVariable(processInstance.getId(), "overlappingVariable"));
            Assert.assertEquals((Object)"Value set in process", (Object)this.activitiProcessEngine.getRuntimeService().getVariable(processInstance.getId(), "overlappingVariable"));
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteTaskVariableExceptions() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        this.activitiProcessEngine.getRuntimeService().setVariable(processInstance.getId(), "overlappingVariable", (Object)"Value set in process");
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            try {
                tasksClient.deleteTaskVariable("unexisting", "myVar");
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("The entity with id: unexisting was not found", expected.getHttpResponse());
            }
            try {
                tasksClient.deleteTaskVariable(task.getId(), "unexistingVarName");
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.NOT_FOUND.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("The entity with id: unexistingVarName was not found", expected.getHttpResponse());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteTaskVariableAuthentication() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String initiator = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        ProcessInstance processInstance = this.startAdhocProcess(initiator, requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            this.activitiProcessEngine.getTaskService().setVariableLocal(task.getId(), "existingVariable", (Object)"Value");
            try {
                tasksClient.deleteTaskVariable(task.getId(), "existingVariable");
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
            Assert.assertTrue((boolean)this.activitiProcessEngine.getTaskService().hasVariableLocal(task.getId(), "existingVariable"));
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), requestContext.getRunAsUser());
            tasksClient.deleteTaskVariable(task.getId(), "existingVariable");
            Assert.assertFalse((boolean)this.activitiProcessEngine.getTaskService().hasVariableLocal(task.getId(), "existingVariable"));
            this.activitiProcessEngine.getTaskService().setVariableLocal(task.getId(), "existingVariable", (Object)"Value");
            String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
            tasksClient.deleteTaskVariable(task.getId(), "existingVariable");
            Assert.assertFalse((boolean)this.activitiProcessEngine.getTaskService().hasVariableLocal(task.getId(), "existingVariable"));
            this.activitiProcessEngine.getTaskService().setVariableLocal(task.getId(), "existingVariable", (Object)"Value");
            RepoService.TestNetwork anotherNetwork = this.getOtherNetwork(requestContext.getNetworkId());
            tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + anotherNetwork.getId();
            this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
            try {
                tasksClient.deleteTaskVariable(task.getId(), "existingVariable");
                Assert.fail((String)"Exception expected");
            }
            catch (PublicApiException expected) {
                Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
                this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTaskModel() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String otherPerson = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        RequestContext otherContext = new RequestContext(requestContext.getNetworkId(), otherPerson);
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        RequestContext adminContext = new RequestContext(requestContext.getNetworkId(), tenantAdmin);
        ProcessInstance processInstance = this.startAdhocProcess(requestContext.getRunAsUser(), requestContext.getNetworkId(), null);
        try {
            Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInstance.getId())).singleResult();
            Assert.assertNotNull((Object)task);
            JSONObject model = this.publicApiClient.tasksClient().findTaskFormModel(task.getId());
            Assert.assertNotNull((Object)model);
            JSONArray entries = (JSONArray)model.get((Object)"entries");
            Assert.assertNotNull((Object)entries);
            Map<String, JSONObject> modelFieldsByName = this.createEntryMap(entries);
            this.testModelEntries(modelFieldsByName);
            this.publicApiClient.setRequestContext(adminContext);
            model = this.publicApiClient.tasksClient().findTaskFormModel(task.getId());
            Assert.assertNotNull((Object)model);
            entries = (JSONArray)model.get((Object)"entries");
            Assert.assertNotNull((Object)entries);
            modelFieldsByName = this.createEntryMap(entries);
            this.testModelEntries(modelFieldsByName);
            this.publicApiClient.setRequestContext(otherContext);
            try {
                this.publicApiClient.tasksClient().findTaskFormModel(task.getId());
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
            }
            this.publicApiClient.setRequestContext(requestContext);
            try {
                this.publicApiClient.tasksClient().findTaskFormModel("fakeid");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInstance);
            throw throwable;
        }
        this.cleanupProcessInstance(processInstance);
    }

    protected Map<String, JSONObject> createEntryMap(JSONArray entries) {
        HashMap<String, JSONObject> modelFieldsByName = new HashMap<String, JSONObject>();
        JSONObject entry = null;
        for (int i = 0; i < entries.size(); ++i) {
            entry = (JSONObject)entries.get(i);
            Assert.assertNotNull((Object)entry);
            entry = (JSONObject)entry.get((Object)"entry");
            Assert.assertNotNull((Object)entry);
            modelFieldsByName.put((String)entry.get((Object)"name"), entry);
        }
        return modelFieldsByName;
    }

    protected void testModelEntries(Map<String, JSONObject> modelFieldsByName) {
        JSONObject modelEntry = modelFieldsByName.get("bpm_completionDate");
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)"Completion Date", (Object)modelEntry.get((Object)"title"));
        Assert.assertEquals((Object)"{http://www.alfresco.org/model/bpm/1.0}completionDate", (Object)modelEntry.get((Object)"qualifiedName"));
        Assert.assertEquals((Object)"d:date", (Object)modelEntry.get((Object)"dataType"));
        Assert.assertFalse((boolean)((Boolean)modelEntry.get((Object)"required")));
        modelEntry = modelFieldsByName.get("cm_owner");
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)"Owner", (Object)modelEntry.get((Object)"title"));
        Assert.assertEquals((Object)"{http://www.alfresco.org/model/content/1.0}owner", (Object)modelEntry.get((Object)"qualifiedName"));
        Assert.assertEquals((Object)"d:text", (Object)modelEntry.get((Object)"dataType"));
        Assert.assertFalse((boolean)((Boolean)modelEntry.get((Object)"required")));
        modelEntry = modelFieldsByName.get("bpm_package");
        Assert.assertNotNull((Object)modelEntry);
        Assert.assertEquals((Object)"Content Package", (Object)modelEntry.get((Object)"title"));
        Assert.assertEquals((Object)"{http://www.alfresco.org/model/bpm/1.0}package", (Object)modelEntry.get((Object)"qualifiedName"));
        Assert.assertEquals((Object)"bpm:workflowPackage", (Object)modelEntry.get((Object)"dataType"));
        Assert.assertFalse((boolean)((Boolean)modelEntry.get((Object)"required")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTaskItems() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String otherPerson = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        RequestContext otherContext = new RequestContext(requestContext.getNetworkId(), otherPerson);
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        RequestContext adminContext = new RequestContext(requestContext.getNetworkId(), tenantAdmin);
        NodeRef[] docNodeRefs = this.createTestDocuments(requestContext);
        ProcessInfo processInfo = this.startAdhocProcess(requestContext, docNodeRefs);
        final Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInfo.getId())).singleResult();
        Assert.assertNotNull((Object)task);
        this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), null);
        try {
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject itemsJSON = tasksClient.findTaskItems(task.getId());
            Assert.assertNotNull((Object)itemsJSON);
            JSONArray entriesJSON = (JSONArray)itemsJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 2 ? 1 : 0) != 0);
            boolean doc1Found = false;
            boolean doc2Found = false;
            for (Object entryObject : entriesJSON) {
                JSONObject entryObjectJSON = (JSONObject)entryObject;
                JSONObject entryJSON = (JSONObject)entryObjectJSON.get((Object)"entry");
                if (entryJSON.get((Object)"name").equals("Test Doc1")) {
                    doc1Found = true;
                    Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)entryJSON.get((Object)"id"));
                    Assert.assertEquals((Object)"Test Doc1", (Object)entryJSON.get((Object)"name"));
                    Assert.assertEquals((Object)"Test Doc1 Title", (Object)entryJSON.get((Object)"title"));
                    Assert.assertEquals((Object)"Test Doc1 Description", (Object)entryJSON.get((Object)"description"));
                    Assert.assertNotNull((Object)entryJSON.get((Object)"createdAt"));
                    Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)entryJSON.get((Object)"createdBy"));
                    Assert.assertNotNull((Object)entryJSON.get((Object)"modifiedAt"));
                    Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)entryJSON.get((Object)"modifiedBy"));
                    Assert.assertNotNull((Object)entryJSON.get((Object)"size"));
                    Assert.assertNotNull((Object)entryJSON.get((Object)"mimeType"));
                    continue;
                }
                doc2Found = true;
                Assert.assertEquals((Object)docNodeRefs[1].getId(), (Object)entryJSON.get((Object)"id"));
                Assert.assertEquals((Object)"Test Doc2", (Object)entryJSON.get((Object)"name"));
                Assert.assertEquals((Object)"Test Doc2 Title", (Object)entryJSON.get((Object)"title"));
                Assert.assertEquals((Object)"Test Doc2 Description", (Object)entryJSON.get((Object)"description"));
                Assert.assertNotNull((Object)entryJSON.get((Object)"createdAt"));
                Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)entryJSON.get((Object)"createdBy"));
                Assert.assertNotNull((Object)entryJSON.get((Object)"modifiedAt"));
                Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)entryJSON.get((Object)"modifiedBy"));
                Assert.assertNotNull((Object)entryJSON.get((Object)"size"));
                Assert.assertNotNull((Object)entryJSON.get((Object)"mimeType"));
            }
            Assert.assertTrue((boolean)doc1Found);
            Assert.assertTrue((boolean)doc2Found);
            this.publicApiClient.setRequestContext(adminContext);
            itemsJSON = tasksClient.findTaskItems(task.getId());
            Assert.assertNotNull((Object)itemsJSON);
            entriesJSON = (JSONArray)itemsJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 2 ? 1 : 0) != 0);
            this.publicApiClient.setRequestContext(otherContext);
            try {
                tasksClient.findTaskItems(task.getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
            }
            this.activitiProcessEngine.getTaskService().addCandidateUser(task.getId(), otherContext.getRunAsUser());
            this.publicApiClient.setRequestContext(otherContext);
            itemsJSON = tasksClient.findTaskItems(task.getId());
            Assert.assertNotNull((Object)itemsJSON);
            entriesJSON = (JSONArray)itemsJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 2 ? 1 : 0) != 0);
            List<MemberOfSite> memberships = this.getTestFixture().getNetwork(otherContext.getNetworkId()).getSiteMemberships(otherContext.getRunAsUser());
            Assert.assertTrue((memberships.size() > 0 ? 1 : 0) != 0);
            MemberOfSite memberOfSite = memberships.get(0);
            String group = "GROUP_site_" + memberOfSite.getSiteId() + "_" + memberOfSite.getRole().name();
            this.activitiProcessEngine.getTaskService().deleteCandidateUser(task.getId(), otherContext.getRunAsUser());
            this.activitiProcessEngine.getTaskService().addCandidateGroup(task.getId(), group);
            this.publicApiClient.setRequestContext(otherContext);
            itemsJSON = tasksClient.findTaskItems(task.getId());
            Assert.assertNotNull((Object)itemsJSON);
            entriesJSON = (JSONArray)itemsJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 2 ? 1 : 0) != 0);
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), requestContext.getRunAsUser());
            try {
                tasksClient.findTaskItems(task.getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
            }
            this.publicApiClient.setRequestContext(requestContext);
            try {
                tasksClient.findTaskItems("fakeid");
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TaskWorkflowApiTest.this.activitiProcessEngine.getTaskService().complete(task.getId());
                    return null;
                }
            }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
            this.publicApiClient.setRequestContext(requestContext);
            itemsJSON = tasksClient.findTaskItems(task.getId());
            Assert.assertNotNull((Object)itemsJSON);
            entriesJSON = (JSONArray)itemsJSON.get((Object)"entries");
            Assert.assertNotNull((Object)entriesJSON);
            Assert.assertTrue((entriesJSON.size() == 2 ? 1 : 0) != 0);
            this.publicApiClient.setRequestContext(otherContext);
            try {
                tasksClient.findTaskItems(task.getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInfo.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processInfo.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddTaskItem() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String otherPerson = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        RequestContext otherContext = new RequestContext(requestContext.getNetworkId(), otherPerson);
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        RequestContext adminContext = new RequestContext(requestContext.getNetworkId(), tenantAdmin);
        NodeRef[] docNodeRefs = this.createTestDocuments(requestContext);
        ProcessInfo processInfo = this.startAdhocProcess(requestContext, null);
        final Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInfo.getId())).singleResult();
        Assert.assertNotNull((Object)task);
        this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), null);
        try {
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            JSONObject createItemObject = new JSONObject();
            createItemObject.put((Object)"id", (Object)docNodeRefs[0].getId());
            JSONObject result = tasksClient.addTaskItem(task.getId(), createItemObject.toJSONString());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)result.get((Object)"id"));
            Assert.assertEquals((Object)"Test Doc1", (Object)result.get((Object)"name"));
            Assert.assertEquals((Object)"Test Doc1 Title", (Object)result.get((Object)"title"));
            Assert.assertEquals((Object)"Test Doc1 Description", (Object)result.get((Object)"description"));
            Assert.assertNotNull((Object)result.get((Object)"createdAt"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)result.get((Object)"createdBy"));
            Assert.assertNotNull((Object)result.get((Object)"modifiedAt"));
            Assert.assertEquals((Object)requestContext.getRunAsUser(), (Object)result.get((Object)"modifiedBy"));
            Assert.assertNotNull((Object)result.get((Object)"size"));
            Assert.assertNotNull((Object)result.get((Object)"mimeType"));
            JSONObject itemJSON = tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)itemJSON.get((Object)"id"));
            tasksClient.deleteTaskItem(task.getId(), docNodeRefs[0].getId());
            try {
                tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            this.publicApiClient.setRequestContext(adminContext);
            result = tasksClient.addTaskItem(task.getId(), createItemObject.toJSONString());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)result.get((Object)"id"));
            Assert.assertEquals((Object)"Test Doc1", (Object)result.get((Object)"name"));
            itemJSON = tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)itemJSON.get((Object)"id"));
            tasksClient.deleteTaskItem(task.getId(), docNodeRefs[0].getId());
            try {
                tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            this.activitiProcessEngine.getTaskService().addCandidateUser(task.getId(), otherPerson);
            this.publicApiClient.setRequestContext(otherContext);
            result = tasksClient.addTaskItem(task.getId(), createItemObject.toJSONString());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)result.get((Object)"id"));
            Assert.assertEquals((Object)"Test Doc1", (Object)result.get((Object)"name"));
            itemJSON = tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)itemJSON.get((Object)"id"));
            tasksClient.deleteTaskItem(task.getId(), docNodeRefs[0].getId());
            try {
                tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            this.activitiProcessEngine.getTaskService().deleteCandidateUser(task.getId(), otherPerson);
            this.publicApiClient.setRequestContext(otherContext);
            try {
                tasksClient.addTaskItem(task.getId(), createItemObject.toJSONString());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
            }
            List<MemberOfSite> memberships = this.getTestFixture().getNetwork(otherContext.getNetworkId()).getSiteMemberships(otherContext.getRunAsUser());
            Assert.assertTrue((memberships.size() > 0 ? 1 : 0) != 0);
            MemberOfSite memberOfSite = memberships.get(0);
            String group = "GROUP_site_" + memberOfSite.getSiteId() + "_" + memberOfSite.getRole().name();
            this.activitiProcessEngine.getTaskService().deleteCandidateUser(task.getId(), otherContext.getRunAsUser());
            this.activitiProcessEngine.getTaskService().addCandidateGroup(task.getId(), group);
            this.publicApiClient.setRequestContext(otherContext);
            result = tasksClient.addTaskItem(task.getId(), createItemObject.toJSONString());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)result.get((Object)"id"));
            Assert.assertEquals((Object)"Test Doc1", (Object)result.get((Object)"name"));
            itemJSON = tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)itemJSON.get((Object)"id"));
            tasksClient.deleteTaskItem(task.getId(), docNodeRefs[0].getId());
            try {
                tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), requestContext.getRunAsUser());
            this.publicApiClient.setRequestContext(otherContext);
            try {
                tasksClient.addTaskItem(task.getId(), createItemObject.toJSONString());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
            }
            this.publicApiClient.setRequestContext(requestContext);
            try {
                tasksClient.addTaskItem("fakeid", createItemObject.toJSONString());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            createItemObject = new JSONObject();
            createItemObject.put((Object)"id", (Object)"fakeid");
            try {
                tasksClient.addTaskItem(task.getId(), createItemObject.toJSONString());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TaskWorkflowApiTest.this.activitiProcessEngine.getTaskService().complete(task.getId());
                    return null;
                }
            }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
            createItemObject = new JSONObject();
            createItemObject.put((Object)"id", (Object)docNodeRefs[0].getId());
            try {
                tasksClient.addTaskItem(task.getId(), createItemObject.toJSONString());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInfo.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processInfo.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteTaskItem() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String otherPerson = this.getOtherPersonInNetwork(requestContext.getRunAsUser(), requestContext.getNetworkId()).getId();
        RequestContext otherContext = new RequestContext(requestContext.getNetworkId(), otherPerson);
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        RequestContext adminContext = new RequestContext(requestContext.getNetworkId(), tenantAdmin);
        NodeRef[] docNodeRefs = this.createTestDocuments(requestContext);
        ProcessInfo processInfo = this.startAdhocProcess(requestContext, docNodeRefs);
        final Task task = (Task)((TaskQuery)this.activitiProcessEngine.getTaskService().createTaskQuery().processInstanceId(processInfo.getId())).singleResult();
        Assert.assertNotNull((Object)task);
        this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), null);
        try {
            WorkflowApiClient.TasksClient tasksClient = this.publicApiClient.tasksClient();
            tasksClient.deleteTaskItem(task.getId(), docNodeRefs[0].getId());
            try {
                tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            JSONObject createItemObject = new JSONObject();
            createItemObject.put((Object)"id", (Object)docNodeRefs[0].getId());
            JSONObject result = tasksClient.addTaskItem(task.getId(), createItemObject.toJSONString());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)result.get((Object)"id"));
            JSONObject itemJSON = tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)itemJSON.get((Object)"id"));
            this.publicApiClient.setRequestContext(adminContext);
            tasksClient.deleteTaskItem(task.getId(), docNodeRefs[0].getId());
            try {
                tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            createItemObject = new JSONObject();
            createItemObject.put((Object)"id", (Object)docNodeRefs[0].getId());
            result = tasksClient.addTaskItem(task.getId(), createItemObject.toJSONString());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)result.get((Object)"id"));
            itemJSON = tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)itemJSON.get((Object)"id"));
            this.activitiProcessEngine.getTaskService().addCandidateUser(task.getId(), otherPerson);
            this.publicApiClient.setRequestContext(otherContext);
            tasksClient.deleteTaskItem(task.getId(), docNodeRefs[0].getId());
            try {
                tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            createItemObject = new JSONObject();
            createItemObject.put((Object)"id", (Object)docNodeRefs[0].getId());
            result = tasksClient.addTaskItem(task.getId(), createItemObject.toJSONString());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)result.get((Object)"id"));
            itemJSON = tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)itemJSON.get((Object)"id"));
            this.activitiProcessEngine.getTaskService().deleteCandidateUser(task.getId(), otherPerson);
            this.publicApiClient.setRequestContext(otherContext);
            try {
                tasksClient.deleteTaskItem(task.getId(), docNodeRefs[0].getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
            }
            List<MemberOfSite> memberships = this.getTestFixture().getNetwork(otherContext.getNetworkId()).getSiteMemberships(otherContext.getRunAsUser());
            Assert.assertTrue((memberships.size() > 0 ? 1 : 0) != 0);
            MemberOfSite memberOfSite = memberships.get(0);
            String group = "GROUP_site_" + memberOfSite.getSiteId() + "_" + memberOfSite.getRole().name();
            this.activitiProcessEngine.getTaskService().deleteCandidateUser(task.getId(), otherContext.getRunAsUser());
            this.activitiProcessEngine.getTaskService().addCandidateGroup(task.getId(), group);
            this.publicApiClient.setRequestContext(otherContext);
            createItemObject = new JSONObject();
            createItemObject.put((Object)"id", (Object)docNodeRefs[0].getId());
            result = tasksClient.addTaskItem(task.getId(), createItemObject.toJSONString());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)result.get((Object)"id"));
            itemJSON = tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)itemJSON.get((Object)"id"));
            tasksClient.deleteTaskItem(task.getId(), docNodeRefs[0].getId());
            try {
                tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            this.activitiProcessEngine.getTaskService().setAssignee(task.getId(), requestContext.getRunAsUser());
            this.publicApiClient.setRequestContext(requestContext);
            createItemObject = new JSONObject();
            createItemObject.put((Object)"id", (Object)docNodeRefs[0].getId());
            result = tasksClient.addTaskItem(task.getId(), createItemObject.toJSONString());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)result.get((Object)"id"));
            itemJSON = tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)itemJSON.get((Object)"id"));
            this.publicApiClient.setRequestContext(otherContext);
            try {
                tasksClient.deleteTaskItem(task.getId(), docNodeRefs[0].getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
            }
            this.publicApiClient.setRequestContext(requestContext);
            itemJSON = tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)itemJSON.get((Object)"id"));
            tasksClient.deleteTaskItem(task.getId(), docNodeRefs[0].getId());
            try {
                tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            this.publicApiClient.setRequestContext(requestContext);
            try {
                tasksClient.deleteTaskItem("fakeid", docNodeRefs[0].getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            try {
                tasksClient.deleteTaskItem(task.getId(), "fakeid");
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
            createItemObject = new JSONObject();
            createItemObject.put((Object)"id", (Object)docNodeRefs[0].getId());
            result = tasksClient.addTaskItem(task.getId(), createItemObject.toJSONString());
            Assert.assertNotNull((Object)result);
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)result.get((Object)"id"));
            itemJSON = tasksClient.findTaskItem(task.getId(), docNodeRefs[0].getId());
            Assert.assertEquals((Object)docNodeRefs[0].getId(), (Object)itemJSON.get((Object)"id"));
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Void>(){

                public Void doWork() throws Exception {
                    TaskWorkflowApiTest.this.activitiProcessEngine.getTaskService().complete(task.getId());
                    return null;
                }
            }, (String)requestContext.getRunAsUser(), (String)requestContext.getNetworkId());
            try {
                tasksClient.deleteTaskItem(task.getId(), docNodeRefs[0].getId());
                Assert.fail((String)"Expected exception");
            }
            catch (PublicApiException e) {
                Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
            }
        }
        catch (Throwable throwable) {
            this.cleanupProcessInstance(processInfo.getId());
            throw throwable;
        }
        this.cleanupProcessInstance(processInfo.getId());
    }

    protected ProcessInstance startAdhocProcess(final String user, final String networkId, final String businessKey) {
        return (ProcessInstance)TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<ProcessInstance>(){

            public ProcessInstance doWork() throws Exception {
                String processDefinitionKey = "@" + networkId + "@activitiAdhoc";
                HashMap<String, Object> variables = new HashMap<String, Object>();
                ActivitiScriptNode person = TaskWorkflowApiTest.this.getPersonNodeRef(user);
                variables.put("bpm_assignee", person);
                variables.put("wf_notifyMe", Boolean.FALSE);
                variables.put("initiator", person);
                return TaskWorkflowApiTest.this.activitiProcessEngine.getRuntimeService().startProcessInstanceByKey(processDefinitionKey, businessKey, variables);
            }
        }, (String)user, (String)networkId);
    }

    protected int getResultSizeForTaskQuery(Map<String, String> params, WorkflowApiClient.TasksClient tasksClient) throws Exception {
        JSONObject taskListJSONObject = tasksClient.findTasks(params);
        Assert.assertNotNull((Object)taskListJSONObject);
        JSONArray jsonEntries = (JSONArray)taskListJSONObject.get((Object)"entries");
        return jsonEntries.size();
    }

    protected void assertTasksPresentInTaskQuery(Map<String, String> params, WorkflowApiClient.TasksClient tasksClient, String ... taskIds) throws Exception {
        this.assertTasksPresentInTaskQuery(params, tasksClient, true, taskIds);
    }

    protected void assertTasksPresentInTaskQuery(Map<String, String> params, WorkflowApiClient.TasksClient tasksClient, boolean countShouldMatch, String ... taskIds) throws Exception {
        JSONObject taskListJSONObject = tasksClient.findTasks(params);
        Assert.assertNotNull((Object)taskListJSONObject);
        JSONArray jsonEntries = (JSONArray)taskListJSONObject.get((Object)"entries");
        if (countShouldMatch) {
            Assert.assertEquals((String)"Wrong amount of tasks returned by query", (long)taskIds.length, (long)jsonEntries.size());
        }
        ArrayList<String> tasksToFind = new ArrayList<String>();
        tasksToFind.addAll(Arrays.asList(taskIds));
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject entry = (JSONObject)((JSONObject)jsonEntries.get(i)).get((Object)"entry");
            Assert.assertNotNull((Object)entry);
            String taskId = (String)entry.get((Object)"id");
            tasksToFind.remove(taskId);
        }
        Assert.assertEquals((String)("Not all tasks have been found in query response, missing: " + StringUtils.join(tasksToFind, (String)",")), (long)0L, (long)tasksToFind.size());
    }

    protected void cleanupProcessInstance(ProcessInstance ... processInstances) {
        try {
            for (ProcessInstance processInstance : processInstances) {
                if (processInstance == null) continue;
                this.activitiProcessEngine.getRuntimeService().deleteProcessInstance(processInstance.getId(), null);
                this.activitiProcessEngine.getHistoryService().deleteHistoricProcessInstance(processInstance.getId());
            }
        }
        catch (Throwable t) {
            this.log("Error while cleaning up process instance", t);
        }
    }

    protected void cleanupProcessInstance(String ... processInstances) {
        try {
            for (String instanceId : processInstances) {
                this.activitiProcessEngine.getRuntimeService().deleteProcessInstance(instanceId, null);
                this.activitiProcessEngine.getHistoryService().deleteHistoricProcessInstance(instanceId);
            }
        }
        catch (Throwable t) {
            this.log("Error while cleaning up process instance", t);
        }
    }
}

