/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.api.tests;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.activiti.engine.repository.Deployment;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.workflow.api.tests.EnterpriseWorkflowTestApi;
import org.alfresco.rest.workflow.api.tests.WorkflowApiClient;
import org.alfresco.util.testing.category.LuceneTests;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.http.HttpStatus;

@Category(value={LuceneTests.class})
public class DeploymentWorkflowApiTest
extends EnterpriseWorkflowTestApi {
    protected static HashSet<String> alfrescoPublicDeploymentNames = new HashSet<String>(Arrays.asList("review-pooled.bpmn20.xml", "review.bpmn20.xml", "parallel-review-group.bpmn20.xml", "parallel-review.bpmn20.xml", "adhoc.bpmn20.xml"));
    protected static HashSet<String> alfrescoPublicProcessDefinitionKeys = new HashSet<String>(Arrays.asList("activitiReviewPooled", "activitiReview", "activitiParallelGroupReview", "activitiParallelReview", "activitiAdhoc"));

    @Test
    public void testGetDeploymentsWithNonAdminUser() throws Exception {
        this.initApiClientWithTestUser();
        WorkflowApiClient.DeploymentsClient deploymentsClient = this.publicApiClient.deploymentsClient();
        try {
            deploymentsClient.getDeployments();
            Assert.fail((String)"Exception expected");
        }
        catch (PublicApiException expected) {
            Assert.assertEquals((long)HttpStatus.FORBIDDEN.value(), (long)expected.getHttpResponse().getStatusCode());
            this.assertErrorSummary("Permission was denied", expected.getHttpResponse());
        }
    }

    @Test
    public void testGetDeployments() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
        WorkflowApiClient.DeploymentsClient deploymentsClient = this.publicApiClient.deploymentsClient();
        PublicApiClient.ListResponse<org.alfresco.rest.workflow.api.model.Deployment> deploymentResponse = deploymentsClient.getDeployments();
        HashMap<String, org.alfresco.rest.workflow.api.model.Deployment> deploymentMap = new HashMap<String, org.alfresco.rest.workflow.api.model.Deployment>();
        for (org.alfresco.rest.workflow.api.model.Deployment deployment : deploymentResponse.getList()) {
            deploymentMap.put(deployment.getName(), deployment);
        }
        Assert.assertEquals((long)5L, (long)deploymentResponse.getList().size());
        Assert.assertTrue((boolean)deploymentMap.containsKey("review-pooled.bpmn20.xml"));
        Assert.assertTrue((boolean)deploymentMap.containsKey("review.bpmn20.xml"));
        Assert.assertTrue((boolean)deploymentMap.containsKey("parallel-review-group.bpmn20.xml"));
        Assert.assertTrue((boolean)deploymentMap.containsKey("parallel-review.bpmn20.xml"));
        Assert.assertTrue((boolean)deploymentMap.containsKey("adhoc.bpmn20.xml"));
        Deployment activitiDeployment = (Deployment)this.activitiProcessEngine.getRepositoryService().createDeploymentQuery().deploymentName("adhoc.bpmn20.xml").processDefinitionKey("@" + requestContext.getNetworkId() + "@activitiAdhoc").singleResult();
        Assert.assertNotNull((Object)activitiDeployment);
        org.alfresco.rest.workflow.api.model.Deployment adhocDeployment = (org.alfresco.rest.workflow.api.model.Deployment)deploymentMap.get("adhoc.bpmn20.xml");
        Assert.assertEquals((Object)activitiDeployment.getId(), (Object)adhocDeployment.getId());
        Assert.assertEquals((Object)activitiDeployment.getCategory(), (Object)adhocDeployment.getCategory());
        Assert.assertEquals((Object)activitiDeployment.getName(), (Object)adhocDeployment.getName());
        Assert.assertEquals((Object)activitiDeployment.getDeploymentTime(), (Object)adhocDeployment.getDeployedAt());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("maxItems", "2");
        JSONObject deploymentsListObject = deploymentsClient.getDeploymentsWithRawResponse(params);
        Assert.assertNotNull((Object)deploymentsListObject);
        JSONObject paginationJSON = (JSONObject)deploymentsListObject.get((Object)"pagination");
        Assert.assertEquals((Object)2L, (Object)paginationJSON.get((Object)"count"));
        Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"totalItems"));
        Assert.assertEquals((Object)0L, (Object)paginationJSON.get((Object)"skipCount"));
        Assert.assertEquals((Object)true, (Object)paginationJSON.get((Object)"hasMoreItems"));
        params = new HashMap();
        deploymentsListObject = deploymentsClient.getDeploymentsWithRawResponse(params);
        Assert.assertNotNull((Object)deploymentsListObject);
        paginationJSON = (JSONObject)deploymentsListObject.get((Object)"pagination");
        Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"count"));
        Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"totalItems"));
        Assert.assertEquals((Object)0L, (Object)paginationJSON.get((Object)"skipCount"));
        Assert.assertEquals((Object)false, (Object)paginationJSON.get((Object)"hasMoreItems"));
        params = new HashMap();
        params.put("skipCount", "2");
        params.put("maxItems", "2");
        deploymentsListObject = deploymentsClient.getDeploymentsWithRawResponse(params);
        Assert.assertNotNull((Object)deploymentsListObject);
        paginationJSON = (JSONObject)deploymentsListObject.get((Object)"pagination");
        Assert.assertEquals((Object)2L, (Object)paginationJSON.get((Object)"count"));
        Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"totalItems"));
        Assert.assertEquals((Object)2L, (Object)paginationJSON.get((Object)"skipCount"));
        Assert.assertEquals((Object)true, (Object)paginationJSON.get((Object)"hasMoreItems"));
        params = new HashMap();
        params.put("skipCount", "2");
        params.put("maxItems", "5");
        deploymentsListObject = deploymentsClient.getDeploymentsWithRawResponse(params);
        Assert.assertNotNull((Object)deploymentsListObject);
        paginationJSON = (JSONObject)deploymentsListObject.get((Object)"pagination");
        Assert.assertEquals((Object)3L, (Object)paginationJSON.get((Object)"count"));
        Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"totalItems"));
        Assert.assertEquals((Object)2L, (Object)paginationJSON.get((Object)"skipCount"));
        Assert.assertEquals((Object)false, (Object)paginationJSON.get((Object)"hasMoreItems"));
        params = new HashMap();
        params.put("skipCount", "0");
        params.put("maxItems", "7");
        deploymentsListObject = deploymentsClient.getDeploymentsWithRawResponse(params);
        Assert.assertNotNull((Object)deploymentsListObject);
        paginationJSON = (JSONObject)deploymentsListObject.get((Object)"pagination");
        Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"count"));
        Assert.assertEquals((Object)5L, (Object)paginationJSON.get((Object)"totalItems"));
        Assert.assertEquals((Object)0L, (Object)paginationJSON.get((Object)"skipCount"));
        Assert.assertEquals((Object)false, (Object)paginationJSON.get((Object)"hasMoreItems"));
    }

    @Test
    public void testGetDeploymentsEmpty() throws Exception {
        String networkName = "acme999";
        final RepoService.TestNetwork testNetwork = this.repoService.createNetworkWithAlias(networkName, true);
        this.transactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                testNetwork.create();
                return null;
            }
        }, false, true);
        List deployments = this.activitiProcessEngine.getRepositoryService().createDeploymentQuery().processDefinitionKeyLike("@" + testNetwork.getId() + "@%").list();
        for (Deployment deployment : deployments) {
            this.activitiProcessEngine.getRepositoryService().deleteDeployment(deployment.getId(), true);
        }
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + testNetwork.getId();
        this.publicApiClient.setRequestContext(new RequestContext(testNetwork.getId(), tenantAdmin));
        WorkflowApiClient.DeploymentsClient deploymentsClient = this.publicApiClient.deploymentsClient();
        PublicApiClient.ListResponse<org.alfresco.rest.workflow.api.model.Deployment> deploymentResponse = deploymentsClient.getDeployments();
        Assert.assertEquals((long)0L, (long)deploymentResponse.getList().size());
    }

    @Test
    public void testGetDeploymentById() throws Exception {
        RequestContext requestContext = this.initApiClientWithTestUser();
        String tenantAdmin = AuthenticationUtil.getAdminUserName() + "@" + requestContext.getNetworkId();
        this.publicApiClient.setRequestContext(new RequestContext("-default-", tenantAdmin));
        Deployment activitiDeployment = (Deployment)this.activitiProcessEngine.getRepositoryService().createDeploymentQuery().deploymentName("adhoc.bpmn20.xml").processDefinitionKey("@" + requestContext.getNetworkId() + "@activitiAdhoc").singleResult();
        Assert.assertNotNull((Object)activitiDeployment);
        WorkflowApiClient.DeploymentsClient deploymentsClient = this.publicApiClient.deploymentsClient();
        org.alfresco.rest.workflow.api.model.Deployment deployment = deploymentsClient.findDeploymentById(activitiDeployment.getId());
        Assert.assertNotNull((Object)deployment);
        Assert.assertEquals((Object)activitiDeployment.getId(), (Object)deployment.getId());
        Assert.assertEquals((Object)activitiDeployment.getCategory(), (Object)deployment.getCategory());
        Assert.assertEquals((Object)activitiDeployment.getName(), (Object)deployment.getName());
        Assert.assertEquals((Object)activitiDeployment.getDeploymentTime(), (Object)deployment.getDeployedAt());
        try {
            deploymentsClient.findDeploymentById("fakeid");
            Assert.fail((String)"Expected exception");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)404L, (long)e.getHttpResponse().getStatusCode());
        }
        try {
            this.publicApiClient.setRequestContext(requestContext);
            deploymentsClient.findDeploymentById(activitiDeployment.getId());
            Assert.fail((String)"Expected exception");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)403L, (long)e.getHttpResponse().getStatusCode());
        }
    }

    protected String createProcessDefinitionKey(String key, RequestContext requestContext) {
        return "@" + requestContext.getNetworkId() + "@" + key;
    }
}

