/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.text.Collator;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import org.alfresco.rest.api.tests.PublicApiDateFormat;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.Person;
import org.alfresco.rest.api.tests.client.data.Site;
import org.alfresco.rest.api.tests.client.data.SiteImpl;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class SiteMembershipRequest
implements ExpectedComparison,
Comparable<SiteMembershipRequest> {
    private Collator collator = Collator.getInstance();
    private String id;
    private String message;
    private Date createdAt;
    private Date modifiedAt;
    private String title;
    private Site site;
    private Person person;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Site getSite() {
        return this.site;
    }

    public void setSite(Site site) {
        this.site = site;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public void setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public JSONObject toJSON() {
        JSONObject siteMembershipRequestJson = new JSONObject();
        siteMembershipRequestJson.put((Object)"id", (Object)this.getId());
        siteMembershipRequestJson.put((Object)"message", (Object)this.getMessage());
        return siteMembershipRequestJson;
    }

    public static SiteMembershipRequest parseSiteMembershipRequest(JSONObject jsonObject) throws ParseException {
        String id = (String)jsonObject.get((Object)"id");
        String createdAt = (String)jsonObject.get((Object)"createdAt");
        String message = (String)jsonObject.get((Object)"message");
        String modifiedAt = (String)jsonObject.get((Object)"modifiedAt");
        JSONObject siteJSON = (JSONObject)jsonObject.get((Object)"site");
        JSONObject personJSON = (JSONObject)jsonObject.get((Object)"person");
        SiteMembershipRequest siteMembershipRequest = new SiteMembershipRequest();
        siteMembershipRequest.setId(id);
        siteMembershipRequest.setCreatedAt(PublicApiDateFormat.getDateFormat().parse(createdAt));
        siteMembershipRequest.setMessage(message);
        if (modifiedAt != null) {
            siteMembershipRequest.setModifiedAt(PublicApiDateFormat.getDateFormat().parse(modifiedAt));
        }
        if (siteJSON != null) {
            Site site = SiteImpl.parseSite(siteJSON);
            siteMembershipRequest.setSite(site);
        }
        if (personJSON != null) {
            Person person = Person.parsePerson(personJSON);
            siteMembershipRequest.setPerson(person);
        }
        return siteMembershipRequest;
    }

    public static PublicApiClient.ListResponse<SiteMembershipRequest> parseSiteMembershipRequests(JSONObject jsonObject) throws ParseException {
        ArrayList<SiteMembershipRequest> siteMembershipRequests = new ArrayList<SiteMembershipRequest>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            siteMembershipRequests.add(SiteMembershipRequest.parseSiteMembershipRequest(entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        return new PublicApiClient.ListResponse<SiteMembershipRequest>(paging, siteMembershipRequests);
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof SiteMembershipRequest));
        SiteMembershipRequest other = (SiteMembershipRequest)o;
        Assert.assertNotNull((Object)other.getCreatedAt());
        if (other.getModifiedAt() != null) {
            Assert.assertFalse((boolean)other.getModifiedAt().before(other.getCreatedAt()));
        }
        if (this.modifiedAt != null) {
            Assert.assertFalse((boolean)other.getModifiedAt().before(this.modifiedAt));
        }
        if (this.createdAt != null) {
            AssertUtil.assertEquals("createdAt", this.createdAt, other.getCreatedAt());
        }
        AssertUtil.assertEquals("createdAt", this.createdAt, other.getCreatedAt());
        AssertUtil.assertEquals("id", this.id.toLowerCase(), other.getId().toLowerCase());
        AssertUtil.assertEquals("message", this.message, other.getMessage());
    }

    public String toString() {
        return "SiteMembershipRequest [id=" + this.id + ", message=" + this.message + ", createdAt=" + this.createdAt + ", modifiedAt=" + this.modifiedAt + ", title=" + this.title + "]";
    }

    @Override
    public int compareTo(SiteMembershipRequest o) {
        int ret = this.collator.compare(this.site.getTitle(), o.getSite().getTitle());
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SiteMembershipRequest other = (SiteMembershipRequest)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }
}

