/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.Network;
import org.alfresco.rest.api.tests.client.data.NetworkImpl;
import org.alfresco.rest.api.tests.client.data.Quota;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class PersonNetwork
implements Network,
Comparable<PersonNetwork>,
ExpectedComparison {
    private String networkId;
    private Boolean homeNetwork;
    private NetworkImpl network;

    public PersonNetwork(String networkId) {
    }

    public PersonNetwork(Boolean homeNetwork, NetworkImpl network) {
        this.homeNetwork = homeNetwork;
        this.network = network;
        this.networkId = network.getId();
    }

    @Override
    public String getId() {
        return this.networkId;
    }

    public Boolean isHomeNetwork() {
        return this.homeNetwork;
    }

    public NetworkImpl getNetwork() {
        return this.network;
    }

    public static PersonNetwork parseNetworkMember(JSONObject jsonObject) {
        Boolean homeNetwork = (Boolean)jsonObject.get((Object)"homeNetwork");
        PersonNetwork networkMember = new PersonNetwork(homeNetwork, NetworkImpl.parseNetwork(jsonObject));
        return networkMember;
    }

    public static PublicApiClient.ListResponse<PersonNetwork> parseNetworkMembers(JSONObject jsonObject) {
        ArrayList<PersonNetwork> networkMembers = new ArrayList<PersonNetwork>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            networkMembers.add(PersonNetwork.parseNetworkMember(entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        PublicApiClient.ListResponse<PersonNetwork> resp = new PublicApiClient.ListResponse<PersonNetwork>(paging, networkMembers);
        return resp;
    }

    public String toString() {
        return "NetworkMember [id=" + this.getId() + ", homeNetwork=" + this.homeNetwork + ", network=" + this.network + "]";
    }

    public JSONObject toJSON() {
        JSONObject networkMemberJson = new JSONObject();
        networkMemberJson.put((Object)"id", (Object)this.getId());
        networkMemberJson.put((Object)"homeNetwork", (Object)this.isHomeNetwork());
        networkMemberJson.put((Object)"network", (Object)this.getNetwork());
        return networkMemberJson;
    }

    @Override
    public int compareTo(PersonNetwork member) {
        int ret = -1 * this.isHomeNetwork().compareTo(member.isHomeNetwork());
        if (ret == 0) {
            ret = this.getId().compareTo(member.getId());
        }
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.network == null ? 0 : this.network.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PersonNetwork other = (PersonNetwork)obj;
        return !(this.network == null ? other.network != null : !this.network.equals(other.network));
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof PersonNetwork));
        PersonNetwork other = (PersonNetwork)o;
        AssertUtil.assertEquals("homeNetwork", this.homeNetwork, other.isHomeNetwork());
        if (this.network != null) {
            this.network.expected(other.getNetwork());
        }
    }

    @Override
    public Boolean getIsEnabled() {
        return this.network.getIsEnabled();
    }

    @Override
    public String getCreatedAt() {
        return this.network.getCreatedAt();
    }

    @Override
    public List<Quota> getQuotas() {
        return this.network.getQuotas();
    }

    @Override
    public String getSubscriptionLevel() {
        return this.network.getSubscriptionLevel();
    }

    @Override
    public Boolean isPaidNetwork() {
        return this.network.isPaidNetwork();
    }
}

