/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.rest.api.tests.PublicApiDateFormat;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.Network;
import org.alfresco.rest.api.tests.client.data.Quota;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class NetworkImpl
implements Network,
Serializable,
ExpectedComparison {
    private static final long serialVersionUID = -5748677903173568273L;
    protected String id;
    protected Boolean isEnabled;
    protected String createdAt;
    protected List<Quota> quotas = new LinkedList<Quota>();
    protected String subscriptionLevel;
    protected Boolean paidNetwork;

    public NetworkImpl(org.alfresco.repo.tenant.Network network) {
        this.id = network.getTenantDomain();
        this.createdAt = network.getCreatedAt() != null ? PublicApiDateFormat.getDateFormat().format(network.getCreatedAt()) : null;
        this.isEnabled = network.isEnabled();
        this.paidNetwork = network.getPaidNetwork();
        this.subscriptionLevel = network.getSubscriptionLevel();
    }

    public NetworkImpl(String id, Boolean isEnabled) {
        this.id = id;
        this.isEnabled = isEnabled;
    }

    public NetworkImpl(String id, Boolean isEnabled, String createdAt, List<Quota> quotas, String subscriptionLevel, Boolean paidNetwork) {
        this.id = id;
        this.isEnabled = isEnabled;
        this.createdAt = createdAt;
        this.quotas = quotas;
        this.subscriptionLevel = subscriptionLevel;
        this.paidNetwork = paidNetwork;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public Boolean getPaidNetwork() {
        return this.paidNetwork;
    }

    public void setPaidNetwork(Boolean paidNetwork) {
        this.paidNetwork = paidNetwork;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public void setQuotas(List<Quota> quotas) {
        this.quotas = quotas;
    }

    public void setSubscriptionLevel(String subscriptionLevel) {
        this.subscriptionLevel = subscriptionLevel;
    }

    public static NetworkImpl parseNetwork(JSONObject jsonObject) {
        String id = (String)jsonObject.get((Object)"id");
        Boolean isEnabled = (Boolean)jsonObject.get((Object)"isEnabled");
        Boolean paidNetwork = (Boolean)jsonObject.get((Object)"paidNetwork");
        String createdAt = (String)jsonObject.get((Object)"createdAt");
        String subscriptionLevel = (String)jsonObject.get((Object)"subscriptionLevel");
        JSONArray quotasJSON = (JSONArray)jsonObject.get((Object)"quotas");
        ArrayList<Quota> quotas = new ArrayList<Quota>(quotasJSON.size());
        for (JSONObject quotaJSON : quotasJSON) {
            Quota quota = Quota.parseQuota(quotaJSON);
            quotas.add(quota);
        }
        NetworkImpl network = new NetworkImpl(id, isEnabled, createdAt, quotas, subscriptionLevel, paidNetwork);
        return network;
    }

    @Override
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public List<Quota> getQuotas() {
        return this.quotas;
    }

    @Override
    public String getSubscriptionLevel() {
        return this.subscriptionLevel;
    }

    @Override
    public Boolean isPaidNetwork() {
        return this.paidNetwork;
    }

    public JSONObject toJSON() {
        JSONObject networkJson = new JSONObject();
        networkJson.put((Object)"id", (Object)this.getId());
        networkJson.put((Object)"isEnabled", (Object)this.getIsEnabled());
        return networkJson;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NetworkImpl other = (NetworkImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof NetworkImpl));
        NetworkImpl other = (NetworkImpl)o;
        AssertUtil.assertEquals("id", this.id, other.getId());
        AssertUtil.assertEquals("isEnabled", this.isEnabled, other.isEnabled);
        AssertUtil.assertEquals("paidNetwork", this.paidNetwork, other.paidNetwork);
        AssertUtil.assertEquals("subscriptionLevel", this.subscriptionLevel, other.subscriptionLevel);
        if (this.createdAt != null) {
            try {
                Date created = PublicApiDateFormat.getDateFormat().parse(this.createdAt);
                Date otherCreatedAt = PublicApiDateFormat.getDateFormat().parse(other.getCreatedAt());
                Assert.assertTrue((otherCreatedAt.after(created) || otherCreatedAt.equals(created) ? 1 : 0) != 0);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return "NetworkImpl [id=" + this.id + ", isEnabled=" + this.isEnabled + ", createdAt=" + this.createdAt + ", quotas=" + this.quotas + ", subscriptionLevel=" + this.subscriptionLevel + ", paidNetwork=" + this.paidNetwork + "]";
    }
}

