/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.ArrayList;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.Site;
import org.alfresco.rest.api.tests.client.data.SiteImpl;
import org.alfresco.rest.api.tests.client.data.SiteRole;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class MemberOfSite
implements Serializable,
ExpectedComparison,
Comparable<MemberOfSite> {
    private static final long serialVersionUID = -5834300883854366123L;
    private SiteRole role;
    private String siteId;
    private String siteGuid;
    private Site site;

    public MemberOfSite() {
    }

    public MemberOfSite(String siteId, String siteGuid, SiteRole role) {
        if (siteId == null) {
            throw new IllegalArgumentException();
        }
        if (siteGuid == null) {
            throw new IllegalArgumentException();
        }
        if (role == null) {
            throw new IllegalArgumentException();
        }
        this.role = role;
        this.siteId = siteId;
        this.siteGuid = siteGuid;
    }

    public MemberOfSite(Site site, SiteRole role) {
        if (site == null) {
            throw new IllegalArgumentException();
        }
        if (role == null) {
            throw new IllegalArgumentException();
        }
        this.role = role;
        this.site = site;
        this.siteId = site.getSiteId();
        this.siteGuid = site.getGuid();
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getGuid() {
        return this.siteGuid;
    }

    public Site getSite() {
        return this.site;
    }

    public SiteRole getRole() {
        return this.role;
    }

    public void setRole(SiteRole role) {
        if (role == null) {
            throw new IllegalArgumentException();
        }
        this.role = role;
    }

    public void setSite(SiteImpl site) {
        if (site == null) {
            throw new IllegalArgumentException();
        }
        this.site = site;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        result = 31 * result + this.site.getSiteId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemberOfSite other = (MemberOfSite)obj;
        if (this.role != other.role) {
            return false;
        }
        return this.site.equals(other.site);
    }

    public static MemberOfSite parseMemberOfSite(JSONObject jsonObject) {
        String role = (String)jsonObject.get((Object)"role");
        JSONObject siteJSON = (JSONObject)jsonObject.get((Object)"site");
        Site site = SiteImpl.parseSite(siteJSON);
        MemberOfSite siteMember = new MemberOfSite(site, SiteRole.valueOf(role));
        return siteMember;
    }

    public static PublicApiClient.ListResponse<MemberOfSite> parseMemberOfSites(JSONObject jsonObject) {
        ArrayList<MemberOfSite> siteMembers = new ArrayList<MemberOfSite>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            siteMembers.add(MemberOfSite.parseMemberOfSite(entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        PublicApiClient.ListResponse<MemberOfSite> resp = new PublicApiClient.ListResponse<MemberOfSite>(paging, siteMembers);
        return resp;
    }

    public JSONObject toJSON() {
        JSONObject memberOfSiteJson = new JSONObject();
        memberOfSiteJson.put((Object)"role", (Object)this.getRole());
        memberOfSiteJson.put((Object)"id", (Object)this.getSiteId());
        memberOfSiteJson.put((Object)"guid", (Object)this.getGuid());
        return memberOfSiteJson;
    }

    public String toString() {
        return "MemberOfSite [role=" + this.role + ", siteShortName=" + this.site + "]";
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof MemberOfSite));
        MemberOfSite other = (MemberOfSite)o;
        if (this.siteId != null) {
            AssertUtil.assertEquals("siteId", this.siteId, other.getSiteId());
        }
        AssertUtil.assertEquals("role", (Object)this.role, (Object)other.getRole());
        this.site.expected(other.getSite());
    }

    @Override
    public int compareTo(MemberOfSite o) {
        int i = this.site.getTitle().compareTo(o.getSite().getTitle());
        if (i == 0) {
            i = this.role.compareTo(o.getRole());
        }
        return i;
    }
}

