/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.CMISNode;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.junit.Assert;

public class FolderNode
extends CMISNode
implements Serializable {
    private static final long serialVersionUID = -7069586854942264572L;
    private Map<String, FolderNode> folderNodes = new HashMap<String, FolderNode>();
    private Map<String, CMISNode> documentNodes = new HashMap<String, CMISNode>();
    private Random random = new Random();

    public FolderNode(String nodeId, String guid, Map<String, Serializable> properties) {
        super(nodeId, guid, properties);
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    public void addFolder(FolderNode folder) {
        this.folderNodes.put(this.getBareObjectId(folder.getNodeId()), folder);
    }

    public void addNode(CMISNode node) {
        this.documentNodes.put(this.getBareObjectId(node.getNodeId()), node);
    }

    public Map<String, FolderNode> getFolderNodes() {
        return this.folderNodes;
    }

    public Map<String, CMISNode> getDocumentNodes() {
        return this.documentNodes;
    }

    private FolderNode getFolderNode(String objectId) {
        FolderNode n = this.folderNodes.get(this.getBareObjectId(objectId));
        return n;
    }

    private CMISNode getDocumentNode(String objectId) {
        CMISNode n = this.documentNodes.get(this.getBareObjectId(objectId));
        return n;
    }

    public CMISNode selectRandomFolderNode() {
        int idx = this.random.nextInt(this.folderNodes.size());
        return this.folderNodes.get(idx);
    }

    public CMISNode selectRandomDocumentNode() {
        int idx = this.random.nextInt(this.documentNodes.size());
        return this.documentNodes.get(idx);
    }

    @Override
    public String toString() {
        return "FolderNode [folderNodes=" + this.folderNodes + ", documentNodes=" + this.documentNodes + ", nodeId=" + this.nodeId + ", properties=" + this.properties + "]";
    }

    private String getBareObjectId(String objectId) {
        int idx = objectId.indexOf(";");
        String bareObjectId = null;
        bareObjectId = idx == -1 ? objectId : objectId.substring(0, idx);
        return bareObjectId;
    }

    private Tree<FileableCmisObject> findTree(String nodeId, List<Tree<FileableCmisObject>> nodes) {
        Tree<FileableCmisObject> ret = null;
        for (Tree<FileableCmisObject> tree : nodes) {
            FileableCmisObject item = (FileableCmisObject)tree.getItem();
            if (!this.getBareObjectId(nodeId).equals(this.getBareObjectId(item.getId()))) continue;
            ret = tree;
            break;
        }
        return ret;
    }

    private void checkChildrenImpl(Map<String, FolderNode> expectedFolderNodes, Map<String, CMISNode> expectedDocumentNodes) {
        Map<String, Serializable> actualProperties;
        Map<String, Serializable> expectedProperties;
        for (FolderNode expectedFolderNode : expectedFolderNodes.values()) {
            FolderNode actualFolderNode = this.getFolderNode(expectedFolderNode.getNodeId());
            Assert.assertNotNull((String)("Unable to find node " + expectedFolderNode), (Object)actualFolderNode);
            expectedProperties = expectedFolderNode.getProperties();
            actualProperties = actualFolderNode.getProperties();
            AssertUtil.assertEquals("cmis:objectTypeId", expectedProperties.get("cmis:objectTypeId"), actualProperties.get("cmis:objectTypeId"));
            AssertUtil.assertEquals("cmis:path", expectedProperties.get("cmis:path"), actualProperties.get("cmis:path"));
            AssertUtil.assertEquals("cmis:name", expectedProperties.get("cmis:name"), actualProperties.get("cmis:name"));
        }
        for (CMISNode expectedDocumentNode : expectedDocumentNodes.values()) {
            CMISNode actualDocumentNode = this.getDocumentNode(expectedDocumentNode.getNodeId());
            Assert.assertNotNull((String)("Unable to find node " + expectedDocumentNode.getNodeId()), (Object)actualDocumentNode);
            expectedProperties = expectedDocumentNode.getProperties();
            actualProperties = actualDocumentNode.getProperties();
            AssertUtil.assertEquals("cmis:objectTypeId", expectedProperties.get("cmis:objectTypeId"), actualProperties.get("cmis:objectTypeId"));
            AssertUtil.assertEquals("cmis:path", expectedProperties.get("cmis:path"), actualProperties.get("cmis:path"));
            AssertUtil.assertEquals("cmis:name", expectedProperties.get("cmis:name"), actualProperties.get("cmis:name"));
        }
    }

    public void checkChildren(ItemIterable<CmisObject> expectedChildren) {
        HashMap<String, FolderNode> expectedFolderNodes = new HashMap<String, FolderNode>();
        HashMap<String, CMISNode> expectedDocumentNodes = new HashMap<String, CMISNode>();
        for (CmisObject child : expectedChildren) {
            CMISNode dn = CMISNode.createNode(child);
            if (dn instanceof FolderNode) {
                expectedFolderNodes.put(this.getBareObjectId(dn.getNodeId()), (FolderNode)dn);
                continue;
            }
            expectedDocumentNodes.put(this.getBareObjectId(dn.getNodeId()), dn);
        }
        this.checkChildrenImpl(expectedFolderNodes, expectedDocumentNodes);
    }

    public void checkChildren(List<String> expectedChildFolderIds, List<String> expectedChildDocumentIds) {
        CMISNode node;
        HashMap<String, FolderNode> expectedFolderNodes = new HashMap<String, FolderNode>();
        for (String childObjectId : expectedChildFolderIds) {
            CMISNode n = CMISNode.createNode(this.getBareObjectId(childObjectId));
            if (!(n instanceof FolderNode)) continue;
            node = (FolderNode)n;
            expectedFolderNodes.put(this.getBareObjectId(node.getNodeId()), (FolderNode)node);
        }
        HashMap<String, CMISNode> expectedDocumentNodes = new HashMap<String, CMISNode>();
        for (String childObjectId : expectedChildDocumentIds) {
            node = CMISNode.createNode(this.getBareObjectId(childObjectId));
            expectedDocumentNodes.put(this.getBareObjectId(node.getNodeId()), node);
        }
        this.checkChildrenImpl(expectedFolderNodes, expectedDocumentNodes);
    }

    public void checkDescendants(List<Tree<FileableCmisObject>> descendants) {
        Map<String, Serializable> actualProperties;
        Map<String, Serializable> expectedProperties;
        Tree<FileableCmisObject> item;
        for (FolderNode expectedFolderNode : this.folderNodes.values()) {
            item = this.findTree(expectedFolderNode.getNodeId(), descendants);
            Assert.assertNotNull(item);
            FolderNode actualFolderNode = (FolderNode)CMISNode.createNode((CmisObject)item.getItem());
            expectedProperties = expectedFolderNode.getProperties();
            actualProperties = actualFolderNode.getProperties();
            Assert.assertEquals((Object)expectedProperties.get("cmis:objectTypeId"), (Object)actualProperties.get("cmis:objectTypeId"));
            Assert.assertEquals((Object)expectedProperties.get("cmis:path"), (Object)actualProperties.get("cmis:path"));
            Assert.assertEquals((Object)expectedProperties.get("cmis:name"), (Object)actualProperties.get("cmis:name"));
            expectedFolderNode.checkDescendants(item.getChildren());
        }
        for (CMISNode expectedDocumentNode : this.documentNodes.values()) {
            item = this.findTree(expectedDocumentNode.getNodeId(), descendants);
            Assert.assertNotNull(item);
            CMISNode actualNode = CMISNode.createNode((CmisObject)item.getItem());
            expectedProperties = expectedDocumentNode.getProperties();
            actualProperties = actualNode.getProperties();
            Assert.assertEquals((Object)expectedProperties.get("cmis:objectTypeId"), (Object)actualProperties.get("cmis:objectTypeId"));
            Assert.assertEquals((Object)expectedProperties.get("cmis:path"), (Object)actualProperties.get("cmis:path"));
            Assert.assertEquals((Object)expectedProperties.get("cmis:name"), (Object)actualProperties.get("cmis:name"));
        }
    }
}

