/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.alfresco.rest.api.tests.PublicApiDateFormat;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.FavouriteDocument;
import org.alfresco.rest.api.tests.client.data.FavouriteFolder;
import org.alfresco.rest.api.tests.client.data.FavouritesTarget;
import org.alfresco.rest.api.tests.client.data.FileFavouriteTarget;
import org.alfresco.rest.api.tests.client.data.FolderFavouriteTarget;
import org.alfresco.rest.api.tests.client.data.Site;
import org.alfresco.rest.api.tests.client.data.SiteFavouriteTarget;
import org.alfresco.rest.api.tests.client.data.SiteImpl;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.favourites.FavouritesService;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class Favourite
implements Serializable,
ExpectedComparison,
Comparable<Favourite> {
    private static final long serialVersionUID = 2812585719477560349L;
    private String username;
    private String targetGuid;
    private Date createdAt;
    private Date modifiedAt;
    private FavouritesTarget target;
    private FavouritesService.Type type;
    private Map<String, Object> properties;

    public Favourite(FavouritesTarget target) throws ParseException {
        this((Date)null, (Date)null, target, null);
    }

    public Favourite(Date createdAt, Date modifiedAt, FavouritesTarget target, Map<String, Object> properties) throws ParseException {
        if (target != null) {
            this.targetGuid = target.getTargetGuid();
        }
        this.username = null;
        this.createdAt = createdAt;
        this.modifiedAt = modifiedAt;
        this.target = target;
        this.properties = properties;
        this.type = target instanceof FileFavouriteTarget ? FavouritesService.Type.FILE : (target instanceof FolderFavouriteTarget ? FavouritesService.Type.FOLDER : (target instanceof SiteFavouriteTarget ? FavouritesService.Type.SITE : null));
    }

    public Favourite(String createdAt, String modifiedAt, FavouritesTarget target, Map<String, Object> properties) throws ParseException {
        this(Favourite.getDate(createdAt), Favourite.getDate(modifiedAt), target, properties);
    }

    private static Date getDate(String dateStr) throws ParseException {
        Date date = dateStr != null ? PublicApiDateFormat.getDateFormat().parse(dateStr) : null;
        return date;
    }

    public String getTargetGuid() {
        return this.targetGuid;
    }

    public String getUsername() {
        return this.username;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public FavouritesTarget getTarget() {
        return this.target;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public FavouritesService.Type getType() {
        FavouritesService.Type type = null;
        if (this.target instanceof FileFavouriteTarget) {
            type = FavouritesService.Type.FILE;
        } else if (this.target instanceof FolderFavouriteTarget) {
            type = FavouritesService.Type.FOLDER;
        } else if (this.target instanceof SiteFavouriteTarget) {
            type = FavouritesService.Type.SITE;
        }
        return type;
    }

    public JSONObject toJSON() {
        JSONObject favouriteJson = new JSONObject();
        if (this.target != null) {
            favouriteJson.put((Object)"target", (Object)this.target.toJSON());
        }
        return favouriteJson;
    }

    public static FavouritesTarget parseTarget(JSONObject jsonObject) throws ParseException {
        FavouritesTarget ret = null;
        if (jsonObject.containsKey((Object)"site")) {
            JSONObject siteJSON = (JSONObject)jsonObject.get((Object)"site");
            Site site = SiteImpl.parseSite(siteJSON);
            ret = new SiteFavouriteTarget(site);
        } else if (jsonObject.containsKey((Object)"file")) {
            JSONObject documentJSON = (JSONObject)jsonObject.get((Object)"file");
            FavouriteDocument document = FavouriteDocument.parseDocument(documentJSON);
            ret = new FileFavouriteTarget(document);
        } else if (jsonObject.containsKey((Object)"folder")) {
            JSONObject folderJSON = (JSONObject)jsonObject.get((Object)"folder");
            FavouriteFolder folder = FavouriteFolder.parseFolder(folderJSON);
            ret = new FolderFavouriteTarget(folder);
        }
        return ret;
    }

    public static Favourite parseFavourite(JSONObject jsonObject) throws ParseException {
        String createdAt = (String)jsonObject.get((Object)"createdAt");
        String modifiedAt = (String)jsonObject.get((Object)"modifiedAt");
        JSONObject jsonTarget = (JSONObject)jsonObject.get((Object)"target");
        Map properties = null;
        try {
            properties = RestApiUtil.parsePojo("properties", jsonObject, Map.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FavouritesTarget target = Favourite.parseTarget(jsonTarget);
        Favourite favourite = new Favourite(createdAt, modifiedAt, target, (Map<String, Object>)properties);
        return favourite;
    }

    public static PublicApiClient.ListResponse<Favourite> parseFavourites(JSONObject jsonObject) throws ParseException {
        ArrayList<Favourite> favourites = new ArrayList<Favourite>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            favourites.add(Favourite.parseFavourite(entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        return new PublicApiClient.ListResponse<Favourite>(paging, favourites);
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof Favourite));
        Favourite other = (Favourite)o;
        if (this.target == null) {
            Assert.fail();
        }
        this.target.expected(other.getTarget());
        if (this.createdAt != null) {
            Assert.assertTrue((other.getCreatedAt().equals(this.createdAt) || other.getCreatedAt().after(this.createdAt) ? 1 : 0) != 0);
        }
        if (this.modifiedAt != null) {
            AssertUtil.assertEquals("modifiedAt", this.modifiedAt, other.getModifiedAt());
        }
        AssertUtil.assertEquals("targetGuid", this.targetGuid, other.getTargetGuid());
    }

    public String toString() {
        return "Favourite [username=" + this.username + ", targetGuid=" + this.targetGuid + ", createdAt=" + this.createdAt + ", modifiedAt = " + this.modifiedAt + ", target=" + this.target + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.targetGuid == null ? 0 : this.targetGuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Favourite other = (Favourite)obj;
        return !(this.targetGuid == null ? other.targetGuid != null : !this.targetGuid.equals(other.targetGuid));
    }

    @Override
    public int compareTo(Favourite o) {
        int idx;
        int n = idx = this.type != null ? this.type.compareTo((Enum)o.getType()) : 0;
        if (idx == 0) {
            idx = o.getCreatedAt().compareTo(this.createdAt);
        }
        return idx;
    }
}

