/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.FolderNode;
import org.alfresco.service.namespace.QName;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.FolderTypeDefinition;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class CMISNode
implements Serializable,
ExpectedComparison {
    private static final long serialVersionUID = -5027938359868278498L;
    protected String nodeId;
    protected String guid;
    protected Map<String, Serializable> properties;

    public CMISNode(String guid) {
        this.guid = guid;
    }

    public CMISNode(String id, String guid) {
        this.nodeId = id;
        this.guid = guid;
    }

    public CMISNode(String nodeId, String guid, Map<String, Serializable> properties) {
        this.nodeId = nodeId;
        this.guid = nodeId;
        this.properties = properties;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getRawNodeId() {
        return this.nodeId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean isFolder() {
        return false;
    }

    public static Map<String, Serializable> getProperties(Map<QName, Serializable> properties) {
        HashMap<String, Serializable> propertiesMap = new HashMap<String, Serializable>();
        for (QName propName : properties.keySet()) {
            propertiesMap.put(propName.toPrefixString(), properties.get(propName));
        }
        return propertiesMap;
    }

    public static Map<String, Serializable> getProperties(List<Property<?>> properties) {
        HashMap<String, Serializable> propertiesMap = new HashMap<String, Serializable>();
        for (Property<?> p : properties) {
            propertiesMap.put(p.getId(), (Serializable)((Object)p.getValueAsString()));
        }
        return propertiesMap;
    }

    public static Map<String, Serializable> getProperties(Properties properties) {
        HashMap<String, Serializable> propertiesMap = new HashMap<String, Serializable>();
        for (PropertyData p : properties.getPropertyList()) {
            propertiesMap.put(p.getId(), (Serializable)((Object)p.getFirstValue().toString()));
        }
        return propertiesMap;
    }

    public Serializable getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    public static CMISNode createNode(QueryResult qr) {
        List props = qr.getProperties();
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        for (PropertyData p : props) {
            properties.put(p.getId(), (Serializable)p.getFirstValue());
        }
        String objectId = (String)qr.getPropertyById("cmis:objectId").getFirstValue();
        CMISNode n = new CMISNode(objectId, objectId, properties);
        return n;
    }

    public static CMISNode createNode(CmisObject o) {
        CMISNode n = null;
        Map<String, Serializable> properties = CMISNode.getProperties(o.getProperties());
        n = o.getBaseType() instanceof FolderTypeDefinition ? new FolderNode(o.getId(), o.getId(), properties) : new CMISNode(o.getId(), o.getId(), properties);
        return n;
    }

    public static CMISNode createNode(String objectId) {
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        CMISNode n = new CMISNode(objectId, objectId, properties);
        return n;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CMISNode other = (CMISNode)obj;
        if (this.nodeId == null ? other.nodeId != null : !this.nodeId.equals(other.nodeId)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put((Object)"guid", (Object)this.getGuid());
        json.put((Object)"id", (Object)this.getNodeId());
        return json;
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof CMISNode));
        CMISNode other = (CMISNode)o;
        AssertUtil.assertEquals("id", this.nodeId, other.getNodeId());
        AssertUtil.assertEquals("guid", this.guid, other.getGuid());
        for (String propertyName : this.properties.keySet()) {
            Serializable expected = this.properties.get(propertyName);
            Serializable actual = other.getProperty(propertyName);
            AssertUtil.assertEquals(propertyName, expected, actual);
        }
    }

    public String toString() {
        return "CMISNode [nodeId=" + this.nodeId + ", guid=" + this.guid + ", properties=" + this.properties + "]";
    }
}

