/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.UserInfo;
import org.alfresco.util.ISO8601DateFormat;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class AuditEntry
extends org.alfresco.rest.api.model.AuditEntry
implements Serializable,
ExpectedComparison {
    private static final long serialVersionUID = 1L;

    public AuditEntry(Long id, String auditApplicationId, org.alfresco.rest.api.model.UserInfo createdByUser, Date createdAt, Map<String, Serializable> values) {
        super(id, auditApplicationId, createdByUser, createdAt, values);
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((String)("o is an instance of " + o.getClass()), (boolean)(o instanceof AuditEntry));
        AuditEntry other = (AuditEntry)o;
        AssertUtil.assertEquals("id", this.getId(), other.getId());
        AssertUtil.assertEquals("auditApplicationId", this.getAuditApplicationId(), other.getAuditApplicationId());
        AssertUtil.assertEquals("values", this.getValues(), other.getValues());
        AssertUtil.assertEquals("createdByUser", this.getCreatedByUser().getId(), other.getCreatedByUser().getId());
        AssertUtil.assertEquals("createdAt", this.getCreatedAt(), other.getCreatedAt());
    }

    public JSONObject toJSON() {
        JSONObject auditEntryJson = new JSONObject();
        if (this.getId() != null) {
            auditEntryJson.put((Object)"id", (Object)this.getId());
        }
        auditEntryJson.put((Object)"auditApplicationId", (Object)this.getAuditApplicationId());
        if (this.createdByUser != null) {
            auditEntryJson.put((Object)"createdByUser", (Object)new UserInfo(this.createdByUser.getId(), this.createdByUser.getDisplayName()).toJSON());
        }
        auditEntryJson.put((Object)"values", (Object)this.getValues());
        auditEntryJson.put((Object)"createdAt", (Object)this.getCreatedAt());
        return auditEntryJson;
    }

    public static AuditEntry parseAuditEntry(JSONObject jsonObject) {
        Long id = (Long)jsonObject.get((Object)"id");
        String auditApplicationId = (String)jsonObject.get((Object)"auditApplicationId");
        Map values = (Map)jsonObject.get((Object)"values");
        org.alfresco.rest.api.model.UserInfo createdByUser = null;
        JSONObject createdByUserJson = (JSONObject)jsonObject.get((Object)"createdByUser");
        if (createdByUserJson != null) {
            String userId = (String)createdByUserJson.get((Object)"id");
            String displayName = (String)createdByUserJson.get((Object)"displayName");
            createdByUser = new org.alfresco.rest.api.model.UserInfo(userId, displayName, displayName);
        }
        Date createdAt = ISO8601DateFormat.parse((String)((String)jsonObject.get((Object)"createdAt")));
        AuditEntry auditEntry = new AuditEntry(id, auditApplicationId, createdByUser, createdAt, values);
        return auditEntry;
    }

    public static PublicApiClient.ListResponse<AuditEntry> parseAuditEntries(JSONObject jsonObject) {
        ArrayList<AuditEntry> entries = new ArrayList<AuditEntry>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            entries.add(AuditEntry.parseAuditEntry(entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        PublicApiClient.ListResponse<AuditEntry> resp = new PublicApiClient.ListResponse<AuditEntry>(paging, entries);
        return resp;
    }
}

