/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.ArrayList;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class AuditApp
extends org.alfresco.rest.api.model.AuditApp
implements Serializable,
ExpectedComparison {
    private static final long serialVersionUID = 1L;

    @Override
    public void expected(Object o) {
        Assert.assertTrue((String)("o is an instance of " + o.getClass()), (boolean)(o instanceof AuditApp));
        AuditApp other = (AuditApp)o;
        AssertUtil.assertEquals("id", this.getId(), other.getId());
        AssertUtil.assertEquals("name", this.getName(), other.getName());
        AssertUtil.assertEquals("isEnabled", this.getIsEnabled(), other.getIsEnabled());
    }

    public JSONObject toJSON() {
        JSONObject auditAppJson = new JSONObject();
        if (this.getId() != null) {
            auditAppJson.put((Object)"id", (Object)this.getId());
        }
        auditAppJson.put((Object)"name", (Object)this.getName());
        auditAppJson.put((Object)"isEnabled", (Object)this.getIsEnabled());
        return auditAppJson;
    }

    public static AuditApp parseAuditApp(JSONObject jsonObject) {
        String id = (String)jsonObject.get((Object)"id");
        String name = (String)jsonObject.get((Object)"name");
        Boolean isEnabled = (Boolean)jsonObject.get((Object)"isEnabled");
        Long maxEntryId = (Long)jsonObject.get((Object)"maxEntryId");
        Long minEntryId = (Long)jsonObject.get((Object)"minEntryId");
        AuditApp auditApp = new AuditApp();
        auditApp.setId(id);
        auditApp.setName(name);
        auditApp.setIsEnabled(isEnabled);
        auditApp.setMaxEntryId(maxEntryId);
        auditApp.setMinEntryId(minEntryId);
        return auditApp;
    }

    public static PublicApiClient.ListResponse<AuditApp> parseAuditApps(JSONObject jsonObject) {
        ArrayList<AuditApp> groups = new ArrayList<AuditApp>();
        JSONObject jsonList = (JSONObject)jsonObject.get((Object)"list");
        Assert.assertNotNull((Object)jsonList);
        JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
        Assert.assertNotNull((Object)jsonEntries);
        for (int i = 0; i < jsonEntries.size(); ++i) {
            JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
            JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
            groups.add(AuditApp.parseAuditApp(entry));
        }
        PublicApiClient.ExpectedPaging paging = PublicApiClient.ExpectedPaging.parsePagination(jsonList);
        PublicApiClient.ListResponse<AuditApp> resp = new PublicApiClient.ListResponse<AuditApp>(paging, groups);
        return resp;
    }
}

