/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.rest.api.tests.client.data.AssertUtil;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.service.cmr.repository.NodeRef;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class Activity
implements Serializable,
ExpectedComparison {
    private static final long serialVersionUID = 1869724448167732060L;
    private Long id;
    private String networkId;
    private String siteId;
    private String feedPersonId;
    private String postPersonId;
    private String postedAt;
    private String activityType;
    private Map<String, Object> summary;

    public Activity(Long id, String networkId, String siteId, String feedPersonId, String postPersonId, String postedAt, String activityType, Map<String, Object> summary) {
        this.id = id;
        this.networkId = networkId;
        this.siteId = siteId;
        this.feedPersonId = feedPersonId;
        this.postPersonId = postPersonId;
        this.postedAt = postedAt;
        this.activityType = activityType;
        this.summary = summary;
    }

    public Long getId() {
        return this.id;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getFeedPersonId() {
        return this.feedPersonId;
    }

    public String getPostPersonId() {
        return this.postPersonId;
    }

    public String getPostedAt() {
        return this.postedAt;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public Map<String, Object> getSummary() {
        return this.summary;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public String toString() {
        return "Activity [id=" + this.id + ", networkId=" + this.networkId + ", siteId=" + this.siteId + ", feedPersonId=" + this.feedPersonId + ", postPersonId=" + this.postPersonId + ", postedAt=" + this.postedAt + ", activityType=" + this.activityType + ", summary=" + this.summary + "]";
    }

    public static Activity parseActivity(JSONObject jsonObject) {
        Long id = (Long)jsonObject.get((Object)"id");
        String networkId = (String)jsonObject.get((Object)"networkId");
        String siteId = (String)jsonObject.get((Object)"siteId");
        String feedPersonId = (String)jsonObject.get((Object)"feedPersonId");
        String postPersonId = (String)jsonObject.get((Object)"postPersonId");
        String postedAt = (String)jsonObject.get((Object)"postedAt");
        String activityType = (String)jsonObject.get((Object)"activityType");
        JSONObject summary = (JSONObject)jsonObject.get((Object)"activitySummary");
        Activity activity = new Activity(id, networkId, siteId, feedPersonId, postPersonId, postedAt, activityType, (Map<String, Object>)summary);
        return activity;
    }

    public JSONObject toJSON() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"id", (Object)String.valueOf(this.getId()));
        jsonObject.put((Object)"networkId", (Object)this.getNetworkId());
        jsonObject.put((Object)"siteId", (Object)this.getSiteId());
        jsonObject.put((Object)"feedPersonId", (Object)this.getFeedPersonId());
        jsonObject.put((Object)"postPersonId", (Object)this.getPostPersonId());
        jsonObject.put((Object)"postedAt", (Object)this.getPostedAt());
        jsonObject.put((Object)"activityType", (Object)this.getActivityType());
        jsonObject.put((Object)"activitySummary", this.getSummary());
        return jsonObject;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Activity other = (Activity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    @Override
    public void expected(Object o) {
        Assert.assertTrue((boolean)(o instanceof Activity));
        Activity other = (Activity)o;
        AssertUtil.assertEquals("id", this.id, other.getId());
        AssertUtil.assertEquals("siteId", this.networkId, other.getNetworkId());
        AssertUtil.assertEquals("siteId", this.siteId, other.getSiteId());
        AssertUtil.assertEquals("feedPersonId", this.feedPersonId, other.getFeedPersonId());
        AssertUtil.assertEquals("postPersonId", this.postPersonId, other.getPostPersonId());
        AssertUtil.assertEquals("postedAt", this.postedAt, other.getPostedAt());
        AssertUtil.assertEquals("activityType", this.activityType, other.getActivityType());
        AssertUtil.assertEquals("summary", this.summary, other.getSummary());
    }

    public static Map<String, Object> getActivitySummary(JSONObject activitySummary, String activityType) {
        HashMap<String, Object> summary = new HashMap<String, Object>();
        if (activityType.equals("org.alfresco.documentlibrary.file-added")) {
            String nodeRefStr = (String)activitySummary.remove((Object)"nodeRef");
            if (!NodeRef.isNodeRef((String)nodeRefStr)) {
                throw new RuntimeException("nodeRef " + nodeRefStr + " in activity feed is not a valid NodeRef");
            }
            summary.put("objectId", new NodeRef(nodeRefStr).getId());
            String parentNodeRefStr = (String)activitySummary.remove((Object)"parentNodeRef");
            if (!NodeRef.isNodeRef((String)parentNodeRefStr)) {
                throw new RuntimeException("parentNodeRef " + parentNodeRefStr + " in activity feed is not a valid NodeRef");
            }
            summary.put("parentObjectId", new NodeRef(parentNodeRefStr).getId());
            summary.put("lastName", activitySummary.get((Object)"lastName"));
            summary.put("firstName", activitySummary.get((Object)"firstName"));
            summary.put("title", activitySummary.get((Object)"title"));
        } else if (activityType.equals("org.alfresco.site.user-joined")) {
            summary.put("lastName", activitySummary.get((Object)"lastName"));
            summary.put("firstName", activitySummary.get((Object)"firstName"));
            summary.put("memberLastName", activitySummary.get((Object)"memberLastName"));
            summary.put("memberFirstName", activitySummary.get((Object)"memberFirstName"));
            summary.put("memberPersonId", activitySummary.get((Object)"memberUserName"));
            summary.put("role", activitySummary.get((Object)"role"));
            summary.put("title", activitySummary.get((Object)"title"));
        }
        return summary;
    }
}

