/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.alfresco.cmis.client.impl.AlfrescoObjectFactoryImpl;
import org.alfresco.opencmis.CMISDispatcherRegistry;
import org.alfresco.rest.api.model.ActionDefinition;
import org.alfresco.rest.api.model.SiteUpdate;
import org.alfresco.rest.api.tests.TestPeople;
import org.alfresco.rest.api.tests.TestSites;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.PublicApiHttpClient;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.RestErrorResponseDefault;
import org.alfresco.rest.api.tests.client.UserData;
import org.alfresco.rest.api.tests.client.UserDataService;
import org.alfresco.rest.api.tests.client.data.Action;
import org.alfresco.rest.api.tests.client.data.Activities;
import org.alfresco.rest.api.tests.client.data.Activity;
import org.alfresco.rest.api.tests.client.data.Aspect;
import org.alfresco.rest.api.tests.client.data.AuditApp;
import org.alfresco.rest.api.tests.client.data.AuditEntry;
import org.alfresco.rest.api.tests.client.data.CMISNode;
import org.alfresco.rest.api.tests.client.data.Comment;
import org.alfresco.rest.api.tests.client.data.ContentData;
import org.alfresco.rest.api.tests.client.data.Favourite;
import org.alfresco.rest.api.tests.client.data.FavouriteSite;
import org.alfresco.rest.api.tests.client.data.FolderNode;
import org.alfresco.rest.api.tests.client.data.Group;
import org.alfresco.rest.api.tests.client.data.GroupMember;
import org.alfresco.rest.api.tests.client.data.MemberOfSite;
import org.alfresco.rest.api.tests.client.data.NodeRating;
import org.alfresco.rest.api.tests.client.data.Person;
import org.alfresco.rest.api.tests.client.data.PersonNetwork;
import org.alfresco.rest.api.tests.client.data.Preference;
import org.alfresco.rest.api.tests.client.data.Site;
import org.alfresco.rest.api.tests.client.data.SiteContainer;
import org.alfresco.rest.api.tests.client.data.SiteGroup;
import org.alfresco.rest.api.tests.client.data.SiteImpl;
import org.alfresco.rest.api.tests.client.data.SiteMember;
import org.alfresco.rest.api.tests.client.data.SiteMembershipRequest;
import org.alfresco.rest.api.tests.client.data.Tag;
import org.alfresco.rest.api.tests.client.data.Type;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.ItemIterable;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.QueryResult;
import org.apache.chemistry.opencmis.client.api.Repository;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.api.Tree;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.definitions.FolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class PublicApiClient {
    private static final Log logger = LogFactory.getLog(PublicApiClient.class);
    private UserDataService userDataService;
    private PublicApiHttpClient client;
    private Sites sites;
    private Tags tags;
    private Comments comments;
    private Nodes nodes;
    private People people;
    private Favourites favourites;
    private SiteMembershipRequests siteMembershipRequests;
    private Groups groups;
    private RawProxy rawProxy;
    private AuditApps auditApps;
    private Actions actions;
    private Aspects aspects;
    private Types types;
    private ThreadLocal<RequestContext> rc = new ThreadLocal();
    private ObjectMapper objectMapper = new ObjectMapper();

    public PublicApiClient(PublicApiHttpClient client, UserDataService userDataService) {
        this.client = client;
        this.userDataService = userDataService;
        this.init();
    }

    public void init() {
        this.sites = new Sites();
        this.tags = new Tags();
        this.comments = new Comments();
        this.nodes = new Nodes();
        this.people = new People();
        this.favourites = new Favourites();
        this.siteMembershipRequests = new SiteMembershipRequests();
        this.groups = new Groups();
        this.rawProxy = new RawProxy();
        this.auditApps = new AuditApps();
        this.actions = new Actions();
        this.aspects = new Aspects();
        this.types = new Types();
    }

    public void setRequestContext(RequestContext rc) {
        this.rc.set(rc);
    }

    public RequestContext getRequestContext() {
        RequestContext context = this.rc.get();
        if (context == null) {
            throw new RuntimeException("Must set a request context");
        }
        return context;
    }

    protected UserData findUser(String userName) {
        return this.userDataService.findUserByUserName(userName);
    }

    public RawProxy rawProxy() {
        return this.rawProxy;
    }

    public People people() {
        return this.people;
    }

    public Nodes nodes() {
        return this.nodes;
    }

    public Sites sites() {
        return this.sites;
    }

    public Favourites favourites() {
        return this.favourites;
    }

    public SiteMembershipRequests siteMembershipRequests() {
        return this.siteMembershipRequests;
    }

    public Tags tags() {
        return this.tags;
    }

    public Comments comments() {
        return this.comments;
    }

    public Groups groups() {
        return this.groups;
    }

    public AuditApps auditApps() {
        return this.auditApps;
    }

    public Actions actions() {
        return this.actions;
    }

    public Aspects aspects() {
        return this.aspects;
    }

    public Types types() {
        return this.types;
    }

    public CmisSession createPublicApiCMISSession(CMISDispatcherRegistry.Binding binding, String version) {
        return this.createPublicApiCMISSession(binding, version, null);
    }

    public CmisSession createPublicApiCMISSession(CMISDispatcherRegistry.Binding binding, String version, String objectFactoryName) {
        CmisSession cmisSession = null;
        RequestContext rc = this.getRequestContext();
        if (rc == null) {
            throw new RuntimeException("Must set a request context");
        }
        String networkId = rc.getNetworkId();
        String username = rc.getRunAsUser();
        UserData userData = this.findUser(rc.getRunAsUser());
        if (userData != null) {
            String password = userData.getPassword();
            SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("org.apache.chemistry.opencmis.user", username);
            parameters.put("org.apache.chemistry.opencmis.password", password);
            if (binding == CMISDispatcherRegistry.Binding.atom) {
                parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", this.client.getPublicApiCmisUrl(networkId, binding, version, null));
                parameters.put("org.apache.chemistry.opencmis.binding.spi.type", binding.getOpenCmisBinding().value());
            } else if (binding == CMISDispatcherRegistry.Binding.browser) {
                parameters.put("org.apache.chemistry.opencmis.binding.browser.url", this.client.getPublicApiCmisUrl(networkId, binding, version, null));
                parameters.put("org.apache.chemistry.opencmis.binding.spi.type", binding.getOpenCmisBinding().value());
            }
            if (networkId != null) {
                parameters.put("org.apache.chemistry.opencmis.session.repository.id", networkId);
            }
            if (objectFactoryName != null) {
                parameters.put("org.apache.chemistry.opencmis.objectfactory.classname", objectFactoryName);
            }
            Session session = factory.createSession(parameters);
            cmisSession = new CmisSession(session);
        }
        return cmisSession;
    }

    public CmisSession createCMISSession(String repositoryId, RequestContext rc) {
        CmisSession session = null;
        UserData userData = this.findUser(rc.getRunAsUser());
        if (userData != null) {
            session = this.createCMISSession(repositoryId, rc.getRunAsUser(), userData.getPassword());
        }
        return session;
    }

    public List<Repository> getCMISRepositories() {
        List repositories = null;
        RequestContext rc = this.getRequestContext();
        if (rc == null) {
            throw new RuntimeException("Must set a request context");
        }
        UserData userData = this.findUser(rc.getRunAsUser());
        if (userData != null) {
            SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("org.apache.chemistry.opencmis.user", rc.getRunAsUser());
            parameters.put("org.apache.chemistry.opencmis.password", userData.getPassword());
            parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", this.client.getCmisUrl(null, null));
            parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
            repositories = factory.getRepositories(parameters);
        }
        return repositories;
    }

    public CmisSession createCMISSession(String repositoryId, String username, String password) {
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.user", username);
        parameters.put("org.apache.chemistry.opencmis.password", password);
        parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", this.client.getCmisUrl(repositoryId, null));
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        if (repositoryId != null) {
            parameters.put("org.apache.chemistry.opencmis.session.repository.id", repositoryId);
        }
        parameters.put("org.apache.chemistry.opencmis.objectfactory.classname", AlfrescoObjectFactoryImpl.class.getName());
        Session session = factory.createSession(parameters);
        CmisSession cmisSession = new CmisSession(session);
        return cmisSession;
    }

    public CmisSession getCMISSession(Repository respository) {
        RequestContext rc = this.getRequestContext();
        if (rc == null) {
            throw new RuntimeException("Must set a request context");
        }
        CmisSession session = this.createCMISSession(respository.getId(), rc);
        return session;
    }

    public HttpResponse post(CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation, String body) throws PublicApiException {
        try {
            HttpResponse response = this.client.post(this.getRequestContext(), cmisBinding, version, cmisOperation, body);
            logger.debug((Object)response.toString());
            return response;
        }
        catch (IOException e) {
            throw new PublicApiException(e);
        }
    }

    public HttpResponse put(CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation, String body) throws PublicApiException {
        try {
            HttpResponse response = this.client.put(this.getRequestContext(), cmisBinding, version, cmisOperation, body);
            logger.debug((Object)response.toString());
            return response;
        }
        catch (IOException e) {
            throw new PublicApiException(e);
        }
    }

    public HttpResponse get(CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation, Map<String, String> parameters) throws PublicApiException {
        try {
            HttpResponse response = this.client.get(this.getRequestContext(), cmisBinding, version, cmisOperation, parameters);
            logger.debug((Object)response.toString());
            return response;
        }
        catch (IOException e) {
            throw new PublicApiException(e);
        }
    }

    public HttpResponse patch(CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation, Map<String, String> parameters) throws PublicApiException {
        try {
            HttpResponse response = this.client.patch(this.getRequestContext(), cmisBinding, version, cmisOperation);
            logger.debug((Object)response.toString());
            return response;
        }
        catch (IOException e) {
            throw new PublicApiException(e);
        }
    }

    public HttpResponse trace(CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation, Map<String, String> parameters) throws PublicApiException {
        try {
            HttpResponse response = this.client.trace(this.getRequestContext(), cmisBinding, version, cmisOperation);
            logger.debug((Object)response.toString());
            return response;
        }
        catch (IOException e) {
            throw new PublicApiException(e);
        }
    }

    public HttpResponse options(CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation, Map<String, String> parameters) throws PublicApiException {
        try {
            HttpResponse response = this.client.options(this.getRequestContext(), cmisBinding, version, cmisOperation);
            logger.debug((Object)response.toString());
            return response;
        }
        catch (IOException e) {
            throw new PublicApiException(e);
        }
    }

    public HttpResponse head(CMISDispatcherRegistry.Binding cmisBinding, String version, String cmisOperation, Map<String, String> parameters) throws PublicApiException {
        try {
            HttpResponse response = this.client.head(this.getRequestContext(), cmisBinding, version, cmisOperation);
            logger.debug((Object)response.toString());
            return response;
        }
        catch (IOException e) {
            throw new PublicApiException(e);
        }
    }

    public HttpResponse post(String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, String body) throws IOException {
        HttpResponse response = this.client.post(this.getRequestContext(), scope, entityCollectionName, entityId, relationCollectionName, relationshipEntityId != null ? relationshipEntityId.toString() : null, body);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse post(String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, String body, Map<String, String> params) throws IOException {
        HttpResponse response = this.client.post(this.getRequestContext(), scope, entityCollectionName, entityId, relationCollectionName, (Object)(relationshipEntityId != null ? relationshipEntityId.toString() : null), body, params);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse post(String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, String body, String contentType) throws IOException {
        HttpResponse response = this.client.post(this.getRequestContext(), scope, entityCollectionName, entityId, relationCollectionName, (Object)(relationshipEntityId != null ? relationshipEntityId.toString() : null), body, contentType);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse post(String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, byte[] body, String contentType) throws IOException {
        HttpResponse response = this.client.post(this.getRequestContext(), scope, entityCollectionName, entityId, relationCollectionName, (Object)(relationshipEntityId != null ? relationshipEntityId.toString() : null), body, contentType);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse post(String urlSuffix, String body) throws IOException {
        HttpResponse response = this.client.post(this.getRequestContext(), urlSuffix, body);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse post(Class<?> c, Object entityId, Object relationshipEntityId, String body) throws IOException {
        HttpResponse response = this.client.post(c, this.getRequestContext(), entityId, relationshipEntityId, body);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse get(String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, Map<String, String> params, Map<String, String> headers) throws IOException {
        HttpResponse response = this.client.get(this.getRequestContext(), scope, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, params, headers);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse get(String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, Map<String, String> params) throws IOException {
        return this.get(scope, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, params, null);
    }

    public HttpResponse getWithPassword(String scope, String password, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, Map<String, String> params) throws IOException {
        HttpResponse response = this.client.get(this.getRequestContext(), scope, password, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, params);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse get(String url, Map<String, String> params) throws IOException {
        RequestContext rc = this.getRequestContext();
        HttpResponse response = this.client.get(url, rc, params);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse get(Class<?> c, Object entityId, Object relationshipEntityId, Map<String, String> params) throws IOException {
        HttpResponse response = this.client.get(c, this.getRequestContext(), entityId, relationshipEntityId, params);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse put(String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, String body, Map<String, String> params) throws IOException {
        HttpResponse response = this.client.put(this.getRequestContext(), scope, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, body, params);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse put(Class<?> c, Object entityId, Object relationshipEntityId, String body) throws IOException {
        HttpResponse response = this.client.put(c, this.getRequestContext(), entityId, relationshipEntityId, body);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse putBinary(String scope, int version, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, PublicApiHttpClient.BinaryPayload payload, Map<String, String> params) throws IOException {
        HttpResponse response = this.client.putBinary(this.getRequestContext(), scope, version, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, payload, params);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse delete(String scope, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId) throws IOException {
        return this.delete(scope, 1, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, null);
    }

    public HttpResponse delete(String scope, int version, String entityCollectionName, Object entityId, String relationCollectionName, Object relationshipEntityId, Map<String, String> params) throws IOException {
        HttpResponse response = this.client.delete(this.getRequestContext(), scope, version, entityCollectionName, entityId, relationCollectionName, relationshipEntityId, params);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse put(Class<?> c, Object entityId, Object relationshipEntityId) throws IOException {
        HttpResponse response = this.client.delete(c, this.getRequestContext(), entityId, relationshipEntityId);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse execute(PublicApiHttpClient.RequestBuilder requestBuilder) throws IOException {
        if (requestBuilder.getRequestContext() == null) {
            throw new RuntimeException("Must set a request context");
        }
        HttpResponse response = this.client.execute(requestBuilder);
        logger.debug((Object)response.toString());
        return response;
    }

    public HttpResponse index(Map<String, String> params) throws IOException {
        HttpResponse response = this.get("", params);
        return response;
    }

    public List<String> getNetworkIds(String version) {
        RequestContext rc = this.getRequestContext();
        UserData userData = this.findUser(rc.getRunAsUser());
        if (userData == null) {
            throw new RuntimeException("Must provide a valid username");
        }
        SessionFactoryImpl factory = SessionFactoryImpl.newInstance();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("org.apache.chemistry.opencmis.binding.atompub.url", this.client.getPublicApiCmisUrl(null, CMISDispatcherRegistry.Binding.atom, version, null));
        parameters.put("org.apache.chemistry.opencmis.binding.spi.type", BindingType.ATOMPUB.value());
        parameters.put("org.apache.chemistry.opencmis.user", rc.getRunAsUser());
        parameters.put("org.apache.chemistry.opencmis.password", userData.getPassword());
        List repositories = factory.getRepositories(parameters);
        ArrayList<String> repositoryIds = new ArrayList<String>(repositories.size());
        for (Repository repository : repositories) {
            repositoryIds.add(repository.getId());
        }
        return repositoryIds;
    }

    public class Actions
    extends AbstractProxy {
        public ListResponse<ActionDefinition> getActionDefinitionsForNode(String nodeId, Map<String, String> params, int expectedStatus) throws PublicApiException {
            JSONObject jsonList;
            HttpResponse response = this.getAll("nodes", nodeId, "action-definitions", null, params, "Unexpected response", expectedStatus);
            if (response != null && response.getJsonResponse() != null && (jsonList = (JSONObject)response.getJsonResponse().get((Object)"list")) != null) {
                return this.parseActionDefinitions(response.getJsonResponse());
            }
            return null;
        }

        public ListResponse<ActionDefinition> getActionDefinitions(Map<String, String> params, int expectedStatus) throws PublicApiException {
            JSONObject jsonList;
            HttpResponse response = this.getAll("action-definitions", null, null, null, params, "Unexpected response", expectedStatus);
            if (response != null && response.getJsonResponse() != null && (jsonList = (JSONObject)response.getJsonResponse().get((Object)"list")) != null) {
                return this.parseActionDefinitions(response.getJsonResponse());
            }
            return null;
        }

        public Action executeAction(Action action, Map<String, String> params, int expectedStatus) throws PublicApiException {
            HttpResponse response = this.create("action-executions", null, null, null, action.toJSON().toString(), "Failed to create action for action def " + action.getActionDefinitionId(), expectedStatus, params);
            return this.parseActionEntity(response);
        }

        private ListResponse<ActionDefinition> parseActionDefinitions(JSONObject jsonResponse) {
            ArrayList<ActionDefinition> actionDefinitions = new ArrayList<ActionDefinition>();
            JSONObject jsonList = (JSONObject)jsonResponse.get((Object)"list");
            Assert.assertNotNull((Object)jsonList);
            JSONArray jsonEntries = (JSONArray)jsonList.get((Object)"entries");
            Assert.assertNotNull((Object)jsonEntries);
            for (int i = 0; i < jsonEntries.size(); ++i) {
                JSONObject jsonEntry = (JSONObject)jsonEntries.get(i);
                JSONObject entry = (JSONObject)jsonEntry.get((Object)"entry");
                actionDefinitions.add(this.parseActionDefinition(entry));
            }
            ExpectedPaging paging = ExpectedPaging.parsePagination(jsonList);
            return new ListResponse<ActionDefinition>(paging, actionDefinitions);
        }

        private ActionDefinition parseActionDefinition(JSONObject entry) {
            ActionDefinition def = null;
            try {
                def = (ActionDefinition)PublicApiClient.this.objectMapper.readValue(entry.toString(), ActionDefinition.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to parse ActionDefinition JSON", e);
            }
            return def;
        }

        private Action parseActionEntity(HttpResponse response) {
            JSONObject jsonEntity;
            if (response != null && response.getJsonResponse() != null && (jsonEntity = (JSONObject)response.getJsonResponse().get((Object)"entry")) != null) {
                return Action.parseAction(jsonEntity);
            }
            return null;
        }

        public ActionDefinition getActionDefinition(String actionDefinitionId, int expectedStatus) throws PublicApiException {
            JSONObject jsonEntity;
            HttpResponse response = this.getSingle("action-definitions", actionDefinitionId, null, null, null, "Unexpected response", expectedStatus);
            if (response != null && response.getJsonResponse() != null && (jsonEntity = (JSONObject)response.getJsonResponse().get((Object)"entry")) != null) {
                return this.parseActionDefinition(jsonEntity);
            }
            return null;
        }
    }

    public class AuditApps
    extends AbstractProxy {
        public ListResponse<AuditApp> getAuditApps(Map<String, String> params, String errorMessage, int expectedStatus) throws PublicApiException {
            JSONObject jsonList;
            HttpResponse response = this.getAll("audit-applications", null, null, null, params, errorMessage, expectedStatus);
            if (response != null && response.getJsonResponse() != null && (jsonList = (JSONObject)response.getJsonResponse().get((Object)"list")) != null) {
                return AuditApp.parseAuditApps(response.getJsonResponse());
            }
            return null;
        }

        public AuditApp getAuditApp(String applicationId) throws PublicApiException {
            return this.getAuditApp(applicationId, 200);
        }

        public AuditApp getAuditApp(String applicationId, int expectedStatus) throws PublicApiException {
            return this.getAuditApp(applicationId, null, expectedStatus);
        }

        public AuditApp getAuditApp(String applicationId, Map<String, String> params, int expectedStatus) throws PublicApiException {
            JSONObject jsonEntry;
            HttpResponse response = this.getSingle("audit-applications", applicationId, null, null, params, "Failed to get Audit Application " + applicationId, expectedStatus);
            if (response != null && response.getJsonResponse() != null && (jsonEntry = (JSONObject)response.getJsonResponse().get((Object)"entry")) != null) {
                return AuditApp.parseAuditApp(jsonEntry);
            }
            return null;
        }

        public AuditApp updateAuditApp(String applicationId, AuditApp auditApp, Map<String, String> params, int expectedStatus) throws PublicApiException {
            JSONObject jsonEntry;
            HttpResponse response = this.update("audit-applications", applicationId, null, null, auditApp.toJSON().toString(), params, "Failed to update Audit Application", expectedStatus);
            if (response != null && response.getJsonResponse() != null && (jsonEntry = (JSONObject)response.getJsonResponse().get((Object)"entry")) != null) {
                return AuditApp.parseAuditApp(jsonEntry);
            }
            return null;
        }

        public ListResponse<AuditEntry> getAuditAppEntries(String applicationId, Map<String, String> params, int expectedStatus) throws PublicApiException, ParseException {
            JSONObject jsonList;
            HttpResponse response = this.getAll("audit-applications", applicationId, "audit-entries", null, params, "Failed to get audit entries for " + applicationId, expectedStatus);
            if (response != null && response.getJsonResponse() != null && (jsonList = (JSONObject)response.getJsonResponse().get((Object)"list")) != null) {
                return AuditEntry.parseAuditEntries(response.getJsonResponse());
            }
            return null;
        }

        public AuditEntry getAuditEntry(String applicationId, String entryId, Map<String, String> param, int expectedStatus) throws PublicApiException, ParseException {
            JSONObject jsonList;
            HttpResponse response = this.getSingle("audit-applications", applicationId, "audit-entries", entryId, param, "Failed to get Audit Application " + applicationId, expectedStatus);
            if (response != null && response.getJsonResponse() != null && (jsonList = (JSONObject)response.getJsonResponse().get((Object)"entry")) != null) {
                return AuditEntry.parseAuditEntry(jsonList);
            }
            return null;
        }

        public void deleteAuditEntry(String applicationId, String entryId, Map<String, String> param, int expectedStatus) throws PublicApiException {
            this.remove("audit-applications", applicationId, "audit-entries", entryId, param, "Failed to delete entry " + entryId, expectedStatus);
        }

        public void deleteAuditEntries(String applicationId, Map<String, String> param, int expectedStatus) throws PublicApiException {
            this.remove("audit-applications", applicationId, "audit-entries", null, param, "Failed to delete entries for audit application " + applicationId, expectedStatus);
        }

        public ListResponse<AuditEntry> getAuditAppEntriesByNodeRefId(String nodeId, Map<String, String> params, int expectedStatus) throws PublicApiException, ParseException {
            JSONObject jsonList;
            HttpResponse response = this.getAll("nodes", nodeId, "audit-entries", null, params, "Failed to get audit entries for " + nodeId, expectedStatus);
            if (response != null && response.getJsonResponse() != null && (jsonList = (JSONObject)response.getJsonResponse().get((Object)"list")) != null) {
                return AuditEntry.parseAuditEntries(response.getJsonResponse());
            }
            return null;
        }
    }

    public class Groups
    extends AbstractProxy {
        public Group createGroup(Group group, Map<String, String> params, int expectedStatus) throws PublicApiException {
            HttpResponse response = this.create("groups", null, null, null, group.toJSON().toString(), "Failed to create group " + group.getId(), expectedStatus, params);
            return this.parseGroupEntity(response);
        }

        public GroupMember createGroupMember(String groupId, GroupMember groupMember) throws PublicApiException {
            return this.createGroupMember(groupId, groupMember, 200);
        }

        public GroupMember createGroupMember(String groupId, GroupMember groupMember, int expectedStatus) throws PublicApiException {
            JSONObject jsonEntity;
            HttpResponse response = this.create("groups", groupId, "members", null, groupMember.toJSON().toString(), "Failed to create group membership", expectedStatus);
            if (response != null && response.getJsonResponse() != null && (jsonEntity = (JSONObject)response.getJsonResponse().get((Object)"entry")) != null) {
                return GroupMember.parseGroupMember(response.getJsonResponse());
            }
            return null;
        }

        public Group updateGroup(String groupId, Group group, Map<String, String> params, int expectedStatus) throws PublicApiException {
            HttpResponse response = this.update("groups", groupId, null, null, group.toJSON().toString(), params, "Failed to update group " + group.getId(), expectedStatus);
            return this.parseGroupEntity(response);
        }

        public Group getGroup(String groupId) throws PublicApiException {
            return this.getGroup(groupId, 200);
        }

        public Group getGroup(String groupId, int expectedStatus) throws PublicApiException {
            return this.getGroup(groupId, null, expectedStatus);
        }

        public Group getGroup(String groupId, Map<String, String> params, int expectedStatus) throws PublicApiException {
            HttpResponse response = this.getSingle("groups", groupId, null, null, params, "Failed to get group " + groupId, expectedStatus);
            return this.parseGroupEntity(response);
        }

        public void deleteGroup(String groupId, boolean cascade, int expectedStatus) throws PublicApiException {
            Map<String, String> params = null;
            if (cascade) {
                params = Collections.singletonMap("cascade", "true");
            }
            this.remove("groups", groupId, null, null, params, "Failed to remove group", expectedStatus);
        }

        public void deleteGroupMembership(String groupId, String groupMemberId, int expectedStatus) throws PublicApiException {
            this.remove("groups", groupId, "members", groupMemberId, null, "Failed to remove group member", expectedStatus);
        }

        private Group parseGroupEntity(HttpResponse response) {
            JSONObject jsonEntity;
            if (response != null && response.getJsonResponse() != null && (jsonEntity = (JSONObject)response.getJsonResponse().get((Object)"entry")) != null) {
                return Group.parseGroup(jsonEntity);
            }
            return null;
        }

        public ListResponse<Group> getGroups(Map<String, String> params, String errorMessage, int expectedStatus) throws PublicApiException, ParseException {
            JSONObject jsonList;
            HttpResponse response = this.getAll("groups", null, null, null, params, errorMessage, expectedStatus);
            if (response != null && response.getJsonResponse() != null && (jsonList = (JSONObject)response.getJsonResponse().get((Object)"list")) != null) {
                return Group.parseGroups(response.getJsonResponse());
            }
            return null;
        }

        public ListResponse<GroupMember> getGroupMembers(String groupId, Map<String, String> params) throws PublicApiException, ParseException {
            return this.getGroupMembers(groupId, params, "Failed to get groups", 200);
        }

        public ListResponse<GroupMember> getGroupMembers(String groupId, Map<String, String> params, String errorMessage, int expectedStatus) throws PublicApiException, ParseException {
            JSONObject jsonList;
            HttpResponse response = this.getAll("groups", groupId, "members", null, params, errorMessage, expectedStatus);
            if (response != null && response.getJsonResponse() != null && (jsonList = (JSONObject)response.getJsonResponse().get((Object)"list")) != null) {
                return GroupMember.parseGroupMembers(response.getJsonResponse());
            }
            return null;
        }

        public ListResponse<Group> getGroupsByPersonId(String userId, Map<String, String> params, String errorMessage, int expectedStatus) throws PublicApiException, ParseException {
            JSONObject jsonList;
            HttpResponse response = this.getAll("people", userId, "groups", null, params, errorMessage, expectedStatus);
            if (response != null && response.getJsonResponse() != null && (jsonList = (JSONObject)response.getJsonResponse().get((Object)"list")) != null) {
                return Group.parseGroups(response.getJsonResponse());
            }
            return null;
        }
    }

    public static class ExpectedErrorResponse {
        private String errorKey;
        private int statusCode;
        private String briefSummary;
        private String stackTrace;
        private Map<String, Object> additionalState;
        private String descriptionURL;
        private String logId;

        public ExpectedErrorResponse() {
        }

        public ExpectedErrorResponse(String errorKey, int statusCode, String briefSummary, StackTraceElement[] stackTrace, Map<String, Object> additionalState, String logId) {
            this.errorKey = errorKey;
            this.statusCode = statusCode;
            this.briefSummary = briefSummary;
            this.stackTrace = Arrays.toString(stackTrace);
            this.additionalState = additionalState;
            this.logId = logId;
        }

        public String getErrorKey() {
            return this.errorKey;
        }

        public ExpectedErrorResponse setErrorKey(String errorKey) {
            this.errorKey = errorKey;
            return this;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public ExpectedErrorResponse setStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public String getBriefSummary() {
            return this.briefSummary;
        }

        public ExpectedErrorResponse setBriefSummary(String briefSummary) {
            this.briefSummary = briefSummary;
            return this;
        }

        public String getLogId() {
            return this.logId;
        }

        public void setLogId(String logId) {
            this.logId = logId;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public ExpectedErrorResponse setStackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
            return this;
        }

        public Map<String, Object> getAdditionalState() {
            return this.additionalState;
        }

        public ExpectedErrorResponse setAdditionalState(Map<String, Object> additionalState) {
            this.additionalState = additionalState;
            return this;
        }

        public String getDescriptionURL() {
            return this.descriptionURL;
        }

        public ExpectedErrorResponse setDescriptionURL(String descriptionURL) {
            this.descriptionURL = descriptionURL;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(250);
            sb.append("ExpectedErrorResponse [errorKey='").append(this.errorKey).append(", statusCode=").append(this.statusCode).append(", briefSummary='").append(this.briefSummary).append(", logId='").append(this.logId).append(", stackTrace='").append(this.stackTrace).append(", additionalState=").append(this.additionalState).append(", descriptionURL='").append(this.descriptionURL).append(']');
            return sb.toString();
        }
    }

    public static class Paging {
        private Integer skipCount;
        private Integer maxItems;
        private ExpectedPaging expectedPaging;

        public Paging() {
        }

        public Paging(Integer skipCount, Integer maxItems, ExpectedPaging expectedPaging) {
            this.skipCount = skipCount;
            this.maxItems = maxItems;
            this.expectedPaging = expectedPaging;
        }

        public ExpectedPaging getExpectedPaging() {
            return this.expectedPaging;
        }

        public void setExpectedPaging(ExpectedPaging expectedPaging) {
            this.expectedPaging = expectedPaging;
        }

        public Integer getSkipCount() {
            return this.skipCount;
        }

        public Integer getMaxItems() {
            return this.maxItems;
        }

        public void setSkipCount(Integer skipCount) {
            this.skipCount = skipCount;
        }

        public void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.maxItems == null ? 0 : this.maxItems.hashCode());
            result = 31 * result + (this.skipCount == null ? 0 : this.skipCount.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Paging other = (Paging)obj;
            if (this.maxItems == null ? other.maxItems != null : !this.maxItems.equals(other.maxItems)) {
                return false;
            }
            return !(this.skipCount == null ? other.skipCount != null : !this.skipCount.equals(other.skipCount));
        }

        public String toString() {
            return "Paging [" + (String)(this.skipCount != null ? "skipCount=" + this.skipCount + ", " : "") + (String)(this.maxItems != null ? "maxItems=" + this.maxItems : "") + "]";
        }
    }

    public class CmisSession {
        private Session session;

        public CmisSession(Session session) {
            this.session = session;
        }

        public Session getCMISSession() {
            return this.session;
        }

        public CmisObject getObject(String objectId) {
            RequestContext rc = PublicApiClient.this.getRequestContext();
            OperationContext ctx = rc.getCmisOperationCtxOverride();
            if (ctx == null) {
                ctx = new OperationContextImpl();
            }
            CmisObject res = this.session.getObject(objectId, ctx);
            return res;
        }

        public CmisObject getObjectByPath(String path) {
            OperationContextImpl ctx = new OperationContextImpl();
            CmisObject res = this.session.getObjectByPath(path, (OperationContext)ctx);
            return res;
        }

        public List<Folder> getObjectParents(String objectId) {
            CmisObject o = this.session.getObject(objectId);
            if (o instanceof FileableCmisObject) {
                FileableCmisObject f = (FileableCmisObject)o;
                OperationContextImpl ctx = new OperationContextImpl();
                List res = f.getParents((OperationContext)ctx);
                return res;
            }
            throw new IllegalArgumentException("Object does not exist or is not a fileable cmis object");
        }

        public void deleteContent(String objectId, boolean refresh) {
            CmisObject o = this.getObject(objectId);
            if (!(o instanceof Document)) {
                throw new IllegalArgumentException("Object does not exists or is not a document");
            }
            Document d = (Document)o;
            d.deleteContentStream(refresh);
        }

        public ContentData getContent(String objectId) throws IOException {
            CmisObject o = this.getObject(objectId);
            if (o instanceof Document) {
                Document d = (Document)o;
                ContentStream res = d.getContentStream();
                ContentData c = new ContentData(res);
                return c;
            }
            throw new IllegalArgumentException("Object does not exist or is not a document");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putContent(String objectId, String filename, BigInteger length, String mimetype, InputStream content, boolean overwrite) {
            CmisObject o = this.getObject(objectId);
            if (o instanceof Document) {
                Document d = (Document)o;
                ContentStreamImpl contentStream = new ContentStreamImpl(filename, length, mimetype, content);
                try {
                    d.setContentStream((ContentStream)contentStream, overwrite);
                }
                finally {
                    try {
                        contentStream.getStream().close();
                    }
                    catch (Exception exception) {}
                }
            }
            throw new IllegalArgumentException("Object does not exist or is not a document");
        }

        public void addChildren(FolderNode f, Tree<FileableCmisObject> t) {
            FileableCmisObject fco = (FileableCmisObject)t.getItem();
            CMISNode child = CMISNode.createNode((CmisObject)fco);
            if (child instanceof FolderNode) {
                f.addFolder((FolderNode)child);
                for (Tree c : t.getChildren()) {
                    this.addChildren((FolderNode)child, (Tree<FileableCmisObject>)c);
                }
            } else {
                f.addNode(child);
            }
        }

        public boolean objectExists(String objectId) {
            CmisObject o = this.getObject(objectId);
            return o != null;
        }

        public FolderNode getRootFolder() {
            Folder rootFolder = this.session.getRootFolder();
            FolderNode ret = (FolderNode)CMISNode.createNode((CmisObject)rootFolder);
            return ret;
        }

        public FolderNode getDescendants(String folderId, int depth) {
            Session session = this.getCMISSession();
            CmisObject o = session.getObject(folderId);
            if (o instanceof Folder) {
                Folder f = (Folder)o;
                OperationContextImpl ctx = new OperationContextImpl();
                List res = f.getDescendants(depth, (OperationContext)ctx);
                FolderNode ret = (FolderNode)CMISNode.createNode((CmisObject)f);
                for (Tree t : res) {
                    this.addChildren(ret, (Tree<FileableCmisObject>)t);
                }
                return ret;
            }
            throw new IllegalArgumentException("Folder does not exist or is not a folder");
        }

        public ItemIterable<ObjectType> getTypeChildren(String typeId, boolean includePropertyDefinitions) {
            ItemIterable res = this.session.getTypeChildren(typeId, includePropertyDefinitions);
            return res;
        }

        public List<Tree<ObjectType>> getTypeDescendants(String typeId, int depth, boolean includePropertyDefinitions) {
            List res = this.session.getTypeDescendants(typeId, depth, includePropertyDefinitions);
            return res;
        }

        public ObjectType getTypeDefinition(String typeId) {
            ObjectType res = this.session.getTypeDefinition(typeId);
            return res;
        }

        public void removeAllVersions(String objectId) {
            CmisObject o = this.getObject(objectId);
            if (!(o instanceof Document)) {
                throw new IllegalArgumentException("Object does not exist or is not a document");
            }
            Document d = (Document)o;
            d.deleteAllVersions();
        }

        public List<CMISNode> query(String query, boolean searchAllVersions, long skipCount, int maxItems) {
            OperationContextImpl ctx = new OperationContextImpl();
            ItemIterable res = this.session.query(query, searchAllVersions, (OperationContext)ctx);
            res = res.skipTo(skipCount);
            res = res.getPage(maxItems);
            ArrayList<CMISNode> results = new ArrayList<CMISNode>((int)res.getPageNumItems());
            for (QueryResult r : res) {
                CMISNode n = CMISNode.createNode(r);
                results.add(n);
            }
            return results;
        }

        public void removeObject(String objectId, boolean allVersions) {
            CmisObject o = this.getObject(objectId);
            if (o == null) {
                throw new IllegalArgumentException("Object does not exist");
            }
            o.delete(allVersions);
        }

        public List<String> removeTree(String objectId, boolean allVersions, UnfileObject unfile, boolean continueOnFailure) {
            CmisObject o = this.getObject(objectId);
            if (o instanceof Folder) {
                Folder f = (Folder)o;
                List res = f.deleteTree(allVersions, unfile, continueOnFailure);
                return res;
            }
            throw new IllegalArgumentException("Object does not exist or is not a folder");
        }

        public void updateProperties(String objectId, Map<String, ?> properties, boolean refresh) {
            CmisObject o = this.getObject(objectId);
            if (o == null) {
                throw new IllegalArgumentException("Object does not exist");
            }
            o.updateProperties(properties, refresh);
        }

        public List<Tree<FileableCmisObject>> getFolderTree(String folderId, int depth) {
            CmisObject o = this.session.getObject(folderId);
            if (o instanceof Folder) {
                Folder f = (Folder)o;
                OperationContextImpl ctx = new OperationContextImpl();
                List res = f.getFolderTree(depth, (OperationContext)ctx);
                return res;
            }
            throw new IllegalArgumentException("Object does not exist or is not a folder");
        }

        public FolderNode getChildren(String folderId, int skipCount, int maxItems) {
            CmisObject o = this.session.getObject(folderId);
            if (o instanceof Folder) {
                Folder f = (Folder)o;
                FolderNode ret = (FolderNode)CMISNode.createNode((CmisObject)f);
                OperationContextImpl ctx = new OperationContextImpl();
                ItemIterable res = f.getChildren((OperationContext)ctx);
                res.skipTo((long)skipCount);
                ItemIterable l = res.getPage(maxItems);
                for (CmisObject c : l) {
                    CMISNode child = null;
                    if (c.getBaseType() instanceof FolderTypeDefinition) {
                        child = (FolderNode)CMISNode.createNode(c);
                        ret.addFolder((FolderNode)child);
                        continue;
                    }
                    child = CMISNode.createNode(c);
                    ret.addNode(child);
                }
                return ret;
            }
            throw new IllegalArgumentException("Folder does not exist or is not a folder");
        }

        public ItemIterable<Document> getCheckedOutDocs() {
            OperationContextImpl ctx = new OperationContextImpl();
            ItemIterable res = this.session.getCheckedOutDocs((OperationContext)ctx);
            return res;
        }

        public List<Document> getAllVersions(String objectId) {
            CmisObject o = this.getObject(objectId);
            if (o instanceof Document) {
                Document d = (Document)o;
                OperationContextImpl ctx = new OperationContextImpl();
                List res = d.getAllVersions((OperationContext)ctx);
                return res;
            }
            throw new IllegalArgumentException("Object does not exist or is not a document");
        }

        public AllowableActions getAllowableActions(String objectId) {
            CmisObject o = this.getObject(objectId);
            AllowableActions res = o.getAllowableActions();
            return res;
        }

        public Document createDocument(String parentId, String name, Map<String, Serializable> properties, ContentStream contentStream, VersioningState versioningState) {
            CmisObject o = this.getObject(parentId);
            if (o instanceof Folder) {
                Folder f = (Folder)o;
                if (properties == null) {
                    properties = new HashMap<String, Serializable>();
                }
                String objectTypeId = (String)((Object)properties.get("cmis:objectTypeId"));
                String type = "cmis:document";
                if (objectTypeId == null) {
                    objectTypeId = type;
                }
                if (objectTypeId.indexOf(type) == -1) {
                    StringBuilder sb = new StringBuilder(objectTypeId);
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(type);
                    objectTypeId = sb.toString();
                }
                properties.put("cmis:name", (Serializable)((Object)name));
                properties.put("cmis:objectTypeId", (Serializable)((Object)objectTypeId));
                Document res = f.createDocument(properties, contentStream, versioningState);
                return res;
            }
            throw new IllegalArgumentException("Parent does not exists or is not a folder");
        }

        public Folder createFolder(String folderId, String name, Map<String, Serializable> properties) {
            CmisObject o = this.getObject(folderId);
            if (o instanceof Folder) {
                Folder f = (Folder)o;
                if (properties == null) {
                    properties = new HashMap<String, Serializable>();
                }
                String objectTypeId = (String)((Object)properties.get("cmis:objectTypeId"));
                String type = "cmis:folder";
                if (objectTypeId == null) {
                    objectTypeId = type;
                }
                if (objectTypeId.indexOf(type) == -1) {
                    StringBuilder sb = new StringBuilder(objectTypeId);
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(type);
                    objectTypeId = sb.toString();
                }
                properties.put("cmis:name", (Serializable)((Object)name));
                properties.put("cmis:objectTypeId", (Serializable)((Object)objectTypeId));
                Folder res = f.createFolder(properties);
                return res;
            }
            throw new IllegalArgumentException("Parent does not exist or is not a folder");
        }

        public ObjectId createRelationship(String sourceObjectId, String targetObjectId) {
            HashMap<String, String> relProps = new HashMap<String, String>();
            relProps.put("cmis:sourceId", sourceObjectId);
            relProps.put("cmis:targetId", targetObjectId);
            relProps.put("cmis:objectTypeId", "cmis:relationship");
            ObjectId res = this.session.createRelationship(relProps);
            return res;
        }

        public ObjectId checkoutObject(String objectId) {
            CmisObject o = this.getObject(objectId);
            if (o instanceof Document) {
                Document d = (Document)o;
                ObjectId res = d.checkOut();
                return res;
            }
            throw new IllegalArgumentException("Object does not exist or is not a document");
        }
    }

    public static class ExpectedPaging {
        private int skipCount;
        private int maxItems;
        private Integer totalItems;
        private boolean hasMoreItems;
        private int count;

        public ExpectedPaging() {
        }

        public ExpectedPaging(int skipCount, int maxItems, Integer totalItems, boolean hasMoreItems, int count) {
            this.skipCount = skipCount;
            this.maxItems = maxItems;
            this.totalItems = totalItems;
            this.hasMoreItems = hasMoreItems;
            this.count = count;
        }

        public Integer getSkipCount() {
            return this.skipCount;
        }

        public Integer getMaxItems() {
            return this.maxItems;
        }

        public Integer getTotalItems() {
            return this.totalItems;
        }

        public Boolean getHasMoreItems() {
            return this.hasMoreItems;
        }

        public Integer getCount() {
            return this.count;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public void setHasMoreItems(Boolean hasMoreItems) {
            this.hasMoreItems = hasMoreItems;
        }

        public void setTotalItems(Integer totalItems) {
            this.totalItems = totalItems;
        }

        public void setSkipCount(Integer skipCount) {
            this.skipCount = skipCount;
        }

        public void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.count;
            result = 31 * result + (this.hasMoreItems ? 1231 : 1237);
            result = 31 * result + this.maxItems;
            result = 31 * result + this.skipCount;
            result = 31 * result + (this.totalItems == null ? 0 : this.totalItems.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ExpectedPaging other = (ExpectedPaging)obj;
            if (this.count != other.count) {
                return false;
            }
            if (this.hasMoreItems != other.hasMoreItems) {
                return false;
            }
            if (this.maxItems != other.maxItems) {
                return false;
            }
            if (this.skipCount != other.skipCount) {
                return false;
            }
            return !(this.totalItems == null ? other.totalItems != null : !this.totalItems.equals(other.totalItems));
        }

        public String toString() {
            return "ExpectedPaging [skipCount=" + this.skipCount + ", maxItems=" + this.maxItems + ", " + (String)(this.totalItems != null ? "totalItems=" + this.totalItems + ", " : "") + "hasMoreItems=" + this.hasMoreItems + ", count=" + this.count + "]";
        }

        public static ExpectedPaging parsePagination(JSONObject jsonList) {
            ExpectedPaging paging = new ExpectedPaging();
            JSONObject jsonPagination = (JSONObject)jsonList.get((Object)"pagination");
            if (jsonPagination != null) {
                Long count = (Long)jsonPagination.get((Object)"count");
                paging.setCount(count.intValue());
                Boolean hasMoreItems = (Boolean)jsonPagination.get((Object)"hasMoreItems");
                paging.setHasMoreItems(hasMoreItems);
                Long totalItems = (Long)jsonPagination.get((Object)"totalItems");
                if (totalItems != null) {
                    paging.setTotalItems(totalItems.intValue());
                }
                Long maxItems = (Long)jsonPagination.get((Object)"maxItems");
                paging.setMaxItems(maxItems.intValue());
                Long skipCount = (Long)jsonPagination.get((Object)"skipCount");
                paging.setSkipCount(skipCount.intValue());
            }
            return paging;
        }

        public static ExpectedPaging getExpectedPaging(Integer skipCount, Integer maxItems, int total, Integer expectedTotal) {
            int skip = skipCount != null ? skipCount : 0;
            int max = maxItems != null ? maxItems : 100;
            int expectedCount = -1;
            int end = skip + max;
            if (end < 0 || end > total) {
                expectedCount = total - skip;
                end = total;
            } else {
                expectedCount = max;
            }
            if (expectedCount < 0) {
                expectedCount = 0;
            }
            boolean hasMore = end < total;
            ExpectedPaging expectedPaging = new ExpectedPaging(skip, max, expectedTotal, hasMore, expectedCount);
            return expectedPaging;
        }
    }

    public class Types
    extends AbstractProxy {
        public ListResponse<Type> getTypes(Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("types", null, null, null, params, "Failed to get types");
            return Type.parseTypes(response.getJsonResponse());
        }

        public Type getType(String typeId) throws PublicApiException {
            HttpResponse response = this.getAll("types", typeId, null, null, null, "Failed to get type");
            return Type.parseType((JSONObject)response.getJsonResponse().get((Object)"entry"));
        }
    }

    public class Aspects
    extends AbstractProxy {
        public ListResponse<Aspect> getAspects(Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("aspects", null, null, null, params, "Failed to get aspects");
            return Aspect.parseAspects(response.getJsonResponse());
        }

        public Aspect getAspect(String aspectId) throws PublicApiException {
            HttpResponse response = this.getAll("aspects", aspectId, null, null, null, "Failed to get aspect");
            return Aspect.parseAspect((JSONObject)response.getJsonResponse().get((Object)"entry"));
        }
    }

    public class Nodes
    extends AbstractProxy {
        public ListResponse<Tag> getNodeTags(String nodeId, Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("nodes", nodeId, "tags", null, params, "Failed to get node tags");
            return Tag.parseTags(nodeId, response.getJsonResponse());
        }

        public void removeNodeTag(String nodeId, String tagId) throws PublicApiException {
            this.remove("nodes", nodeId, "tags", tagId, "Failed to remove node tag");
        }

        public Tag createNodeTag(String nodeId, Tag tag) throws PublicApiException {
            HttpResponse response = this.create("nodes", nodeId, "tags", null, tag.toJSON().toString(), "Failed to create node tag");
            Tag tagRet = Tag.parseTag(nodeId, (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return tagRet;
        }

        public NodeRating getNodeRating(String nodeId, String ratingId) throws PublicApiException {
            HttpResponse response = this.getSingle("nodes", nodeId, "ratings", ratingId, "Failed to get node ratings");
            return NodeRating.parseNodeRating(nodeId, (JSONObject)response.getJsonResponse().get((Object)"entry"));
        }

        public ListResponse<NodeRating> getNodeRatings(String nodeId, Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("nodes", nodeId, "ratings", null, params, "Failed to get node ratings");
            return NodeRating.parseNodeRatings(nodeId, response.getJsonResponse());
        }

        public NodeRating updateNodeRating(String nodeId, NodeRating nodeRating) throws PublicApiException {
            HttpResponse response = this.update("nodes", nodeId, "ratings", nodeRating.getId(), nodeRating.toJSON().toString(), "Failed to update node rating");
            NodeRating nodeRatingRet = NodeRating.parseNodeRating(nodeId, (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return nodeRatingRet;
        }

        public NodeRating createNodeRating(String nodeId, NodeRating nodeRating) throws PublicApiException {
            HttpResponse response = this.create("nodes", nodeId, "ratings", null, nodeRating.toJSON().toString(), "Failed to create node rating");
            NodeRating nodeRatingRet = NodeRating.parseNodeRating(nodeId, (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return nodeRatingRet;
        }

        public void removeNodeRating(String nodeId, NodeRating rating) throws PublicApiException {
            this.remove("nodes", nodeId, "ratings", rating.getId(), "Failed to remove node rating");
        }
    }

    public class Tags
    extends AbstractProxy {
        public ListResponse<Tag> getTags(Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("tags", null, null, null, params, "Failed to get tags");
            return Tag.parseTags(null, response.getJsonResponse());
        }

        public Tag getSingle(String tagId) throws PublicApiException {
            HttpResponse response = this.getSingle("tags", tagId, null, null, "Failed to get tag");
            Tag tag = Tag.parseTag(null, (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return tag;
        }

        public Tag update(Tag tag) throws PublicApiException {
            HttpResponse response = this.update("tags", tag.getId(), null, null, tag.toJSON().toString(), "Failed to update tag");
            Tag retTag = Tag.parseTag(null, (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retTag;
        }

        public void remove(Tag tag) throws PublicApiException {
            this.remove("tags", tag.getId(), null, null, "Failed to remove tag");
        }
    }

    public class Comments
    extends AbstractProxy {
        public ListResponse<Comment> getTenantComments(Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("comments", null, null, null, params, "Failed to get comments");
            return Comment.parseComments(null, response.getJsonResponse());
        }

        public Comment getTenantComment(String commentId) throws PublicApiException {
            HttpResponse response = this.getSingle("comments", commentId, null, null, "Failed to get comment");
            Comment comment = Comment.parseComment(null, (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return comment;
        }

        public Comment updateTenantComment(Comment comment) throws PublicApiException {
            HttpResponse response = this.update("comments", comment.getId(), null, null, comment.toJSON(true).toString(), "Failed to update comment");
            Comment retComment = Comment.parseComment(null, (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retComment;
        }

        public Comment createTenantComment(Comment comment) throws PublicApiException {
            HttpResponse response = this.create("comments", null, null, null, comment.toJSON(true).toString(), "Failed to create comment");
            Comment retComment = Comment.parseComment(null, (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retComment;
        }

        public void removeTenantComment(Comment comment) throws PublicApiException {
            this.remove("comments", comment.getId(), null, null, "Failed to remove comment");
        }

        public ListResponse<Comment> getNodeComments(String nodeId, Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("nodes", nodeId, "comments", null, params, "Failed to get comments");
            return Comment.parseComments(nodeId, response.getJsonResponse());
        }

        public Comment getNodeComment(String nodeId) throws PublicApiException {
            HttpResponse response = this.getSingle("nodes", nodeId, null, null, "Failed to get comment");
            Comment comment = Comment.parseComment(nodeId, (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return comment;
        }

        public Comment updateNodeComment(String nodeId, String commentId, Comment comment) throws PublicApiException {
            HttpResponse response = this.update("nodes", nodeId, "comments", commentId, comment.toJSON(true).toString(), "Failed to update comment");
            Comment retComment = Comment.parseComment(nodeId, (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retComment;
        }

        public Comment createNodeComment(String nodeId, Comment comment) throws PublicApiException {
            HttpResponse response = this.create("nodes", nodeId, "comments", null, comment.toJSON(true).toString(), "Failed to create comment");
            Comment retComment = Comment.parseComment(nodeId, (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retComment;
        }

        public void removeNodeComment(String nodeId, String commentId) throws PublicApiException {
            this.remove("nodes", nodeId, "comments", commentId, "Failed to remove comment");
        }
    }

    public class People
    extends AbstractProxy {
        public ListResponse<Person> getPeople(Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("people", null, null, null, params, "Failed to get people");
            return Person.parsePeople(response.getJsonResponse());
        }

        public Person getPerson(String personId) throws PublicApiException {
            return this.getPerson(personId, 200);
        }

        public Person getPerson(String personId, int expectedStatus) throws PublicApiException {
            JSONObject entry;
            HttpResponse response = this.getSingle("people", personId, null, null, "Failed to get person", expectedStatus);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)response);
            }
            System.out.println(response);
            if (response != null && response.getJsonResponse() != null && (entry = (JSONObject)response.getJsonResponse().get((Object)"entry")) != null) {
                return Person.parsePerson(entry);
            }
            return null;
        }

        public Person update(String personId, Person person) throws PublicApiException {
            return this.update(personId, person, 200);
        }

        public Person update(String personId, Person person, int expectedStatus) throws PublicApiException {
            return this.update(personId, person.toJSON(true).toString(), expectedStatus);
        }

        public Person update(String personId, String json, int expectedStatus) throws PublicApiException {
            return this.update(personId, json, null, expectedStatus);
        }

        public Person update(String personId, String json, Map<String, String> params, int expectedStatus) throws PublicApiException {
            JSONObject entry;
            HttpResponse response = this.update("people", personId, null, null, json, params, "Failed to update person", expectedStatus);
            if (response != null && response.getJsonResponse() != null && (entry = (JSONObject)response.getJsonResponse().get((Object)"entry")) != null) {
                return Person.parsePerson(entry);
            }
            return null;
        }

        public Person create(Person person) throws PublicApiException {
            return this.create(person, 201);
        }

        public Person create(Person person, int expectedStatus) throws PublicApiException {
            JSONObject entry;
            TestPeople.PersonJSONSerializer jsonizer = new TestPeople.PersonJSONSerializer(person);
            HttpResponse response = this.create("people", null, null, null, jsonizer.toJSON().toString(), "Failed to create person", expectedStatus);
            if (response != null && response.getJsonResponse() != null && (entry = (JSONObject)response.getJsonResponse().get((Object)"entry")) != null) {
                return Person.parsePerson(entry);
            }
            return null;
        }

        public void remove(Person person) throws PublicApiException {
            this.remove("people", person.getId(), null, null, "Failed to remove person");
        }

        public ListResponse<Preference> getPreferences(String personId, Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("people", personId, "preferences", null, params, "Failed to get person preferences");
            return Preference.parsePreferences(response.getJsonResponse());
        }

        public Preference getPreference(String personId, String preferenceId) throws PublicApiException {
            HttpResponse response = this.getSingle("people", personId, "preferences", preferenceId, "Failed to get person preference");
            Preference pref = Preference.parsePreference((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return pref;
        }

        public Person updatePreference(String personId, Preference preference) throws PublicApiException {
            HttpResponse response = this.update("people", personId, "preferences", preference.getId(), preference.toJSON().toString(), "Failed to update person preference");
            Person retSite = Person.parsePerson((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retSite;
        }

        public Person createPreference(String personId, Preference preference) throws PublicApiException {
            HttpResponse response = this.create("people", personId, "preferences", null, preference.toJSON().toString(), "Failed to create person preference");
            Person retSite = Person.parsePerson((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retSite;
        }

        public void removePreference(String personId, Preference preference) throws PublicApiException {
            this.remove("people", personId, "preferences", preference.getId(), "Failed to remove person preference");
        }

        public ListResponse<PersonNetwork> getNetworkMemberships(String personId, Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("people", personId, "networks", null, params, "Failed to get network members");
            return PersonNetwork.parseNetworkMembers(response.getJsonResponse());
        }

        public PersonNetwork getNetworkMembership(String personId, String networkId) throws PublicApiException {
            HttpResponse response = this.getSingle("people", personId, "networks", networkId, "Failed to get network member");
            PersonNetwork networkMember = PersonNetwork.parseNetworkMember((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return networkMember;
        }

        public PersonNetwork updateNetworkMembership(String personId, PersonNetwork networkMember) throws PublicApiException {
            HttpResponse response = this.update("people", personId, "networks", networkMember.getId(), networkMember.toJSON().toString(), "Failed to update network member");
            PersonNetwork retNetwork = PersonNetwork.parseNetworkMember((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retNetwork;
        }

        public PersonNetwork createNetworkMembership(String personId, PersonNetwork network) throws PublicApiException {
            HttpResponse response = this.create("people", personId, "networks", null, network.toJSON().toString(), "Failed to create network member");
            PersonNetwork retNetwork = PersonNetwork.parseNetworkMember((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retNetwork;
        }

        public void removeNetworkMembership(String personId, PersonNetwork networkMember) throws PublicApiException {
            this.remove("people", personId, "networks", networkMember.getId(), "Failed to remove network member");
        }

        public ListResponse<Activity> getActivities(String personId, Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("people", personId, "activities", null, params, "Failed to get activities");
            return Activities.parseActivities(response.getJsonResponse());
        }

        public Activity getSingleActivity(String personId, String activityId) throws PublicApiException {
            HttpResponse response = this.getSingle("people", personId, "activities", activityId, "Failed to get activities");
            Activity activity = Activity.parseActivity((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return activity;
        }

        public Activity update(String personId, Activity activity) throws PublicApiException {
            HttpResponse response = this.update("people", personId, "activities", String.valueOf(activity.getId()), activity.toJSON().toString(), "Failed to update activity");
            Activity retActivity = Activity.parseActivity((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retActivity;
        }

        public Activity create(String personId, Activity activity) throws PublicApiException {
            HttpResponse response = this.create("people", personId, "activities", String.valueOf(activity.getId()), activity.toJSON().toString(), "Failed to create activity");
            Activity retActivity = Activity.parseActivity((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retActivity;
        }

        public void remove(String personId, Activity activity) throws PublicApiException {
            this.remove("people", personId, "activities", String.valueOf(activity.getId()), "Failed to remove activity");
        }

        public HttpResponse getAvatar(String personId, boolean placeholder, int expectedStatus) throws PublicApiException, InterruptedException {
            return this.getAvatar(personId, null, placeholder, null, expectedStatus);
        }

        public HttpResponse getAvatar(String personId, String ifModifiedSince, int expectedStatus) throws PublicApiException, InterruptedException {
            return this.getAvatar(personId, null, false, ifModifiedSince, expectedStatus);
        }

        public HttpResponse getAvatar(String personId, Boolean attachment, boolean placeholder, String ifModifiedSince, int expectedStatus) throws PublicApiException, InterruptedException {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("placeholder", Boolean.toString(placeholder));
            if (attachment != null) {
                params.put("attachment", attachment.toString());
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            if (ifModifiedSince != null) {
                headers.put("If-Modified-Since", ifModifiedSince);
            }
            HttpResponse response = this.getSingleWithDelayRetry("people", personId, "avatar", null, params, headers, "Failed to get avatar", 40, 2500L, expectedStatus);
            this.checkStatus("Unexpected response", expectedStatus, response);
            return response;
        }

        private HttpResponse getSingleWithDelayRetry(String entityCollectionName, String entityId, String relationCollectionName, String relationId, Map<String, String> params, Map<String, String> headers, String errorMessage, int repeat, long pauseInMillisecond, int expectedStatus) throws PublicApiException, InterruptedException {
            for (int retryCount = 0; retryCount < repeat; ++retryCount) {
                try {
                    return this.getSingle(entityCollectionName, entityId, relationCollectionName, relationId, params, headers, errorMessage, expectedStatus);
                }
                catch (PublicApiException ex) {
                    Thread.sleep(pauseInMillisecond);
                    continue;
                }
            }
            return null;
        }

        public HttpResponse updateAvatar(String personId, File avatar, int expectedStatus) throws PublicApiException {
            try {
                HashMap<String, String> params = new HashMap<String, String>();
                PublicApiHttpClient.BinaryPayload payload = new PublicApiHttpClient.BinaryPayload(avatar);
                HttpResponse response = PublicApiClient.this.client.putBinary(PublicApiClient.this.getRequestContext(), "public", 1, "people", personId, "avatar", null, payload, params);
                this.checkStatus("Unexpected status", expectedStatus, response);
                return response;
            }
            catch (IOException e) {
                throw new PublicApiException(e);
            }
        }

        public void deleteAvatarImage(String personId, int expectedStatus) throws PublicApiException {
            this.remove("people", personId, "avatar", null, null, "Failed to remove avatar image", expectedStatus);
        }
    }

    public class Favourites
    extends AbstractProxy {
        public ListResponse<Favourite> getFavourites(String personId, Map<String, String> params) throws PublicApiException, ParseException {
            HttpResponse response = this.getAll("people", personId, "favorites", null, params, "Failed to get favourites");
            return Favourite.parseFavourites(response.getJsonResponse());
        }

        public Favourite getFavourite(String personId, String favouriteId) throws PublicApiException, ParseException {
            HttpResponse response = this.getSingle("people", personId, "favorites", favouriteId, "Failed to get favourite " + favouriteId);
            return Favourite.parseFavourite((JSONObject)response.getJsonResponse().get((Object)"entry"));
        }

        public Favourite getFavourite(String personId, String favouriteId, Map<String, String> params) throws PublicApiException, ParseException {
            HttpResponse response = this.getSingle("people", personId, "favorites", favouriteId, params, "Failed to get favourite " + favouriteId, 200);
            return Favourite.parseFavourite((JSONObject)response.getJsonResponse().get((Object)"entry"));
        }

        public Favourite createFavourite(String personId, Favourite favourite) throws PublicApiException, ParseException {
            HttpResponse response = this.create("people", personId, "favorites", null, favourite.toJSON().toString(), "Failed to create favourite");
            Favourite ret = Favourite.parseFavourite((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return ret;
        }

        public Favourite createFavourite(String personId, Favourite favourite, Map<String, String> params) throws PublicApiException, ParseException {
            HttpResponse response = this.create("people", personId, "favorites", null, favourite.toJSON().toString(), "Failed to create favourite", 201, params);
            Favourite ret = Favourite.parseFavourite((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return ret;
        }

        public void removeFavourite(String personId, String favouriteId) throws PublicApiException {
            this.remove("people", personId, "favorites", favouriteId, "Failed to remove favourite");
        }
    }

    public class RawProxy
    extends AbstractProxy {
    }

    public class SiteMembershipRequests
    extends AbstractProxy {
        public SiteMembershipRequest getSiteMembershipRequest(String personId, String siteId) throws PublicApiException, ParseException {
            HttpResponse response = this.getSingle("people", personId, "site-membership-requests", siteId, "Failed to get siteMembershipRequest");
            return SiteMembershipRequest.parseSiteMembershipRequest((JSONObject)response.getJsonResponse().get((Object)"entry"));
        }

        public ListResponse<SiteMembershipRequest> getSiteMembershipRequests(String personId, Map<String, String> params) throws PublicApiException, ParseException {
            HttpResponse response = this.getAll("people", personId, "site-membership-requests", null, params, "Failed to get siteMembershipRequests");
            return SiteMembershipRequest.parseSiteMembershipRequests(response.getJsonResponse());
        }

        public SiteMembershipRequest createSiteMembershipRequest(String personId, SiteMembershipRequest siteMembershipRequest) throws PublicApiException, ParseException {
            HttpResponse response = this.create("people", personId, "site-membership-requests", null, siteMembershipRequest.toJSON().toString(), "Failed to create siteMembershipRequest");
            SiteMembershipRequest ret = SiteMembershipRequest.parseSiteMembershipRequest((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return ret;
        }

        public SiteMembershipRequest updateSiteMembershipRequest(String personId, SiteMembershipRequest siteMembershipRequest) throws PublicApiException, ParseException {
            HttpResponse response = this.update("people", personId, "site-membership-requests", siteMembershipRequest.getId(), siteMembershipRequest.toJSON().toString(), "Failed to update siteMembershipRequest");
            SiteMembershipRequest ret = SiteMembershipRequest.parseSiteMembershipRequest((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return ret;
        }

        public void cancelSiteMembershipRequest(String personId, String siteMembershipRequestId) throws PublicApiException {
            this.remove("people", personId, "site-membership-requests", siteMembershipRequestId, "Failed to cancel siteMembershipRequest");
        }

        public ListResponse<SiteMembershipRequest> getSiteMembershipRequests(Map<String, String> params, String errorMessage, int expectedStatus) throws PublicApiException, ParseException {
            JSONObject jsonList;
            HttpResponse response = this.getAll("site-membership-requests", null, null, null, params, errorMessage, expectedStatus);
            if (response != null && response.getJsonResponse() != null && (jsonList = (JSONObject)response.getJsonResponse().get((Object)"list")) != null) {
                return SiteMembershipRequest.parseSiteMembershipRequests(response.getJsonResponse());
            }
            return null;
        }
    }

    public class Sites
    extends AbstractProxy {
        public ListResponse<Site> getSites(Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("sites", null, null, null, params, "Failed to get sites");
            return SiteImpl.parseSites(response.getJsonResponse());
        }

        public Site getSite(String siteId) throws PublicApiException {
            return this.getSite(siteId, 200);
        }

        public Site getSite(String siteId, int expectedStatus) throws PublicApiException {
            HttpResponse response = this.getSingle("sites", siteId, null, null, "Failed to get site " + siteId, expectedStatus);
            if (response != null && response.getJsonResponse() != null) {
                return SiteImpl.parseSite((JSONObject)response.getJsonResponse().get((Object)"entry"));
            }
            return null;
        }

        public Site createSite(Site site) throws PublicApiException {
            return this.createSite(site, 201);
        }

        public Site createSite(Site site, int expectedStatus) throws PublicApiException {
            HttpResponse response = this.create("sites", null, null, null, site.toJSON().toString(), "Failed to create site " + site.getTitle(), expectedStatus);
            return SiteImpl.parseSite((JSONObject)response.getJsonResponse().get((Object)"entry"));
        }

        public void removeSite(String siteId) throws PublicApiException {
            this.removeSite(siteId, false, 204);
        }

        public void removeSite(String siteId, boolean permanent, int expectedStatus) throws PublicApiException {
            Map<String, String> params = null;
            if (permanent) {
                params = Collections.singletonMap("permanent", "true");
            }
            this.remove("sites", siteId, null, null, params, "Failed to remove site", expectedStatus);
        }

        public Site updateSite(String siteId, SiteUpdate update, int expectedStatus) throws PublicApiException {
            TestSites.SiteUpdateJSONSerializer jsonizer = new TestSites.SiteUpdateJSONSerializer(update);
            HttpResponse response = this.update("sites", siteId, null, null, jsonizer.toJSON().toString(), null, "Failed to update site " + update.getTitle(), expectedStatus);
            if (response.getJsonResponse() != null) {
                return SiteImpl.parseSite((JSONObject)response.getJsonResponse().get((Object)"entry"));
            }
            return null;
        }

        public ListResponse<SiteContainer> getSiteContainers(String siteId, Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("sites", siteId, "containers", null, params, "Failed to get site containers");
            return SiteContainer.parseSiteContainers(response.getJsonResponse());
        }

        public SiteContainer getSingleSiteContainer(String siteId, String containerId) throws PublicApiException {
            HttpResponse response = this.getSingle("sites", siteId, "containers", containerId, "Failed to get site container");
            SiteContainer siteContainer = SiteContainer.parseSiteContainer(siteId, (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return siteContainer;
        }

        public SiteContainer updateSiteContainer(SiteContainer siteContainer) throws PublicApiException {
            HttpResponse response = this.update("sites", siteContainer.getSiteId(), "containers", siteContainer.getId(), siteContainer.toJSON().toString(), "Failed to update site container");
            SiteContainer retSiteContainer = SiteContainer.parseSiteContainer(siteContainer.getSiteId(), (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retSiteContainer;
        }

        public SiteContainer createSiteContainer(SiteContainer siteContainer) throws PublicApiException {
            HttpResponse response = this.create("sites", siteContainer.getSiteId(), "containers", null, siteContainer.toJSON().toString(), "Failed to create site container");
            SiteContainer retSiteContainer = SiteContainer.parseSiteContainer(siteContainer.getSiteId(), (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retSiteContainer;
        }

        public void removeSiteContainer(SiteContainer siteContainer) throws PublicApiException {
            this.remove("sites", siteContainer.getSiteId(), "containers", siteContainer.getId(), "Failed to remove site container");
        }

        public ListResponse<SiteMember> getSiteMembers(String siteId, Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("sites", siteId, "members", null, params, "Failed to get all site members");
            return SiteMember.parseSiteMembers(siteId, response.getJsonResponse());
        }

        public SiteMember getSingleSiteMember(String siteId, String personId) throws PublicApiException {
            HttpResponse response = this.getSingle("sites", siteId, "members", personId, "Failed to get site member");
            SiteMember retSiteMember = SiteMember.parseSiteMember(siteId, (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retSiteMember;
        }

        public SiteMember updateSiteMember(String siteId, SiteMember siteMember) throws PublicApiException {
            HttpResponse response = this.update("sites", siteId, "members", siteMember.getMemberId(), siteMember.toJSON().toString(), "Failed to update site member");
            SiteMember retSiteMember = SiteMember.parseSiteMember(siteMember.getSiteId(), (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retSiteMember;
        }

        public SiteMember createSiteMember(String siteId, SiteMember siteMember) throws PublicApiException {
            HttpResponse response = this.create("sites", siteId, "members", null, siteMember.toJSON().toString(), "Failed to create site member");
            SiteMember retSiteMember = SiteMember.parseSiteMember(siteMember.getSiteId(), (JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retSiteMember;
        }

        public void removeSiteMember(String siteId, SiteMember siteMember) throws PublicApiException {
            this.remove("sites", siteId, "members", siteMember.getMemberId(), "Failed to remove site member");
        }

        public ListResponse<MemberOfSite> getPersonSites(String personId, Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("people", personId, "sites", null, params, "Failed to get person sites");
            return MemberOfSite.parseMemberOfSites(response.getJsonResponse());
        }

        public MemberOfSite getPersonSite(String personId, String siteId) throws PublicApiException {
            HttpResponse response = this.getSingle("people", personId, "sites", siteId, "Failed to get person site" + siteId);
            return MemberOfSite.parseMemberOfSite((JSONObject)response.getJsonResponse().get((Object)"entry"));
        }

        public MemberOfSite updatePersonSite(String personId, SiteMember siteMember) throws PublicApiException {
            HttpResponse response = this.update("people", personId, "sites", siteMember.getSiteId(), siteMember.toJSON().toString(), "Failed to update person site");
            MemberOfSite retSiteMember = MemberOfSite.parseMemberOfSite((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retSiteMember;
        }

        public MemberOfSite createPersonSite(String personId, SiteMember siteMember) throws PublicApiException {
            HttpResponse response = this.create("people", personId, "sites", null, siteMember.toJSON().toString(), "Failed to create person site");
            MemberOfSite retSiteMember = MemberOfSite.parseMemberOfSite((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return retSiteMember;
        }

        public void removePersonSite(String personId, SiteMember siteMember) throws PublicApiException {
            this.remove("people", personId, "sites", siteMember.getSiteId(), "Failed to remove person site");
        }

        public ListResponse<FavouriteSite> getFavouriteSites(String personId, Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("people", personId, "favorite-sites", null, params, "Failed to get favourite sites");
            return FavouriteSite.parseFavouriteSites(response.getJsonResponse());
        }

        public FavouriteSite getSingleFavouriteSite(String personId, String siteId) throws PublicApiException {
            HttpResponse response = this.getSingle("people", personId, "favorite-sites", siteId, "Failed to get favourite site");
            FavouriteSite favouriteSite = FavouriteSite.parseFavouriteSite((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return favouriteSite;
        }

        public FavouriteSite updateFavouriteSite(String personId, FavouriteSite site) throws PublicApiException {
            HttpResponse response = this.update("people", personId, "favorite-sites", site.getSiteId(), site.toJSON().toString(), "Failed to update favourite site");
            FavouriteSite favouriteSite = FavouriteSite.parseFavouriteSite((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return favouriteSite;
        }

        public FavouriteSite createFavouriteSite(String personId, FavouriteSite site) throws PublicApiException {
            HttpResponse response = this.create("people", personId, "favorite-sites", null, site.toJSON().toString(), "Failed to create favourite site");
            FavouriteSite favouriteSite = FavouriteSite.parseFavouriteSite((JSONObject)response.getJsonResponse().get((Object)"entry"));
            return favouriteSite;
        }

        public void removeFavouriteSite(String personId, FavouriteSite site) throws PublicApiException {
            this.remove("people", personId, "favorite-sites", site.getSiteId(), "Failed to remove favourite site");
        }

        public SiteGroup addGroup(String siteId, SiteGroup group) throws PublicApiException {
            HttpResponse response = this.create("sites", siteId, "group-members", null, group.toJSON().toString(), "Failed to add site groups");
            return SiteGroup.parseSiteGroup(siteId, (JSONObject)response.getJsonResponse().get((Object)"entry"));
        }

        public ListResponse<SiteGroup> getGroups(String siteId, Map<String, String> params) throws PublicApiException {
            HttpResponse response = this.getAll("sites", siteId, "group-members", null, params, "Failed to fetch all site groups");
            return SiteGroup.parseGroupMemberOfSites(siteId, response.getJsonResponse());
        }

        public SiteGroup getGroup(String siteId, String groupId) throws PublicApiException {
            HttpResponse response = this.getSingle("sites", siteId, "group-members", groupId.toString(), "Failed to get a site group");
            return SiteGroup.parseSiteGroup(siteId, (JSONObject)response.getJsonResponse().get((Object)"entry"));
        }

        public SiteGroup updateGroup(String siteId, SiteGroup group) throws PublicApiException {
            HttpResponse response = this.update("sites", siteId, "group-members", group.getId(), group.toJSON().toString(), "Failed to update a site group");
            return SiteGroup.parseSiteGroup(siteId, (JSONObject)response.getJsonResponse().get((Object)"entry"));
        }

        public void deleteGroup(String siteId, String groupId) throws PublicApiException {
            this.remove("sites", siteId, "group-members", groupId, "Failed to delete site group");
        }
    }

    public static class ListResponse<T> {
        private ExpectedPaging paging;
        private List<T> list;

        public ListResponse(ExpectedPaging paging, List<T> list) {
            this.paging = paging;
            this.list = list;
        }

        public ExpectedPaging getPaging() {
            return this.paging;
        }

        public List<T> getList() {
            return this.list;
        }
    }

    public class AbstractProxy {
        public HttpResponse getAll(String entityCollectionName, String entityId, String relationCollectionName, String relationId, Map<String, String> params, String errorMessage) throws PublicApiException {
            return this.getAll(entityCollectionName, entityId, relationCollectionName, relationId, params, errorMessage, 200);
        }

        public HttpResponse getAll(String entityCollectionName, String entityId, String relationCollectionName, String relationId, Map<String, String> params, String errorMessage, int expectedStatus) throws PublicApiException {
            try {
                HttpResponse response = PublicApiClient.this.get("public", entityCollectionName, entityId, relationCollectionName, relationId, params);
                this.checkStatus(errorMessage, expectedStatus, response);
                return response;
            }
            catch (IOException e) {
                throw new PublicApiException(e);
            }
        }

        public HttpResponse getSingle(String entityCollectionName, String entityId, String relationCollectionName, String relationId, String errorMessage) throws PublicApiException {
            return this.getSingle(entityCollectionName, entityId, relationCollectionName, relationId, errorMessage, 200);
        }

        public HttpResponse getSingle(String entityCollectionName, String entityId, String relationCollectionName, String relationId, String errorMessage, int expectedStatus) throws PublicApiException {
            try {
                HttpResponse response = PublicApiClient.this.get("public", entityCollectionName, entityId, relationCollectionName, relationId, null);
                this.checkStatus(errorMessage, expectedStatus, response);
                return response;
            }
            catch (IOException e) {
                throw new PublicApiException(e);
            }
        }

        public HttpResponse getSingle(String entityCollectionName, String entityId, String relationCollectionName, String relationId, Map<String, String> params, Map<String, String> headers, String errorMessage, int expectedStatus) throws PublicApiException {
            try {
                HttpResponse response = PublicApiClient.this.get("public", entityCollectionName, entityId, relationCollectionName, relationId, params, headers);
                this.checkStatus(errorMessage, expectedStatus, response);
                return response;
            }
            catch (IOException e) {
                throw new PublicApiException(e);
            }
        }

        public HttpResponse getSingle(String entityCollectionName, String entityId, String relationCollectionName, String relationId, Map<String, String> params, String errorMessage, int expectedStatus) throws PublicApiException {
            try {
                HttpResponse response = PublicApiClient.this.get("public", entityCollectionName, entityId, relationCollectionName, relationId, params);
                this.checkStatus(errorMessage, expectedStatus, response);
                return response;
            }
            catch (IOException e) {
                throw new PublicApiException(e);
            }
        }

        public HttpResponse update(String entityCollectionName, String entityId, String relationCollectionName, String relationId, String body, String errorMessage) throws PublicApiException {
            return this.update(entityCollectionName, entityId, relationCollectionName, relationId, body, null, errorMessage, 200);
        }

        public HttpResponse update(String entityCollectionName, String entityId, String relationCollectionName, String relationId, String body, Map<String, String> params, String errorMessage, int expectedStatus) throws PublicApiException {
            try {
                HttpResponse response = PublicApiClient.this.put("public", entityCollectionName, entityId, relationCollectionName, relationId, body, params);
                this.checkStatus(errorMessage, expectedStatus, response);
                return response;
            }
            catch (IOException e) {
                throw new PublicApiException(e);
            }
        }

        public HttpResponse create(String entityCollectionName, String entityId, String relationCollectionName, String relationId, String body, String errorMessage) throws PublicApiException {
            return this.create(entityCollectionName, entityId, relationCollectionName, relationId, body, errorMessage, 201);
        }

        public HttpResponse create(String entityCollectionName, String entityId, String relationCollectionName, String relationId, String body, String errorMessage, int expectedStatus) throws PublicApiException {
            return this.create(entityCollectionName, entityId, relationCollectionName, relationId, body, errorMessage, expectedStatus, null);
        }

        public HttpResponse create(String entityCollectionName, String entityId, String relationCollectionName, String relationId, String body, String errorMessage, int expectedStatus, Map<String, String> params) throws PublicApiException {
            try {
                HttpResponse response = PublicApiClient.this.post("public", entityCollectionName, (Object)entityId, relationCollectionName, (Object)relationId, body, params);
                this.checkStatus(errorMessage, expectedStatus, response);
                return response;
            }
            catch (IOException e) {
                throw new PublicApiException(e);
            }
        }

        public HttpResponse remove(String entityCollectionName, String entityId, String relationCollectionName, String relationId, String errorMessage) throws PublicApiException {
            return this.remove(entityCollectionName, entityId, relationCollectionName, relationId, null, errorMessage, 204);
        }

        public HttpResponse remove(String entityCollectionName, String entityId, String relationCollectionName, String relationId, Map<String, String> params, String errorMessage, int expectedStatus) throws PublicApiException {
            try {
                HttpResponse response = PublicApiClient.this.delete("public", 1, entityCollectionName, entityId, relationCollectionName, relationId, params);
                this.checkStatus(errorMessage, expectedStatus, response);
                return response;
            }
            catch (IOException e) {
                throw new PublicApiException(e);
            }
        }

        public JSONObject parseListSource(JSONObject jsonResponse) {
            JSONObject jsonList = (JSONObject)jsonResponse.get((Object)"list");
            Assert.assertNotNull((Object)jsonList);
            JSONObject source = (JSONObject)jsonList.get((Object)"source");
            Assert.assertNotNull((Object)source);
            return source;
        }

        public void checkStatus(String errorMessage, int expectedStatus, HttpResponse response) throws PublicApiException {
            int actualStatus = response.getStatusCode();
            if (expectedStatus > 0 && expectedStatus != actualStatus) {
                String msg = "Status code " + actualStatus + " returned, but expected " + expectedStatus + ": \n" + errorMessage + ": \n   Response: " + response;
                throw new PublicApiException(msg, response);
            }
            if (expectedStatus >= 400 && expectedStatus != 401) {
                this.checkErrorKeyResponse(errorMessage, expectedStatus, response);
            }
        }

        public void checkErrorKeyResponse(String errorMessage, int expectedStatus, HttpResponse response) throws PublicApiException {
            ExpectedErrorResponse error;
            try {
                error = RestApiUtil.parseErrorResponse(response.getJsonResponse());
            }
            catch (Exception e) {
                throw new PublicApiException(e.getMessage(), response);
            }
            String errorKey = error.errorKey;
            if (errorKey != null && errorKey.contains("exception")) {
                boolean validErrorKey = false;
                List httpErrorsFilteredByStatusCode = Arrays.asList(RestErrorResponseDefault.values()).stream().filter(t -> t.getStatusCode() == expectedStatus && t.getDefaultMessage() != null).collect(Collectors.toList());
                httpErrorsFilteredByStatusCode.add(RestErrorResponseDefault.DEFAULT_API_EXCEPTION);
                for (RestErrorResponseDefault errorResponseDefault : httpErrorsFilteredByStatusCode) {
                    if (!errorResponseDefault.getDefaultMessage().equals(errorKey)) continue;
                    validErrorKey = true;
                }
                if (!validErrorKey) {
                    String msg = "Error key " + errorKey + " returned is not valid \n" + errorMessage + ": \n   Response: " + response;
                    throw new PublicApiException(msg, response);
                }
            }
        }
    }
}

