/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.mail.internet.MimeMessage;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentLimitProvider;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.ResetPasswordServiceImpl;
import org.alfresco.repo.security.authentication.ResetPasswordServiceImplTest;
import org.alfresco.rest.api.Renditions;
import org.alfresco.rest.api.model.Client;
import org.alfresco.rest.api.model.LoginTicket;
import org.alfresco.rest.api.model.LoginTicketResponse;
import org.alfresco.rest.api.model.PasswordReset;
import org.alfresco.rest.api.model.Rendition;
import org.alfresco.rest.api.tests.AbstractBaseApiTest;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.Pair;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.Company;
import org.alfresco.rest.api.tests.client.data.ExpectedComparison;
import org.alfresco.rest.api.tests.client.data.JSONAble;
import org.alfresco.rest.api.tests.client.data.Person;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.preference.PreferenceService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.GUID;
import org.alfresco.util.email.EmailUtil;
import org.json.simple.JSONObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.core.io.ClassPathResource;

public class TestPeople
extends AbstractBaseApiTest {
    private static final String URL_PEOPLE = "people";
    private static final QName ASPECT_COMMS = QName.createQName((String)"test.people.api", (String)"comms");
    private static final QName PROP_TELEHASH = QName.createQName((String)"test.people.api", (String)"telehash");
    private static final QName ASPECT_LUNCHABLE = QName.createQName((String)"test.people.api", (String)"lunchable");
    private static final QName PROP_LUNCH = QName.createQName((String)"test.people.api", (String)"lunch");
    private static final QName PROP_LUNCH_COMMENTS = QName.createQName((String)"test.people.api", (String)"lunchcomments");
    private PublicApiClient.People people;
    private Iterator<RepoService.TestNetwork> accountsIt;
    private RepoService.TestNetwork account1;
    private RepoService.TestNetwork account2;
    private static RepoService.TestNetwork account3;
    private static RepoService.TestNetwork account4;
    private Iterator<String> account1PersonIt;
    private Iterator<String> account2PersonIt;
    private String account1Admin;
    private String account2Admin;
    private String account3Admin;
    private static String account4Admin;
    private static Person personAliceSmith;
    private static Person personAliceDavis;
    private static Person personBenCarson;
    private Person personBob;
    private NodeService nodeService;
    private PersonService personService;

    @Before
    public void setUp() throws Exception {
        this.people = this.publicApiClient.people();
        this.accountsIt = this.getTestFixture().getNetworksIt();
        this.account1 = this.accountsIt.next();
        this.account2 = this.accountsIt.next();
        if (account3 == null) {
            account3 = this.createNetwork("account3");
        }
        if (account4 == null) {
            account4 = this.createNetwork("account4");
            account4Admin = "admin@" + account4.getId();
            this.publicApiClient.setRequestContext(new RequestContext(account4.getId(), account4Admin, "admin"));
            personAliceSmith = new Person();
            personAliceSmith.setUserName("alice@" + account4.getId());
            personAliceSmith.setId("alice@" + account4.getId());
            personAliceSmith.setFirstName("Alice");
            personAliceSmith.setLastName("Smith");
            personAliceSmith.setEmail("alison.smith@example.com");
            personAliceSmith.setPassword("password");
            personAliceSmith.setEnabled(true);
            personAliceSmith.setProperties(Collections.singletonMap("papi:lunch", "Magical sandwich"));
            this.people.create(personAliceSmith);
            personAliceDavis = new Person();
            personAliceDavis.setUserName("aliced@" + account4.getId());
            personAliceDavis.setId("aliced@" + account4.getId());
            personAliceDavis.setFirstName("Alice");
            personAliceDavis.setLastName("Davis");
            personAliceDavis.setEmail("alison.davis@example.com");
            personAliceDavis.setPassword("password");
            personAliceDavis.setEnabled(true);
            this.people.create(personAliceDavis);
            personBenCarson = new Person();
            personBenCarson.setUserName("ben@" + account4.getId());
            personBenCarson.setId("ben@" + account4.getId());
            personBenCarson.setFirstName("Ben");
            personBenCarson.setLastName("Carson");
            personBenCarson.setEmail("ben.smythe@example.com");
            personBenCarson.setPassword("password");
            personBenCarson.setEnabled(true);
            this.people.create(personBenCarson);
        }
        this.account1Admin = "admin@" + this.account1.getId();
        this.account2Admin = "admin@" + this.account2.getId();
        this.account3Admin = "admin@" + account3.getId();
        this.account1PersonIt = this.account1.getPersonIds().iterator();
        this.account2PersonIt = this.account2.getPersonIds().iterator();
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService", NodeService.class);
        this.personService = (PersonService)this.applicationContext.getBean("PersonService", PersonService.class);
        AuthenticationUtil.pushAuthentication();
    }

    @Override
    @After
    public void tearDown() {
        try {
            AuthenticationUtil.popAuthentication();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    private RepoService.TestNetwork createNetwork(String networkPrefix) {
        RepoService.TestNetwork network = this.getRepoService().createNetwork(networkPrefix + GUID.generate(), true);
        network.create();
        return network;
    }

    @Test
    public void testGetPerson() throws Exception {
        String person1 = this.account1PersonIt.next();
        String person2 = this.account1PersonIt.next();
        String person3 = this.account2PersonIt.next();
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1));
        Person resp = this.people.getPerson(person1);
        RepoService.TestPerson person1Entity = this.repoService.getPerson(person1);
        this.check(person1Entity, resp);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person2));
        resp = this.people.getPerson(person1);
        person1Entity = this.repoService.getPerson(person1);
        Map respCapabilities = resp.getCapabilities();
        Assert.assertNotNull((String)"Check if capabilities are present", (Object)respCapabilities);
        this.check(person1Entity, resp);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1));
        resp = this.people.getPerson("-me-");
        person1Entity = this.repoService.getPerson(person1);
        respCapabilities = resp.getCapabilities();
        Assert.assertNotNull((String)"Check if capabilities are present", (Object)respCapabilities);
        Assert.assertTrue((String)"Check if -me- user is mutable", (boolean)((Boolean)respCapabilities.get("isMutable")));
        this.check(person1Entity, resp);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person3));
        try {
            this.people.getPerson(person1);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        RepoService.TestPerson testP = this.account1.createUser();
        String personId = testP.getId();
        String desc = "<B>Nice person</B>";
        this.account1.addUserDescription(personId, desc);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), personId));
        Person resp2 = this.publicApiClient.people().getPerson(personId);
        Assert.assertEquals((Object)resp2.getId(), (Object)personId);
        Assert.assertEquals((Object)resp2.getDescription(), (Object)desc);
    }

    @Test
    public void testCreatePerson() throws Exception {
        char[] invalidCharacters;
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "admin"));
        Person person = new Person();
        person.setUserName("myUserName00@" + this.account1.getId());
        person.setFirstName("Firstname");
        person.setLastName("Lastname");
        person.setDescription("my description");
        person.setEmail("email@example.com");
        person.setSkypeId("my.skype.id");
        person.setGoogleId("google");
        person.setInstantMessageId("jabber@im.example.com");
        person.setJobTitle("International Man of Mystery");
        person.setLocation("location");
        person.setCompany(new Company("Org", "addr1", "addr2", "addr3", "AB1 1BA", "111 12312123", "222 345345345", "company.email@example.com"));
        person.setMobile("5657 567567 34543");
        person.setTelephone("1234 5678 9012");
        person.setUserStatus("userStatus");
        person.setEnabled(true);
        person.setEmailNotificationsEnabled(true);
        person.setPassword("password");
        Person p = this.people.create(person);
        Assert.assertEquals((Object)("myUserName00@" + this.account1.getId()), (Object)p.getId());
        Assert.assertEquals((Object)"Firstname", (Object)p.getFirstName());
        Assert.assertEquals((Object)"Lastname", (Object)p.getLastName());
        Assert.assertEquals((Object)"Firstname Lastname", (Object)p.getDisplayName());
        Assert.assertEquals((Object)"my description", (Object)p.getDescription());
        Assert.assertEquals((Object)"email@example.com", (Object)p.getEmail());
        Assert.assertEquals((Object)"my.skype.id", (Object)p.getSkypeId());
        Assert.assertEquals((Object)"google", (Object)p.getGoogleId());
        Assert.assertEquals((Object)"jabber@im.example.com", (Object)p.getInstantMessageId());
        Assert.assertEquals((Object)"International Man of Mystery", (Object)p.getJobTitle());
        Assert.assertEquals((Object)"location", (Object)p.getLocation());
        org.alfresco.rest.api.model.Company co = p.getCompany();
        Assert.assertEquals((Object)"Org", (Object)co.getOrganization());
        Assert.assertEquals((Object)"addr1", (Object)co.getAddress1());
        Assert.assertEquals((Object)"addr2", (Object)co.getAddress2());
        Assert.assertEquals((Object)"addr3", (Object)co.getAddress3());
        Assert.assertEquals((Object)"AB1 1BA", (Object)co.getPostcode());
        Assert.assertEquals((Object)"111 12312123", (Object)co.getTelephone());
        Assert.assertEquals((Object)"222 345345345", (Object)co.getFax());
        Assert.assertEquals((Object)"company.email@example.com", (Object)co.getEmail());
        Assert.assertEquals((Object)"5657 567567 34543", (Object)p.getMobile());
        Assert.assertEquals((Object)"1234 5678 9012", (Object)p.getTelephone());
        Assert.assertEquals((Object)"userStatus", (Object)p.getUserStatus());
        Assert.assertEquals((Object)true, (Object)p.isEnabled());
        Assert.assertEquals((Object)true, (Object)p.isEmailNotificationsEnabled());
        person.setUserName("myUserName11111111111111111111111111111111111111111111111111111111111111111111111111111111@" + this.account1.getId());
        this.people.create(person, 400);
        for (char invalidCharacter : invalidCharacters = new char[]{'/', '\\', '\n', '\r', '\"'}) {
            person.setUserName("myUser" + invalidCharacter + "Name@" + this.account1.getId());
            this.people.create(person, 400);
        }
        person.setUserName("GROUP_EVERYONE");
        this.people.create(person, 400);
        person.setUserName("GROUP_mygroup");
        this.people.create(person, 400);
        person.setUserName("ROLE_ANYTHING");
        this.people.create(person, 400);
        person.setUserName("role_whatever");
        this.people.create(person, 400);
    }

    @Test
    public void testCreatePerson_canCreateDisabledPerson() throws PublicApiException {
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "admin"));
        Person person = new Person();
        person.setUserName("myUserName04@" + this.account1.getId());
        person.setFirstName("Firstname");
        person.setEmail("myUserName04@" + this.account1.getId());
        person.setEnabled(false);
        person.setPassword("hello");
        Person p = this.people.create(person);
        Assert.assertEquals((Object)false, (Object)p.isEnabled());
        Assert.assertNull((Object)p.getPassword());
        p = this.people.getPerson(person.getUserName());
        Assert.assertEquals((Object)false, (Object)p.isEnabled());
        Assert.assertNull((Object)p.getPassword());
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person.getUserName(), "hello"));
        try {
            this.people.getPerson(person.getUserName());
            Assert.fail((String)"It should not be possible to use a disabled account.");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "admin"));
        person = new Person();
        person.setUserName("myUserName05@" + this.account1.getId());
        person.setFirstName("Firstname");
        person.setEmail("myUserName05@" + this.account1.getId());
        person.setEnabled(true);
        person.setPassword("banana");
        p = this.people.create(person);
        Assert.assertEquals((Object)true, (Object)p.isEnabled());
        Assert.assertNull((Object)p.getPassword());
        p = this.people.getPerson(person.getUserName());
        Assert.assertEquals((Object)true, (Object)p.isEnabled());
        Assert.assertNull((Object)p.getPassword());
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person.getUserName(), "banana"));
        p = this.people.getPerson(person.getUserName());
        Assert.assertNotNull((Object)p);
        Assert.assertNull((Object)p.getPassword());
    }

    @Test
    public void testCreatePerson_notAllFieldsRequired() throws Exception {
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "admin"));
        Person person = new Person();
        person.setUserName("joe.bloggs@" + this.account1.getId());
        person.setFirstName("Joe");
        person.setLastName("Bloggs");
        person.setEmail("joe.bloggs@example.com");
        person.setSkypeId("jb.skype.id");
        person.setTelephone("1234 5678 9012");
        person.setEnabled(false);
        person.setEmailNotificationsEnabled(false);
        person.setPassword("password123");
        Person p = this.people.create(person);
        Assert.assertEquals((Object)("joe.bloggs@" + this.account1.getId()), (Object)p.getId());
        Assert.assertEquals((Object)"Joe", (Object)p.getFirstName());
        Assert.assertEquals((Object)"Bloggs", (Object)p.getLastName());
        Assert.assertEquals((Object)"Joe Bloggs", (Object)p.getDisplayName());
        Assert.assertEquals(null, (Object)p.getDescription());
        Assert.assertEquals((Object)"joe.bloggs@example.com", (Object)p.getEmail());
        Assert.assertEquals((Object)"jb.skype.id", (Object)p.getSkypeId());
        Assert.assertEquals(null, (Object)p.getGoogleId());
        Assert.assertEquals(null, (Object)p.getInstantMessageId());
        Assert.assertEquals(null, (Object)p.getJobTitle());
        Assert.assertEquals(null, (Object)p.getLocation());
        Assert.assertNotNull((Object)p.getCompany());
        Assert.assertNull((Object)p.getCompany().getOrganization());
        Assert.assertNull((Object)p.getCompany().getAddress1());
        Assert.assertNull((Object)p.getCompany().getAddress2());
        Assert.assertNull((Object)p.getCompany().getAddress3());
        Assert.assertNull((Object)p.getCompany().getPostcode());
        Assert.assertNull((Object)p.getCompany().getFax());
        Assert.assertNull((Object)p.getCompany().getEmail());
        Assert.assertNull((Object)p.getCompany().getTelephone());
        Assert.assertEquals(null, (Object)p.getMobile());
        Assert.assertEquals((Object)"1234 5678 9012", (Object)p.getTelephone());
        Assert.assertEquals(null, (Object)p.getUserStatus());
        Assert.assertEquals((Object)false, (Object)p.isEnabled());
        Assert.assertEquals((Object)false, (Object)p.isEmailNotificationsEnabled());
        person = new Person();
        person.setUserName("joe.bloggs.2@" + this.account1.getId());
        person.setFirstName("Joe");
        person.setEmail("joe.bloggs.2@example.com");
        person.setPassword("password-is-secret");
        p = this.people.create(person);
        Assert.assertEquals((Object)("joe.bloggs.2@" + this.account1.getId()), (Object)p.getId());
        Assert.assertEquals((Object)"Joe", (Object)p.getFirstName());
        Assert.assertEquals(null, (Object)p.getLastName());
        Assert.assertEquals((Object)"Joe", (Object)p.getDisplayName());
        Assert.assertEquals(null, (Object)p.getDescription());
        Assert.assertEquals((Object)"joe.bloggs.2@example.com", (Object)p.getEmail());
        Assert.assertEquals(null, (Object)p.getSkypeId());
        Assert.assertEquals(null, (Object)p.getGoogleId());
        Assert.assertEquals(null, (Object)p.getInstantMessageId());
        Assert.assertEquals(null, (Object)p.getJobTitle());
        Assert.assertEquals(null, (Object)p.getLocation());
        Assert.assertNotNull((Object)p.getCompany());
        Assert.assertNull((Object)p.getCompany().getOrganization());
        Assert.assertNull((Object)p.getCompany().getAddress1());
        Assert.assertNull((Object)p.getCompany().getAddress2());
        Assert.assertNull((Object)p.getCompany().getAddress3());
        Assert.assertNull((Object)p.getCompany().getPostcode());
        Assert.assertNull((Object)p.getCompany().getFax());
        Assert.assertNull((Object)p.getCompany().getEmail());
        Assert.assertNull((Object)p.getCompany().getTelephone());
        Assert.assertEquals(null, (Object)p.getMobile());
        Assert.assertEquals(null, (Object)p.getTelephone());
        Assert.assertEquals(null, (Object)p.getUserStatus());
        Assert.assertEquals((Object)true, (Object)p.isEnabled());
        Assert.assertEquals((Object)true, (Object)p.isEmailNotificationsEnabled());
        person = new Person();
        person.setUserName("joe.bloggs.2@" + this.account1.getId());
        this.people.create(person, 400);
        person.setUserName(null);
        this.people.create(person, 400);
    }

    @Test
    public void testCreatePerson_extraFieldsCauseError() throws Exception {
        String[] illegalFields;
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "admin"));
        String username = "joe.bloggs@" + this.account1.getId();
        for (String badField : illegalFields = new String[]{"\"avatarId\": \"workspace://SpacesStore/\"", "\"statusUpdatedAt\": \"2016-10-25T09:12:58.621Z\"", "\"quota\": \"123\"", "\"quotaUsed\": \"80\""}) {
            String json = "{\n  \"id\": \"" + username + "\",\n  \"firstName\": \"Joe\",\n  \"lastName\": \"Bloggs\",\n" + badField + "}";
            this.people.create(URL_PEOPLE, null, null, null, json, "Illegal field test:" + badField, 400);
        }
    }

    @Test
    public void testCreatePerson_errorResponses() throws Exception {
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), GUID.generate(), "password"));
        Person person = new Person();
        person.setUserName("myUserName01@" + this.account1.getId());
        person.setFirstName("Caroline");
        person.setEmail("caroline.smithson@example.com");
        person.setEnabled(true);
        this.people.create(person, 401);
        String apiUser = this.account2PersonIt.next();
        this.publicApiClient.setRequestContext(new RequestContext(this.account2.getId(), apiUser));
        Person person2 = new Person();
        person2.setUserName("myUserName02@" + this.account2.getId());
        person2.setFirstName("Kieth");
        person2.setEmail("keith.smith@example.com");
        person2.setEnabled(true);
        person2.setPassword("password");
        this.people.create(person2, 403);
        this.publicApiClient.setRequestContext(new RequestContext(this.account2.getId(), this.account2Admin, "admin"));
        this.people.create(person2, 201);
        String username = "myUserName03@" + this.account1.getId();
        String password = "secret";
        Person person3 = new Person();
        person3.setUserName(username);
        person3.setFirstName("Alison");
        person3.setEmail("alison.smythe@example.com");
        person3.setEnabled(true);
        person3.setPassword(password);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "admin"));
        this.people.create(person3);
        this.people.create(person3, 409);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), username, password));
        this.people.create(person3, 403);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "admin"));
        person = new Person();
        String personId = UUID.randomUUID().toString() + "@" + this.account1.getId();
        person.setUserName(personId);
        person.setFirstName("Joe");
        person.setEmail(personId);
        person.setEnabled(true);
        person.setPassword("password123");
        person.setProperties(Collections.singletonMap("usr:enabled", false));
        this.people.create(person, 400);
        person.setProperties(Collections.singletonMap("cm:title", "hello-world"));
        this.people.create(person, 400);
        person.setProperties(Collections.singletonMap("sys:locale", "en_GB"));
        this.people.create(person, 400);
    }

    @Test
    public void testGetPerson_withCustomProps() throws PublicApiException {
        MutableAuthenticationService authService = (MutableAuthenticationService)this.applicationContext.getBean("AuthenticationService", MutableAuthenticationService.class);
        PreferenceService prefService = (PreferenceService)this.applicationContext.getBean("PreferenceService", PreferenceService.class);
        HashMap<QName, Object> nodeProps = new HashMap<QName, Object>();
        nodeProps.put(PROP_LUNCH, "Falafel wrap");
        nodeProps.put(PROP_LUNCH_COMMENTS, "");
        String userName = "docbrown@" + this.account1.getId();
        nodeProps.put(ContentModel.PROP_USERNAME, userName);
        nodeProps.put(ContentModel.PROP_FIRSTNAME, "Doc");
        nodeProps.put(ContentModel.PROP_LASTNAME, "Brown");
        nodeProps.put(ContentModel.PROP_JOBTITLE, "Inventor");
        nodeProps.put(ContentModel.PROP_LOCATION, "Location");
        nodeProps.put(ContentModel.PROP_TELEPHONE, "123345");
        nodeProps.put(ContentModel.PROP_MOBILE, "456456");
        nodeProps.put(ContentModel.PROP_EMAIL, "doc.brown@example.com");
        nodeProps.put(ContentModel.PROP_ORGANIZATION, "Acme");
        nodeProps.put(ContentModel.PROP_COMPANYADDRESS1, "123 Acme Crescent");
        nodeProps.put(ContentModel.PROP_COMPANYADDRESS2, "Cholsey");
        nodeProps.put(ContentModel.PROP_COMPANYADDRESS3, "Oxfordshire");
        nodeProps.put(ContentModel.PROP_COMPANYPOSTCODE, "OX10 1AB");
        nodeProps.put(ContentModel.PROP_COMPANYTELEPHONE, "098876234");
        nodeProps.put(ContentModel.PROP_COMPANYFAX, "098234876");
        nodeProps.put(ContentModel.PROP_COMPANYEMAIL, "info@example.com");
        nodeProps.put(ContentModel.PROP_SKYPE, "doc.brown");
        nodeProps.put(ContentModel.PROP_INSTANTMSG, "doc.brown.instmsg");
        nodeProps.put(ContentModel.PROP_USER_STATUS, "status");
        nodeProps.put(ContentModel.PROP_USER_STATUS_TIME, new Date());
        nodeProps.put(ContentModel.PROP_GOOGLEUSERNAME, "doc.brown.google");
        nodeProps.put(ContentModel.PROP_SIZE_QUOTA, 12345000);
        nodeProps.put(ContentModel.PROP_SIZE_CURRENT, 1230);
        nodeProps.put(ContentModel.PROP_EMAIL_FEED_DISABLED, false);
        nodeProps.put(ContentModel.PROP_ENABLED, true);
        nodeProps.put(ContentModel.PROP_SYS_NAME, "name-value");
        AuthenticationUtil.setFullyAuthenticatedUser((String)("admin@" + this.account1.getId()));
        authService.createAuthentication(userName, "password".toCharArray());
        authService.setAuthenticationEnabled(userName, true);
        this.personService.createPerson(nodeProps);
        prefService.setPreferences(userName, Collections.singletonMap("olives", "green"));
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "admin"));
        Person person = this.people.getPerson(userName);
        Assert.assertEquals((Object)userName, (Object)person.getId());
        Assert.assertEquals((Object)"Doc", (Object)person.getFirstName());
        Assert.assertEquals((Object)"Falafel wrap", person.getProperties().get("papi:lunch"));
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:lunchable"));
        Assert.assertNull(person.getProperties().get("papi:lunchcomments"));
        for (String key : person.getProperties().keySet()) {
            if (!key.startsWith("cm:") && !key.startsWith("sys:") && !key.startsWith("usr:")) continue;
            Object value = person.getProperties().get(key);
            String keyValueStr = String.format("(key=%s, value=%s)", key, value);
            Assert.fail((String)("Property " + keyValueStr + " found with namespace that should have been excluded."));
        }
    }

    @Test
    public void testCreatePerson_withCustomProps() throws Exception {
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "admin"));
        Person person = new Person();
        person.setUserName("jbloggs@" + this.account1.getId());
        person.setFirstName("Joe");
        person.setEmail("jbloggs@" + this.account1.getId());
        person.setEnabled(true);
        person.setPassword("password123");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("papi:telehash", "724332b5796a8");
        person.setProperties(props);
        ArrayList<String> aspectNames = new ArrayList<String>();
        aspectNames.add("papi:lunchable");
        person.setAspectNames(aspectNames);
        Person retPerson = this.people.create(person);
        Assert.assertEquals((long)2L, (long)retPerson.getAspectNames().size());
        Assert.assertTrue((boolean)retPerson.getAspectNames().contains("papi:comms"));
        Assert.assertEquals((long)1L, (long)retPerson.getProperties().size());
        Assert.assertEquals((Object)"724332b5796a8", retPerson.getProperties().get("papi:telehash"));
        AuthenticationUtil.setFullyAuthenticatedUser((String)("admin@" + this.account1.getId()));
        NodeRef nodeRef = this.personService.getPerson("jbloggs@" + this.account1.getId(), false);
        Assert.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ASPECT_COMMS));
        Assert.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ASPECT_LUNCHABLE));
        Map retProps = this.nodeService.getProperties(nodeRef);
        Assert.assertEquals((Object)"724332b5796a8", retProps.get(PROP_TELEHASH));
        Assert.assertEquals(null, retProps.get(PROP_LUNCH));
    }

    private Person createTestUpdatePerson() throws PublicApiException {
        Person person = new Person();
        String personId = UUID.randomUUID().toString() + "@" + this.account1.getId();
        person.setUserName(personId);
        person.setFirstName("Joe");
        person.setEmail(personId);
        person.setEnabled(true);
        person.setPassword("password123");
        person.setDescription("This is a very short bio.");
        person.setProperties(Collections.singletonMap("papi:jabber", "jbloggs@example.com"));
        person.setAspectNames(Collections.singletonList("papi:dessertable"));
        person = this.people.create(person);
        AuthenticationUtil.setFullyAuthenticatedUser((String)("admin@" + this.account1.getId()));
        NodeRef nodeRef = this.personService.getPerson(person.getId());
        this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_AUDITABLE, null);
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_TITLE, (Serializable)((Object)"This is a title"));
        Assert.assertEquals((Object)"jbloggs@example.com", person.getProperties().get("papi:jabber"));
        Assert.assertEquals((long)2L, (long)person.getAspectNames().size());
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:comms"));
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:dessertable"));
        return person;
    }

    @Test
    public void testUpdatePerson_withCustomProps() throws Exception {
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "admin"));
        Person person = this.createTestUpdatePerson();
        Assert.assertNull(person.getProperties().get("papi:lunch"));
        Assert.assertFalse((boolean)person.getAspectNames().contains("papi:lunchable"));
        String json = this.qjson("{    `properties`: {        `papi:lunch`: `Tomato soup`    }}");
        person = this.people.update(person.getId(), json, 200);
        Assert.assertEquals((Object)"Tomato soup", person.getProperties().get("papi:lunch"));
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:lunchable"));
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:comms"));
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:dessertable"));
        person = this.createTestUpdatePerson();
        person = this.people.update(person.getId(), this.qjson("{`properties`: {`papi:jabber`: `updated@example.com`}}"), 200);
        Assert.assertEquals((Object)"updated@example.com", person.getProperties().get("papi:jabber"));
        Assert.assertEquals((long)2L, (long)person.getAspectNames().size());
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:comms"));
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:dessertable"));
        person = this.createTestUpdatePerson();
        Assert.assertEquals((long)2L, (long)person.getAspectNames().size());
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:comms"));
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:dessertable"));
        person = this.people.update(person.getId(), this.qjson("{`aspectNames`: []}"), 200);
        Assert.assertNull((Object)person.getAspectNames());
        NodeRef nodeRef = this.personService.getPerson(person.getId());
        Set aspects = this.nodeService.getAspects(nodeRef);
        Assert.assertTrue((boolean)aspects.contains(ContentModel.ASPECT_REFERENCEABLE));
        Assert.assertTrue((boolean)aspects.contains(ContentModel.ASPECT_LOCALIZED));
        person = this.createTestUpdatePerson();
        Assert.assertEquals((long)2L, (long)person.getAspectNames().size());
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:comms"));
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:dessertable"));
        json = this.qjson("{ `aspectNames`: [`papi:lunchable`] }");
        person = this.people.update(person.getId(), json, 200);
        AuthenticationUtil.setFullyAuthenticatedUser((String)("admin@" + this.account1.getId()));
        NodeRef nodeRef2 = this.personService.getPerson(person.getId(), false);
        this.nodeService.hasAspect(nodeRef2, ContentModel.ASPECT_AUDITABLE);
        this.nodeService.hasAspect(nodeRef2, ContentModel.ASPECT_TITLED);
        List aspectNames = person.getAspectNames();
        Assert.assertEquals((long)1L, (long)aspectNames.size());
        Assert.assertTrue((boolean)aspectNames.contains("papi:lunchable"));
        Assert.assertNull((Object)person.getProperties());
        person = new Person();
        Object personId = UUID.randomUUID().toString() + "@" + this.account1.getId();
        person.setUserName((String)personId);
        person.setFirstName("Joe");
        person.setEmail((String)personId);
        person.setEnabled(true);
        person.setPassword("password123");
        person.setProperties(null);
        person.setAspectNames(null);
        person = this.people.create(person);
        Assert.assertNull((Object)person.getAspectNames());
        Assert.assertNull((Object)person.getProperties());
        String json2 = this.qjson("{    `aspectNames`: [         `papi:lunchable`     ],     `properties`: {         `papi:jabber`: `another@jabber.example.com`,         `papi:lunch`: `sandwich`      }}");
        person = this.people.update(person.getId(), json2, 200);
        aspectNames = person.getAspectNames();
        Assert.assertEquals((long)2L, (long)aspectNames.size());
        Assert.assertTrue((boolean)aspectNames.contains("papi:lunchable"));
        Assert.assertTrue((boolean)aspectNames.contains("papi:comms"));
        Assert.assertEquals((long)2L, (long)person.getProperties().size());
        Assert.assertEquals((Object)"another@jabber.example.com", person.getProperties().get("papi:jabber"));
        Assert.assertEquals((Object)"sandwich", person.getProperties().get("papi:lunch"));
        person = this.createTestUpdatePerson();
        Assert.assertEquals((long)2L, (long)person.getAspectNames().size());
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:comms"));
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:dessertable"));
        Assert.assertEquals((long)1L, (long)person.getProperties().size());
        Assert.assertTrue((boolean)person.getProperties().containsKey("papi:jabber"));
        person = this.people.update(person.getId(), this.qjson("{`properties`: {`papi:jabber`: null}}"), 200);
        Assert.assertNull((Object)person.getProperties());
        Assert.assertEquals((long)2L, (long)person.getAspectNames().size());
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:comms"));
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:dessertable"));
        person = this.createTestUpdatePerson();
        personId = person.getId();
        Assert.assertEquals((long)2L, (long)person.getAspectNames().size());
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:comms"));
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:dessertable"));
        json2 = this.qjson("{ `properties`: {`usr:enabled`: false} }");
        this.people.update(person.getId(), json2, 400);
        json2 = this.qjson("{ `properties`: {`cm:title`: `hello-world`} }");
        this.people.update(person.getId(), json2, 400);
        json2 = this.qjson("{ `properties`: {`sys:locale`: `en_GB`} }");
        this.people.update(person.getId(), json2, 400);
        AuthenticationUtil.setFullyAuthenticatedUser((String)("admin@" + this.account1.getId()));
        NodeRef nodeRef3 = this.personService.getPerson(person.getId(), false);
        this.nodeService.hasAspect(nodeRef3, ContentModel.ASPECT_AUDITABLE);
        this.nodeService.hasAspect(nodeRef3, ContentModel.ASPECT_TITLED);
        person = this.people.getPerson((String)personId);
        Assert.assertEquals((long)2L, (long)person.getAspectNames().size());
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:comms"));
        Assert.assertTrue((boolean)person.getAspectNames().contains("papi:dessertable"));
        Assert.assertEquals((Object)"jbloggs@example.com", person.getProperties().get("papi:jabber"));
    }

    private String qjson(String raw) {
        return raw.replace("`", "\"");
    }

    @Test
    public void testUpdatePersonAuthenticationFailed() throws PublicApiException {
        String personId = this.account2PersonIt.next();
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), personId));
        this.people.update(URL_PEOPLE, personId, null, null, "{\n  \"firstName\": \"Updated firstName\"\n}", null, "Expected 401 response when updating " + personId, 401);
    }

    @Test
    public void testUpdatePersonNonSelfAndNonAdminDisallowed() throws PublicApiException {
        String personId = this.account1PersonIt.next();
        String personToUpdateId = this.account1PersonIt.next();
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), personId));
        this.people.update(personToUpdateId, this.qjson("{ `firstName`:`Updated firstName` }"), 403);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "admin"));
        this.people.update(personToUpdateId, this.qjson("{ `firstName`:`Bob` }"), 200);
    }

    @Test
    public void testUpdatePersonCanUpdateThemself() throws PublicApiException {
        String personId = this.account1PersonIt.next();
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), personId));
        Person updatedPerson = this.people.update(personId, this.qjson("{ `firstName`: `Matt` }"), 200);
        Assert.assertEquals((Object)"Matt", (Object)updatedPerson.getFirstName());
        updatedPerson = this.people.update("-me-", this.qjson("{ `firstName`: `John` }"), 200);
        Assert.assertEquals((Object)"John", (Object)updatedPerson.getFirstName());
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "admin"));
        this.people.update(personId, this.qjson("{ `firstName`:`Bill` }"), 200);
        this.people.update(URL_PEOPLE, personId, null, null, this.qjson("{ `firstName`:`` }"), null, "Expected 400 response when updating " + personId, 400);
        this.people.update(URL_PEOPLE, personId, null, null, this.qjson("{ `email`:`` }"), null, "Expected 400 response when updating " + personId, 400);
        this.people.update(URL_PEOPLE, personId, null, null, this.qjson("{ `emailNotificationsEnabled`:`` }"), null, "Expected 400 response when updating " + personId, 400);
    }

    @Test
    public void testUpdatePersonNonexistentPerson() throws PublicApiException {
        String personId = "non-existent";
        this.publicApiClient.setRequestContext(new RequestContext(account3.getId(), this.account3Admin, "admin"));
        this.people.update(URL_PEOPLE, "non-existent", null, null, "{\n  \"firstName\": \"Updated firstName\"\n}", null, "Expected 404 response when updating non-existent", 404);
    }

    @Test
    public void testUpdatePersonUsingPartialUpdate() throws PublicApiException {
        String personId = account3.createUser().getId();
        this.publicApiClient.setRequestContext(new RequestContext(account3.getId(), this.account3Admin, "admin"));
        String updatedFirstName = "Updated firstName";
        HttpResponse response = this.people.update(URL_PEOPLE, personId, null, null, "{\n  \"firstName\": \"" + updatedFirstName + "\"\n}", null, "Expected 200 response when updating " + personId, 200);
        Person updatedPerson = Person.parsePerson((JSONObject)response.getJsonResponse().get((Object)"entry"));
        Assert.assertEquals((Object)updatedFirstName, (Object)updatedPerson.getFirstName());
    }

    @Test
    public void testUpdatePersonWithRestrictedResponseFields() throws PublicApiException {
        String personId = account3.createUser().getId();
        this.publicApiClient.setRequestContext(new RequestContext(account3.getId(), this.account3Admin, "admin"));
        String updatedFirstName = "Updated firstName";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fields", "id,firstName");
        HttpResponse response = this.people.update(URL_PEOPLE, personId, null, null, "{\n  \"firstName\": \"" + updatedFirstName + "\"\n}", params, "Expected 200 response when updating " + personId, 200);
        Person updatedPerson = Person.parsePerson((JSONObject)response.getJsonResponse().get((Object)"entry"));
        Assert.assertNotNull((Object)updatedPerson.getId());
        Assert.assertEquals((Object)updatedFirstName, (Object)updatedPerson.getFirstName());
        Assert.assertNull((Object)updatedPerson.getEmail());
    }

    @Test
    public void testUpdatePersonUpdateAsAdmin() throws Exception {
        String personId = account3.createUser().getId();
        this.publicApiClient.setRequestContext(new RequestContext(account3.getId(), this.account3Admin, "admin"));
        String firstName = "updatedFirstName";
        String lastName = "updatedLastName";
        String description = "updatedDescription";
        String email = "updated@example.com";
        String skypeId = "updated.skype.id";
        String googleId = "googleId";
        String instantMessageId = "updated.user@example.com";
        String jobTitle = "updatedJobTitle";
        String location = "updatedLocation";
        Company company = new Company("updatedOrganization", "updatedAddress1", "updatedAddress2", "updatedAddress3", "updatedPostcode", "updatedTelephone", "updatedFax", "updatedEmail");
        String mobile = "mobile";
        String telephone = "telephone";
        String userStatus = "userStatus";
        Boolean enabled = true;
        Boolean emailNotificationsEnabled = false;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fields", "id,firstName,lastName,description,avatarId,email,skypeId,googleId,instantMessageId,jobTitle,location,mobile,telephone,userStatus,emailNotificationsEnabled,enabled,company");
        HttpResponse response = this.people.update(URL_PEOPLE, personId, null, null, "{\n  \"firstName\": \"" + firstName + "\",\n  \"lastName\": \"" + lastName + "\",\n  \"description\": \"" + description + "\",\n  \"email\": \"" + email + "\",\n  \"skypeId\": \"" + skypeId + "\",\n  \"googleId\": \"" + googleId + "\",\n  \"instantMessageId\": \"" + instantMessageId + "\",\n  \"jobTitle\": \"" + jobTitle + "\",\n  \"location\": \"" + location + "\",\n  \"company\": {\n    \"organization\": \"" + company.getOrganization() + "\",\n    \"address1\": \"" + company.getAddress1() + "\",\n    \"address2\": \"" + company.getAddress2() + "\",\n    \"address3\": \"" + company.getAddress3() + "\",\n    \"postcode\": \"" + company.getPostcode() + "\",\n    \"telephone\": \"" + company.getTelephone() + "\",\n    \"fax\": \"" + company.getFax() + "\",\n    \"email\": \"" + company.getEmail() + "\"\n  },\n  \"mobile\": \"" + mobile + "\",\n  \"telephone\": \"" + telephone + "\",\n  \"userStatus\": \"" + userStatus + "\",\n  \"emailNotificationsEnabled\": \"" + emailNotificationsEnabled + "\",\n  \"enabled\": \"" + enabled + "\"\n}", params, "Expected 200 response when updating " + personId, 200);
        Person updatedPerson = Person.parsePerson((JSONObject)response.getJsonResponse().get((Object)"entry"));
        Assert.assertNotNull((Object)updatedPerson.getId());
        Assert.assertEquals((Object)firstName, (Object)updatedPerson.getFirstName());
        Assert.assertEquals((Object)lastName, (Object)updatedPerson.getLastName());
        Assert.assertEquals((Object)(firstName + " " + lastName), (Object)updatedPerson.getDisplayName());
        Assert.assertEquals((Object)description, (Object)updatedPerson.getDescription());
        Assert.assertEquals((Object)email, (Object)updatedPerson.getEmail());
        Assert.assertEquals((Object)skypeId, (Object)updatedPerson.getSkypeId());
        Assert.assertEquals((Object)googleId, (Object)updatedPerson.getGoogleId());
        Assert.assertEquals((Object)instantMessageId, (Object)updatedPerson.getInstantMessageId());
        Assert.assertEquals((Object)jobTitle, (Object)updatedPerson.getJobTitle());
        Assert.assertEquals((Object)location, (Object)updatedPerson.getLocation());
        Assert.assertNotNull((Object)updatedPerson.getCompany());
        company.expected(updatedPerson.getCompany());
        Assert.assertEquals((Object)mobile, (Object)updatedPerson.getMobile());
        Assert.assertEquals((Object)telephone, (Object)updatedPerson.getTelephone());
        Assert.assertEquals((Object)userStatus, (Object)updatedPerson.getUserStatus());
        Assert.assertEquals((Object)emailNotificationsEnabled, (Object)updatedPerson.isEmailNotificationsEnabled());
        Assert.assertEquals((Object)enabled, (Object)updatedPerson.isEnabled());
        response = this.people.update(URL_PEOPLE, personId, null, null, "{\n  \"lastName\":null,\n  \"description\":null,\n  \"skypeId\":null,\n  \"googleId\":null,\n  \"instantMessageId\":null,\n  \"jobTitle\":null,\n  \"location\":null,\n  \"company\": {\n    \"address1\":null,\n    \"address2\":null,\n    \"address3\":null,\n    \"postcode\":null,\n    \"telephone\":null,\n    \"fax\":null,\n    \"email\":null\n  },\n  \"mobile\":null,\n  \"telephone\":null,\n  \"userStatus\":null\n}", params, "Expected 200 response when updating " + personId, 200);
        updatedPerson = Person.parsePerson((JSONObject)response.getJsonResponse().get((Object)"entry"));
        Assert.assertNotNull((Object)updatedPerson.getId());
        Assert.assertNull((Object)updatedPerson.getLastName());
        Assert.assertEquals((Object)updatedPerson.getFirstName(), (Object)updatedPerson.getDisplayName());
        Assert.assertNull((Object)updatedPerson.getDescription());
        Assert.assertNull((Object)updatedPerson.getSkypeId());
        Assert.assertNull((Object)updatedPerson.getGoogleId());
        Assert.assertNull((Object)updatedPerson.getInstantMessageId());
        Assert.assertNull((Object)updatedPerson.getJobTitle());
        Assert.assertNull((Object)updatedPerson.getLocation());
        Assert.assertNotNull((Object)updatedPerson.getCompany());
        Assert.assertNotNull((Object)updatedPerson.getCompany().getOrganization());
        Assert.assertNull((Object)updatedPerson.getCompany().getAddress1());
        Assert.assertNull((Object)updatedPerson.getCompany().getAddress2());
        Assert.assertNull((Object)updatedPerson.getCompany().getAddress3());
        Assert.assertNull((Object)updatedPerson.getCompany().getPostcode());
        Assert.assertNull((Object)updatedPerson.getCompany().getFax());
        Assert.assertNull((Object)updatedPerson.getCompany().getEmail());
        Assert.assertNull((Object)updatedPerson.getCompany().getTelephone());
        Assert.assertNull((Object)updatedPerson.getMobile());
        Assert.assertNull((Object)updatedPerson.getTelephone());
        Assert.assertNull((Object)updatedPerson.getUserStatus());
        response = this.people.update(URL_PEOPLE, personId, null, null, "{\n  \"company\": {} \n}", params, "Expected 200 response when updating " + personId, 200);
        updatedPerson = Person.parsePerson((JSONObject)response.getJsonResponse().get((Object)"entry"));
        Assert.assertNotNull((Object)updatedPerson.getCompany());
        Assert.assertNull((Object)updatedPerson.getCompany().getOrganization());
        String updatedOrgName = "another org";
        response = this.people.update(URL_PEOPLE, personId, null, null, "{\n  \"company\": {\n    \"organization\":\"" + updatedOrgName + "\"\n  }\n}", params, "Expected 200 response when updating " + personId, 200);
        updatedPerson = Person.parsePerson((JSONObject)response.getJsonResponse().get((Object)"entry"));
        Assert.assertNotNull((Object)updatedPerson.getCompany());
        Assert.assertEquals((Object)updatedOrgName, (Object)updatedPerson.getCompany().getOrganization());
        response = this.people.update(URL_PEOPLE, personId, null, null, "{\n  \"company\": null\n}", params, "Expected 200 response when updating " + personId, 200);
        updatedPerson = Person.parsePerson((JSONObject)response.getJsonResponse().get((Object)"entry"));
        Assert.assertNotNull((Object)updatedPerson.getCompany());
        Assert.assertNull((Object)updatedPerson.getCompany().getOrganization());
    }

    @Test
    public void testUpdatePersonEnabledNonAdminNotAllowed() throws PublicApiException {
        String personId = account3.createUser().getId();
        this.publicApiClient.setRequestContext(new RequestContext(account3.getId(), personId));
        this.people.update(URL_PEOPLE, personId, null, null, "{\n  \"enabled\": \"false\"\n}", null, "Expected 403 response when updating " + personId, 403);
    }

    @Test
    public void testUpdatePersonEnabled() throws PublicApiException {
        String personId = account3.createUser().getId();
        this.publicApiClient.setRequestContext(new RequestContext(account3.getId(), this.account3Admin, "admin"));
        Boolean enabled = false;
        Map<String, String> params = Collections.singletonMap("fields", "enabled");
        Person updatedPerson = this.people.update(personId, this.qjson("{`enabled`:" + enabled + "}"), params, 200);
        Assert.assertEquals((Object)enabled, (Object)updatedPerson.isEnabled());
        enabled = true;
        params = Collections.singletonMap("fields", "enabled");
        updatedPerson = this.people.update(personId, this.qjson("{`enabled`:" + enabled + "}"), params, 200);
        Assert.assertEquals((Object)enabled, (Object)updatedPerson.isEnabled());
        this.people.update(URL_PEOPLE, personId, null, null, this.qjson("{ `enabled`: null }"), null, "Expected 400 response when updating " + personId, 400);
        this.people.update(URL_PEOPLE, personId, null, null, this.qjson("{ `enabled`: `` }"), null, "Expected 400 response when updating " + personId, 400);
        this.publicApiClient.setRequestContext(new RequestContext(account3.getId(), personId, "password"));
        boolean origEnabled = this.people.getPerson(personId).isEnabled();
        Boolean enabled2 = false;
        Assert.assertNotEquals((Object)origEnabled, (Object)enabled2);
        Map<String, String> params2 = Collections.singletonMap("fields", "enabled");
        this.people.update(personId, this.qjson("{`enabled`:" + enabled2 + "}"), params2, 403);
        Person me = this.people.getPerson(personId);
        Assert.assertEquals((String)"Enabled state shouldn't have changed, but did", (Object)origEnabled, (Object)me.isEnabled());
    }

    @Test
    public void testUpdatePersonAdminCannotBeDisabled() throws PublicApiException {
        this.publicApiClient.setRequestContext(new RequestContext(account3.getId(), this.account3Admin, "admin"));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("fields", "enabled");
        this.people.update(URL_PEOPLE, this.account3Admin, null, null, "{\n  \"enabled\": \"false\"\n}", params, "Expected 403 response when updating " + this.account3Admin, 403);
    }

    @Test
    public void testUpdatePersonPasswordByThemself() throws PublicApiException {
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "admin"));
        Person me = new Person();
        me.setId(UUID.randomUUID().toString() + "@" + this.account1.getId());
        me.setUserName(me.getId());
        me.setFirstName("Jo");
        me.setEmail(me.getId());
        me.setEnabled(true);
        me.setPassword("password123");
        me = this.people.create(me);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), me.getId(), "password123"));
        this.people.update(me.getId(), this.qjson("{ `oldPassword`:`password123`, `password`:`newpassword456` }"), 200);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), me.getId(), "password123"));
        this.people.getPerson(me.getId(), 401);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), me.getId(), "newpassword456"));
        this.people.getPerson(me.getId());
        this.people.update(me.getId(), this.qjson("{ `oldPassword`:`password123`, `password`:`newpassword456` }"), 403);
        this.people.update(me.getId(), this.qjson("{ `password`:`newpassword456` }"), 400);
        this.people.update(me.getId(), this.qjson("{ `oldPassword`:``, `password`:`newpassword456` }"), 400);
        this.people.update(me.getId(), this.qjson("{ `oldPassword`:null, `password`:`newpassword456` }"), 400);
        this.people.update(me.getId(), this.qjson("{ `oldPassword`:`newpassword456` }"), 400);
        this.people.update(me.getId(), this.qjson("{ `oldPassword`:`newpassword456`, `password`:`` }"), 400);
        this.people.update(me.getId(), this.qjson("{ `oldPassword`:`newpassword456`, `password`:null }"), 400);
    }

    @Test
    public void testUpdatePersonPasswordByAdmin() throws PublicApiException {
        String personId = account3.createUser().getId();
        String networkId = account3.getId();
        this.publicApiClient.setRequestContext(new RequestContext(networkId, this.account3Admin, "admin"));
        String invalidPassword = "invalidPassword";
        String updatedPassword = "newPassword";
        this.people.update(URL_PEOPLE, personId, null, null, "{\n  \"password\": \"" + updatedPassword + "\"\n}", null, "Expected 200 response when updating " + personId, 200);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, personId, invalidPassword));
        try {
            this.people.getPerson(personId);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(networkId, personId, updatedPassword));
        this.people.getPerson(personId);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, this.account3Admin, "admin"));
        String updatedPassword2 = "newPassword2";
        this.people.update(personId, this.qjson("{ `password`:`" + updatedPassword2 + "`, `oldPassword`:`rubbish` }"), 200);
        this.publicApiClient.setRequestContext(new RequestContext(networkId, personId, updatedPassword));
        try {
            this.people.getPerson(personId);
            Assert.fail((String)"");
        }
        catch (PublicApiException e) {
            Assert.assertEquals((long)401L, (long)e.getHttpResponse().getStatusCode());
        }
        this.publicApiClient.setRequestContext(new RequestContext(networkId, personId, updatedPassword2));
        this.people.getPerson(personId);
        this.people.update(personId, this.qjson("{ `password`:`` }"), 400);
        this.people.update(personId, this.qjson("{ `password`:null }"), 400);
    }

    @Test
    public void testUpdatePersonWithNotUpdatableFields() throws PublicApiException {
        String personId = account3.createUser().getId();
        this.publicApiClient.setRequestContext(new RequestContext(account3.getId(), this.account3Admin, "admin"));
        ArrayList<Pair<String, String>> notUpdatableFields = new ArrayList<Pair<String, String>>();
        notUpdatableFields.add(new Pair<String, String>("userName", "userName"));
        notUpdatableFields.add(new Pair<String, String>("avatarId", "avatarId"));
        notUpdatableFields.add(new Pair<String, String>("statusUpdatedAt", "statusUpdatedAt"));
        notUpdatableFields.add(new Pair<String, String>("quota", "quota"));
        notUpdatableFields.add(new Pair<String, String>("quotaUsed", "quotaUsed"));
        for (Pair pair : notUpdatableFields) {
            this.people.update(URL_PEOPLE, personId, null, null, "{\n\"" + (String)pair.getFirst() + "\": \"" + (String)pair.getSecond() + "\"\n}", null, "Expected 400 response when updating " + personId, 400);
        }
    }

    private PublicApiClient.ListResponse<Person> listPeople(PublicApiClient.Paging paging, String sortColumn, boolean asc, int statusCode) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (sortColumn != null) {
            params.put("orderBy", sortColumn + " " + (asc ? "ASC" : "DESC"));
        }
        return this.listPeople(this.createParams(paging, params), statusCode);
    }

    private PublicApiClient.ListResponse<Person> listPeople(Map<String, String> parameters, int expectedStatusCode) throws PublicApiException {
        HttpResponse response = this.people.getAll(URL_PEOPLE, null, null, null, parameters, "Failed to get people", expectedStatusCode);
        JSONObject jsonList = (JSONObject)response.getJsonResponse().get((Object)"list");
        if (jsonList == null) {
            return null;
        }
        return Person.parsePeople(response.getJsonResponse());
    }

    @Test
    public void testListPeopleWithAspectNamesAndProperties() throws PublicApiException {
        this.publicApiClient.setRequestContext(new RequestContext(account3.getId(), this.account3Admin, "admin"));
        this.personBob = new Person();
        this.personBob.setId("bob@" + account3.getId());
        this.personBob.setUserName(this.personBob.getId());
        this.personBob.setFirstName("Bob");
        this.personBob.setLastName("Cratchit");
        this.personBob.setEmail("bob.cratchit@example.com");
        this.personBob.setPassword("password");
        this.personBob.setEnabled(true);
        this.personBob.setProperties(Collections.singletonMap("papi:lunch", "Magical sandwich"));
        this.people.create(this.personBob);
        PublicApiClient.ListResponse<Person> resp = this.listPeople(Collections.emptyMap(), 200);
        Assert.assertNull((Object)resp.getList().get(0).getAspectNames());
        Assert.assertNull((Object)resp.getList().get(0).getProperties());
        Map<String, String> parameters = Collections.singletonMap("include", "aspectNames,properties");
        PublicApiClient.ListResponse<Person> resp2 = this.listPeople(parameters, 200);
        Person bob = resp2.getList().stream().filter(p -> p.getUserName().equals(this.personBob.getId())).findFirst().get();
        Assert.assertNotNull((Object)bob.getAspectNames());
        Assert.assertTrue((boolean)bob.getAspectNames().contains("papi:lunchable"));
        Assert.assertNotNull((Object)bob.getProperties());
        Assert.assertEquals((Object)"Magical sandwich", bob.getProperties().get("papi:lunch"));
    }

    @Test
    public void testPagingAndSortingByFirstNameAsc() throws Exception {
        this.publicApiClient.setRequestContext(new RequestContext(account4.getId(), account4Admin, "admin"));
        int skipCount = 1;
        int maxItems = 3;
        int totalResults = 5;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<Person> resp = this.listPeople(paging, "firstName", true, 200);
        LinkedList<ExpectedComparison> expectedList = new LinkedList<ExpectedComparison>();
        expectedList.add(this.expectedFirstName(personAliceSmith));
        expectedList.add(this.expectedFirstName(personAliceDavis));
        expectedList.add(this.expectedFirstName(personBenCarson));
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    @Test
    public void testPagingAndSortingByFirstNameDesc() throws Exception {
        this.publicApiClient.setRequestContext(new RequestContext(account4.getId(), account4Admin, "admin"));
        int skipCount = 1;
        int maxItems = 3;
        int totalResults = 5;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<Person> resp = this.listPeople(paging, "firstName", false, 200);
        LinkedList<ExpectedComparison> expectedList = new LinkedList<ExpectedComparison>();
        expectedList.add(this.expectedFirstName(personBenCarson));
        expectedList.add(this.expectedFirstName(personAliceSmith));
        expectedList.add(this.expectedFirstName(personAliceDavis));
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    @Test
    public void testPagingAndDefaultSorting() throws Exception {
        this.publicApiClient.setRequestContext(new RequestContext(account4.getId(), account4Admin, "admin"));
        int skipCount = 1;
        int maxItems = 3;
        int totalResults = 5;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<Person> resp = this.listPeople(paging, null, false, 200);
        LinkedList<Person> expectedList = new LinkedList<Person>();
        expectedList.add(personAliceSmith);
        expectedList.add(personAliceDavis);
        expectedList.add(personBenCarson);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    @Test
    public void testPagingAndSortingByIdDesc() throws Exception {
        this.publicApiClient.setRequestContext(new RequestContext(account4.getId(), account4Admin, "admin"));
        int skipCount = 1;
        int maxItems = 3;
        int totalResults = 5;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<Person> resp = this.listPeople(paging, "id", false, 200);
        LinkedList<Person> expectedList = new LinkedList<Person>();
        expectedList.add(personBenCarson);
        expectedList.add(personAliceDavis);
        expectedList.add(personAliceSmith);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    @Test
    public void testPagingAndSortingByInvalidSortKey() throws Exception {
        this.publicApiClient.setRequestContext(new RequestContext(account4.getId(), account4Admin, "admin"));
        int skipCount = 1;
        int maxItems = 3;
        int totalResults = 5;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        this.listPeople(paging, "invalidSortKey", true, 400);
    }

    @Test
    public void testPagingAndSortingByLastName() throws Exception {
        this.publicApiClient.setRequestContext(new RequestContext(account4.getId(), account4Admin, "admin"));
        int skipCount = 2;
        int maxItems = 3;
        int totalResults = 5;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<Person> resp = this.listPeople(paging, "lastName", true, 200);
        LinkedList<Person> expectedList = new LinkedList<Person>();
        expectedList.add(personBenCarson);
        expectedList.add(personAliceDavis);
        expectedList.add(personAliceSmith);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    @Test
    public void testPagingAndSortingByFirstNameAndLastName() throws Exception {
        this.publicApiClient.setRequestContext(new RequestContext(account4.getId(), account4Admin, "admin"));
        int skipCount = 1;
        int maxItems = 3;
        int totalResults = 5;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems, totalResults, totalResults);
        PublicApiClient.ListResponse<Person> resp = this.listPeople(paging, "firstName,lastName", true, 200);
        LinkedList<Person> expectedList = new LinkedList<Person>();
        expectedList.add(personAliceDavis);
        expectedList.add(personAliceSmith);
        expectedList.add(personBenCarson);
        this.checkList(expectedList, paging.getExpectedPaging(), resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResetPassword() throws Exception {
        this.setRequestContext(this.account1.getId(), this.account1Admin, "admin");
        Person person = new Person();
        person.setUserName("john.doe@" + this.account1.getId());
        person.setFirstName("John");
        person.setLastName("Doe");
        person.setEmail("john.doe@alfresco.com");
        person.setEnabled(true);
        person.setEmailNotificationsEnabled(true);
        person.setPassword("password");
        this.people.create(person);
        this.setRequestContext(this.account1.getId(), null, null);
        LoginTicket loginRequest = new LoginTicket();
        loginRequest.setUserId(person.getUserName());
        loginRequest.setPassword(person.getPassword());
        HttpResponse response = this.post("tickets", RestApiUtil.toJsonAsString(loginRequest), null, null, "authentication", 201);
        LoginTicketResponse loginResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), LoginTicketResponse.class);
        Assert.assertNotNull((Object)loginResponse.getId());
        Assert.assertNotNull((Object)loginResponse.getUserId());
        ResetPasswordServiceImpl passwordService = (ResetPasswordServiceImpl)this.applicationContext.getBean("resetPasswordService", ResetPasswordServiceImpl.class);
        passwordService.setSendEmailAsynchronously(false);
        EmailUtil emailUtil = new EmailUtil(this.applicationContext);
        try {
            this.setRequestContext(this.account1.getId(), null, null);
            emailUtil.reset();
            Client client = new Client().setClient("share");
            this.post(this.getRequestResetPasswordUrl(person.getUserName()), RestApiUtil.toJsonAsString(client), 202);
            Assert.assertEquals((String)"A reset password email should have been sent.", (long)1L, (long)emailUtil.getSentCount());
            MimeMessage msg = emailUtil.getLastEmail();
            Assert.assertNotNull((String)"There should be an email.", (Object)msg);
            Assert.assertEquals((String)"Should've been only one email recipient.", (long)1L, (long)msg.getAllRecipients().length);
            Assert.assertEquals((Object)person.getEmail(), (Object)msg.getAllRecipients()[0].toString());
            Assert.assertNotNull((String)"There should be a subject.", (Object)msg.getSubject());
            String resetPasswordUrl = (String)emailUtil.getLastEmailTemplateModelValue("reset_password_url");
            Assert.assertNotNull((String)"Wrong email is sent.", (Object)resetPasswordUrl);
            org.alfresco.util.Pair pair = ResetPasswordServiceImplTest.getWorkflowIdAndKeyFromUrl((String)resetPasswordUrl);
            Assert.assertNotNull((String)"Workflow Id can't be null.", (Object)pair.getFirst());
            Assert.assertNotNull((String)"Workflow Key can't be null.", (Object)pair.getSecond());
            emailUtil.reset();
            PasswordReset passwordReset = new PasswordReset().setPassword("changed").setId((String)pair.getFirst()).setKey((String)pair.getSecond());
            this.post(this.getResetPasswordUrl(person.getUserName()), RestApiUtil.toJsonAsString(passwordReset), 202);
            Assert.assertEquals((String)"A reset password confirmation email should have been sent.", (long)1L, (long)emailUtil.getSentCount());
            msg = emailUtil.getLastEmail();
            Assert.assertNotNull((String)"There should be an email.", (Object)msg);
            Assert.assertEquals((String)"Should've been only one email recipient.", (long)1L, (long)msg.getAllRecipients().length);
            Assert.assertEquals((Object)person.getEmail(), (Object)msg.getAllRecipients()[0].toString());
            Assert.assertNotNull((String)"There should be a subject.", (Object)msg.getSubject());
            this.post("tickets", RestApiUtil.toJsonAsString(loginRequest), null, null, "authentication", 403);
            loginRequest.setPassword(passwordReset.getPassword());
            response = this.post("tickets", RestApiUtil.toJsonAsString(loginRequest), null, null, "authentication", 201);
            loginResponse = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), LoginTicketResponse.class);
            Assert.assertNotNull((Object)loginResponse.getId());
            Assert.assertNotNull((Object)loginResponse.getUserId());
            emailUtil.reset();
            passwordReset.setPassword("changedAgain");
            this.post(this.getResetPasswordUrl(person.getUserName()), RestApiUtil.toJsonAsString(passwordReset), 202);
            Assert.assertEquals((String)"No email should have been sent.", (long)0L, (long)emailUtil.getSentCount());
            this.post(this.getRequestResetPasswordUrl(System.currentTimeMillis() + "noUser"), RestApiUtil.toJsonAsString(client), 202);
            Assert.assertEquals((String)"No email should have been sent.", (long)0L, (long)emailUtil.getSentCount());
            this.setRequestContext(this.account1.getId(), this.account1Admin, "admin");
            Map<String, String> params = Collections.singletonMap("fields", "enabled");
            Person updatedPerson = this.people.update(person.getUserName(), this.qjson("{`enabled`:false}"), params, 200);
            Assert.assertFalse((boolean)updatedPerson.isEnabled());
            this.setRequestContext(this.account1.getId(), null, null);
            this.post(this.getRequestResetPasswordUrl(person.getUserName()), RestApiUtil.toJsonAsString(client), 202);
            Assert.assertEquals((String)"No email should have been sent.", (long)0L, (long)emailUtil.getSentCount());
            client = new Client();
            this.post(this.getRequestResetPasswordUrl(person.getUserName()), RestApiUtil.toJsonAsString(client), 400);
            emailUtil.reset();
            this.setRequestContext(this.account1.getId(), this.account1Admin, "admin");
            params = Collections.singletonMap("fields", "enabled");
            updatedPerson = this.people.update(person.getUserName(), this.qjson("{`enabled`:true}"), params, 200);
            Assert.assertTrue((boolean)updatedPerson.isEnabled());
            this.setRequestContext(this.account1.getId(), null, null);
            client = new Client().setClient("share");
            this.post(this.getRequestResetPasswordUrl(person.getUserName()), RestApiUtil.toJsonAsString(client), 202);
            Assert.assertEquals((String)"A reset password email should have been sent.", (long)1L, (long)emailUtil.getSentCount());
            resetPasswordUrl = (String)emailUtil.getLastEmailTemplateModelValue("reset_password_url");
            Assert.assertNotNull((String)"Wrong email is sent.", (Object)resetPasswordUrl);
            pair = ResetPasswordServiceImplTest.getWorkflowIdAndKeyFromUrl((String)resetPasswordUrl);
            Assert.assertNotNull((String)"Workflow Id can't be null.", (Object)pair.getFirst());
            Assert.assertNotNull((String)"Workflow Key can't be null.", (Object)pair.getSecond());
            emailUtil.reset();
            PasswordReset passwordResetInvalid = new PasswordReset().setId((String)pair.getFirst()).setKey((String)pair.getSecond());
            this.post(this.getResetPasswordUrl(person.getUserName()), RestApiUtil.toJsonAsString(passwordResetInvalid), 400);
            passwordResetInvalid.setPassword("changedAgain").setId(null);
            this.post(this.getResetPasswordUrl(person.getUserName()), RestApiUtil.toJsonAsString(passwordResetInvalid), 400);
            passwordResetInvalid.setId((String)pair.getFirst()).setKey(null);
            this.post(this.getResetPasswordUrl(person.getUserName()), RestApiUtil.toJsonAsString(passwordResetInvalid), 400);
            passwordResetInvalid = new PasswordReset().setPassword("changedAgain").setId("activiti$" + System.currentTimeMillis()).setKey((String)pair.getSecond());
            this.post(this.getResetPasswordUrl(person.getUserName()), RestApiUtil.toJsonAsString(passwordResetInvalid), 202);
            Assert.assertEquals((String)"No email should have been sent.", (long)0L, (long)emailUtil.getSentCount());
            passwordResetInvalid = new PasswordReset().setPassword("changedAgain").setId((String)pair.getFirst()).setKey(GUID.generate());
            this.post(this.getResetPasswordUrl(person.getUserName()), RestApiUtil.toJsonAsString(passwordResetInvalid), 202);
            Assert.assertEquals((String)"No email should have been sent.", (long)0L, (long)emailUtil.getSentCount());
            passwordResetInvalid = new PasswordReset().setPassword("changedAgain").setId((String)pair.getFirst()).setKey((String)pair.getSecond());
            this.post(this.getResetPasswordUrl(user1), RestApiUtil.toJsonAsString(passwordResetInvalid), 202);
            Assert.assertEquals((String)"No email should have been sent.", (long)0L, (long)emailUtil.getSentCount());
        }
        finally {
            passwordService.setSendEmailAsynchronously(true);
            emailUtil.reset();
        }
    }

    private String getRequestResetPasswordUrl(String userId) {
        return "people/" + userId + "/request-password-reset";
    }

    private String getResetPasswordUrl(String userId) {
        return "people/" + userId + "/reset-password";
    }

    @Test
    public void retrieveAvatar() throws Exception {
        String person1 = this.account1PersonIt.next();
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1));
        AuthenticationUtil.setFullyAuthenticatedUser((String)person1);
        NodeRef person1Ref = this.personService.getPerson(person1, false);
        this.deleteAvatarDirect(person1Ref);
        Assert.assertNotNull((Object)this.people.getPerson(person1));
        this.people.getAvatar(person1, false, 404);
        Assert.assertNotNull((Object)this.people.getPerson(person1));
        this.people.getAvatar(person1, true, 200);
        String nonPerson = "i-do-not-exist";
        this.people.getPerson(nonPerson, 404);
        this.people.getAvatar(nonPerson, false, 404);
        nonPerson = "i-do-not-exist";
        this.people.getPerson(nonPerson, 404);
        this.people.getAvatar(nonPerson, true, 404);
        ClassPathResource thumbRes = new ClassPathResource("test.jpg");
        this.deleteAvatarDirect(person1Ref);
        this.createAvatarDirect(person1Ref, thumbRes.getFile());
        this.people.getAvatar(person1, false, 200);
        this.people.getAvatar("-me-", false, 200);
        HttpResponse response = this.people.getAvatar(person1, false, 200);
        Map<String, String> responseHeaders = response.getHeaders();
        String lastModified = responseHeaders.get("Last-Modified");
        Assert.assertNotNull((Object)lastModified);
        this.people.getAvatar(person1, lastModified, 304);
        this.waitMillis(2000);
        ClassPathResource thumbRes2 = new ClassPathResource("publicapi/upload/quick.jpg");
        this.deleteAvatarDirect(person1Ref);
        this.createAvatarDirect(person1Ref, thumbRes2.getFile());
        this.people.getAvatar(person1, lastModified, 200);
        Boolean attachmentParam = null;
        HttpResponse response2 = this.people.getAvatar(person1, attachmentParam, false, null, 200);
        Map<String, String> responseHeaders2 = response2.getHeaders();
        String contentDisposition = responseHeaders2.get("Content-Disposition");
        Assert.assertNotNull((Object)contentDisposition);
        Assert.assertTrue((boolean)contentDisposition.startsWith("attachment;"));
        attachmentParam = true;
        response2 = this.people.getAvatar(person1, attachmentParam, false, null, 200);
        responseHeaders2 = response2.getHeaders();
        contentDisposition = responseHeaders2.get("Content-Disposition");
        Assert.assertNotNull((Object)contentDisposition);
        Assert.assertTrue((boolean)contentDisposition.startsWith("attachment;"));
        attachmentParam = false;
        response2 = this.people.getAvatar(person1, attachmentParam, false, null, 200);
        responseHeaders2 = response2.getHeaders();
        contentDisposition = responseHeaders2.get("Content-Disposition");
        Assert.assertNull((Object)contentDisposition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitMillis(int requiredDelay) {
        long startTime;
        long currTime = startTime = System.currentTimeMillis();
        while (currTime < startTime + (long)requiredDelay) {
            try {
                Thread.sleep(requiredDelay);
            }
            catch (InterruptedException e) {
                System.out.println(":>>> " + e.getMessage());
            }
            finally {
                currTime = System.currentTimeMillis();
                System.out.println(":>>> waited " + (currTime - startTime) + "ms");
            }
        }
    }

    private void deleteAvatarDirect(NodeRef personRef) {
        List refs;
        List assocs = this.nodeService.getChildAssocs(personRef).stream().filter(x -> x.getTypeQName().equals((Object)ContentModel.ASSOC_PREFERENCE_IMAGE)).collect(Collectors.toList());
        if (assocs.size() > 0) {
            this.nodeService.deleteNode(((ChildAssociationRef)assocs.get(0)).getChildRef());
        }
        if ((refs = this.nodeService.getTargetAssocs(personRef, (QNamePattern)ContentModel.ASSOC_AVATAR)).size() == 1) {
            NodeRef existingRef = ((AssociationRef)refs.get(0)).getTargetRef();
            this.nodeService.removeAssociation(personRef, existingRef, ContentModel.ASSOC_AVATAR);
        }
        if (assocs.size() > 1 || refs.size() > 1) {
            Assert.fail((String)String.format("Pref images: %d, Avatar assocs: %d", assocs.size(), refs.size()));
        }
    }

    private NodeRef createAvatarDirect(NodeRef personRef, File avatarFile) {
        this.nodeService.addAspect(personRef, ContentModel.ASPECT_PREFERENCES, null);
        ChildAssociationRef assoc = this.nodeService.createNode(personRef, ContentModel.ASSOC_PREFERENCE_IMAGE, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"origAvatar"), ContentModel.TYPE_CONTENT);
        NodeRef avatarRef = assoc.getChildRef();
        this.nodeService.createAssociation(personRef, avatarRef, ContentModel.ASSOC_AVATAR);
        ContentService contentService = (ContentService)this.applicationContext.getBean("ContentService", ContentService.class);
        ContentWriter writer = contentService.getWriter(avatarRef, ContentModel.PROP_CONTENT, true);
        writer.guessMimetype(avatarFile.getName());
        writer.putContent(avatarFile);
        Rendition avatarR = new Rendition();
        avatarR.setId("avatar");
        Renditions renditions = (Renditions)this.applicationContext.getBean("Renditions", Renditions.class);
        renditions.createRendition(avatarRef, avatarR, false, null);
        return avatarRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateAvatar() throws PublicApiException, IOException, InterruptedException {
        String person1 = this.account1PersonIt.next();
        String person2 = this.account1PersonIt.next();
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person2));
        AuthenticationUtil.setFullyAuthenticatedUser((String)person2);
        NodeRef personRef = this.personService.getPerson(person2, false);
        this.deleteAvatarDirect(personRef);
        this.people.getAvatar(person2, false, 404);
        ClassPathResource avatar = new ClassPathResource("publicapi/upload/quick.jpg");
        HttpResponse response = this.people.updateAvatar(person2, avatar.getFile(), 200);
        this.people.getAvatar(person2, false, 200);
        this.people.getAvatar(person2, false, 200);
        ClassPathResource avatar2 = new ClassPathResource("test.jpg");
        HttpResponse response2 = this.people.updateAvatar(person2, avatar2.getFile(), 200);
        this.people.getAvatar(person2, false, 200);
        this.people.updateAvatar(person2, avatar2.getFile(), 200);
        this.people.getAvatar("-me-", false, 200);
        avatar2 = new ClassPathResource("publicapi/upload/quick.jpg");
        this.people.updateAvatar("joe@@bloggs.example.com", avatar2.getFile(), 404);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "Wr0ngP4ssw0rd!"));
        avatar2 = new ClassPathResource("publicapi/upload/quick.jpg");
        this.people.updateAvatar(this.account1Admin, avatar2.getFile(), 401);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1));
        avatar2 = new ClassPathResource("publicapi/upload/quick.jpg");
        this.people.updateAvatar(person2, avatar2.getFile(), 403);
        this.people.updateAvatar(person1, avatar2.getFile(), 200);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), this.account1Admin, "admin"));
        this.people.updateAvatar(person1, avatar2.getFile(), 200);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1));
        String nonPerson = "joebloggs@" + this.account1.getId();
        this.people.getPerson(nonPerson, 404);
        avatar = new ClassPathResource("publicapi/upload/quick.jpg");
        this.people.updateAvatar(nonPerson, avatar.getFile(), 404);
        ContentLimitProvider.SimpleFixedLimitProvider limitProvider = (ContentLimitProvider.SimpleFixedLimitProvider)this.applicationContext.getBean("defaultContentLimitProvider", ContentLimitProvider.SimpleFixedLimitProvider.class);
        long defaultSizeLimit = limitProvider.getSizeLimit();
        limitProvider.setSizeLimitString("20000");
        try {
            ClassPathResource avatar3 = new ClassPathResource("publicapi/upload/quick.jpg");
            this.people.updateAvatar(person1, avatar3.getFile(), 413);
        }
        finally {
            limitProvider.setSizeLimitString(Long.toString(defaultSizeLimit));
        }
        ThumbnailService thumbnailService = (ThumbnailService)this.applicationContext.getBean("thumbnailService", ThumbnailService.class);
        thumbnailService.setThumbnailsEnabled(false);
        try {
            avatar = new ClassPathResource("publicapi/upload/quick.jpg");
            this.people.updateAvatar(person1, avatar.getFile(), 501);
        }
        finally {
            thumbnailService.setThumbnailsEnabled(true);
        }
    }

    @Test
    public void removeAvatar() throws IOException, PublicApiException, InterruptedException {
        String person1 = this.account1PersonIt.next();
        String person2 = this.account1PersonIt.next();
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1));
        AuthenticationUtil.setFullyAuthenticatedUser((String)("admin@" + this.account1.getId()));
        ClassPathResource thumbRes = new ClassPathResource("publicapi/upload/quick.jpg");
        NodeRef personRef = this.personService.getPerson(person1, false);
        this.deleteAvatarDirect(personRef);
        this.createAvatarDirect(personRef, thumbRes.getFile());
        this.people.getAvatar(person1, false, 200);
        this.people.deleteAvatarImage(person1, 204);
        String nonPerson = "i-do-not-exist";
        this.people.getPerson(nonPerson, 404);
        this.people.deleteAvatarImage(nonPerson, 404);
        this.setRequestContext(this.account1.getId(), networkAdmin, "wrongPassword");
        this.people.deleteAvatarImage(person1, 401);
        this.publicApiClient.setRequestContext(new RequestContext(this.account1.getId(), person1));
        AuthenticationUtil.setFullyAuthenticatedUser((String)("admin@" + this.account1.getId()));
        thumbRes = new ClassPathResource("test.jpg");
        personRef = this.personService.getPerson(person1, false);
        this.deleteAvatarDirect(personRef);
        this.createAvatarDirect(personRef, thumbRes.getFile());
        this.people.deleteAvatarImage(person2, 403);
    }

    @Test
    public void testListPeopleWithCapabilities() throws Exception {
        String personGuestId = "guest@" + account3.getId();
        this.publicApiClient.setRequestContext(new RequestContext(account3.getId(), this.account3Admin, "admin"));
        PublicApiClient.ListResponse<Person> resp = this.listPeople(Collections.emptyMap(), 200);
        Assert.assertNull((Object)resp.getList().get(0).getCapabilities());
        Map<String, String> parameters = Collections.singletonMap("include", "capabilities");
        PublicApiClient.ListResponse<Person> resp2 = this.listPeople(parameters, 200);
        Person personAdmin = resp2.getList().stream().filter(p -> p.getUserName().equals(this.account3Admin)).findFirst().get();
        Assert.assertNotNull((Object)personAdmin.getCapabilities());
        Assert.assertTrue((boolean)((Boolean)personAdmin.getCapabilities().get("isAdmin")));
        Assert.assertFalse((boolean)((Boolean)personAdmin.getCapabilities().get("isGuest")));
        Assert.assertTrue((boolean)((Boolean)personAdmin.getCapabilities().get("isMutable")));
        System.out.println(resp2.getList());
        Person personGuest = resp2.getList().stream().filter(p -> p.getUserName().equals(personGuestId)).findFirst().get();
        Assert.assertNotNull((Object)personGuest.getCapabilities());
        Assert.assertFalse((boolean)((Boolean)personGuest.getCapabilities().get("isAdmin")));
        Assert.assertTrue((boolean)((Boolean)personGuest.getCapabilities().get("isGuest")));
        Assert.assertFalse((boolean)((Boolean)personGuest.getCapabilities().get("isMutable")));
    }

    @Test
    public void testDisplayName() {
        Person person = new Person();
        Assert.assertNull((Object)person.getDisplayName());
        String firstName = "First";
        person.setFirstName(firstName);
        Assert.assertEquals((Object)firstName, (Object)person.getDisplayName());
        String lastName = "Last";
        person.setLastName(lastName);
        Assert.assertEquals((Object)(firstName + " " + lastName), (Object)person.getDisplayName());
        person = new Person();
        person.setLastName(lastName);
        Assert.assertEquals((Object)lastName, (Object)person.getDisplayName());
    }

    @Override
    public String getScope() {
        return "public";
    }

    private ExpectedComparison expectedFirstName(final Person person) {
        return new ExpectedComparison(){

            @Override
            public void expected(Object other) {
                if (other instanceof Person) {
                    Assert.assertEquals((String)"firstName", (Object)person.getFirstName(), (Object)((Person)other).getFirstName());
                } else {
                    Assert.fail((String)("Not a person? " + other));
                }
            }
        };
    }

    public static class PersonJSONSerializer
    implements JSONAble {
        private final Person personUpdate;

        public PersonJSONSerializer(Person personUpdate) {
            this.personUpdate = personUpdate;
        }

        @Override
        public JSONObject toJSON() {
            JSONObject personJson = new JSONObject();
            if (this.personUpdate.getUserName() != null) {
                personJson.put((Object)"id", (Object)this.personUpdate.getUserName());
            }
            personJson.put((Object)"firstName", (Object)this.personUpdate.getFirstName());
            personJson.put((Object)"lastName", (Object)this.personUpdate.getLastName());
            personJson.put((Object)"description", (Object)this.personUpdate.getDescription());
            personJson.put((Object)"email", (Object)this.personUpdate.getEmail());
            personJson.put((Object)"skypeId", (Object)this.personUpdate.getSkypeId());
            personJson.put((Object)"googleId", (Object)this.personUpdate.getGoogleId());
            personJson.put((Object)"instantMessageId", (Object)this.personUpdate.getInstantMessageId());
            personJson.put((Object)"jobTitle", (Object)this.personUpdate.getJobTitle());
            personJson.put((Object)"location", (Object)this.personUpdate.getLocation());
            org.alfresco.rest.api.model.Company co = this.personUpdate.getCompany();
            if (co == null) {
                co = new org.alfresco.rest.api.model.Company();
            }
            personJson.put((Object)"company", (Object)new Company(co).toJSON());
            personJson.put((Object)"mobile", (Object)this.personUpdate.getMobile());
            personJson.put((Object)"telephone", (Object)this.personUpdate.getTelephone());
            personJson.put((Object)"userStatus", (Object)this.personUpdate.getUserStatus());
            personJson.put((Object)"enabled", (Object)this.personUpdate.isEnabled());
            personJson.put((Object)"emailNotificationsEnabled", (Object)this.personUpdate.isEmailNotificationsEnabled());
            personJson.put((Object)"password", (Object)this.personUpdate.getPassword());
            personJson.put((Object)"properties", (Object)this.personUpdate.getProperties());
            personJson.put((Object)"aspectNames", (Object)this.personUpdate.getAspectNames());
            return personJson;
        }
    }
}

