/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.opencmis.OpenCMISClientContext;
import org.alfresco.opencmis.tck.tests.query.QueryForObjectCustom;
import org.alfresco.opencmis.tck.tests.query.QueryInFolderTestCustom;
import org.alfresco.opencmis.tck.tests.query.QueryLikeTestCustom;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.util.JettyComponent;
import org.alfresco.rest.api.tests.AbstractEnterpriseOpenCMIS10TCKTest;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.chemistry.opencmis.tck.CmisTest;
import org.apache.chemistry.opencmis.tck.CmisTestGroup;
import org.apache.chemistry.opencmis.tck.impl.AbstractSessionTestGroup;
import org.apache.chemistry.opencmis.tck.impl.JUnitHelper;
import org.apache.chemistry.opencmis.tck.tests.control.ControlTestGroup;
import org.apache.chemistry.opencmis.tck.tests.crud.CRUDTestGroup;
import org.apache.chemistry.opencmis.tck.tests.filing.FilingTestGroup;
import org.apache.chemistry.opencmis.tck.tests.query.ContentChangesSmokeTest;
import org.apache.chemistry.opencmis.tck.tests.query.QuerySmokeTest;
import org.apache.chemistry.opencmis.tck.tests.versioning.CheckedOutTest;
import org.apache.chemistry.opencmis.tck.tests.versioning.VersionDeleteTest;
import org.apache.chemistry.opencmis.tck.tests.versioning.VersioningSmokeTest;
import org.apache.chemistry.opencmis.tck.tests.versioning.VersioningStateCreateTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

public class TestEnterpriseAtomPubTCK
extends AbstractEnterpriseOpenCMIS10TCKTest {
    private static final String CMIS_URL = "http://{0}:{1}/{2}/cmisatom";
    protected static final Log logger = LogFactory.getLog(TestEnterpriseAtomPubTCK.class);

    @Override
    @Before
    public void setup() throws Exception {
        final JettyComponent jetty = this.getTestFixture().getJettyComponent();
        SearchService searchService = (SearchService)jetty.getApplicationContext().getBean("searchService");
        NodeService nodeService = (NodeService)jetty.getApplicationContext().getBean("nodeService");
        final FileFolderService fileFolderService = (FileFolderService)jetty.getApplicationContext().getBean("fileFolderService");
        NamespaceService namespaceService = (NamespaceService)jetty.getApplicationContext().getBean("namespaceService");
        TransactionService transactionService = (TransactionService)jetty.getApplicationContext().getBean("transactionService");
        final String name = "abc" + System.currentTimeMillis();
        transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                Repository repositoryHelper = (Repository)jetty.getApplicationContext().getBean("repositoryHelper");
                NodeRef companyHome = repositoryHelper.getCompanyHome();
                fileFolderService.create(companyHome, name, ContentModel.TYPE_FOLDER).getNodeRef();
                return null;
            }
        }, false, true);
        int port = jetty.getPort();
        HashMap<String, String> cmisParameters = new HashMap<String, String>();
        cmisParameters.put("org.apache.chemistry.opencmis.tck.default.relationshipType", "R:cm:replaces");
        cmisParameters.put("org.apache.chemistry.opencmis.tck.default.testFolderParent", "/" + name);
        clientContext = new OpenCMISClientContext(BindingType.ATOMPUB, MessageFormat.format(CMIS_URL, "localhost", String.valueOf(port), "alfresco"), "admin", "admin", cmisParameters, (ApplicationContext)jetty.getApplicationContext());
        this.overrideVersionableAspectProperties((ApplicationContext)jetty.getApplicationContext());
    }

    @Test
    public void testCMISTCKCRUD() throws Exception {
        CRUDTestGroup crudTestGroup = new CRUDTestGroup();
        JUnitHelper.run((CmisTestGroup)crudTestGroup);
    }

    @Test
    public void testCMISTCKVersioning() throws Exception {
        OverrideVersioningTestGroup versioningTestGroup = new OverrideVersioningTestGroup();
        JUnitHelper.run((CmisTestGroup)versioningTestGroup);
    }

    @Test
    public void testCMISTCKFiling() throws Exception {
        FilingTestGroup filingTestGroup = new FilingTestGroup();
        JUnitHelper.run((CmisTestGroup)filingTestGroup);
    }

    @Test
    public void testCMISTCKControl() throws Exception {
        ControlTestGroup controlTestGroup = new ControlTestGroup();
        JUnitHelper.run((CmisTestGroup)controlTestGroup);
    }

    @Test
    @Category(value={LuceneTests.class, RedundantTests.class})
    public void testCMISTCKQuery() throws Exception {
        OverrideQueryTestGroup queryTestGroup = new OverrideQueryTestGroup();
        JUnitHelper.run((CmisTestGroup)queryTestGroup);
    }

    private class OverrideQueryTestGroup
    extends AbstractSessionTestGroup {
        private OverrideQueryTestGroup() {
        }

        public void init(Map<String, String> parameters) throws Exception {
            super.init(parameters);
            this.setName("Query Test Group");
            this.setDescription("Query and content changes tests.");
            this.addTest((CmisTest)new QuerySmokeTest());
            this.addTest((CmisTest)new QueryForObjectCustom());
            this.addTest((CmisTest)new QueryLikeTestCustom());
            this.addTest((CmisTest)new QueryInFolderTestCustom());
            this.addTest((CmisTest)new ContentChangesSmokeTest());
        }
    }

    private class OverrideVersioningTestGroup
    extends AbstractSessionTestGroup {
        private OverrideVersioningTestGroup() {
        }

        public void init(Map<String, String> parameters) throws Exception {
            super.init(parameters);
            this.setName("Versioning Test Group");
            this.setDescription("Versioning tests.");
            this.addTest((CmisTest)new VersioningSmokeTest());
            this.addTest((CmisTest)new VersionDeleteTest());
            this.addTest((CmisTest)new VersioningStateCreateTest());
            this.addTest((CmisTest)new CheckedOutTest());
        }
    }
}

