/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import com.google.common.collect.Ordering;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.alfresco.repo.rendition2.RenditionService2Impl;
import org.alfresco.repo.rendition2.SynchronousTransformClient;
import org.alfresco.rest.api.model.Site;
import org.alfresco.rest.api.nodes.NodesEntityResource;
import org.alfresco.rest.api.tests.AbstractBaseApiTest;
import org.alfresco.rest.api.tests.RepoService;
import org.alfresco.rest.api.tests.client.HttpResponse;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.data.ContentInfo;
import org.alfresco.rest.api.tests.client.data.Document;
import org.alfresco.rest.api.tests.client.data.Rendition;
import org.alfresco.rest.api.tests.util.MultiPartBuilder;
import org.alfresco.rest.api.tests.util.RestApiUtil;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.util.TempFileProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenditionsTest
extends AbstractBaseApiTest {
    RepoService.TestNetwork networkN1;
    private RepoService.TestPerson userOneN1;
    private Site userOneN1Site;
    private static final long DELAY_IN_MS = 500L;
    protected static ContentService contentService;
    private static SynchronousTransformClient synchronousTransformClient;

    @Override
    @Before
    public void setup() throws Exception {
        contentService = (ContentService)this.applicationContext.getBean("contentService", ContentService.class);
        synchronousTransformClient = (SynchronousTransformClient)this.applicationContext.getBean("synchronousTransformClient", SynchronousTransformClient.class);
        this.networkN1 = this.repoService.createNetworkWithAlias("ping", true);
        this.networkN1.create();
        this.userOneN1 = this.networkN1.createUser();
        this.setRequestContext(this.networkN1.getId(), this.userOneN1.getId(), null);
        String siteTitle = "RandomSite" + System.currentTimeMillis();
        this.userOneN1Site = this.createSite(siteTitle, SiteVisibility.PRIVATE);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.setRequestContext(this.networkN1.getId(), this.userOneN1.getId(), null);
        this.deleteSite(this.userOneN1Site.getId(), true, 204);
    }

    @Test
    public void testListNodeRenditions() throws Exception {
        this.setRequestContext(this.networkN1.getId(), this.userOneN1.getId(), null);
        String folderName = "folder" + System.currentTimeMillis();
        String folder_Id = this.addToDocumentLibrary(this.userOneN1Site, folderName, "cm:folder", this.userOneN1.getId());
        String fileName = "quick.pdf";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        HttpResponse response = this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        PublicApiClient.Paging paging = this.getPaging(0, 50);
        response = this.getAll(this.getNodeRenditionsUrl(contentNodeId), paging, 200);
        List<Rendition> renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertTrue((renditions.size() >= 5 ? 1 : 0) != 0);
        Rendition docLib = this.getRendition(renditions, "doclib");
        Assert.assertNotNull((Object)docLib);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.NOT_CREATED), (Object)((Object)docLib.getStatus()));
        ContentInfo contentInfo = docLib.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"image/png", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"PNG Image", (Object)contentInfo.getMimeTypeName());
        Assert.assertNull((Object)contentInfo.getEncoding());
        Assert.assertNull((Object)contentInfo.getSizeInBytes());
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("where", "(status='NOT_CREATED')");
        response = this.getAll(this.getNodeRenditionsUrl(contentNodeId), paging, params, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertTrue((renditions.size() >= 5 ? 1 : 0) != 0);
        params.put("where", "(status='CREATED')");
        response = this.getAll(this.getNodeRenditionsUrl(contentNodeId), paging, params, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertEquals((String)"There is no rendition created yet.", (long)0L, (long)renditions.size());
        paging = this.getPaging(0, 2);
        response = this.getAll(this.getNodeRenditionsUrl(contentNodeId), paging, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertEquals((long)2L, (long)renditions.size());
        PublicApiClient.ExpectedPaging expectedPaging = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertEquals((long)2L, (long)expectedPaging.getCount().intValue());
        Assert.assertEquals((long)0L, (long)expectedPaging.getSkipCount().intValue());
        Assert.assertEquals((long)2L, (long)expectedPaging.getMaxItems().intValue());
        Assert.assertTrue((expectedPaging.getTotalItems() >= 5 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)expectedPaging.getHasMoreItems());
        paging = this.getPaging(2, 3);
        response = this.getAll(this.getNodeRenditionsUrl(contentNodeId), paging, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertEquals((long)3L, (long)renditions.size());
        expectedPaging = RestApiUtil.parsePaging(response.getJsonResponse());
        Assert.assertEquals((long)3L, (long)expectedPaging.getCount().intValue());
        Assert.assertEquals((long)2L, (long)expectedPaging.getSkipCount().intValue());
        Assert.assertEquals((long)3L, (long)expectedPaging.getMaxItems().intValue());
        Assert.assertTrue((expectedPaging.getTotalItems() >= 5 ? 1 : 0) != 0);
        this.createAndGetRendition(contentNodeId, docLib.getId());
        paging = this.getPaging(0, 50);
        response = this.getAll(this.getNodeRenditionsUrl(contentNodeId), paging, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertTrue((renditions.size() >= 5 ? 1 : 0) != 0);
        docLib = this.getRendition(renditions, "doclib");
        Assert.assertNotNull((Object)docLib);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)docLib.getStatus()));
        contentInfo = docLib.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"image/png", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"PNG Image", (Object)contentInfo.getMimeTypeName());
        Assert.assertNotNull((Object)contentInfo.getEncoding());
        Assert.assertTrue((contentInfo.getSizeInBytes() > 0L ? 1 : 0) != 0);
        response = this.getAll(this.getNodeRenditionsUrl(contentNodeId), paging, params, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertEquals((String)"Should've only returned the 'doclib' rendition.", (long)1L, (long)renditions.size());
        params.put("where", "(status='NOT_CREATED')");
        response = this.getAll(this.getNodeRenditionsUrl(contentNodeId), paging, params, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertTrue((renditions.size() > 0 ? 1 : 0) != 0);
        docLib = this.getRendition(renditions, "doclib");
        Assert.assertNull((String)"'doclib' rendition has already been created.", (Object)docLib);
        response = this.getAll(this.getNodeRenditionsUrl(contentNodeId), paging, params, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertTrue((boolean)Ordering.natural().isOrdered(renditions));
        response = this.getAll(this.getNodeRenditionsUrl(contentNodeId), paging, params, 200);
        renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Assert.assertTrue((boolean)Ordering.natural().isOrdered(renditions));
        this.getAll(this.getNodeRenditionsUrl(folder_Id), paging, params, 400);
        this.getAll(this.getNodeRenditionsUrl(UUID.randomUUID().toString()), paging, params, 404);
        String emptyContentNodeId = this.addToDocumentLibrary(this.userOneN1Site, "emptyDoc.txt", "cm:content", this.userOneN1.getId());
        this.getAll(this.getNodeRenditionsUrl(emptyContentNodeId), paging, params, 200);
        params.put("where", "(status='WRONG')");
        this.getAll(this.getNodeRenditionsUrl(contentNodeId), paging, params, 400);
        params.put("where", "(id='doclib')");
        this.getAll(this.getNodeRenditionsUrl(contentNodeId), paging, params, 400);
    }

    @Test
    public void testGetNodeRendition() throws Exception {
        this.setRequestContext(this.networkN1.getId(), this.userOneN1.getId(), null);
        String folderName = "folder" + System.currentTimeMillis();
        String folder_Id = this.addToDocumentLibrary(this.userOneN1Site, folderName, "cm:folder", this.userOneN1.getId());
        String fileName = "quick.pdf";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        HttpResponse response = this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        Thread.sleep(500L);
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "doclib", 200);
        Rendition rendition = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Rendition.class);
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.NOT_CREATED), (Object)((Object)rendition.getStatus()));
        ContentInfo contentInfo = rendition.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"image/png", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"PNG Image", (Object)contentInfo.getMimeTypeName());
        Assert.assertNull((String)"Shouldn't have returned the encoding, as the rendition hasn't been created yet.", (Object)contentInfo.getEncoding());
        Assert.assertNull((String)"Shouldn't have returned the size, as the rendition hasn't been created yet.", (Object)contentInfo.getSizeInBytes());
        rendition = this.createAndGetRendition(contentNodeId, "doclib");
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)rendition.getStatus()));
        contentInfo = rendition.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"image/png", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"PNG Image", (Object)contentInfo.getMimeTypeName());
        Assert.assertNotNull((Object)contentInfo.getEncoding());
        Assert.assertTrue((contentInfo.getSizeInBytes() > 0L ? 1 : 0) != 0);
        this.getSingle(this.getNodeRenditionsUrl(folder_Id), "doclib", 400);
        this.getSingle(this.getNodeRenditionsUrl(UUID.randomUUID().toString()), "doclib", 404);
        this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "renditionId" + System.currentTimeMillis(), 404);
        if (this.areLocalTransformsAvailable()) {
            String emptyContentNodeId = this.addToDocumentLibrary(this.userOneN1Site, "emptyDoc.txt", "cm:content", this.userOneN1.getId());
            this.getSingle(this.getNodeRenditionsUrl(emptyContentNodeId), "doclib", 200);
        }
        String jpgFileName = "quick.jpg";
        File jpgFile = this.getResourceFile(fileName);
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(jpgFileName, jpgFile)).build();
        response = this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document jpgImage = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String jpgImageNodeId = jpgImage.getId();
        response = this.getAll(this.getNodeRenditionsUrl(jpgImageNodeId), this.getPaging(0, 50), 200);
        List<Rendition> renditions = RestApiUtil.parseRestApiEntries(response.getJsonResponse(), Rendition.class);
        Rendition pdf = this.getRendition(renditions, "pdf");
        Assert.assertNull((Object)pdf);
        this.getSingle(this.getNodeRenditionsUrl(jpgImageNodeId), "pdf", 404);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateRendition() throws Exception {
        this.setRequestContext(this.networkN1.getId(), this.userOneN1.getId(), null);
        String folderName = "folder" + System.currentTimeMillis();
        String folder_Id = this.addToDocumentLibrary(this.userOneN1Site, folderName, "cm:folder", this.userOneN1.getId());
        String fileName = "quick.pdf";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        HttpResponse response = this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        Thread.sleep(500L);
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "imgpreview", 200);
        Rendition rendition = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Rendition.class);
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.NOT_CREATED), (Object)((Object)rendition.getStatus()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("placeholder", "false");
        this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "doclib/content", params, 404);
        params = new HashMap();
        params.put("placeholder", "true");
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "doclib/content", params, 200);
        Assert.assertNotNull((Object)response.getResponseAsBytes());
        rendition = this.createAndGetRendition(contentNodeId, "imgpreview");
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)rendition.getStatus()));
        ContentInfo contentInfo = rendition.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"image/jpeg", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"JPEG Image", (Object)contentInfo.getMimeTypeName());
        Assert.assertNotNull((Object)contentInfo.getEncoding());
        Assert.assertTrue((contentInfo.getSizeInBytes() > 0L ? 1 : 0) != 0);
        Rendition renditionRequest = new Rendition().setId("doclib");
        if (this.areLocalTransformsAvailable()) {
            String emptyContentNodeId = this.addToDocumentLibrary(this.userOneN1Site, "emptyDoc.txt", "cm:content", this.userOneN1.getId());
            this.post(this.getNodeRenditionsUrl(emptyContentNodeId), RestApiUtil.toJsonAsString(renditionRequest), 202);
            String content = "The quick brown fox jumps over the lazy dog.";
            file = TempFileProvider.createTempFile((InputStream)new ByteArrayInputStream(content.getBytes()), (String)this.getClass().getSimpleName(), (String)".bin");
            multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("binaryFileName", file));
            reqBody = multiPartBuilder.build();
            response = this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
            Document binaryDocument = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
            this.post(this.getNodeRenditionsUrl(binaryDocument.getId()), RestApiUtil.toJsonAsString(renditionRequest), 202);
        }
        response = this.post(this.getNodeRenditionsUrl(contentNodeId), RestApiUtil.toJsonAsString(new Rendition().setId("imgpreview")), 409);
        PublicApiClient.ExpectedErrorResponse errorResponse = RestApiUtil.parseErrorResponse(response.getJsonResponse());
        Assert.assertNotNull((Object)errorResponse);
        Assert.assertNotNull((Object)errorResponse.getErrorKey());
        Assert.assertNotNull((Object)errorResponse.getBriefSummary());
        Assert.assertNotNull((Object)errorResponse.getStackTrace());
        Assert.assertNotNull((Object)errorResponse.getDescriptionURL());
        Assert.assertEquals((long)409L, (long)errorResponse.getStatusCode());
        this.post(this.getNodeRenditionsUrl(folder_Id), RestApiUtil.toJsonAsString(renditionRequest), 400);
        response = this.post(this.getNodeRenditionsUrl(UUID.randomUUID().toString()), RestApiUtil.toJsonAsString(renditionRequest), 404);
        errorResponse = RestApiUtil.parseErrorResponse(response.getJsonResponse());
        Assert.assertNotNull((Object)errorResponse);
        Assert.assertNotNull((Object)errorResponse.getErrorKey());
        Assert.assertNotNull((Object)errorResponse.getBriefSummary());
        Assert.assertNotNull((Object)errorResponse.getStackTrace());
        Assert.assertNotNull((Object)errorResponse.getDescriptionURL());
        Assert.assertEquals((long)404L, (long)errorResponse.getStatusCode());
        String randomRenditionId = "renditionId" + System.currentTimeMillis();
        this.post(this.getNodeRenditionsUrl(contentNodeId), RestApiUtil.toJsonAsString(new Rendition().setId(randomRenditionId)), 404);
        this.post(this.getNodeRenditionsUrl(contentNodeId), RestApiUtil.toJsonAsString(new Rendition().setId(null)), 400);
        this.post(this.getNodeRenditionsUrl(contentNodeId), RestApiUtil.toJsonAsString(new Rendition().setId("")), 400);
        ArrayList<Rendition> multipleRenditionRequest = new ArrayList<Rendition>(2);
        multipleRenditionRequest.add(new Rendition().setId(""));
        multipleRenditionRequest.add(new Rendition().setId("medium"));
        this.post(this.getNodeRenditionsUrl(contentNodeId), RestApiUtil.toJsonAsString(multipleRenditionRequest), 400);
        multipleRenditionRequest = new ArrayList(3);
        multipleRenditionRequest.add(new Rendition().setId("doclib"));
        multipleRenditionRequest.add(new Rendition().setId("medium"));
        multipleRenditionRequest.add(new Rendition().setId("avatar,avatar32"));
        this.post(this.getNodeRenditionsUrl(contentNodeId), RestApiUtil.toJsonAsString(multipleRenditionRequest), 202);
        this.assertRenditionCreatedWithWait(contentNodeId, "doclib", "medium", "avatar", "avatar32");
        multipleRenditionRequest = new ArrayList(2);
        multipleRenditionRequest.add(new Rendition().setId("doclib"));
        multipleRenditionRequest.add(new Rendition().setId("medium"));
        multipleRenditionRequest.add(new Rendition().setId("avatar"));
        this.post(this.getNodeRenditionsUrl(contentNodeId), RestApiUtil.toJsonAsString(multipleRenditionRequest), 409);
        RenditionService2Impl renditionService2 = (RenditionService2Impl)this.applicationContext.getBean("renditionService2", RenditionService2Impl.class);
        renditionService2.setThumbnailsEnabled(false);
        try {
            String txtFileName = "quick-1.txt";
            File txtFile = this.getResourceFile(fileName);
            reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(txtFileName, txtFile)).build();
            response = this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
            Document txtDocument = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
            response = this.post(this.getNodeRenditionsUrl(txtDocument.getId()), RestApiUtil.toJsonAsString(renditionRequest), 501);
            errorResponse = RestApiUtil.parseErrorResponse(response.getJsonResponse());
            Assert.assertNotNull((Object)errorResponse);
            Assert.assertNotNull((Object)errorResponse.getErrorKey());
            Assert.assertNotNull((Object)errorResponse.getBriefSummary());
            Assert.assertNotNull((Object)errorResponse.getStackTrace());
            Assert.assertNotNull((Object)errorResponse.getDescriptionURL());
            Assert.assertEquals((long)501L, (long)errorResponse.getStatusCode());
        }
        finally {
            renditionService2.setThumbnailsEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateRenditionOnUpload() throws Exception {
        String userId = this.userOneN1.getId();
        this.setRequestContext(this.networkN1.getId(), this.userOneN1.getId(), null);
        String folderName = "folder" + System.currentTimeMillis();
        String folder_Id = this.addToDocumentLibrary(this.userOneN1Site, folderName, "cm:folder", userId);
        String renditionName = "doclib";
        String fileName = "quick.pdf";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder.MultiPartRequest reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file)).setRenditions(Collections.singletonList(renditionName)).build();
        HttpResponse response = this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        Rendition rendition = this.waitAndGetRendition(contentNodeId, null, renditionName);
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)rendition.getStatus()));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("placeholder", "false");
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "doclib/content", params, 200);
        Assert.assertNotNull((Object)response.getResponseAsBytes());
        if (this.areLocalTransformsAvailable()) {
            renditionName = "doclib";
            fileName = "farmers_markets_list_2003.doc";
            file = this.getResourceFile(fileName);
            reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file)).setRenditions(Collections.singletonList(renditionName)).build();
            response = this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
            document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
            contentNodeId = document.getId();
            this.assertRenditionCreatedWithWait(contentNodeId, renditionName);
        }
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file)).setAutoRename(true).setRenditions(Arrays.asList("doclib,imgpreview")).build();
        this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file)).setAutoRename(true).setRenditions(Arrays.asList("unknown")).build();
        this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, reqBody.getContentType(), 404);
        ThumbnailService thumbnailService = (ThumbnailService)this.applicationContext.getBean("thumbnailService", ThumbnailService.class);
        thumbnailService.setThumbnailsEnabled(false);
        try {
            String txtFileName = "quick-1.txt";
            File txtFile = this.getResourceFile(fileName);
            reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(txtFileName, txtFile)).setRenditions(Arrays.asList("doclib")).build();
            this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        }
        finally {
            thumbnailService.setThumbnailsEnabled(true);
        }
    }

    protected void assertRenditionCreatedWithWait(String contentNodeId, String ... renditionNames) throws Exception {
        for (String renditionName : renditionNames) {
            Rendition rendition = this.waitAndGetRendition(contentNodeId, null, renditionName);
            Assert.assertNotNull((Object)rendition);
            Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)rendition.getStatus()));
        }
    }

    @Test
    public void testCreateRenditionForNewVersion() throws Exception {
        String PROP_LTM = "cm:lastThumbnailModification";
        String RENDITION_NAME = "imgpreview";
        String userId = this.userOneN1.getId();
        this.setRequestContext(this.networkN1.getId(), this.userOneN1.getId(), null);
        String folderName = "folder" + System.currentTimeMillis();
        String folder_Id = this.addToDocumentLibrary(this.userOneN1Site, folderName, "cm:folder", userId);
        String fileName = "quick.pdf";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder.MultiPartRequest reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file)).build();
        Map<String, String> params = Collections.singletonMap("include", "properties");
        HttpResponse response = this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), params, null, "alfresco", reqBody.getContentType(), 201);
        Document document1 = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document1.getId();
        Assert.assertNotNull(document1.getProperties());
        Assert.assertNull((Object)document1.getProperties().get(PROP_LTM));
        Thread.sleep(500L);
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), RENDITION_NAME, 200);
        Rendition rendition = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Rendition.class);
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.NOT_CREATED), (Object)((Object)rendition.getStatus()));
        params = new HashMap<String, String>();
        params.put("placeholder", "false");
        this.getSingle(this.getNodeRenditionsUrl(contentNodeId), RENDITION_NAME + "/content", params, 404);
        rendition = this.createAndGetRendition(contentNodeId, RENDITION_NAME);
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)rendition.getStatus()));
        ContentInfo contentInfo = rendition.getContent();
        Assert.assertNotNull((Object)contentInfo);
        Assert.assertEquals((Object)"image/jpeg", (Object)contentInfo.getMimeType());
        Assert.assertEquals((Object)"JPEG Image", (Object)contentInfo.getMimeTypeName());
        Assert.assertNotNull((Object)contentInfo.getEncoding());
        Assert.assertTrue((contentInfo.getSizeInBytes() > 0L ? 1 : 0) != 0);
        params = new HashMap<String, String>();
        params.put("placeholder", "false");
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), RENDITION_NAME + "/content", params, 200);
        byte[] renditionBytes1 = response.getResponseAsBytes();
        Assert.assertNotNull((Object)renditionBytes1);
        params = Collections.singletonMap("include", "properties");
        response = this.getSingle(NodesEntityResource.class, contentNodeId, params, 200);
        Document document1b = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)document1b.getModifiedByUser().getId(), (Object)document1.getModifiedByUser().getId());
        Assert.assertEquals((Object)document1b.getModifiedByUser().getDisplayName(), (Object)document1.getModifiedByUser().getDisplayName());
        Assert.assertNotEquals((Object)document1b.getProperties().get(PROP_LTM), (Object)document1.getProperties().get(PROP_LTM));
        fileName = "quick-2.pdf";
        file = this.getResourceFile(fileName);
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData("quick.pdf", file)).setOverwrite(true).build();
        response = this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, null, "alfresco", reqBody.getContentType(), 201);
        Document document2 = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)contentNodeId, (Object)document2.getId());
        Thread.sleep(2000L);
        params = new HashMap<String, String>();
        params.put("placeholder", "false");
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), RENDITION_NAME + "/content", params, 200);
        Assert.assertNotNull((Object)response.getResponseAsBytes());
        Assert.assertNotEquals((Object)renditionBytes1, (Object)response.getResponseAsBytes());
        params = Collections.singletonMap("include", "properties");
        response = this.getSingle(NodesEntityResource.class, contentNodeId, params, 200);
        Document document2b = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        Assert.assertEquals((Object)document2b.getModifiedByUser().getId(), (Object)document1.getModifiedByUser().getId());
        Assert.assertEquals((Object)document2b.getModifiedByUser().getDisplayName(), (Object)document1.getModifiedByUser().getDisplayName());
        Assert.assertNotEquals((Object)document2b.getProperties().get(PROP_LTM), (Object)document1b.getProperties().get(PROP_LTM));
    }

    @Test
    public void testDownloadRendition() throws Exception {
        this.setRequestContext(this.networkN1.getId(), this.userOneN1.getId(), null);
        String folderName = "folder" + System.currentTimeMillis();
        String folder_Id = this.addToDocumentLibrary(this.userOneN1Site, folderName, "cm:folder", this.userOneN1.getId());
        String fileName = "quick.pdf";
        File file = this.getResourceFile(fileName);
        MultiPartBuilder multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file));
        MultiPartBuilder.MultiPartRequest reqBody = multiPartBuilder.build();
        HttpResponse response = this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        Document document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        String contentNodeId = document.getId();
        Thread.sleep(500L);
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "doclib", 200);
        Rendition rendition = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Rendition.class);
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.NOT_CREATED), (Object)((Object)rendition.getStatus()));
        Map<String, String> params = new HashMap<String, String>();
        params.put("placeholder", "true");
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "doclib/content", params, 200);
        Assert.assertNotNull((Object)response.getResponseAsBytes());
        Map<String, String> responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        String contentDisposition = responseHeaders.get("Content-Disposition");
        Assert.assertNotNull((Object)contentDisposition);
        Assert.assertTrue((boolean)contentDisposition.contains("filename=\"doclib\""));
        String contentType = responseHeaders.get("Content-Type");
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.startsWith("image/png"));
        params.put("attachment", "false");
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "doclib/content", params, 200);
        Assert.assertNotNull((Object)response.getResponseAsBytes());
        responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        String cacheControl = responseHeaders.get("Cache-Control");
        Assert.assertNotNull((Object)cacheControl);
        Assert.assertTrue((boolean)cacheControl.contains("must-revalidate"));
        Assert.assertNull((Object)responseHeaders.get("Content-Disposition"));
        contentType = responseHeaders.get("Content-Type");
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.startsWith("image/png"));
        String lastModifiedHeader = responseHeaders.get("Last-Modified");
        Assert.assertNotNull((Object)lastModifiedHeader);
        Map<String, String> headers = Collections.singletonMap("If-Modified-Since", lastModifiedHeader);
        this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "doclib/content", params, headers, 200);
        rendition = this.createAndGetRendition(contentNodeId, "doclib");
        Assert.assertNotNull((Object)rendition);
        Assert.assertEquals((Object)((Object)Rendition.RenditionStatus.CREATED), (Object)((Object)rendition.getStatus()));
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "doclib/content", 200);
        Assert.assertNotNull((Object)response.getResponseAsBytes());
        responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        contentDisposition = responseHeaders.get("Content-Disposition");
        Assert.assertNotNull((Object)contentDisposition);
        Assert.assertTrue((boolean)contentDisposition.contains("filename=\"doclib\""));
        contentType = responseHeaders.get("Content-Type");
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.startsWith("image/png"));
        params = Collections.singletonMap("attachment", "false");
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "doclib/content", params, 200);
        Assert.assertNotNull((Object)response.getResponseAsBytes());
        responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        Assert.assertNull((Object)responseHeaders.get("Content-Disposition"));
        contentType = responseHeaders.get("Content-Type");
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.startsWith("image/png"));
        params = Collections.singletonMap("attachment", "true");
        response = this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "doclib/content", params, 200);
        Assert.assertNotNull((Object)response.getResponseAsBytes());
        responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        cacheControl = responseHeaders.get("Cache-Control");
        Assert.assertNotNull((Object)cacheControl);
        Assert.assertFalse((boolean)cacheControl.contains("must-revalidate"));
        Assert.assertTrue((boolean)cacheControl.contains("max-age=31536000"));
        contentDisposition = responseHeaders.get("Content-Disposition");
        Assert.assertNotNull((Object)contentDisposition);
        Assert.assertTrue((boolean)contentDisposition.contains("filename=\"doclib\""));
        contentType = responseHeaders.get("Content-Type");
        Assert.assertNotNull((Object)contentType);
        Assert.assertTrue((boolean)contentType.startsWith("image/png"));
        lastModifiedHeader = responseHeaders.get("Last-Modified");
        Assert.assertNotNull((Object)lastModifiedHeader);
        headers = Collections.singletonMap("If-Modified-Since", lastModifiedHeader);
        this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "doclib/content", params, headers, 304);
        file = this.getResourceFile("quick-2.pdf");
        multiPartBuilder = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(fileName, file)).setOverwrite(true);
        reqBody = multiPartBuilder.build();
        this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        response = this.getSingleWithDelayRetry(this.getNodeRenditionsUrl(contentNodeId), "doclib/content", params, headers, 20, 5000L, 200);
        Assert.assertNotNull((Object)response);
        responseHeaders = response.getHeaders();
        Assert.assertNotNull(responseHeaders);
        String newLastModifiedHeader = responseHeaders.get("Last-Modified");
        Assert.assertNotNull((Object)newLastModifiedHeader);
        Assert.assertNotEquals((Object)lastModifiedHeader, (Object)newLastModifiedHeader);
        this.getSingle(this.getNodeRenditionsUrl(folder_Id), "doclib/content", 400);
        this.getSingle(this.getNodeRenditionsUrl(UUID.randomUUID().toString()), "doclib/content", 404);
        this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "renditionId" + System.currentTimeMillis() + "/content", 404);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("The quick brown fox jumps over the lazy dog".getBytes());
        file = TempFileProvider.createTempFile((InputStream)inputStream, (String)"RenditionsTest-", (String)".abcdef");
        reqBody = MultiPartBuilder.create().setFileData(new MultiPartBuilder.FileData(file.getName(), file)).build();
        response = this.post(this.getNodeChildrenUrl(folder_Id), reqBody.getBody(), null, reqBody.getContentType(), 201);
        document = RestApiUtil.parseRestApiEntry(response.getJsonResponse(), Document.class);
        contentNodeId = document.getId();
        this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "doclib/content", 404);
        params = Collections.singletonMap("placeholder", "false");
        this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "doclib/content", params, 404);
        params = Collections.singletonMap("placeholder", "true");
        this.getSingle(this.getNodeRenditionsUrl(contentNodeId), "renditionId" + System.currentTimeMillis() + "/content", params, 404);
        String emptyContentNodeId = this.addToDocumentLibrary(this.userOneN1Site, "emptyDoc.txt", "cm:content", this.userOneN1.getId());
        this.getSingle(this.getNodeRenditionsUrl(emptyContentNodeId), "doclib/content", params, 200);
    }

    private String addToDocumentLibrary(Site testSite, String name, String nodeType, String userId) throws Exception {
        String parentId = this.getSiteContainerNodeId(testSite.getId(), "documentLibrary");
        return this.createNode(parentId, name, nodeType, null).getId();
    }

    private Rendition getRendition(List<Rendition> renditions, String renditionName) {
        for (Rendition rn : renditions) {
            if (!rn.getId().equals(renditionName)) continue;
            return rn;
        }
        return null;
    }

    @Override
    public String getScope() {
        return "public";
    }

    protected boolean areLocalTransformsAvailable() {
        return synchronousTransformClient.isSupported("application/msword", -1L, null, "application/pdf", Collections.emptyMap(), null, null);
    }
}

