/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.api.tests;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authority.AuthorityDAOImpl;
import org.alfresco.rest.AbstractSingleNetworkSiteTest;
import org.alfresco.rest.api.tests.client.PublicApiClient;
import org.alfresco.rest.api.tests.client.PublicApiException;
import org.alfresco.rest.api.tests.client.RequestContext;
import org.alfresco.rest.api.tests.client.data.Group;
import org.alfresco.rest.api.tests.client.data.GroupMember;
import org.alfresco.rest.api.tests.client.data.Person;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.util.GUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;

public class GroupsTest
extends AbstractSingleNetworkSiteTest {
    private static final String MEMBER_TYPE_GROUP = "GROUP";
    private static final String MEMBER_TYPE_PERSON = "PERSON";
    private static final String GROUP_EVERYONE = "GROUP_EVERYONE";
    protected AuthorityService authorityService;
    private String rootGroupName = null;
    private Group rootGroup = null;
    private Group groupA = null;
    private Group groupB = null;
    private GroupMember groupMemberA = null;
    private GroupMember groupMemberB = null;
    private GroupMember personMember = null;
    @Mock
    private ResultSetRow groupAResultSetRow;
    @Mock
    private ResultSetRow groupBResultSetRow;
    @Mock
    private Iterator iterator;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.authorityService = (AuthorityService)this.applicationContext.getBean("AuthorityService");
        AuthorityDAOImpl authorityDAOImpl = (AuthorityDAOImpl)this.applicationContext.getBean("authorityDAO");
        authorityDAOImpl.setSearchService(this.mockSearchService);
        Mockito.when((Object)this.mockSearchServiceQueryResultSet.iterator()).thenReturn((Object)this.iterator);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testGetGroups() throws Exception {
        try {
            this.createAuthorityContext(user1);
            this.setRequestContext(user1);
            this.testGetGroupsSorting();
            this.testGetGroupsWithInclude();
            this.testGetGroupsSkipPaging();
            this.testGetGroupsByIsRoot(true);
            this.testGetGroupsByIsRoot(false);
            this.testGetGroupsWithZoneFilter();
            this.testGetGroupsWithDisplayNameFilter();
        }
        finally {
            this.clearAuthorityContext();
        }
    }

    private void testGetGroupsSkipPaging() throws Exception {
        HashMap<String, String> otherParams = new HashMap<String, String>();
        this.addOrderBy(otherParams, "displayName", false);
        int skipCount = 0;
        int maxItems = 4;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
        PublicApiClient.ListResponse<Group> resp = this.getGroups(paging, otherParams);
        skipCount = 2;
        maxItems = 2;
        paging = this.getPaging(skipCount, maxItems);
        PublicApiClient.ListResponse<Group> sublistResponse = this.getGroups(paging, otherParams);
        List<Group> expectedSublist = this.sublist(resp.getList(), skipCount, maxItems);
        this.checkList(expectedSublist, sublistResponse.getPaging(), sublistResponse);
        this.getGroups(this.getPaging(-1, null), null, "", 400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetGroupsSorting() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        this.addOrderBy(otherParams, "displayName", null);
        PublicApiClient.ListResponse<Group> resp = this.getGroups(paging, otherParams);
        List<Group> groups = resp.getList();
        Assert.assertTrue((String)"groups order not valid", (groups.indexOf(this.groupA) < groups.indexOf(this.groupB) ? 1 : 0) != 0);
        this.addOrderBy(otherParams, "displayName", true);
        PublicApiClient.ListResponse<Group> respOrderAsc = this.getGroups(paging, otherParams);
        this.checkList(respOrderAsc.getList(), resp.getPaging(), resp);
        paging = this.getPaging(0, Integer.MAX_VALUE);
        otherParams = new HashMap();
        this.addOrderBy(otherParams, "displayName", null);
        PublicApiClient.ListResponse<Group> respCannedQuery = this.getGroups(paging, otherParams);
        otherParams.put("where", "(isRoot=true)");
        PublicApiClient.ListResponse<Group> respPostProcess = this.getGroups(paging, otherParams);
        List<Group> expected = respCannedQuery.getList();
        expected.retainAll(respPostProcess.getList());
        this.checkList(expected, respPostProcess.getPaging(), respPostProcess);
        paging = this.getPaging(0, Integer.MAX_VALUE);
        otherParams = new HashMap();
        this.addOrderBy(otherParams, "id", null);
        respCannedQuery = this.getGroups(paging, otherParams);
        otherParams.put("where", "(isRoot=true)");
        respPostProcess = this.getGroups(paging, otherParams);
        expected = respCannedQuery.getList();
        expected.retainAll(respPostProcess.getList());
        this.checkList(expected, respPostProcess.getPaging(), respPostProcess);
        paging = this.getPaging(0, Integer.MAX_VALUE);
        otherParams = new HashMap();
        this.addOrderBy(otherParams, "displayName", true);
        resp = this.getGroups(paging, otherParams);
        groups = resp.getList();
        Assert.assertTrue((String)"groups order not valid", (groups.indexOf(this.groupA) < groups.indexOf(this.groupB) ? 1 : 0) != 0);
        paging = this.getPaging(0, Integer.MAX_VALUE);
        otherParams = new HashMap();
        this.addOrderBy(otherParams, "id", false);
        resp = this.getGroups(paging, otherParams);
        groups = resp.getList();
        Assert.assertTrue((String)"groups order not valid", (groups.indexOf(this.groupB) < groups.indexOf(this.groupA) ? 1 : 0) != 0);
        paging = this.getPaging(0, Integer.MAX_VALUE);
        otherParams = new HashMap();
        otherParams.put("orderBy", "id ASC,displayName ASC");
        this.getGroups(paging, otherParams, "", 400);
        Group aardvark = new Group();
        Group gecko = new Group();
        try {
            aardvark.setId("GROUP_AARDVARK");
            aardvark.setDisplayName("Aardvark");
            this.authorityService.createAuthority(AuthorityType.GROUP, aardvark.getId());
            this.authorityService.setAuthorityDisplayName(aardvark.getId(), aardvark.getDisplayName());
            gecko.setId("GROUP_GECKO");
            gecko.setDisplayName("Aaaaah, a gecko!");
            this.authorityService.createAuthority(AuthorityType.GROUP, gecko.getId());
            this.authorityService.setAuthorityDisplayName(gecko.getId(), gecko.getDisplayName());
            HashMap<String, String> params = new HashMap<String, String>();
            this.addOrderBy(params, "id", true);
            PublicApiClient.ListResponse<Group> response = this.getGroups(this.getPaging(0, Integer.MAX_VALUE), params, "Couldn't get user's groups", 200);
            Group groupEveryone = new Group();
            groupEveryone.setId(GROUP_EVERYONE);
            List<Group> groups2 = response.getList();
            Assert.assertFalse((boolean)groups2.isEmpty());
            if (groups2.contains(groupEveryone)) {
                Assert.assertTrue((groups2.indexOf(aardvark) < groups2.indexOf(groupEveryone) ? 1 : 0) != 0);
                Assert.assertTrue((groups2.indexOf(groupEveryone) < groups2.indexOf(gecko) ? 1 : 0) != 0);
            }
            Assert.assertTrue((groups2.indexOf(aardvark) < groups2.indexOf(gecko) ? 1 : 0) != 0);
        }
        finally {
            this.authorityService.deleteAuthority(aardvark.getId());
            this.authorityService.deleteAuthority(gecko.getId());
        }
    }

    private void testGetGroupsWithInclude() throws Exception {
        int maxItems = 2;
        PublicApiClient.Paging paging = this.getPaging(0, maxItems);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        PublicApiClient.ListResponse<Group> resp = this.getGroups(paging, null);
        Assert.assertNotNull(resp);
        Assert.assertNotNull(resp.getList());
        Assert.assertFalse((boolean)resp.getList().isEmpty());
        Assert.assertEquals((long)maxItems, (long)resp.getList().size());
        resp.getList().forEach(group -> this.validateGroupDefaultFields((Group)group));
        otherParams.put("include", "parentIds");
        resp = this.getGroups(paging, otherParams);
        Assert.assertEquals((long)maxItems, (long)resp.getList().size());
        resp.getList().forEach(group -> {
            Assert.assertNotNull((Object)group);
            Assert.assertNotNull((Object)group.getParentIds());
        });
        otherParams.put("include", "zones");
        resp = this.getGroups(paging, otherParams);
        Assert.assertEquals((long)maxItems, (long)resp.getList().size());
        resp.getList().forEach(group -> {
            Assert.assertNotNull((Object)group);
            Assert.assertNotNull((Object)group.getZones());
        });
    }

    private void testGetGroupsByIsRoot(boolean isRoot) throws Exception {
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(isRoot=" + isRoot + ")");
        PublicApiClient.Paging paging = this.getPaging(0, 4);
        PublicApiClient.ListResponse<Group> resp = this.getGroups(paging, otherParams);
        resp.getList().forEach(group -> {
            this.validateGroupDefaultFields((Group)group);
            Assert.assertEquals((String)("isRoot was expected to be " + isRoot), (Object)isRoot, (Object)group.getIsRoot());
        });
    }

    private void testGetGroupsWithZoneFilter() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("include", "zones");
        otherParams.put("where", "(zones in ('APP.DEFAULT'))");
        PublicApiClient.ListResponse<Group> response = this.getGroups(paging, otherParams);
        List<Group> groups = response.getList();
        Assert.assertFalse((boolean)groups.isEmpty());
        groups.forEach(group -> Assert.assertTrue((boolean)group.getZones().contains("APP.DEFAULT")));
        paging = this.getPaging(0, Integer.MAX_VALUE);
        otherParams = new HashMap();
        this.addOrderBy(otherParams, "displayName", true);
        otherParams.put("include", "zones");
        otherParams.put("where", "(zones in ('APITEST.MYZONE'))");
        response = this.getGroups(paging, otherParams);
        groups = response.getList();
        Assert.assertEquals((long)3L, (long)groups.size());
        Assert.assertEquals((Object)this.groupA, (Object)groups.get(0));
        Assert.assertEquals((Object)this.groupB, (Object)groups.get(1));
        Assert.assertEquals((Object)this.rootGroup, (Object)groups.get(2));
        groups.forEach(group -> Assert.assertTrue((boolean)group.getZones().contains("APITEST.MYZONE")));
        otherParams.put("where", "(zones in ('APITEST.ANOTHER'))");
        response = this.getGroups(paging, otherParams);
        groups = response.getList();
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)this.groupA, (Object)groups.get(0));
        Assert.assertTrue((boolean)groups.get(0).getZones().contains("APITEST.MYZONE"));
        Assert.assertTrue((boolean)groups.get(0).getZones().contains("APITEST.ANOTHER"));
        paging = this.getPaging(0, Integer.MAX_VALUE);
        otherParams = new HashMap();
        this.addOrderBy(otherParams, "displayName", true);
        otherParams.put("where", "(zones in ('APITEST.MYZONE'))");
        Assert.assertFalse((boolean)otherParams.containsKey("include"));
        response = this.getGroups(paging, otherParams);
        groups = response.getList();
        Assert.assertEquals((long)3L, (long)groups.size());
        Assert.assertEquals((Object)this.groupA, (Object)groups.get(0));
        Assert.assertEquals((Object)this.groupB, (Object)groups.get(1));
        Assert.assertEquals((Object)this.rootGroup, (Object)groups.get(2));
        groups.forEach(group -> Assert.assertNull((Object)group.getZones()));
        paging = this.getPaging(0, Integer.MAX_VALUE);
        otherParams = new HashMap();
        this.addOrderBy(otherParams, "displayName", true);
        otherParams.put("include", "zones");
        otherParams.put("where", "(isRoot=true AND zones in ('APITEST.MYZONE'))");
        response = this.getGroups(paging, otherParams);
        groups = response.getList();
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)this.rootGroup, (Object)groups.get(0));
        Assert.assertTrue((boolean)groups.get(0).getZones().contains("APITEST.MYZONE"));
        otherParams.put("where", "(isRoot=true AND zones in ('I.DO.NOT.EXIST'))");
        response = this.getGroups(paging, otherParams, "Incorrect response", 200);
        groups = response.getList();
        Assert.assertTrue((boolean)groups.isEmpty());
        paging = this.getPaging(0, Integer.MAX_VALUE);
        otherParams = new HashMap();
        this.addOrderBy(otherParams, "displayName", true);
        otherParams.put("where", "(isRoot=false AND zones in ('APITEST.MYZONE'))");
        response = this.getGroups(paging, otherParams);
        groups = response.getList();
        Assert.assertEquals((long)2L, (long)groups.size());
        Assert.assertEquals((Object)this.groupA, (Object)groups.get(0));
        Assert.assertEquals((Object)this.groupB, (Object)groups.get(1));
        groups.forEach(group -> Assert.assertNull((Object)group.getZones()));
        otherParams.put("where", "(isRoot=false AND zones in ('I.DO.NOT.EXIST'))");
        response = this.getGroups(paging, otherParams, "Incorrect response", 200);
        groups = response.getList();
        Assert.assertTrue((boolean)groups.isEmpty());
        paging = this.getPaging(0, Integer.MAX_VALUE);
        otherParams = new HashMap();
        otherParams.put("include", "zones");
        otherParams.put("where", "(zones in ())");
        this.getGroups(paging, otherParams, "Incorrect response", 400);
        otherParams.put("where", "(zones in (''))");
        this.getGroups(paging, otherParams, "Incorrect response", 400);
        otherParams.put("where", "(zones in ('APP.DEFAULT', 'APITEST.MYZONE'))");
        this.getGroups(paging, otherParams, "Incorrect response", 400);
        otherParams.put("where", "(zones in ('', 'APP.DEFAULT', '', 'APITEST.MYZONE'))");
        this.getGroups(paging, otherParams, "Incorrect response", 400);
        otherParams.put("where", "(isRoot=true OR zones in ('APP.DEFAULT'))");
        this.getGroups(paging, otherParams, "Incorrect response", 400);
    }

    private PublicApiClient.ListResponse<Group> getGroups(PublicApiClient.Paging paging, Map<String, String> otherParams, String errorMessage, int expectedStatus) throws Exception {
        PublicApiClient.Groups groupsProxy = this.publicApiClient.groups();
        return groupsProxy.getGroups(this.createParams(paging, otherParams), errorMessage, expectedStatus);
    }

    private PublicApiClient.ListResponse<Group> getGroups(PublicApiClient.Paging paging, Map<String, String> otherParams) throws Exception {
        return this.getGroups(paging, otherParams, "Failed to get groups", 200);
    }

    private void addOrderBy(Map<String, String> otherParams, String sortColumn, Boolean asc) {
        otherParams.put("orderBy", sortColumn + (String)(asc != null ? " " + (asc != false ? "ASC" : "DESC") : ""));
    }

    private void createAuthorityContext(String userName) throws PublicApiException {
        String groupName = "Group_ROOT" + GUID.generate();
        AuthenticationUtil.setRunAsUser((String)userName);
        if (this.rootGroupName == null) {
            this.rootGroupName = this.authorityService.getName(AuthorityType.GROUP, groupName);
        }
        if (!this.authorityService.authorityExists(this.rootGroupName)) {
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            this.rootGroupName = this.authorityService.createAuthority(AuthorityType.GROUP, groupName);
            this.authorityService.addAuthorityToZones(this.rootGroupName, this.zoneSet("APITEST.MYZONE"));
            this.authorityService.setAuthorityDisplayName(this.rootGroupName, "Root Group");
            String groupBAuthorityName = this.authorityService.createAuthority(AuthorityType.GROUP, "Test_GroupB" + GUID.generate());
            this.authorityService.setAuthorityDisplayName(groupBAuthorityName, "B Group");
            this.authorityService.addAuthority(this.rootGroupName, groupBAuthorityName);
            this.authorityService.addAuthorityToZones(groupBAuthorityName, this.zoneSet("APITEST.MYZONE"));
            Mockito.when((Object)this.groupBResultSetRow.getNodeRef()).thenReturn((Object)this.authorityService.getAuthorityNodeRef(groupBAuthorityName));
            String groupAAuthorityName = this.authorityService.createAuthority(AuthorityType.GROUP, "Test_GroupA" + GUID.generate());
            this.authorityService.setAuthorityDisplayName(groupAAuthorityName, "A Group");
            this.authorityService.addAuthority(this.rootGroupName, groupAAuthorityName);
            this.authorityService.addAuthorityToZones(groupAAuthorityName, this.zoneSet("APITEST.MYZONE", "APITEST.ANOTHER"));
            Mockito.when((Object)this.groupAResultSetRow.getNodeRef()).thenReturn((Object)this.authorityService.getAuthorityNodeRef(groupAAuthorityName));
            this.authorityService.addAuthority(groupAAuthorityName, user1);
            this.authorityService.addAuthority(groupBAuthorityName, user2);
            this.rootGroup = new Group();
            this.rootGroup.setId(this.rootGroupName);
            this.rootGroup.setDisplayName("Root Group");
            this.groupA = new Group();
            this.groupA.setId(groupAAuthorityName);
            this.groupA.setDisplayName("A Group");
            this.groupB = new Group();
            this.groupB.setId(groupBAuthorityName);
            this.groupB.setDisplayName("B Group");
            this.groupMemberA = new GroupMember();
            this.groupMemberA.setId(groupAAuthorityName);
            this.groupMemberA.setMemberType(AuthorityType.GROUP.toString());
            this.groupMemberB = new GroupMember();
            this.groupMemberB.setId(groupBAuthorityName);
            this.groupMemberB.setMemberType(AuthorityType.GROUP.toString());
        }
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), networkAdmin, "admin"));
        Person personAlice = new Person();
        String aliceId = "alice-" + UUID.randomUUID() + "@" + networkOne.getId();
        personAlice.setUserName(aliceId);
        personAlice.setId(aliceId);
        personAlice.setFirstName("Alice");
        personAlice.setEmail("alison.smith@example.com");
        personAlice.setPassword("password");
        personAlice.setEnabled(true);
        PublicApiClient.People people = this.publicApiClient.people();
        people.create(personAlice);
        this.personMember = new GroupMember();
        this.personMember.setId(personAlice.getId());
        this.personMember.setMemberType(MEMBER_TYPE_PERSON);
    }

    private Set<String> zoneSet(String ... zones) {
        HashSet<String> zoneSet = new HashSet<String>(zones.length);
        zoneSet.addAll(Arrays.asList(zones));
        return zoneSet;
    }

    private void clearAuthorityContext() {
        if (this.authorityService.authorityExists(this.rootGroupName)) {
            AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
            this.authorityService.deleteAuthority(this.rootGroupName, true);
        }
    }

    private void validateGroupDefaultFields(Group group, boolean ignoreOptionallyIncluded) {
        Assert.assertNotNull((Object)group);
        Assert.assertNotNull((Object)group.getId());
        Assert.assertNotNull((Object)group.getDisplayName());
        Assert.assertNotNull((Object)group.getIsRoot());
        if (!ignoreOptionallyIncluded) {
            Assert.assertNull((Object)group.getParentIds());
            Assert.assertNull((Object)group.getZones());
        }
    }

    private void validateGroupDefaultFields(Group group) {
        this.validateGroupDefaultFields(group, false);
    }

    private PublicApiClient.ListResponse<GroupMember> getGroupMembers(String groupId, PublicApiClient.Paging paging, Map<String, String> otherParams, String errorMessage, int expectedStatus) throws Exception {
        PublicApiClient.Groups groupsProxy = this.publicApiClient.groups();
        return groupsProxy.getGroupMembers(groupId, this.createParams(paging, otherParams), errorMessage, expectedStatus);
    }

    private PublicApiClient.ListResponse<Group> getGroupsByPersonId(String userId, PublicApiClient.Paging paging, Map<String, String> otherParams) throws Exception {
        return this.getGroupsByPersonId(userId, paging, otherParams, 200);
    }

    private PublicApiClient.ListResponse<Group> getGroupsByPersonId(String userId, PublicApiClient.Paging paging, Map<String, String> otherParams, int expectedStatus) throws Exception {
        PublicApiClient.Groups groupsProxy = this.publicApiClient.groups();
        return groupsProxy.getGroupsByPersonId(userId, this.createParams(paging, otherParams), "Incorrect response when getting groups for user ID " + userId, expectedStatus);
    }

    private PublicApiClient.ListResponse<GroupMember> getGroupMembers(String groupId, PublicApiClient.Paging paging, Map<String, String> otherParams) throws Exception {
        return this.getGroupMembers(groupId, paging, otherParams, "Failed to get group members", 200);
    }

    @Test
    public void testGetGroupMembers() throws Exception {
        try {
            this.createAuthorityContext(user1);
            this.setRequestContext(user1);
            this.testGetGroupMembersByGroupId();
            this.testGetGroupMembersSorting();
            this.testGetGroupMembersSkipPaging();
            this.testGetGroupsByMemberType();
        }
        finally {
            this.clearAuthorityContext();
        }
    }

    @Test
    public void testGetGroupsByUserId() throws Exception {
        try {
            this.createAuthorityContext(user1);
            this.canGetGroupsForUserId();
        }
        finally {
            this.clearAuthorityContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void canGetGroupsForUserId() throws Exception {
        this.publicApiClient.setRequestContext(new RequestContext(networkOne.getId(), networkAdmin, "admin"));
        Person personAlice = new Person();
        String aliceId = "alice-" + UUID.randomUUID() + "@" + networkOne.getId();
        personAlice.setUserName(aliceId);
        personAlice.setId(aliceId);
        personAlice.setFirstName("Alice");
        personAlice.setEmail("alison.smith@example.com");
        personAlice.setPassword("password");
        personAlice.setEnabled(true);
        PublicApiClient.People people = this.publicApiClient.people();
        people.create(personAlice);
        PublicApiClient.Groups groupsProxy = this.publicApiClient.groups();
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        PublicApiClient.ListResponse<Group> groups = groupsProxy.getGroupsByPersonId(personAlice.getId(), null, "Couldn't get user's groups", 200);
        Assert.assertEquals((long)1L, (long)groups.getPaging().getTotalItems().intValue());
        Iterator<Group> it = groups.getList().iterator();
        Assert.assertEquals((Object)GROUP_EVERYONE, (Object)it.next().getId());
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.authorityService.addAuthority(this.groupA.getId(), personAlice.getId());
        this.authorityService.addAuthority(this.groupB.getId(), personAlice.getId());
        groups = groupsProxy.getGroupsByPersonId(personAlice.getId(), null, "Couldn't get user's groups", 200);
        Assert.assertEquals((long)4L, (long)groups.getPaging().getTotalItems().intValue());
        it = groups.getList().iterator();
        Assert.assertEquals((Object)this.groupA, (Object)it.next());
        Assert.assertEquals((Object)this.groupB, (Object)it.next());
        Assert.assertEquals((Object)GROUP_EVERYONE, (Object)it.next().getId());
        Assert.assertEquals((Object)this.rootGroup, (Object)it.next());
        Group aardvark = new Group();
        try {
            aardvark.setId("GROUP_AARDVARK");
            aardvark.setDisplayName("Aardvark");
            this.authorityService.createAuthority(AuthorityType.GROUP, aardvark.getId());
            this.authorityService.setAuthorityDisplayName(aardvark.getId(), aardvark.getDisplayName());
            Person personBob = new Person();
            String bobId = "bob-" + UUID.randomUUID() + "@" + networkOne.getId();
            personBob.setUserName(bobId);
            personBob.setId(bobId);
            personBob.setFirstName("Bob");
            personBob.setEmail("bob.cratchet@example.com");
            personBob.setPassword("password");
            personBob.setEnabled(true);
            PublicApiClient.People people2 = this.publicApiClient.people();
            people2.create(personBob);
            this.authorityService.addAuthority(aardvark.getId(), personBob.getId());
            HashMap<String, String> params = new HashMap<String, String>();
            this.addOrderBy(params, "id", true);
            PublicApiClient.ListResponse<Group> groups2 = groupsProxy.getGroupsByPersonId(personBob.getId(), params, "Couldn't get user's groups", 200);
            Assert.assertEquals((long)2L, (long)groups2.getPaging().getTotalItems().intValue());
            Iterator<Group> it2 = groups2.getList().iterator();
            Assert.assertEquals((Object)aardvark.getId(), (Object)it2.next().getId());
            Assert.assertEquals((Object)GROUP_EVERYONE, (Object)it2.next().getId());
        }
        finally {
            this.authorityService.deleteAuthority(aardvark.getId());
        }
        groups = groupsProxy.getGroupsByPersonId(networkAdmin, null, "Couldn't get user's groups", 200);
        Assert.assertEquals((long)7L, (long)groups.getPaging().getTotalItems().intValue());
        groups = groupsProxy.getGroupsByPersonId("-me-", null, "Couldn't get user's groups", 200);
        Assert.assertEquals((long)7L, (long)groups.getPaging().getCount().intValue());
        it = groups.getList().iterator();
        Assert.assertEquals((Object)"GROUP_ALFRESCO_ADMINISTRATORS", (Object)it.next().getId());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("where", "(isRoot=true)");
        PublicApiClient.ListResponse<Group> response = groupsProxy.getGroupsByPersonId("-me-", params, "Couldn't get user's groups", 200);
        List<Group> groups3 = response.getList();
        Assert.assertFalse((boolean)groups3.isEmpty());
        groups3.forEach(group -> Assert.assertTrue((boolean)group.getIsRoot()));
        params.put("where", "(isRoot=false)");
        response = groupsProxy.getGroupsByPersonId("-me-", params, "Couldn't get user's groups", 200);
        groups3 = response.getList();
        Assert.assertFalse((boolean)groups3.isEmpty());
        groups3.forEach(group -> Assert.assertFalse((boolean)group.getIsRoot()));
        groupsProxy.getGroupsByPersonId("i-do-not-exist", null, "Incorrect response", 404);
        this.setRequestContext(networkOne.getId(), personAlice.getId(), "password");
        groups = groupsProxy.getGroupsByPersonId("-me-", null, "Couldn't get user's groups", 200);
        Assert.assertEquals((long)4L, (long)groups.getPaging().getCount().intValue());
        it = groups.getList().iterator();
        Assert.assertEquals((Object)this.groupA, (Object)it.next());
        Assert.assertEquals((Object)this.groupB, (Object)it.next());
        Assert.assertEquals((Object)GROUP_EVERYONE, (Object)it.next().getId());
        Assert.assertEquals((Object)this.rootGroup, (Object)it.next());
        HashMap<String, String> otherParams = new HashMap<String, String>();
        this.addOrderBy(otherParams, "displayName", false);
        int skipCount = 0;
        int maxItems = 4;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
        PublicApiClient.ListResponse<Group> resp = this.getGroupsByPersonId(personAlice.getId(), paging, otherParams);
        skipCount = 2;
        maxItems = 2;
        paging = this.getPaging(skipCount, maxItems);
        PublicApiClient.ListResponse<Group> sublistResponse = this.getGroupsByPersonId(personAlice.getId(), paging, otherParams);
        List<Group> expectedSublist = this.sublist(resp.getList(), skipCount, maxItems);
        this.checkList(expectedSublist, sublistResponse.getPaging(), sublistResponse);
        this.getGroupsByPersonId(personAlice.getId(), this.getPaging(-1, null), null, 400);
        PublicApiClient.Paging paging2 = this.getPaging(0, Integer.MAX_VALUE);
        HashMap<String, String> otherParams2 = new HashMap<String, String>();
        this.addOrderBy(otherParams2, "displayName", null);
        PublicApiClient.ListResponse<Group> resp2 = this.getGroupsByPersonId(personAlice.getId(), paging2, otherParams2);
        List<Group> groups4 = resp2.getList();
        Assert.assertTrue((String)"groups order not valid", (groups4.indexOf(this.groupA) < groups4.indexOf(this.groupB) ? 1 : 0) != 0);
        this.addOrderBy(otherParams2, "displayName", true);
        PublicApiClient.ListResponse<Group> respOrderAsc = this.getGroupsByPersonId(personAlice.getId(), paging2, otherParams2);
        this.checkList(respOrderAsc.getList(), resp2.getPaging(), resp2);
        paging2 = this.getPaging(0, Integer.MAX_VALUE);
        otherParams2 = new HashMap();
        this.addOrderBy(otherParams2, "displayName", null);
        PublicApiClient.ListResponse<Group> respCannedQuery = this.getGroupsByPersonId(personAlice.getId(), paging2, otherParams2);
        otherParams2.put("where", "(isRoot=true)");
        PublicApiClient.ListResponse<Group> respPostProcess = this.getGroupsByPersonId(personAlice.getId(), paging2, otherParams2);
        List<Group> expected = respCannedQuery.getList();
        expected.retainAll(respPostProcess.getList());
        Assert.assertTrue((String)"List doesn't contain enough items for test to be conclusive.", (expected.size() > 0 ? 1 : 0) != 0);
        this.checkList(expected, respPostProcess.getPaging(), respPostProcess);
        paging2 = this.getPaging(0, Integer.MAX_VALUE);
        otherParams2 = new HashMap();
        this.addOrderBy(otherParams2, "id", null);
        respCannedQuery = this.getGroupsByPersonId(personAlice.getId(), paging2, otherParams2);
        otherParams2.put("where", "(isRoot=true)");
        respPostProcess = this.getGroupsByPersonId(personAlice.getId(), paging2, otherParams2);
        expected = respCannedQuery.getList();
        expected.retainAll(respPostProcess.getList());
        Assert.assertTrue((String)"List doesn't contain enough items for test to be conclusive.", (expected.size() > 0 ? 1 : 0) != 0);
        this.checkList(expected, respPostProcess.getPaging(), respPostProcess);
        paging2 = this.getPaging(0, Integer.MAX_VALUE);
        otherParams2 = new HashMap();
        Group groupEveryone = new Group();
        groupEveryone.setId(GROUP_EVERYONE);
        this.addOrderBy(otherParams2, "id", true);
        PublicApiClient.ListResponse<Group> resp3 = this.getGroupsByPersonId(personAlice.getId(), paging2, otherParams2);
        Assert.assertEquals((long)4L, (long)resp3.getList().size());
        Iterator<Group> it3 = resp3.getList().iterator();
        Assert.assertEquals((Object)groupEveryone, (Object)it3.next());
        Assert.assertEquals((Object)this.rootGroup, (Object)it3.next());
        Assert.assertEquals((Object)this.groupA, (Object)it3.next());
        Assert.assertEquals((Object)this.groupB, (Object)it3.next());
        this.addOrderBy(otherParams2, "id", false);
        resp3 = this.getGroupsByPersonId(personAlice.getId(), paging2, otherParams2);
        Assert.assertEquals((long)4L, (long)resp3.getList().size());
        it3 = resp3.getList().iterator();
        Assert.assertEquals((Object)this.groupB, (Object)it3.next());
        Assert.assertEquals((Object)this.groupA, (Object)it3.next());
        Assert.assertEquals((Object)this.rootGroup, (Object)it3.next());
        Assert.assertEquals((Object)groupEveryone, (Object)it3.next());
        paging2 = this.getPaging(0, Integer.MAX_VALUE);
        otherParams2 = new HashMap();
        otherParams2.put("orderBy", "id ASC,displayName ASC");
        this.getGroupsByPersonId(personAlice.getId(), paging2, otherParams2, 400);
        paging2 = this.getPaging(0, Integer.MAX_VALUE);
        otherParams2 = new HashMap();
        otherParams2.put("include", "parentIds");
        resp2 = this.getGroupsByPersonId(personAlice.getId(), paging2, otherParams2);
        Assert.assertEquals((long)4L, (long)resp2.getList().size());
        Iterator<Group> it4 = resp2.getList().iterator();
        Group group2 = it4.next();
        Assert.assertEquals((Object)this.groupA.getId(), (Object)group2.getId());
        Assert.assertEquals((long)1L, (long)group2.getParentIds().size());
        Assert.assertTrue((boolean)group2.getParentIds().contains(this.rootGroup.getId()));
        group2 = it4.next();
        Assert.assertEquals((Object)this.groupB.getId(), (Object)group2.getId());
        Assert.assertEquals((long)1L, (long)group2.getParentIds().size());
        Assert.assertTrue((boolean)group2.getParentIds().contains(this.rootGroup.getId()));
        group2 = it4.next();
        Assert.assertEquals((Object)GROUP_EVERYONE, (Object)group2.getId());
        Assert.assertEquals((long)0L, (long)group2.getParentIds().size());
        group2 = it4.next();
        Assert.assertEquals((Object)this.rootGroup.getId(), (Object)group2.getId());
        Assert.assertEquals((long)0L, (long)group2.getParentIds().size());
        params = new HashMap();
        params.put("include", "zones");
        params.put("where", "(zones in ('APP.DEFAULT'))");
        response = groupsProxy.getGroupsByPersonId("-me-", params, "Couldn't get user's groups", 200);
        groups = response.getList();
        Assert.assertFalse((boolean)groups.isEmpty());
        groups.forEach(group -> Assert.assertTrue((boolean)group.getZones().contains("APP.DEFAULT")));
        params = new HashMap();
        params.put("include", "zones");
        params.put("where", "(zones in ('APITEST.MYZONE'))");
        response = groupsProxy.getGroupsByPersonId("-me-", params, "Couldn't get user's groups", 200);
        groups = response.getList();
        Assert.assertEquals((long)3L, (long)groups.size());
        groups.forEach(group -> Assert.assertTrue((boolean)group.getZones().contains("APITEST.MYZONE")));
        params = new HashMap();
        params.put("where", "(zones in ('APITEST.ANOTHER'))");
        response = groupsProxy.getGroupsByPersonId(personAlice.getId(), params, "Couldn't get user's groups", 200);
        groups = response.getList();
        Assert.assertEquals((long)1L, (long)groups.size());
        groups.forEach(group -> Assert.assertNull((Object)group.getZones()));
        otherParams = new HashMap();
        this.addOrderBy(otherParams, "displayName", true);
        otherParams.put("include", "zones");
        otherParams.put("where", "(isRoot=true AND zones in ('APITEST.MYZONE'))");
        response = groupsProxy.getGroupsByPersonId("-me-", otherParams, "Unexpected response", 200);
        groups = response.getList();
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)this.rootGroup, (Object)groups.get(0));
        Assert.assertTrue((boolean)groups.get(0).getZones().contains("APITEST.MYZONE"));
        otherParams.put("where", "(isRoot=true AND zones in ('I.DO.NOT.EXIST'))");
        response = groupsProxy.getGroupsByPersonId("-me-", otherParams, "Unexpected response", 200);
        groups = response.getList();
        Assert.assertTrue((boolean)groups.isEmpty());
        otherParams = new HashMap();
        this.addOrderBy(otherParams, "displayName", true);
        otherParams.put("where", "(isRoot=false AND zones in ('APITEST.MYZONE'))");
        response = groupsProxy.getGroupsByPersonId("-me-", otherParams, "Unexpected response", 200);
        groups = response.getList();
        Assert.assertEquals((long)2L, (long)groups.size());
        Assert.assertEquals((Object)this.groupA, (Object)groups.get(0));
        Assert.assertEquals((Object)this.groupB, (Object)groups.get(1));
        groups.forEach(group -> Assert.assertNull((Object)group.getZones()));
        otherParams.put("where", "(isRoot=false AND zones in ('I.DO.NOT.EXIST'))");
        response = groupsProxy.getGroupsByPersonId("-me-", otherParams, "Unexpected response", 200);
        groups = response.getList();
        Assert.assertTrue((boolean)groups.isEmpty());
        paging2 = this.getPaging(0, Integer.MAX_VALUE);
        otherParams2 = new HashMap();
        otherParams2.put("include", "zones");
        otherParams2.put("where", "(zones in ())");
        groupsProxy.getGroupsByPersonId(personAlice.getId(), otherParams2, "Incorrect response", 400);
        otherParams2.put("where", "(zones in (''))");
        groupsProxy.getGroupsByPersonId(personAlice.getId(), otherParams2, "Incorrect response", 400);
        otherParams2.put("where", "(zones in ('APP.DEFAULT', 'APITEST.MYZONE'))");
        groupsProxy.getGroupsByPersonId(personAlice.getId(), otherParams2, "Incorrect response", 400);
        otherParams2.put("where", "(zones in ('', 'APP.DEFAULT', '', 'APITEST.MYZONE'))");
        groupsProxy.getGroupsByPersonId(personAlice.getId(), otherParams2, "Incorrect response", 400);
        otherParams2.put("where", "(isRoot=true OR zones in ('APP.DEFAULT'))");
        groupsProxy.getGroupsByPersonId(personAlice.getId(), otherParams2, "Incorrect response", 400);
    }

    private void testGetGroupMembersByGroupId() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, 4);
        this.getGroupMembers("", paging, null, "", 400);
        this.getGroupMembers("invalidGroupId", paging, null, "", 404);
        this.getGroupMembers(GROUP_EVERYONE, paging, null, "", 405);
    }

    private void testGetGroupMembersSorting() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        this.addOrderBy(otherParams, "displayName", null);
        Mockito.when((Object)this.iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(this.iterator.next()).thenReturn((Object)this.groupBResultSetRow, new Object[]{this.groupAResultSetRow});
        PublicApiClient.ListResponse<GroupMember> resp = this.getGroupMembers(this.rootGroupName, paging, otherParams);
        List<GroupMember> groupMembers = resp.getList();
        Assert.assertTrue((String)"group members order not valid", (groupMembers.indexOf(this.groupMemberA) < groupMembers.indexOf(this.groupMemberB) ? 1 : 0) != 0);
        this.addOrderBy(otherParams, "displayName", true);
        Mockito.when((Object)this.iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(this.iterator.next()).thenReturn((Object)this.groupBResultSetRow, new Object[]{this.groupAResultSetRow});
        PublicApiClient.ListResponse<GroupMember> respOrderAsc = this.getGroupMembers(this.rootGroupName, paging, otherParams);
        this.checkList(respOrderAsc.getList(), resp.getPaging(), resp);
        paging = this.getPaging(0, Integer.MAX_VALUE);
        otherParams = new HashMap();
        this.addOrderBy(otherParams, "displayName", true);
        Mockito.when((Object)this.iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(this.iterator.next()).thenReturn((Object)this.groupBResultSetRow, new Object[]{this.groupAResultSetRow});
        resp = this.getGroupMembers(this.rootGroupName, paging, otherParams);
        groupMembers = resp.getList();
        Assert.assertTrue((String)"group members order not valid", (groupMembers.indexOf(this.groupMemberA) < groupMembers.indexOf(this.groupMemberB) ? 1 : 0) != 0);
        paging = this.getPaging(0, Integer.MAX_VALUE);
        otherParams = new HashMap();
        this.addOrderBy(otherParams, "id", false);
        Mockito.when((Object)this.iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(this.iterator.next()).thenReturn((Object)this.groupBResultSetRow, new Object[]{this.groupAResultSetRow});
        resp = this.getGroupMembers(this.rootGroupName, paging, otherParams);
        groupMembers = resp.getList();
        Assert.assertTrue((String)"group members order not valid", (groupMembers.indexOf(this.groupMemberB) < groupMembers.indexOf(this.groupMemberA) ? 1 : 0) != 0);
        paging = this.getPaging(0, Integer.MAX_VALUE);
        otherParams = new HashMap();
        otherParams.put("orderBy", "id ASC,displayName ASC");
        Mockito.when((Object)this.iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(this.iterator.next()).thenReturn((Object)this.groupBResultSetRow, new Object[]{this.groupAResultSetRow});
        this.getGroupMembers(this.rootGroupName, paging, otherParams, "", 400);
    }

    private void testGetGroupMembersSkipPaging() throws Exception {
        HashMap<String, String> otherParams = new HashMap<String, String>();
        this.addOrderBy(otherParams, "displayName", false);
        int skipCount = 0;
        int maxItems = 2;
        PublicApiClient.Paging paging = this.getPaging(skipCount, maxItems);
        Mockito.when((Object)this.iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(this.iterator.next()).thenReturn((Object)this.groupBResultSetRow, new Object[]{this.groupAResultSetRow});
        PublicApiClient.ListResponse<GroupMember> resp = this.getGroupMembers(this.rootGroupName, paging, otherParams);
        skipCount = 1;
        maxItems = 1;
        paging = this.getPaging(skipCount, maxItems);
        Mockito.when((Object)this.iterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when(this.iterator.next()).thenReturn((Object)this.groupBResultSetRow, new Object[]{this.groupAResultSetRow});
        PublicApiClient.ListResponse<GroupMember> sublistResponse = this.getGroupMembers(this.rootGroupName, paging, otherParams);
        List<GroupMember> expectedSublist = this.sublist(resp.getList(), skipCount, maxItems);
        this.checkList(expectedSublist, sublistResponse.getPaging(), sublistResponse);
        this.getGroupMembers(this.rootGroupName, this.getPaging(-1, null), null, "", 400);
    }

    private void testGetGroupsByMemberType() throws Exception {
        this.testGetGroupsByMemberType(this.rootGroupName, MEMBER_TYPE_GROUP);
        this.testGetGroupsByMemberType(this.groupB.getId(), MEMBER_TYPE_PERSON);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(memberType=invalidMemberType)");
        this.getGroupMembers(this.rootGroupName, this.getPaging(0, 4), otherParams, "", 400);
    }

    private void testGetGroupsByMemberType(String groupId, String memberType) throws Exception {
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(memberType=" + memberType + ")");
        PublicApiClient.Paging paging = this.getPaging(0, 4);
        PublicApiClient.ListResponse<GroupMember> resp = this.getGroupMembers(groupId, paging, otherParams);
        resp.getList().forEach(groupMember -> {
            this.validateGroupMemberDefaultFields((GroupMember)groupMember);
            Assert.assertEquals((String)("memberType was expected to be " + memberType), (Object)memberType, (Object)groupMember.getMemberType());
        });
    }

    private void validateGroupMemberDefaultFields(GroupMember groupMember) {
        Assert.assertNotNull((Object)groupMember);
        Assert.assertNotNull((Object)groupMember.getId());
        Assert.assertNotNull((Object)groupMember.getDisplayName());
        Assert.assertNotNull((Object)groupMember.getMemberType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetGroup() throws Exception {
        PublicApiClient.Groups groupsProxy = this.publicApiClient.groups();
        try {
            this.createAuthorityContext(user1);
            this.setRequestContext(user1);
            groupsProxy.getGroup("invalidGroupId", 404);
            Group group = groupsProxy.getGroup(this.groupA.getId());
            this.validateGroupDefaultFields(group);
            HashMap<String, String> otherParams = new HashMap<String, String>();
            otherParams.put("include", "parentIds");
            Group group2 = groupsProxy.getGroup(this.groupA.getId(), otherParams, 200);
            this.validateGroupDefaultFields(group2, true);
            Assert.assertNotNull((Object)group2.getParentIds());
            Assert.assertNull((Object)group2.getZones());
            otherParams = new HashMap();
            otherParams.put("include", "zones");
            group2 = groupsProxy.getGroup(this.groupA.getId(), otherParams, 200);
            this.validateGroupDefaultFields(group2, true);
            Assert.assertNull((Object)group2.getParentIds());
            Assert.assertNotNull((Object)group2.getZones());
            group = groupsProxy.getGroup(GROUP_EVERYONE, null, 200);
            Assert.assertNotNull((Object)group);
            Assert.assertNotNull((Object)group.getId());
            Assert.assertNotNull((Object)group.getIsRoot());
        }
        finally {
            this.clearAuthorityContext();
        }
    }

    @Test
    public void testCreateGroup() throws Exception {
        PublicApiClient.Groups groupsProxy = this.publicApiClient.groups();
        this.setRequestContext(user1);
        Group group = this.generateGroup();
        groupsProxy.createGroup(group, null, 403);
        this.setRequestContext(networkOne.getId(), GUID.generate(), "password");
        groupsProxy.createGroup(this.generateGroup(), null, 401);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("include", "parentIds");
        Group group2 = this.generateGroup();
        Group createdGroup01 = groupsProxy.createGroup(group2, null, 201);
        Assert.assertNotNull((Object)createdGroup01);
        Assert.assertNotNull((Object)createdGroup01.getId());
        Assert.assertTrue((boolean)createdGroup01.getIsRoot());
        Assert.assertNull((Object)createdGroup01.getParentIds());
        HashSet<String> subGroup01Parents = new HashSet<String>();
        subGroup01Parents.add(createdGroup01.getId());
        Group subGroup01 = this.generateGroup();
        subGroup01.setParentIds(subGroup01Parents);
        Group createdSubGroup01 = groupsProxy.createGroup(subGroup01, otherParams, 201);
        Assert.assertNotNull((Object)createdSubGroup01);
        Assert.assertNotNull((Object)createdSubGroup01.getId());
        Assert.assertFalse((boolean)createdSubGroup01.getIsRoot());
        Assert.assertNotNull((Object)createdSubGroup01.getParentIds());
        Assert.assertEquals(subGroup01Parents, (Object)createdSubGroup01.getParentIds());
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        group = new Group();
        groupsProxy.createGroup(group, null, 400);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        char[] invalidCharacters = new char[]{'/', '\\', '\n', '\r', '\"'};
        for (Object invalidCharacter : (Group)invalidCharacters) {
            Group group3 = new Group();
            group3.setId((char)invalidCharacter + "test" + (char)invalidCharacter);
            groupsProxy.createGroup(group3, null, 400);
        }
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        group = this.generateGroup();
        groupsProxy.createGroup(group, null, 201);
        groupsProxy.createGroup(group, null, 409);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        otherParams = new HashMap();
        otherParams.put("include", "parentIds");
        HashSet<String> subGroupParents = new HashSet<String>();
        subGroupParents.add("invalidId");
        Group subGroup = this.generateGroup();
        subGroup.setParentIds(subGroupParents);
        groupsProxy.createGroup(subGroup, otherParams, 404);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateGroupMembers() throws PublicApiException {
        PublicApiClient.Groups groupsProxy = this.publicApiClient.groups();
        try {
            this.createAuthorityContext(user1);
            groupsProxy.createGroupMember(this.groupB.getId(), this.personMember, 201);
            groupsProxy.createGroupMember(this.groupB.getId(), this.groupMemberA, 201);
            Group groupRoot = this.generateGroup();
            Group groupRootCreated = groupsProxy.createGroup(groupRoot, null, 201);
            Assert.assertTrue((String)"Group was expected to be root.", (boolean)groupRootCreated.getIsRoot());
            GroupMember groupMember = new GroupMember();
            groupMember.setId(groupRootCreated.getId());
            groupMember.setMemberType(MEMBER_TYPE_GROUP);
            groupsProxy.createGroupMember(this.groupB.getId(), groupMember, 201);
            Group subGroup = groupsProxy.getGroup(groupMember.getId());
            Assert.assertFalse((String)"Group was expected to be sub-group.", (boolean)subGroup.getIsRoot());
            groupsProxy.createGroupMember(this.groupB.getId(), this.groupMemberA, 409);
            groupsProxy.createGroupMember(GROUP_EVERYONE, this.groupMemberA, 409);
            GroupMember invalidIdGroupMember = new GroupMember();
            invalidIdGroupMember.setId("invalidPersonId-" + GUID.generate());
            invalidIdGroupMember.setMemberType(MEMBER_TYPE_PERSON);
            groupsProxy.createGroupMember(this.groupA.getId(), invalidIdGroupMember, 404);
            invalidIdGroupMember.setMemberType(MEMBER_TYPE_GROUP);
            groupsProxy.createGroupMember(this.groupA.getId(), invalidIdGroupMember, 404);
            groupsProxy.createGroupMember("invalidGroupId", this.groupMemberA, 404);
            GroupMember invalidGroupMember = new GroupMember();
            groupsProxy.createGroupMember(this.groupA.getId(), invalidGroupMember, 400);
            invalidGroupMember.setId("Test_" + GUID.generate());
            groupsProxy.createGroupMember(this.groupA.getId(), invalidGroupMember, 400);
            invalidGroupMember.setMemberType("invalidMemberType");
            groupsProxy.createGroupMember(this.groupA.getId(), invalidGroupMember, 400);
            this.personMember.setId(null);
            groupsProxy.createGroupMember(this.groupB.getId(), this.personMember, 400);
            this.personMember.setDisplayName(null);
            groupsProxy.createGroupMember(this.groupB.getId(), this.personMember, 400);
            this.personMember.setMemberType(null);
            groupsProxy.createGroupMember(this.groupB.getId(), this.personMember, 400);
            this.personMember.setMemberType(MEMBER_TYPE_GROUP);
            groupsProxy.createGroupMember(this.groupB.getId(), this.personMember, 400);
            this.groupMemberA.setMemberType(MEMBER_TYPE_PERSON);
            groupsProxy.createGroupMember(this.groupB.getId(), this.groupMemberA, 400);
            this.setRequestContext(user1);
            groupsProxy.createGroupMember(this.groupB.getId(), this.groupMemberB, 403);
            this.setRequestContext(networkOne.getId(), GUID.generate(), "password");
            groupsProxy.createGroupMember(this.groupB.getId(), this.groupMemberB, 401);
        }
        finally {
            this.clearAuthorityContext();
        }
    }

    @Test
    public void testUpdateGroup() throws Exception {
        PublicApiClient.Groups groupsProxy = this.publicApiClient.groups();
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("include", "parentIds");
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        Group group = groupsProxy.createGroup(this.generateGroup(), null, 201);
        HashSet<String> subGroupParents = new HashSet<String>();
        subGroupParents.add(group.getId());
        Group generatedSubGroup = this.generateGroup();
        generatedSubGroup.setParentIds(subGroupParents);
        Group subGroup = groupsProxy.createGroup(generatedSubGroup, otherParams, 201);
        this.setRequestContext(user1);
        groupsProxy.updateGroup(group.getId(), new Group(), null, 403);
        this.setRequestContext(networkOne.getId(), GUID.generate(), "password");
        groupsProxy.updateGroup(group.getId(), new Group(), null, 401);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        String displayName = "newDisplayName";
        Group mySubGroup = new Group();
        mySubGroup.setDisplayName(displayName);
        Group updateGroup = groupsProxy.updateGroup(subGroup.getId(), mySubGroup, otherParams, 200);
        Assert.assertNotNull((Object)updateGroup);
        Assert.assertNotNull((Object)updateGroup.getId());
        Assert.assertFalse((boolean)updateGroup.getIsRoot());
        Assert.assertNotNull((Object)updateGroup.getParentIds());
        Assert.assertEquals((Object)displayName, (Object)updateGroup.getDisplayName());
        Assert.assertEquals((Object)subGroup.getId(), (Object)updateGroup.getId());
        Assert.assertEquals((Object)subGroup.getIsRoot(), (Object)updateGroup.getIsRoot());
        Assert.assertEquals((Object)subGroup.getParentIds(), (Object)updateGroup.getParentIds());
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        groupsProxy.updateGroup("invalidId", group, null, 404);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        Group myGroup = new Group();
        myGroup.setDisplayName("newDisplayName");
        groupsProxy.updateGroup(GROUP_EVERYONE, myGroup, null, 409);
    }

    @Test
    public void testDeleteGroup() throws Exception {
        PublicApiClient.Groups groupsProxy = this.publicApiClient.groups();
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("include", "parentIds");
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        Group group = groupsProxy.createGroup(this.generateGroup(), otherParams, 201);
        this.setRequestContext(user1);
        groupsProxy.deleteGroup(group.getId(), false, 403);
        this.setRequestContext(networkOne.getId(), GUID.generate(), "password");
        groupsProxy.deleteGroup("invalidId", false, 401);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        groupsProxy.deleteGroup("GROUP_invalidId", false, 404);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        groupsProxy.deleteGroup(GROUP_EVERYONE, false, 409);
        this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
        groupsProxy.deleteGroup(user1, false, 400);
        Group groupLevel1 = groupsProxy.createGroup(this.generateGroup(), otherParams, 201);
        Group groupLevel2 = groupsProxy.createGroup(this.generateSubGroup(groupLevel1), otherParams, 201);
        Group groupLevel3 = groupsProxy.createGroup(this.generateSubGroup(groupLevel2), otherParams, 201);
        groupsProxy.deleteGroup(groupLevel1.getId(), false, 204);
        groupsProxy.getGroup(groupLevel1.getId(), 404);
        groupLevel2 = groupsProxy.getGroup(groupLevel2.getId(), 200);
        Assert.assertTrue((boolean)groupLevel2.getIsRoot());
        groupsProxy.getGroup(groupLevel3.getId(), 200);
        groupsProxy.deleteGroup(groupLevel2.getId(), true, 204);
        groupsProxy.getGroup(groupLevel2.getId(), 404);
        groupsProxy.getGroup(groupLevel3.getId(), 404);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteGroupMembership() throws Exception {
        PublicApiClient.Groups groupsProxy = this.publicApiClient.groups();
        try {
            this.createAuthorityContext(user1);
            HashMap<String, String> otherParams = new HashMap<String, String>();
            otherParams.put("include", "parentIds");
            Group createdTestGroup = groupsProxy.createGroup(this.generateGroup(), null, 201);
            GroupMember groupMember = new GroupMember();
            groupMember.setId(createdTestGroup.getId());
            groupMember.setMemberType(MEMBER_TYPE_GROUP);
            groupsProxy.createGroupMember(this.groupA.getId(), groupMember, 201);
            Assert.assertFalse((boolean)groupsProxy.getGroup(groupMember.getId(), otherParams, 200).getParentIds().isEmpty());
            groupsProxy.deleteGroupMembership(this.groupA.getId(), groupMember.getId(), 204);
            Assert.assertTrue((boolean)groupsProxy.getGroup(groupMember.getId(), otherParams, 200).getParentIds().isEmpty());
            groupsProxy.createGroupMember(this.groupA.getId(), this.personMember, 201);
            PublicApiClient.ListResponse<Group> groups = groupsProxy.getGroupsByPersonId(this.personMember.getId(), null, "Cannot retrieve user groups", 200);
            Assert.assertEquals((long)3L, (long)groups.getPaging().getTotalItems().intValue());
            Iterator<Group> it = groups.getList().iterator();
            Assert.assertEquals((Object)this.groupA, (Object)it.next());
            Assert.assertEquals((Object)GROUP_EVERYONE, (Object)it.next().getId());
            Assert.assertEquals((Object)this.rootGroup, (Object)it.next());
            groupsProxy.deleteGroupMembership(this.groupA.getId(), this.personMember.getId(), 204);
            groups = groupsProxy.getGroupsByPersonId(this.personMember.getId(), null, "Cannot retrieve user groups", 200);
            Assert.assertEquals((long)1L, (long)groups.getPaging().getTotalItems().intValue());
            it = groups.getList().iterator();
            Assert.assertEquals((Object)GROUP_EVERYONE, (Object)it.next().getId());
            groupsProxy.deleteGroupMembership("invalidGroupId", this.groupMemberA.getId(), 404);
            groupsProxy.deleteGroupMembership(this.groupA.getId(), "invalidGroupMemberId", 404);
            groupsProxy.deleteGroupMembership(GROUP_EVERYONE, this.groupMemberA.getId(), 409);
            groupsProxy.deleteGroupMembership(this.groupB.getId(), this.personMember.getId(), 404);
            this.setRequestContext(networkOne.getId(), GUID.generate(), "password");
            groupsProxy.deleteGroupMembership(this.groupA.getId(), this.groupMemberA.getId(), 401);
            this.setRequestContext(networkOne.getId(), networkAdmin, "admin");
            groupsProxy.createGroupMember(this.groupA.getId(), this.personMember, 201);
            this.setRequestContext(user1);
            groupsProxy.deleteGroupMembership(this.groupA.getId(), this.personMember.getId(), 403);
        }
        finally {
            this.clearAuthorityContext();
        }
    }

    private Group generateGroup() {
        Group group = new Group();
        group.setId("TST" + GUID.generate());
        return group;
    }

    private Group generateSubGroup(Group parentGroup) {
        HashSet<String> subGroupParents = new HashSet<String>();
        if (parentGroup.getParentIds() != null && !parentGroup.getParentIds().isEmpty()) {
            subGroupParents.addAll(parentGroup.getParentIds());
        }
        subGroupParents.add(parentGroup.getId());
        Group subGroup = this.generateGroup();
        subGroup.setParentIds(subGroupParents);
        return subGroup;
    }

    private void testGetGroupsWithDisplayNameFilter() throws Exception {
        this.shouldFilterGroupByDisplayName();
        this.shouldFilterGroupByDisplayNameWhenNameNotExist();
        this.shouldFilterGroupByDisplayNameAndZone();
        this.shouldFilterGroupByDisplayNameWhenGroupIsRoot();
        this.shouldFilterGroupByDisplayNameWhenIsRootIsFalse();
        this.shouldFilterGroupByDisplayNameAndZoneWhenGroupIsRoot();
        this.shouldReturnBadRequestErrorWhenTooManyDisplayNames();
        this.shouldReturnBadRequestErrorWhenDisplayNameIsEmpty();
        this.shouldNotAllowWildcards();
    }

    private void shouldFilterGroupByDisplayName() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(displayName in ('A Group'))");
        PublicApiClient.ListResponse<Group> response = this.getGroups(paging, otherParams);
        List<Group> groups = response.getList();
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)"A Group", (Object)groups.get(0).getDisplayName());
        otherParams.put("where", "(displayName in ('a group'))");
        response = this.getGroups(paging, otherParams);
        response.getList();
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)"A Group", (Object)groups.get(0).getDisplayName());
    }

    private void shouldFilterGroupByDisplayNameWhenNameNotExist() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(displayName in ('AGroupName'))");
        PublicApiClient.ListResponse<Group> response = this.getGroups(paging, otherParams);
        List<Group> groups = response.getList();
        Assert.assertTrue((boolean)groups.isEmpty());
    }

    private void shouldFilterGroupByDisplayNameAndZone() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        this.addOrderBy(otherParams, "displayName", true);
        otherParams.put("include", "zones");
        otherParams.put("where", "(zones in ('APITEST.MYZONE') AND displayName in ('A Group'))");
        PublicApiClient.ListResponse<Group> response = this.getGroups(paging, otherParams);
        List<Group> groups = response.getList();
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertTrue((boolean)groups.get(0).getZones().contains("APITEST.MYZONE"));
        Assert.assertEquals((Object)"A Group", (Object)groups.get(0).getDisplayName());
    }

    private void shouldFilterGroupByDisplayNameWhenGroupIsRoot() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(isRoot=true AND displayName in ('Root Group'))");
        PublicApiClient.ListResponse<Group> response = this.getGroups(paging, otherParams);
        List<Group> groups = response.getList();
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)"Root Group", (Object)groups.get(0).getDisplayName());
    }

    private void shouldFilterGroupByDisplayNameWhenIsRootIsFalse() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(isRoot=False AND displayName in ('A Group'))");
        PublicApiClient.ListResponse<Group> response = this.getGroups(paging, otherParams);
        List<Group> groups = response.getList();
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((Object)"A Group", (Object)groups.get(0).getDisplayName());
    }

    private void shouldFilterGroupByDisplayNameAndZoneWhenGroupIsRoot() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("include", "zones");
        otherParams.put("where", "(isRoot=true AND zones in ('APITEST.MYZONE') AND displayName in ('Root Group'))");
        PublicApiClient.ListResponse<Group> response = this.getGroups(paging, otherParams);
        List<Group> groups = response.getList();
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertTrue((boolean)groups.get(0).getZones().contains("APP.DEFAULT"));
        Assert.assertEquals((Object)"Root Group", (Object)groups.get(0).getDisplayName());
    }

    private void shouldReturnBadRequestErrorWhenTooManyDisplayNames() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(displayName in ('Group A', 'Group B'))");
        this.getGroups(paging, otherParams, "Incorrect response", 400);
    }

    private void shouldReturnBadRequestErrorWhenDisplayNameIsEmpty() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(displayName in ())");
        this.getGroups(paging, otherParams, "Incorrect response", 400);
        otherParams.put("where", "(displayName in (''))");
        this.getGroups(paging, otherParams, "Incorrect response", 400);
    }

    private void shouldNotAllowWildcards() throws Exception {
        PublicApiClient.Paging paging = this.getPaging(0, Integer.MAX_VALUE);
        HashMap<String, String> otherParams = new HashMap<String, String>();
        otherParams.put("where", "(displayName in ('*'))");
        PublicApiClient.ListResponse<Group> response = this.getGroups(paging, otherParams);
        List<Group> groups = response.getList();
        Assert.assertEquals((long)0L, (long)groups.size());
        otherParams.put("where", "(isRoot=true AND displayName in ('*'))");
        response = this.getGroups(paging, otherParams);
        groups = response.getList();
        Assert.assertEquals((long)0L, (long)groups.size());
        otherParams.put("where", "(displayName in ('A*'))");
        response = this.getGroups(paging, otherParams);
        groups = response.getList();
        Assert.assertEquals((long)0L, (long)groups.size());
        otherParams.put("where", "(isRoot=true AND displayName in ('A*'))");
        response = this.getGroups(paging, otherParams);
        groups = response.getList();
        Assert.assertEquals((long)0L, (long)groups.size());
        otherParams.put("where", "(displayName in ('*roup'))");
        response = this.getGroups(paging, otherParams);
        groups = response.getList();
        Assert.assertEquals((long)0L, (long)groups.size());
        otherParams.put("where", "(isRoot=true AND displayName in ('*roup'))");
        response = this.getGroups(paging, otherParams);
        groups = response.getList();
        Assert.assertEquals((long)0L, (long)groups.size());
        otherParams.put("where", "(displayName in ('Root ?ROUP'))");
        response = this.getGroups(paging, otherParams);
        groups = response.getList();
        Assert.assertEquals((long)0L, (long)groups.size());
        otherParams.put("where", "(isRoot=true AND displayName in ('Root ?ROUP'))");
        response = this.getGroups(paging, otherParams);
        groups = response.getList();
        Assert.assertEquals((long)0L, (long)groups.size());
        otherParams.put("where", "(displayName in ('Group'))");
        response = this.getGroups(paging, otherParams);
        groups = response.getList();
        Assert.assertEquals((long)0L, (long)groups.size());
        otherParams.put("where", "(isRoot=true AND displayName in ('Group'))");
        response = this.getGroups(paging, otherParams);
        groups = response.getList();
        Assert.assertEquals((long)0L, (long)groups.size());
    }
}

