/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.webdav;

import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.webdav.DeleteMethod;
import org.alfresco.repo.webdav.LockMethod;
import org.alfresco.repo.webdav.PutMethod;
import org.alfresco.repo.webdav.UnlockMethod;
import org.alfresco.repo.webdav.WebDAVHelper;
import org.alfresco.repo.webdav.WebDAVMethod;
import org.alfresco.repo.webdav.WebDAVServerException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.IntermittentlyFailingTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

@RunWith(value=MockitoJUnitRunner.class)
public class WebDAVMethodTest {
    private WebDAVMethod method;
    private MockHttpServletRequest req;
    private MockHttpServletResponse resp;
    @Mock
    private WebDAVHelper davHelper;
    private NodeService nodeService;
    private SearchService searchService;
    private NamespaceService namespaceService;
    private TenantService tenantService;
    private TransactionService transactionService;
    private WebDAVHelper webDAVHelper;
    private TenantAdminService tenantAdminService;
    @Mock
    private LockMethod lockMethod;
    @Mock
    private PutMethod putMethod;
    @Mock
    private DeleteMethod deleteMethod;
    @Mock
    private UnlockMethod unlockMethod;
    private static Log logger = LogFactory.getLog(WebDAVMethodTest.class);
    public static final String TEST_RUN = "" + System.currentTimeMillis();
    public static final String TEST_TENANT_DOMAIN = TEST_RUN + ".my.test";
    public static final String DEFAULT_ADMIN_PW = "admin";
    private Level saveLogLevel;

    protected void setUpApplicationContext() {
        ApplicationContext appContext = ApplicationContextHelper.getApplicationContext((String[])new String[]{"classpath:alfresco/application-context.xml", "classpath:alfresco/web-scripts-application-context.xml", "classpath:alfresco/remote-api-context.xml"});
        this.nodeService = (NodeService)appContext.getBean("NodeService");
        this.searchService = (SearchService)appContext.getBean("SearchService");
        this.namespaceService = (NamespaceService)appContext.getBean("NamespaceService");
        this.tenantService = (TenantService)appContext.getBean("tenantService");
        this.transactionService = (TransactionService)appContext.getBean("transactionService");
        this.webDAVHelper = (WebDAVHelper)appContext.getBean("webDAVHelper");
        this.tenantAdminService = (TenantAdminService)appContext.getBean("tenantAdminService");
        AuthenticationComponent authenticationComponent = (AuthenticationComponent)appContext.getBean("authenticationComponent");
        authenticationComponent.setSystemUserAsCurrentUser();
    }

    private void checkLockedNodeTestWork() throws WebDAVServerException {
        this.req = new MockHttpServletRequest();
        this.resp = new MockHttpServletResponse();
        String rootPath = "/app:company_home";
        String storeName = "workspace://SpacesStore";
        StoreRef storeRef = new StoreRef(storeName);
        NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
        List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, rootPath, null, (NamespacePrefixResolver)this.namespaceService, false);
        NodeRef defaultRootNode = (NodeRef)nodeRefs.get(0);
        this.lockMethod = new LockMethod();
        NodeRef rootNodeRef = this.tenantService.getRootNode(this.nodeService, this.searchService, this.namespaceService, rootPath, defaultRootNode);
        String strPath = "/testLockedNode" + GUID.generate();
        this.lockMethod.createExclusive = true;
        this.lockMethod.setDetails((HttpServletRequest)this.req, (HttpServletResponse)this.resp, this.webDAVHelper, rootNodeRef);
        this.lockMethod.m_strPath = strPath;
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                WebDAVMethodTest.this.lockMethod.executeImpl();
                return null;
            }
        });
        this.req.addHeader("If", (Object)("(<" + this.lockMethod.lockToken + ">)"));
        this.putMethod = new PutMethod();
        this.putMethod.setDetails((HttpServletRequest)this.req, (HttpServletResponse)this.resp, this.webDAVHelper, rootNodeRef);
        this.putMethod.parseRequestHeaders();
        this.putMethod.m_strPath = strPath;
        String content = "test content stream";
        this.req.setContent(content.getBytes());
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                WebDAVMethodTest.this.putMethod.executeImpl();
                return null;
            }
        });
    }

    @Test
    public void checkLockedNodeTest() throws Exception {
        this.setUpApplicationContext();
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (!WebDAVMethodTest.this.tenantAdminService.existsTenant(TEST_TENANT_DOMAIN)) {
                    WebDAVMethodTest.this.tenantAdminService.createTenant(TEST_TENANT_DOMAIN, ("admin " + TEST_TENANT_DOMAIN).toCharArray(), null);
                }
                return null;
            }
        }, (String)"");
        try {
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                public Object doWork() throws Exception {
                    WebDAVMethodTest.this.checkLockedNodeTestWork();
                    return null;
                }
            }, (String)AuthenticationUtil.getAdminUserName(), (String)"");
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to lock and put content as admin with error: " + e.getCause()));
        }
        try {
            TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                public Object doWork() throws Exception {
                    WebDAVMethodTest.this.checkLockedNodeTestWork();
                    return null;
                }
            }, (String)AuthenticationUtil.getAdminUserName(), (String)TEST_TENANT_DOMAIN);
        }
        catch (Exception e) {
            Assert.fail((String)("Failed to lock and put content as tenant admin with error: " + e.getCause()));
        }
    }

    private void checkLockedNodeTestTenantWork() throws Exception {
        String strPath;
        NodeRef rootNodeRef;
        block6: {
            this.req = new MockHttpServletRequest();
            this.resp = new MockHttpServletResponse();
            String rootPath = "/app:company_home";
            String storeName = "workspace://SpacesStore";
            StoreRef storeRef = new StoreRef(storeName);
            NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
            List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, rootPath, null, (NamespacePrefixResolver)this.namespaceService, false);
            NodeRef defaultRootNode = (NodeRef)nodeRefs.get(0);
            this.lockMethod = new LockMethod();
            rootNodeRef = this.tenantService.getRootNode(this.nodeService, this.searchService, this.namespaceService, rootPath, defaultRootNode);
            strPath = "/testLockedNode" + GUID.generate();
            this.lockMethod.createExclusive = true;
            this.lockMethod.setDetails((HttpServletRequest)this.req, (HttpServletResponse)this.resp, this.webDAVHelper, rootNodeRef);
            this.lockMethod.m_strPath = strPath;
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    WebDAVMethodTest.this.lockMethod.executeImpl();
                    return null;
                }
            });
            String corruptedLockToken = this.lockMethod.lockToken + "corr";
            this.req.addHeader("If", (Object)("(<" + corruptedLockToken + ">)"));
            this.deleteMethod = new DeleteMethod();
            this.deleteMethod.setDetails((HttpServletRequest)this.req, (HttpServletResponse)this.resp, this.webDAVHelper, rootNodeRef);
            this.deleteMethod.parseRequestHeaders();
            this.deleteMethod.m_strPath = strPath;
            try {
                this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                    public Object execute() throws Throwable {
                        WebDAVMethodTest.this.deleteMethod.executeImpl();
                        return null;
                    }
                });
                Assert.fail((String)"Locked node shouldn't be deleted");
            }
            catch (Exception e) {
                if (e.getCause() instanceof WebDAVServerException) break block6;
                throw e;
            }
        }
        this.req = new MockHttpServletRequest();
        this.req.addHeader("Lock-Token", (Object)this.lockMethod.lockToken);
        this.unlockMethod = new UnlockMethod();
        this.unlockMethod.setDetails((HttpServletRequest)this.req, (HttpServletResponse)this.resp, this.webDAVHelper, rootNodeRef);
        this.unlockMethod.parseRequestHeaders();
        this.unlockMethod.m_strPath = strPath;
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    WebDAVMethodTest.this.unlockMethod.executeImpl();
                    return null;
                }
            });
        }
        catch (Exception e) {
            Assert.fail((String)("Locked node should be unlocked with correct lockTocken " + e.getCause()));
        }
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                WebDAVMethodTest.this.lockMethod.executeImpl();
                return null;
            }
        });
        this.req.addHeader("If", (Object)("(<" + this.lockMethod.lockToken + ">)"));
        this.deleteMethod = new DeleteMethod();
        this.deleteMethod.setDetails((HttpServletRequest)this.req, (HttpServletResponse)this.resp, this.webDAVHelper, rootNodeRef);
        this.deleteMethod.parseRequestHeaders();
        this.deleteMethod.m_strPath = strPath;
        try {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    WebDAVMethodTest.this.deleteMethod.executeImpl();
                    return null;
                }
            });
        }
        catch (Exception e) {
            Assert.fail((String)("Locked node should be deleted with correct lockTocken " + e.getCause()));
        }
    }

    @Test
    public void checkLockedNodeTenantTest() {
        this.setUpApplicationContext();
        TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                if (!WebDAVMethodTest.this.tenantAdminService.existsTenant(TEST_TENANT_DOMAIN)) {
                    WebDAVMethodTest.this.tenantAdminService.createTenant(TEST_TENANT_DOMAIN, ("admin " + TEST_TENANT_DOMAIN).toCharArray(), null);
                }
                return null;
            }
        }, (String)"");
        TenantUtil.runAsUserTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

            public Object doWork() throws Exception {
                WebDAVMethodTest.this.checkLockedNodeTestTenantWork();
                return null;
            }
        }, (String)AuthenticationUtil.getAdminUserName(), (String)TEST_TENANT_DOMAIN);
    }

    @Test
    public void canGetStatusForAccessDeniedException() {
        this.assertStatusCode(500, "WebDAVLib/1.3");
        this.assertStatusCode(500, "WebDAVFS/1.9.0 (01908000) Darwin/11.4.0 (x86_64)");
        this.assertStatusCode(500, "WebDAVFS/100.10.5 (01908000) Darwin/11.4.0 (x86_64)");
        this.assertStatusCode(500, "WebDAVFS/100.10.5 (01908000) Darwin/109.6.3 (some_other_processor_arch)");
        this.assertStatusCode(403, "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_6; en-us)");
        this.assertStatusCode(403, "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.2.12)");
        this.assertStatusCode(403, "SomeBrowser/1.0 (Macintosh; U; Intel Mac OS X 10_6; en-us)");
        this.assertStatusCode(403, "SomeBrowser/1.9.0 (01908000) Darwin/11.4.0 (x86_64)");
        this.assertStatusCode(403, "Cyberduck/4.2.1 (Mac OS X/10.7.4) (i386)");
        this.assertStatusCode(403, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_4) AppleWebKit/536.5 (KHTML, like Gecko) Chrome/19.0.1084.54 Safari/536.5");
        this.assertStatusCode(403, "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_7_4) AppleWebKit/534.57.2 (KHTML, like Gecko) Version/5.1.7 Safari/534.57.2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Category(value={IntermittentlyFailingTests.class})
    @Test
    public void expiryLockTest() {
        Level repoWebdavSaveLogLevel = Logger.getLogger((String)"org.alfresco.repo.webdav").getLevel();
        Logger.getLogger((String)"org.alfresco.repo.webdav").setLevel(Level.ALL);
        Level webdavProtocolSaveLogLevel = Logger.getLogger((String)"org.alfresco.webdav.protocol").getLevel();
        Logger.getLogger((String)"org.alfresco.webdav.protocol").setLevel(Level.ALL);
        try {
            this.setUpApplicationContext();
            this.req = new MockHttpServletRequest();
            this.resp = new MockHttpServletResponse();
            String rootPath = "/app:company_home";
            StoreRef storeRef = new StoreRef("workspace://SpacesStore");
            NodeRef storeRootNodeRef = this.nodeService.getRootNode(storeRef);
            List nodeRefs = this.searchService.selectNodes(storeRootNodeRef, rootPath, null, (NamespacePrefixResolver)this.namespaceService, false);
            NodeRef defaultRootNode = (NodeRef)nodeRefs.get(0);
            NodeRef rootNodeRef = this.tenantService.getRootNode(this.nodeService, this.searchService, this.namespaceService, rootPath, defaultRootNode);
            NodeRef folderNodeRef = this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"test"), ContentModel.TYPE_FOLDER, Collections.singletonMap(ContentModel.PROP_NAME, "WebDavMethodExpiryLockTest" + System.currentTimeMillis())).getChildRef();
            NodeRef nodeRef = this.nodeService.createNode(folderNodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"test"), ContentModel.TYPE_CONTENT, Collections.singletonMap(ContentModel.PROP_NAME, "text.txt")).getChildRef();
            this.lockMethod = new LockMethod();
            this.lockMethod.createExclusive = true;
            this.lockMethod.m_timeoutDuration = 1;
            this.lockMethod.setDetails((HttpServletRequest)this.req, (HttpServletResponse)this.resp, this.webDAVHelper, nodeRef);
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    try {
                        WebDAVMethodTest.this.lockMethod.executeImpl();
                        for (int timeout = 5; timeout > 0 && !WebDAVMethodTest.this.lockMethod.lockInfo.isExpired(); --timeout) {
                            Thread.sleep(1000L);
                        }
                        WebDAVMethodTest.this.lockMethod.executeImpl();
                    }
                    catch (WebDAVServerException e) {
                        logger.debug((Object)e);
                        com.ibm.icu.impl.Assert.fail((String)"Document was not locked again, when lock has expired.");
                    }
                    return null;
                }
            });
            this.nodeService.deleteNode(folderNodeRef);
        }
        finally {
            Logger.getLogger((String)"org.alfresco.webdav.protocol").setLevel(webdavProtocolSaveLogLevel);
            Logger.getLogger((String)"org.alfresco.repo.webdav").setLevel(repoWebdavSaveLogLevel);
        }
    }

    private void assertStatusCode(int expectedStatusCode, String userAgent) {
        this.createRequestObjects();
        this.req.addHeader("User-Agent", (Object)userAgent);
        this.method.setDetails((HttpServletRequest)this.req, (HttpServletResponse)this.resp, this.davHelper, null);
        int statusCode = this.method.getStatusForAccessDeniedException();
        Assert.assertEquals((String)("Incorrect status code for user-agent string \"" + userAgent + "\""), (long)expectedStatusCode, (long)statusCode);
    }

    private void createRequestObjects() {
        this.method = new TestWebDAVMethod();
        this.req = new MockHttpServletRequest();
        this.resp = new MockHttpServletResponse();
    }

    private static class TestWebDAVMethod
    extends WebDAVMethod {
        private TestWebDAVMethod() {
        }

        protected void executeImpl() throws WebDAVServerException, Exception {
        }

        protected void parseRequestBody() throws WebDAVServerException {
        }

        protected void parseRequestHeaders() throws WebDAVServerException {
        }
    }
}

