/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.workflow;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.person.TestGroupManager;
import org.alfresco.repo.security.person.TestPersonManager;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.repo.workflow.WorkflowAdminServiceImpl;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.repo.workflow.WorkflowTestHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowDefinition;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowPath;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskDefinition;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.LuceneTests;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.surf.util.ISO8601DateFormat;
import org.springframework.extensions.webscripts.TestWebScriptServer;

@Category(value={LuceneTests.class})
public abstract class AbstractWorkflowRestApiTest
extends BaseWebScriptTest {
    protected static final String USER1 = "Bob" + GUID.generate();
    protected static final String USER2 = "Jane" + GUID.generate();
    protected static final String USER3 = "Nick" + GUID.generate();
    protected static final String GROUP = "Group" + GUID.generate();
    protected static final String URL_TASKS = "api/task-instances";
    protected static final String URL_USER_TASKS = "api/task-instances?authority={0}";
    protected static final String URL_USER_TASKS_PROPERTIES = "api/task-instances?authority={0}&properties={1}";
    protected static final String URL_TASKS_DUE_BEFORE = "api/task-instances?dueBefore={0}";
    protected static final String URL_TASKS_DUE_AFTER = "api/task-instances?dueAfter={0}";
    protected static final String URL_TASKS_DUE_AFTER_AND_SKIP = "api/task-instances?dueAfter={0}&skipCount={1}";
    protected static final String URL_WORKFLOW_TASKS = "api/workflow-instances/{0}/task-instances";
    protected static final String URL_WORKFLOW_DEFINITIONS = "api/workflow-definitions";
    protected static final String URL_WORKFLOW_DEFINITION = "api/workflow-definitions/{0}";
    protected static final String URL_WORKFLOW_INSTANCES = "api/workflow-instances";
    protected static final String URL_WORKFLOW_INSTANCES_FOR_DEFINITION = "api/workflow-definitions/{0}/workflow-instances";
    protected static final String URL_WORKFLOW_INSTANCES_FOR_NODE = "api/node/{0}/{1}/{2}/workflow-instances";
    protected static final String COMPANY_HOME = "/app:company_home";
    protected static final String TEST_CONTENT = "TestContent";
    protected static final String ADHOC_START_TASK_TYPE = "wf:submitAdhocTask";
    protected static final String ADHOC_TASK_TYPE = "wf:adhocTask";
    protected static final String ADHOC_TASK_COMPLETED_TYPE = "wf:completedAdhocTask";
    private TestPersonManager personManager;
    private TestGroupManager groupManager;
    protected WorkflowService workflowService;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private NodeRef packageRef;
    private NodeRef contentNodeRef;
    private AuthenticationComponent authenticationComponent;
    private DictionaryService dictionaryService;
    private List<String> workflows = new LinkedList<String>();
    private WorkflowTestHelper wfTestHelper;

    public void testTaskInstancesGet() throws Exception {
        this.personManager.setUser(USER2);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2)), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        AbstractWorkflowRestApiTest.assertTrue((results.length() == 0 ? 1 : 0) != 0);
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName(this.getAdhocWorkflowDefinitionName());
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        Calendar dueDateCal = Calendar.getInstance();
        Date dueDate = dueDateCal.getTime();
        params.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.getId(), params);
        String workflowId = adhocPath.getInstance().getId();
        this.workflows.add(workflowId);
        WorkflowTask startTask = this.workflowService.getStartTask(workflowId);
        this.workflowService.endTask(startTask.getId(), null);
        List tasks = this.workflowService.getAssignedTasks(USER2, WorkflowTaskState.IN_PROGRESS);
        WorkflowTask task = (WorkflowTask)tasks.get(0);
        HashMap<QName, Date> updateParams = new HashMap<QName, Date>(1);
        updateParams.put(WorkflowModel.PROP_DUE_DATE, new Date());
        this.workflowService.updateTask(task.getId(), updateParams, null, null);
        this.personManager.setUser(USER2);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2)), 200);
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        AbstractWorkflowRestApiTest.assertTrue((results.length() == tasks.size() ? 1 : 0) != 0);
        JSONObject result = results.getJSONObject(0);
        int totalItems = results.length();
        String expUrl = "api/task-instances/" + task.getId();
        AbstractWorkflowRestApiTest.assertEquals((String)expUrl, (String)result.getString("url"));
        AbstractWorkflowRestApiTest.assertEquals((String)task.getName(), (String)result.getString("name"));
        AbstractWorkflowRestApiTest.assertEquals((String)task.getTitle(), (String)result.getString("title"));
        AbstractWorkflowRestApiTest.assertEquals((String)task.getDescription(), (String)result.getString("description"));
        AbstractWorkflowRestApiTest.assertEquals((String)task.getState().name(), (String)result.getString("state"));
        AbstractWorkflowRestApiTest.assertEquals((String)("api/workflow-paths/" + adhocPath.getId()), (String)result.getString("path"));
        AbstractWorkflowRestApiTest.assertFalse((boolean)result.getBoolean("isPooled"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)result.getBoolean("isEditable"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)result.getBoolean("isReassignable"));
        AbstractWorkflowRestApiTest.assertFalse((boolean)result.getBoolean("isClaimable"));
        AbstractWorkflowRestApiTest.assertFalse((boolean)result.getBoolean("isReleasable"));
        JSONObject owner = result.getJSONObject("owner");
        AbstractWorkflowRestApiTest.assertEquals((String)USER2, (String)owner.getString("userName"));
        AbstractWorkflowRestApiTest.assertEquals((String)this.personManager.getFirstName(USER2), (String)owner.getString("firstName"));
        AbstractWorkflowRestApiTest.assertEquals((String)this.personManager.getLastName(USER2), (String)owner.getString("lastName"));
        JSONObject properties = result.getJSONObject("properties");
        AbstractWorkflowRestApiTest.assertNotNull((Object)properties);
        JSONObject instance = result.getJSONObject("workflowInstance");
        AbstractWorkflowRestApiTest.assertNotNull((Object)instance);
        this.checkTasksState("api/task-instances?state=completed", WorkflowTaskState.COMPLETED);
        this.checkTasksState("api/task-instances?state=in_progress", WorkflowTaskState.IN_PROGRESS);
        this.checkPriorityFiltering("api/task-instances?priority=2");
        dueDateCal.add(5, -1);
        this.checkTasksPresent(MessageFormat.format(URL_TASKS_DUE_AFTER, org.alfresco.util.ISO8601DateFormat.format((Date)dueDateCal.getTime())), true, task.getId());
        this.checkTasksPresent(MessageFormat.format(URL_TASKS_DUE_BEFORE, org.alfresco.util.ISO8601DateFormat.format((Date)dueDateCal.getTime())), false, task.getId());
        dueDateCal.add(5, 2);
        this.checkTasksPresent(MessageFormat.format(URL_TASKS_DUE_BEFORE, org.alfresco.util.ISO8601DateFormat.format((Date)dueDateCal.getTime())), true, task.getId());
        this.checkTasksPresent(MessageFormat.format(URL_TASKS_DUE_AFTER, org.alfresco.util.ISO8601DateFormat.format((Date)dueDateCal.getTime())), false, task.getId());
        String customProperties = "bpm_description,bpm_priority";
        this.checkTaskPropertyFiltering(customProperties, Arrays.asList("bpm_description", "bpm_priority"));
        customProperties = "bpm_unexistingProperty,bpm_description,bpm_priority";
        this.checkTaskPropertyFiltering(customProperties, Arrays.asList("bpm_description", "bpm_priority", "bpm_unexistingProperty"));
        int maxItems = 3;
        for (int skipCount = 0; skipCount < totalItems; skipCount += maxItems) {
            this.checkPaging(MessageFormat.format(URL_USER_TASKS, USER2) + "&maxItems=" + maxItems + "&skipCount=" + skipCount, totalItems, maxItems, skipCount);
        }
        this.checkPaging(MessageFormat.format(URL_USER_TASKS, USER2) + "&maxItems=" + maxItems + "&skipCount=" + (totalItems + 1), totalItems, maxItems, totalItems + 1);
        String exclude = ADHOC_START_TASK_TYPE;
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/task-instances?exclude=" + exclude), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        boolean adhocTasksPresent = false;
        for (int i = 0; i < results.length(); ++i) {
            JSONObject taskJSON = results.getJSONObject(i);
            String type = taskJSON.getString("name");
            if (!exclude.equals(type)) continue;
            adhocTasksPresent = true;
            break;
        }
        AbstractWorkflowRestApiTest.assertFalse((String)"Found wf:submitAdhocTask when they were supposed to be excluded", (boolean)adhocTasksPresent);
        this.personManager.setUser(USER1);
        params.clear();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        dueDateCal.add(6, 2);
        params.put(WorkflowModel.PROP_DUE_DATE, dueDateCal.getTime());
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.workflowService.createPackage(null));
        WorkflowPath adhocPath2 = this.workflowService.startWorkflow(adhocDef.getId(), params);
        String workflowId2 = adhocPath2.getInstance().getId();
        this.workflows.add(workflowId2);
        WorkflowTask startTask2 = this.workflowService.getStartTask(workflowId2);
        this.workflowService.endTask(startTask2.getId(), null);
        String url = MessageFormat.format(URL_TASKS_DUE_AFTER_AND_SKIP, org.alfresco.util.ISO8601DateFormat.format((Date)dueDateCal.getTime()), 1);
        json = this.getDataFromRequest(url);
        JSONArray resultArray = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertEquals((int)0, (int)resultArray.length());
    }

    public void testTaskInstancesGetWithFiltering() throws Exception {
        this.personManager.setUser(USER2);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2)), 200);
        this.getJsonArray(response, 0);
        this.personManager.setUser(USER1);
        WorkflowDefinition wfDefinition = this.workflowService.getDefinitionByName(this.getReviewPooledWorkflowDefinitionName());
        HashMap<QName, Object> params = new HashMap<QName, Object>(3);
        params.put(WorkflowModel.ASSOC_GROUP_ASSIGNEE, this.groupManager.get(GROUP));
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        params.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, "descTest1");
        WorkflowPath wfPath = this.workflowService.startWorkflow(wfDefinition.getId(), params);
        String workflowId = wfPath.getInstance().getId();
        this.workflows.add(workflowId);
        WorkflowTask startTask = this.workflowService.getStartTask(workflowId);
        this.workflowService.endTask(startTask.getId(), null);
        wfDefinition = this.workflowService.getDefinitionByName(this.getReviewPooledWorkflowDefinitionName());
        params.put(WorkflowModel.ASSOC_GROUP_ASSIGNEE, this.groupManager.get(GROUP));
        params.put(WorkflowModel.ASSOC_PACKAGE, this.workflowService.createPackage(null));
        params.put(WorkflowModel.PROP_WORKFLOW_DESCRIPTION, "descTest2/withSlash");
        wfPath = this.workflowService.startWorkflow(wfDefinition.getId(), params);
        workflowId = wfPath.getInstance().getId();
        this.workflows.add(workflowId);
        startTask = this.workflowService.getStartTask(workflowId);
        this.workflowService.endTask(startTask.getId(), null);
        this.personManager.setUser(USER2);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2)), 200);
        this.getJsonArray(response, 2);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2) + "&property=bpm:description/descTest1"), 200);
        JSONArray results = this.getJsonArray(response, 1);
        JSONObject result = results.getJSONObject(0);
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        JSONObject properties = result.getJSONObject("properties");
        AbstractWorkflowRestApiTest.assertNotNull((Object)properties);
        AbstractWorkflowRestApiTest.assertEquals((String)"descTest1", (String)properties.getString("bpm_description"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2) + "&property=bpm:description/descTest2/withSlash"), 200);
        results = this.getJsonArray(response, 1);
        result = results.getJSONObject(0);
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        properties = result.getJSONObject("properties");
        AbstractWorkflowRestApiTest.assertNotNull((Object)properties);
        AbstractWorkflowRestApiTest.assertEquals((String)"descTest2/withSlash", (String)properties.getString("bpm_description"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2) + "&property=bpm:description/somePropValue"), 200);
        this.getJsonArray(response, 0);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2) + "&property=unknownPrefix:description/test"), 200);
        this.getJsonArray(response, 2);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2) + "&property=bpm:nonexistentProp/test"), 200);
        this.getJsonArray(response, 2);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2) + "&property=bpm:description/"), 200);
        this.getJsonArray(response, 2);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2) + "&property=descTest1"), 200);
        this.getJsonArray(response, 2);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2) + "&property=/descTest1"), 200);
        this.getJsonArray(response, 2);
        this.personManager.setUser(USER3);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER3)), 200);
        this.getJsonArray(response, 0);
    }

    public void testWorkflowPermissions() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName(this.getAdhocWorkflowDefinitionName());
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER1));
        Calendar dueDateCal = Calendar.getInstance();
        Date dueDate = dueDateCal.getTime();
        params.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.getId(), params);
        String workflowId = adhocPath.getInstance().getId();
        this.workflows.add(workflowId);
        WorkflowTask startTask = this.workflowService.getStartTask(workflowId);
        this.workflowService.endTask(startTask.getId(), null);
        this.personManager.setUser(USER2);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER1)), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        AbstractWorkflowRestApiTest.assertTrue((String)"User2 should not see any tasks if he is not initiator or assignee", (results.length() == 0 ? 1 : 0) != 0);
    }

    public void testTaskInstancesForWorkflowGet() throws Exception {
        this.personManager.setUser(USER2);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_WORKFLOW_TASKS, "Foo")), 500);
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName(this.getAdhocWorkflowDefinitionName());
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        Calendar dueDateCal = Calendar.getInstance();
        Date dueDate = dueDateCal.getTime();
        params.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.getId(), params);
        String workflowId = adhocPath.getInstance().getId();
        this.workflows.add(workflowId);
        WorkflowTask startTask = this.workflowService.getStartTask(workflowId);
        String startTaskId = startTask.getId();
        this.workflowService.endTask(startTaskId, null);
        List tasks = this.workflowService.getAssignedTasks(USER2, WorkflowTaskState.IN_PROGRESS);
        AbstractWorkflowRestApiTest.assertEquals((int)1, (int)tasks.size());
        WorkflowTask task = (WorkflowTask)tasks.get(0);
        String baseUrl = MessageFormat.format(URL_WORKFLOW_TASKS, workflowId);
        String adhocTaskId = task.getId();
        this.checkTasksMatch(baseUrl, startTaskId);
        String completedUrl = baseUrl + "?state=" + WorkflowTaskState.COMPLETED;
        this.checkTasksMatch(completedUrl, startTaskId);
        this.personManager.setUser(USER2);
        String inProgressUrl = baseUrl + "?state=" + WorkflowTaskState.IN_PROGRESS;
        this.checkTasksMatch(inProgressUrl, adhocTaskId);
        String user1Url = baseUrl + "?authority=" + USER1;
        this.checkTasksMatch(user1Url, startTaskId);
        String user2Url = baseUrl + "?authority=" + USER2;
        this.checkTasksMatch(user2Url, adhocTaskId);
        String user1CompletedURL = user1Url + "&state=" + WorkflowTaskState.COMPLETED;
        this.checkTasksMatch(user1CompletedURL, startTaskId);
        String user1InProgressURL = user1Url + "&state=" + WorkflowTaskState.IN_PROGRESS;
        this.checkTasksMatch(user1InProgressURL, new String[0]);
        String user2CompletedURL = user2Url + "&state=" + WorkflowTaskState.COMPLETED;
        this.checkTasksMatch(user2CompletedURL, new String[0]);
        String user2InProgressURL = user2Url + "&state=" + WorkflowTaskState.IN_PROGRESS;
        this.checkTasksMatch(user2InProgressURL, adhocTaskId);
    }

    public void testTaskInstanceGet() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName(this.getAdhocWorkflowDefinitionName());
        Calendar dueDateCal = Calendar.getInstance();
        dueDateCal.clear(14);
        Date dueDate = dueDateCal.getTime();
        NodeRef assignee = this.personManager.get(USER2);
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, assignee);
        params.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.getId(), params);
        String workflowId = adhocPath.getInstance().getId();
        this.workflows.add(workflowId);
        WorkflowTask startTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.getId()).get(0);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/task-instances/" + startTask.getId()), 200);
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONObject result = json.getJSONObject("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        AbstractWorkflowRestApiTest.assertEquals((String)startTask.getId(), (String)result.getString("id"));
        AbstractWorkflowRestApiTest.assertEquals((String)("api/task-instances/" + startTask.getId()), (String)result.getString("url"));
        AbstractWorkflowRestApiTest.assertEquals((String)startTask.getName(), (String)result.getString("name"));
        AbstractWorkflowRestApiTest.assertEquals((String)startTask.getTitle(), (String)result.getString("title"));
        AbstractWorkflowRestApiTest.assertEquals((String)startTask.getDescription(), (String)result.getString("description"));
        AbstractWorkflowRestApiTest.assertEquals((String)startTask.getState().name(), (String)result.getString("state"));
        AbstractWorkflowRestApiTest.assertEquals((String)("api/workflow-paths/" + adhocPath.getId()), (String)result.getString("path"));
        this.checkWorkflowTaskEditable(result);
        this.checkWorkflowTaskOwner(result, USER1);
        this.checkWorkflowTaskPropertiesPresent(result);
        JSONObject properties = result.getJSONObject("properties");
        AbstractWorkflowRestApiTest.assertEquals((int)1, (int)properties.getInt("bpm_priority"));
        String dueDateStr = org.alfresco.util.ISO8601DateFormat.format((Date)dueDate);
        AbstractWorkflowRestApiTest.assertEquals((String)dueDateStr, (String)properties.getString("bpm_dueDate"));
        AbstractWorkflowRestApiTest.assertEquals((String)assignee.toString(), (String)properties.getString("bpm_assignee"));
        AbstractWorkflowRestApiTest.assertEquals((String)this.packageRef.toString(), (String)properties.getString("bpm_package"));
        this.checkWorkflowInstance(startTask.getPath().getInstance(), result.getJSONObject("workflowInstance"));
        this.checkWorkflowTaskDefinition(startTask.getDefinition(), result.getJSONObject("definition"));
        this.personManager.setUser(USER2);
        this.workflowService.endTask(startTask.getId(), null);
        startTask = this.workflowService.getTaskById(startTask.getId());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/task-instances/" + startTask.getId()), 200);
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        result = json.getJSONObject("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        AbstractWorkflowRestApiTest.assertEquals((String)startTask.getId(), (String)result.getString("id"));
        AbstractWorkflowRestApiTest.assertEquals((String)("api/task-instances/" + startTask.getId()), (String)result.getString("url"));
        AbstractWorkflowRestApiTest.assertEquals((String)startTask.getName(), (String)result.getString("name"));
        AbstractWorkflowRestApiTest.assertEquals((String)startTask.getTitle(), (String)result.getString("title"));
        AbstractWorkflowRestApiTest.assertEquals((String)startTask.getDescription(), (String)result.getString("description"));
        AbstractWorkflowRestApiTest.assertEquals((String)startTask.getState().name(), (String)result.getString("state"));
        AbstractWorkflowRestApiTest.assertEquals((String)("api/workflow-paths/" + adhocPath.getId()), (String)result.getString("path"));
        this.checkWorkflowTaskReadOnly(result);
        this.checkWorkflowTaskOwner(result, USER1);
        this.checkWorkflowTaskPropertiesPresent(result);
        this.checkWorkflowInstance(startTask.getPath().getInstance(), result.getJSONObject("workflowInstance"));
        this.checkWorkflowTaskDefinition(startTask.getDefinition(), result.getJSONObject("definition"));
        WorkflowTask firstTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.getId()).get(0);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/task-instances/" + firstTask.getId()), 200);
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        result = json.getJSONObject("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        AbstractWorkflowRestApiTest.assertEquals((String)firstTask.getId(), (String)result.getString("id"));
        AbstractWorkflowRestApiTest.assertEquals((String)("api/task-instances/" + firstTask.getId()), (String)result.getString("url"));
        AbstractWorkflowRestApiTest.assertEquals((String)firstTask.getName(), (String)result.getString("name"));
        AbstractWorkflowRestApiTest.assertEquals((String)firstTask.getTitle(), (String)result.getString("title"));
        AbstractWorkflowRestApiTest.assertEquals((String)firstTask.getDescription(), (String)result.getString("description"));
        AbstractWorkflowRestApiTest.assertEquals((String)firstTask.getState().name(), (String)result.getString("state"));
        AbstractWorkflowRestApiTest.assertEquals((String)WorkflowTaskState.IN_PROGRESS.toString(), (String)result.getString("state"));
        AbstractWorkflowRestApiTest.assertEquals((String)("api/workflow-paths/" + adhocPath.getId()), (String)result.getString("path"));
        this.checkWorkflowTaskEditable(result);
        this.checkWorkflowTaskOwner(result, USER2);
        this.checkWorkflowTaskPropertiesPresent(result);
        this.checkWorkflowInstance(firstTask.getPath().getInstance(), result.getJSONObject("workflowInstance"));
        this.checkWorkflowTaskDefinition(firstTask.getDefinition(), result.getJSONObject("definition"));
        this.workflowService.endTask(firstTask.getId(), null);
        firstTask = this.workflowService.getTaskById(firstTask.getId());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/task-instances/" + firstTask.getId()), 200);
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        result = json.getJSONObject("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        AbstractWorkflowRestApiTest.assertEquals((String)firstTask.getId(), (String)result.getString("id"));
        AbstractWorkflowRestApiTest.assertEquals((String)("api/task-instances/" + firstTask.getId()), (String)result.getString("url"));
        AbstractWorkflowRestApiTest.assertEquals((String)firstTask.getName(), (String)result.getString("name"));
        AbstractWorkflowRestApiTest.assertEquals((String)firstTask.getTitle(), (String)result.getString("title"));
        AbstractWorkflowRestApiTest.assertEquals((String)firstTask.getDescription(), (String)result.getString("description"));
        AbstractWorkflowRestApiTest.assertEquals((String)firstTask.getState().name(), (String)result.getString("state"));
        AbstractWorkflowRestApiTest.assertEquals((String)WorkflowTaskState.COMPLETED.toString(), (String)result.getString("state"));
        AbstractWorkflowRestApiTest.assertEquals((String)("api/workflow-paths/" + adhocPath.getId()), (String)result.getString("path"));
        this.checkWorkflowTaskReadOnly(result);
        this.checkWorkflowTaskOwner(result, USER2);
        this.checkWorkflowTaskPropertiesPresent(result);
        this.checkWorkflowInstance(firstTask.getPath().getInstance(), result.getJSONObject("workflowInstance"));
        this.checkWorkflowTaskDefinition(firstTask.getDefinition(), result.getJSONObject("definition"));
    }

    private void checkWorkflowTaskPropertiesPresent(JSONObject taskJson) throws Exception {
        JSONObject properties = taskJson.getJSONObject("properties");
        AbstractWorkflowRestApiTest.assertNotNull((Object)properties);
        AbstractWorkflowRestApiTest.assertTrue((boolean)properties.has("bpm_priority"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)properties.has("bpm_description"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)properties.has("bpm_reassignable"));
        JSONObject labels = taskJson.getJSONObject("propertyLabels");
        AbstractWorkflowRestApiTest.assertNotNull((Object)labels);
        AbstractWorkflowRestApiTest.assertTrue((boolean)labels.has("bpm_status"));
    }

    private void checkWorkflowTaskReadOnly(JSONObject taskJson) throws Exception {
        AbstractWorkflowRestApiTest.assertFalse((boolean)taskJson.getBoolean("isPooled"));
        AbstractWorkflowRestApiTest.assertFalse((boolean)taskJson.getBoolean("isEditable"));
        AbstractWorkflowRestApiTest.assertFalse((boolean)taskJson.getBoolean("isReassignable"));
        AbstractWorkflowRestApiTest.assertFalse((boolean)taskJson.getBoolean("isClaimable"));
        AbstractWorkflowRestApiTest.assertFalse((boolean)taskJson.getBoolean("isReleasable"));
    }

    private void checkWorkflowTaskOwner(JSONObject taskJson, String user) throws Exception {
        JSONObject owner = taskJson.getJSONObject("owner");
        AbstractWorkflowRestApiTest.assertEquals((String)user, (String)owner.getString("userName"));
        AbstractWorkflowRestApiTest.assertEquals((String)this.personManager.getFirstName(user), (String)owner.getString("firstName"));
        AbstractWorkflowRestApiTest.assertEquals((String)this.personManager.getLastName(user), (String)owner.getString("lastName"));
    }

    private void checkWorkflowTaskEditable(JSONObject taskJson) throws Exception {
        AbstractWorkflowRestApiTest.assertFalse((boolean)taskJson.getBoolean("isPooled"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)taskJson.getBoolean("isEditable"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)taskJson.getBoolean("isReassignable"));
        AbstractWorkflowRestApiTest.assertFalse((boolean)taskJson.getBoolean("isClaimable"));
        AbstractWorkflowRestApiTest.assertFalse((boolean)taskJson.getBoolean("isReleasable"));
    }

    private void checkWorkflowInstance(WorkflowInstance wfInstance, JSONObject instance) throws Exception {
        AbstractWorkflowRestApiTest.assertNotNull((Object)instance);
        AbstractWorkflowRestApiTest.assertEquals((String)wfInstance.getId(), (String)instance.getString("id"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)instance.has("url"));
        AbstractWorkflowRestApiTest.assertEquals((String)wfInstance.getDefinition().getName(), (String)instance.getString("name"));
        AbstractWorkflowRestApiTest.assertEquals((String)wfInstance.getDefinition().getTitle(), (String)instance.getString("title"));
        AbstractWorkflowRestApiTest.assertEquals((String)wfInstance.getDefinition().getDescription(), (String)instance.getString("description"));
        AbstractWorkflowRestApiTest.assertEquals((boolean)wfInstance.isActive(), (boolean)instance.getBoolean("isActive"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)instance.has("startDate"));
        JSONObject initiator = instance.getJSONObject("initiator");
        AbstractWorkflowRestApiTest.assertEquals((String)USER1, (String)initiator.getString("userName"));
        AbstractWorkflowRestApiTest.assertEquals((String)this.personManager.getFirstName(USER1), (String)initiator.getString("firstName"));
        AbstractWorkflowRestApiTest.assertEquals((String)this.personManager.getLastName(USER1), (String)initiator.getString("lastName"));
    }

    private void checkWorkflowTaskDefinition(WorkflowTaskDefinition wfDefinition, JSONObject definition) throws Exception {
        AbstractWorkflowRestApiTest.assertNotNull((Object)definition);
        AbstractWorkflowRestApiTest.assertEquals((String)wfDefinition.getId(), (String)definition.getString("id"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)definition.has("url"));
        JSONObject type = definition.getJSONObject("type");
        TypeDefinition startType = wfDefinition.getMetadata();
        AbstractWorkflowRestApiTest.assertNotNull((Object)type);
        AbstractWorkflowRestApiTest.assertEquals((String)startType.getName().toPrefixString(), (String)type.getString("name"));
        AbstractWorkflowRestApiTest.assertEquals((String)startType.getTitle((MessageLookup)this.dictionaryService), (String)type.getString("title"));
        AbstractWorkflowRestApiTest.assertEquals((String)startType.getDescription((MessageLookup)this.dictionaryService), (String)type.getString("description"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)type.has("url"));
        JSONObject node = definition.getJSONObject("node");
        WorkflowNode startNode = wfDefinition.getNode();
        AbstractWorkflowRestApiTest.assertNotNull((Object)node);
        AbstractWorkflowRestApiTest.assertEquals((String)startNode.getName(), (String)node.getString("name"));
        AbstractWorkflowRestApiTest.assertEquals((String)startNode.getTitle(), (String)node.getString("title"));
        AbstractWorkflowRestApiTest.assertEquals((String)startNode.getDescription(), (String)node.getString("description"));
        AbstractWorkflowRestApiTest.assertEquals((boolean)startNode.isTaskNode(), (boolean)node.getBoolean("isTaskNode"));
        JSONArray transitions = node.getJSONArray("transitions");
        WorkflowTransition[] startTransitions = startNode.getTransitions();
        AbstractWorkflowRestApiTest.assertNotNull((Object)transitions);
        AbstractWorkflowRestApiTest.assertEquals((int)startTransitions.length, (int)transitions.length());
        for (int i = 0; i < transitions.length(); ++i) {
            JSONObject transition = transitions.getJSONObject(i);
            WorkflowTransition startTransition = startTransitions[i];
            AbstractWorkflowRestApiTest.assertNotNull((Object)transition);
            if (startTransition.getId() == null) {
                AbstractWorkflowRestApiTest.assertEquals((String)"", (String)transition.getString("id"));
            } else {
                AbstractWorkflowRestApiTest.assertEquals((String)startTransition.getId(), (String)transition.getString("id"));
            }
            AbstractWorkflowRestApiTest.assertEquals((String)startTransition.getTitle(), (String)transition.getString("title"));
            AbstractWorkflowRestApiTest.assertEquals((String)startTransition.getDescription(), (String)transition.getString("description"));
            AbstractWorkflowRestApiTest.assertEquals((boolean)startTransition.isDefault(), (boolean)transition.getBoolean("isDefault"));
            AbstractWorkflowRestApiTest.assertTrue((boolean)transition.has("isHidden"));
        }
    }

    public void testTaskInstancePut() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName(this.getAdhocWorkflowDefinitionName());
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        Calendar dueDate = Calendar.getInstance();
        dueDate.set(14, 0);
        params.put(WorkflowModel.PROP_DUE_DATE, new Date());
        params.put(WorkflowModel.PROP_PRIORITY, 2);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.getId(), params);
        String worfklowId = adhocPath.getInstance().getId();
        this.workflows.add(worfklowId);
        WorkflowTask startTask = this.workflowService.getStartTask(adhocPath.getInstance().getId());
        this.workflowService.endTask(startTask.getId(), null);
        WorkflowTask firstTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.getId()).get(0);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/task-instances/" + firstTask.getId()), 200);
        JSONObject jsonProperties = new JSONObject(response.getContentAsString()).getJSONObject("data").getJSONObject("properties");
        jsonProperties.remove(this.qnameToString(WorkflowModel.ASSOC_PACKAGE));
        jsonProperties.put(this.qnameToString(WorkflowModel.PROP_COMMENT), (Object)"Edited comment");
        Calendar newDueDate = Calendar.getInstance();
        newDueDate.set(14, 0);
        jsonProperties.put(this.qnameToString(WorkflowModel.PROP_DUE_DATE), (Object)org.alfresco.util.ISO8601DateFormat.format((Date)newDueDate.getTime()));
        jsonProperties.put(this.qnameToString(WorkflowModel.PROP_DESCRIPTION), (Object)"Edited description");
        jsonProperties.put(this.qnameToString(WorkflowModel.PROP_PRIORITY), 1);
        jsonProperties.put("customIntegerProperty", 1234);
        jsonProperties.put("customBooleanProperty", (Object)Boolean.TRUE);
        jsonProperties.put("customStringProperty", (Object)"Property value");
        this.personManager.setUser(USER3);
        TestWebScriptServer.Response unauthResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/task-instances/" + firstTask.getId(), jsonProperties.toString(), "application/json"), 401);
        AbstractWorkflowRestApiTest.assertEquals((int)401, (int)unauthResponse.getStatus());
        this.personManager.setUser(USER2);
        TestWebScriptServer.Response putResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/task-instances/" + firstTask.getId(), jsonProperties.toString(), "application/json"), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)putResponse.getStatus());
        String jsonStr = putResponse.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONObject result = json.getJSONObject("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        JSONObject editedJsonProperties = result.getJSONObject("properties");
        editedJsonProperties.remove(this.qnameToString(ContentModel.PROP_CREATOR));
        this.compareProperties(jsonProperties, editedJsonProperties);
        this.personManager.setUser(USER1);
        putResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/task-instances/" + firstTask.getId(), jsonProperties.toString(), "application/json"), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)putResponse.getStatus());
        jsonStr = putResponse.getContentAsString();
        json = new JSONObject(jsonStr);
        result = json.getJSONObject("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        editedJsonProperties = result.getJSONObject("properties");
        editedJsonProperties.remove(this.qnameToString(ContentModel.PROP_CREATOR));
        this.compareProperties(jsonProperties, editedJsonProperties);
        jsonProperties = new JSONObject();
        jsonProperties.put(this.qnameToString(ContentModel.PROP_OWNER), (Object)USER3);
        putResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/task-instances/" + firstTask.getId(), jsonProperties.toString(), "application/json"), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)putResponse.getStatus());
        this.personManager.setUser(USER3);
        jsonProperties.put(this.qnameToString(WorkflowModel.PROP_COMMENT), (Object)"Edited comment by USER3");
        putResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/task-instances/" + firstTask.getId(), jsonProperties.toString(), "application/json"), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)putResponse.getStatus());
        jsonStr = putResponse.getContentAsString();
        json = new JSONObject(jsonStr);
        result = json.getJSONObject("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        editedJsonProperties = result.getJSONObject("properties");
        editedJsonProperties.remove(this.qnameToString(ContentModel.PROP_CREATOR));
        this.compareProperties(jsonProperties, editedJsonProperties);
    }

    public void testTaskInstancePutCompletedTask() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName(this.getAdhocWorkflowDefinitionName());
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER1));
        params.put(WorkflowModel.PROP_DUE_DATE, new Date());
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.getId(), params);
        String WorkflowId = adhocPath.getInstance().getId();
        this.workflows.add(WorkflowId);
        WorkflowTask startTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.getId()).get(0);
        this.workflowService.endTask(startTask.getId(), null);
        WorkflowTask firstTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.getId()).get(0);
        TestWebScriptServer.Response getResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/task-instances/" + firstTask.getId()), 200);
        JSONObject jsonProperties = new JSONObject(getResponse.getContentAsString()).getJSONObject("data").getJSONObject("properties");
        jsonProperties.put(this.qnameToString(WorkflowModel.PROP_DESCRIPTION), (Object)"Edited description");
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/task-instances/" + startTask.getId(), jsonProperties.toString(), "application/json"), 401);
    }

    public void testWorkflowDefinitionsGet() throws Exception {
        String name;
        JSONObject workflowDefinitionJSON;
        int i;
        this.personManager.setUser(USER1);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_WORKFLOW_DEFINITIONS), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        JSONObject json = new JSONObject(response.getContentAsString());
        JSONArray results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        AbstractWorkflowRestApiTest.assertTrue((results.length() > 0 ? 1 : 0) != 0);
        boolean adhocWorkflowPresent = false;
        String adhocDefName = this.getAdhocWorkflowDefinitionName();
        for (int i2 = 0; i2 < results.length(); ++i2) {
            JSONObject workflowDefinitionJSON2 = results.getJSONObject(i2);
            AbstractWorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON2.has("id"));
            AbstractWorkflowRestApiTest.assertTrue((workflowDefinitionJSON2.getString("id").length() > 0 ? 1 : 0) != 0);
            AbstractWorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON2.has("url"));
            String url = workflowDefinitionJSON2.getString("url");
            AbstractWorkflowRestApiTest.assertTrue((url.length() > 0 ? 1 : 0) != 0);
            AbstractWorkflowRestApiTest.assertTrue((boolean)url.startsWith("api/workflow-definitions/"));
            AbstractWorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON2.has("name"));
            AbstractWorkflowRestApiTest.assertTrue((workflowDefinitionJSON2.getString("name").length() > 0 ? 1 : 0) != 0);
            AbstractWorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON2.has("title"));
            String title = workflowDefinitionJSON2.getString("title");
            AbstractWorkflowRestApiTest.assertTrue((title.length() > 0 ? 1 : 0) != 0);
            AbstractWorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON2.has("description"));
            String description = workflowDefinitionJSON2.getString("description");
            AbstractWorkflowRestApiTest.assertTrue((description.length() > 0 ? 1 : 0) != 0);
            if (!adhocDefName.equals(workflowDefinitionJSON2.getString("name"))) continue;
            AbstractWorkflowRestApiTest.assertEquals((String)this.getAdhocWorkflowDefinitionTitle(), (String)title);
            AbstractWorkflowRestApiTest.assertEquals((String)this.getAdhocWorkflowDefinitionDescription(), (String)description);
            adhocWorkflowPresent = true;
        }
        AbstractWorkflowRestApiTest.assertTrue((String)"Adhoc workflow definition was not present!", (boolean)adhocWorkflowPresent);
        String exclude = adhocDefName;
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/workflow-definitions?exclude=" + exclude), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        json = new JSONObject(response.getContentAsString());
        results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        adhocWorkflowPresent = false;
        for (i = 0; i < results.length(); ++i) {
            workflowDefinitionJSON = results.getJSONObject(i);
            name = workflowDefinitionJSON.getString("name");
            if (!exclude.equals(name)) continue;
            adhocWorkflowPresent = true;
            break;
        }
        AbstractWorkflowRestApiTest.assertFalse((String)"Found adhoc workflow when it was supposed to be excluded", (boolean)adhocWorkflowPresent);
        exclude = adhocDefName;
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/workflow-definitions?exclude=" + exclude), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        json = new JSONObject(response.getContentAsString());
        results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        adhocWorkflowPresent = false;
        for (i = 0; i < results.length(); ++i) {
            workflowDefinitionJSON = results.getJSONObject(i);
            name = workflowDefinitionJSON.getString("name");
            if (!name.equals(adhocDefName)) continue;
            adhocWorkflowPresent = true;
        }
        AbstractWorkflowRestApiTest.assertFalse((String)"Found adhoc workflow when it was supposed to be excluded", (boolean)adhocWorkflowPresent);
    }

    public void testWorkflowDefinitionGet() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition wDef = this.workflowService.getDefinitionByName(this.getAdhocWorkflowDefinitionName());
        String responseUrl = MessageFormat.format(URL_WORKFLOW_DEFINITION, wDef.getId());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(responseUrl), 200);
        JSONObject json = new JSONObject(response.getContentAsString());
        JSONObject workflowDefinitionJSON = json.getJSONObject("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)workflowDefinitionJSON);
        AbstractWorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON.has("id"));
        AbstractWorkflowRestApiTest.assertTrue((workflowDefinitionJSON.getString("id").length() > 0 ? 1 : 0) != 0);
        AbstractWorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON.has("url"));
        String url = workflowDefinitionJSON.getString("url");
        AbstractWorkflowRestApiTest.assertTrue((url.length() > 0 ? 1 : 0) != 0);
        AbstractWorkflowRestApiTest.assertTrue((boolean)url.startsWith("api/workflow-definitions/"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON.has("name"));
        AbstractWorkflowRestApiTest.assertTrue((workflowDefinitionJSON.getString("name").length() > 0 ? 1 : 0) != 0);
        AbstractWorkflowRestApiTest.assertEquals((String)this.getAdhocWorkflowDefinitionName(), (String)workflowDefinitionJSON.getString("name"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON.has("title"));
        AbstractWorkflowRestApiTest.assertTrue((workflowDefinitionJSON.getString("title").length() > 0 ? 1 : 0) != 0);
        AbstractWorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON.has("description"));
        AbstractWorkflowRestApiTest.assertTrue((workflowDefinitionJSON.getString("description").length() > 0 ? 1 : 0) != 0);
        AbstractWorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON.has("startTaskDefinitionUrl"));
        String startTaskDefUrl = workflowDefinitionJSON.getString("startTaskDefinitionUrl");
        AbstractWorkflowRestApiTest.assertEquals((String)startTaskDefUrl, (String)("api/classes/" + this.getSafeDefinitionName(ADHOC_START_TASK_TYPE)));
        AbstractWorkflowRestApiTest.assertTrue((boolean)workflowDefinitionJSON.has("startTaskDefinitionType"));
        AbstractWorkflowRestApiTest.assertEquals((String)ADHOC_START_TASK_TYPE, (String)workflowDefinitionJSON.getString("startTaskDefinitionType"));
        JSONArray taskDefinitions = workflowDefinitionJSON.getJSONArray("taskDefinitions");
        AbstractWorkflowRestApiTest.assertNotNull((Object)taskDefinitions);
        AbstractWorkflowRestApiTest.assertEquals((int)2, (int)taskDefinitions.length());
        JSONObject firstTaskDefinition = (JSONObject)taskDefinitions.get(0);
        this.checkTaskDefinitionTypeAndUrl(ADHOC_TASK_TYPE, firstTaskDefinition);
        JSONObject secondTaskDefinition = (JSONObject)taskDefinitions.get(1);
        this.checkTaskDefinitionTypeAndUrl(ADHOC_TASK_COMPLETED_TYPE, secondTaskDefinition);
    }

    private void checkTaskDefinitionTypeAndUrl(String expectedTaskType, JSONObject taskDefinition) throws Exception {
        AbstractWorkflowRestApiTest.assertTrue((boolean)taskDefinition.has("type"));
        AbstractWorkflowRestApiTest.assertEquals((String)expectedTaskType, (String)taskDefinition.getString("type"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)taskDefinition.has("url"));
        AbstractWorkflowRestApiTest.assertEquals((String)("api/classes/" + this.getSafeDefinitionName(expectedTaskType)), (String)taskDefinition.getString("url"));
    }

    private String getSafeDefinitionName(String definitionName) {
        return definitionName.replace(":", "_");
    }

    public void testWorkflowInstanceGet() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName(this.getAdhocWorkflowDefinitionName());
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        params.put(WorkflowModel.PROP_CONTEXT, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.getId(), params);
        String WorkflowId = adhocPath.getInstance().getId();
        this.workflows.add(WorkflowId);
        WorkflowTask startTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.getId()).get(0);
        startTask = this.workflowService.endTask(startTask.getId(), null);
        WorkflowInstance adhocInstance = startTask.getPath().getInstance();
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/workflow-instances/" + adhocInstance.getId() + "?includeTasks=true"), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONObject result = json.getJSONObject("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        AbstractWorkflowRestApiTest.assertEquals((String)adhocInstance.getId(), (String)result.getString("id"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)result.opt("message").equals(JSONObject.NULL));
        AbstractWorkflowRestApiTest.assertEquals((String)adhocInstance.getDefinition().getName(), (String)result.getString("name"));
        AbstractWorkflowRestApiTest.assertEquals((String)adhocInstance.getDefinition().getTitle(), (String)result.getString("title"));
        AbstractWorkflowRestApiTest.assertEquals((String)adhocInstance.getDefinition().getDescription(), (String)result.getString("description"));
        AbstractWorkflowRestApiTest.assertEquals((boolean)adhocInstance.isActive(), (boolean)result.getBoolean("isActive"));
        AbstractWorkflowRestApiTest.assertEquals((String)ISO8601DateFormat.format((Date)adhocInstance.getStartDate()), (String)result.getString("startDate"));
        AbstractWorkflowRestApiTest.assertNotNull((Object)result.get("dueDate"));
        AbstractWorkflowRestApiTest.assertNotNull((Object)result.get("endDate"));
        AbstractWorkflowRestApiTest.assertEquals((int)1, (int)result.getInt("priority"));
        JSONObject initiator = result.getJSONObject("initiator");
        AbstractWorkflowRestApiTest.assertEquals((String)USER1, (String)initiator.getString("userName"));
        AbstractWorkflowRestApiTest.assertEquals((String)this.personManager.getFirstName(USER1), (String)initiator.getString("firstName"));
        AbstractWorkflowRestApiTest.assertEquals((String)this.personManager.getLastName(USER1), (String)initiator.getString("lastName"));
        AbstractWorkflowRestApiTest.assertEquals((String)adhocInstance.getContext().toString(), (String)result.getString("context"));
        AbstractWorkflowRestApiTest.assertEquals((String)adhocInstance.getWorkflowPackage().toString(), (String)result.getString("package"));
        AbstractWorkflowRestApiTest.assertNotNull((Object)result.getString("startTaskInstanceId"));
        JSONObject jsonDefinition = result.getJSONObject("definition");
        WorkflowDefinition adhocDefinition = adhocInstance.getDefinition();
        AbstractWorkflowRestApiTest.assertNotNull((Object)jsonDefinition);
        AbstractWorkflowRestApiTest.assertEquals((String)adhocDefinition.getId(), (String)jsonDefinition.getString("id"));
        AbstractWorkflowRestApiTest.assertEquals((String)adhocDefinition.getName(), (String)jsonDefinition.getString("name"));
        AbstractWorkflowRestApiTest.assertEquals((String)adhocDefinition.getTitle(), (String)jsonDefinition.getString("title"));
        AbstractWorkflowRestApiTest.assertEquals((String)adhocDefinition.getDescription(), (String)jsonDefinition.getString("description"));
        AbstractWorkflowRestApiTest.assertEquals((String)adhocDefinition.getVersion(), (String)jsonDefinition.getString("version"));
        AbstractWorkflowRestApiTest.assertEquals((String)adhocDefinition.getStartTaskDefinition().getMetadata().getName().toPrefixString((NamespacePrefixResolver)this.namespaceService), (String)jsonDefinition.getString("startTaskDefinitionType"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)jsonDefinition.has("taskDefinitions"));
        JSONArray tasks = result.getJSONArray("tasks");
        AbstractWorkflowRestApiTest.assertTrue((tasks.length() > 1 ? 1 : 0) != 0);
    }

    public void testWorkflowInstancesGet() throws Exception {
        this.wfTestHelper.setVisible(false);
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName(this.getAdhocWorkflowDefinitionName());
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_WORKFLOW_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_WORKFLOW_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        params.put(WorkflowModel.PROP_CONTEXT, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.getId(), params);
        String WorkflowId = adhocPath.getInstance().getId();
        this.workflows.add(WorkflowId);
        WorkflowTask startTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.getId()).get(0);
        WorkflowInstance adhocInstance = startTask.getPath().getInstance();
        this.workflowService.endTask(startTask.getId(), null);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_WORKFLOW_INSTANCES), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray result = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        int totalItems = result.length();
        for (int i = 0; i < result.length(); ++i) {
            this.checkSimpleWorkflowInstanceResponse(result.getJSONObject(i));
        }
        TestWebScriptServer.Response forDefinitionResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_WORKFLOW_INSTANCES_FOR_DEFINITION, adhocDef.getId())), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)forDefinitionResponse.getStatus());
        String forDefinitionJsonStr = forDefinitionResponse.getContentAsString();
        JSONObject forDefinitionJson = new JSONObject(forDefinitionJsonStr);
        JSONArray forDefinitionResult = forDefinitionJson.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)forDefinitionResult);
        for (int i = 0; i < forDefinitionResult.length(); ++i) {
            this.checkSimpleWorkflowInstanceResponse(forDefinitionResult.getJSONObject(i));
        }
        Calendar hourAgoCal = Calendar.getInstance();
        hourAgoCal.setTime(dueDate);
        hourAgoCal.add(11, -1);
        Date anHourAgo = hourAgoCal.getTime();
        Calendar hourLater = Calendar.getInstance();
        hourLater.setTime(dueDate);
        hourLater.add(11, 1);
        Date anHourLater = hourLater.getTime();
        this.checkFiltering("api/workflow-instances?initiator=" + USER1);
        this.checkFiltering("api/workflow-instances?startedAfter=" + org.alfresco.util.ISO8601DateFormat.format((Date)anHourAgo));
        this.checkFiltering("api/workflow-instances?startedBefore=" + org.alfresco.util.ISO8601DateFormat.format((Date)anHourLater));
        this.checkFiltering("api/workflow-instances?dueAfter=" + org.alfresco.util.ISO8601DateFormat.format((Date)anHourAgo));
        this.checkFiltering("api/workflow-instances?dueBefore=" + org.alfresco.util.ISO8601DateFormat.format((Date)anHourLater));
        if (adhocInstance.getEndDate() != null) {
            this.checkFiltering("api/workflow-instances?completedAfter=" + org.alfresco.util.ISO8601DateFormat.format((Date)adhocInstance.getEndDate()));
            this.checkFiltering("api/workflow-instances?completedBefore=" + org.alfresco.util.ISO8601DateFormat.format((Date)adhocInstance.getEndDate()));
        }
        this.checkFiltering("api/workflow-instances?priority=1");
        this.checkFiltering("api/workflow-instances?state=active");
        this.checkFiltering("api/workflow-instances?definitionName=" + this.getAdhocWorkflowDefinitionName());
        int maxItems = 3;
        for (int skipCount = 0; skipCount < totalItems; skipCount += maxItems) {
            this.checkPaging("api/workflow-instances?maxItems=" + maxItems + "&skipCount=" + skipCount, totalItems, maxItems, skipCount);
        }
        String exclude = this.getAdhocWorkflowDefinitionName();
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/workflow-instances?exclude=" + exclude), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        JSONArray results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        boolean adhocWorkflowPresent = false;
        for (int i = 0; i < results.length(); ++i) {
            JSONObject workflowInstanceJSON = results.getJSONObject(i);
            String type = workflowInstanceJSON.getString("name");
            if (!exclude.equals(type)) continue;
            adhocWorkflowPresent = true;
            break;
        }
        AbstractWorkflowRestApiTest.assertFalse((String)"Found adhoc workflows when they were supposed to be excluded", (boolean)adhocWorkflowPresent);
    }

    public void testWorkflowInstancesForNodeGet() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName(this.getAdhocWorkflowDefinitionName());
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        params.put(WorkflowModel.PROP_DUE_DATE, new Date());
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        this.nodeService.addChild(this.packageRef, this.contentNodeRef, WorkflowModel.ASSOC_PACKAGE_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)((String)((Object)this.nodeService.getProperty(this.contentNodeRef, ContentModel.PROP_NAME))))));
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.getId(), params);
        String url = MessageFormat.format(URL_WORKFLOW_INSTANCES_FOR_NODE, this.contentNodeRef.getStoreRef().getProtocol(), this.contentNodeRef.getStoreRef().getIdentifier(), this.contentNodeRef.getId());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray result = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        AbstractWorkflowRestApiTest.assertTrue((result.length() > 0 ? 1 : 0) != 0);
        this.workflowService.cancelWorkflow(adhocPath.getInstance().getId());
        TestWebScriptServer.Response afterCancelResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)afterCancelResponse.getStatus());
        String afterCancelJsonStr = afterCancelResponse.getContentAsString();
        JSONObject afterCancelJson = new JSONObject(afterCancelJsonStr);
        JSONArray afterCancelResult = afterCancelJson.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)afterCancelResult);
        AbstractWorkflowRestApiTest.assertTrue((afterCancelResult.length() == 0 ? 1 : 0) != 0);
    }

    public void testWorkflowInstanceDeleteAsAdministrator() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName(this.getAdhocWorkflowDefinitionName());
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        params.put(WorkflowModel.PROP_CONTEXT, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.getId(), params);
        WorkflowTask startTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.getId()).get(0);
        startTask = this.workflowService.endTask(startTask.getId(), null);
        WorkflowInstance adhocInstance = startTask.getPath().getInstance();
        String admin = (String)this.authenticationComponent.getDefaultAdministratorUserNames().iterator().next();
        AuthenticationUtil.setFullyAuthenticatedUser((String)admin);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/workflow-instances/" + adhocInstance.getId()), 200);
        WorkflowInstance instance = this.workflowService.getWorkflowById(adhocInstance.getId());
        if (instance != null) {
            AbstractWorkflowRestApiTest.assertFalse((String)"The deleted workflow is still active!", (boolean)instance.isActive());
        }
        List instances = this.workflowService.getActiveWorkflows(adhocInstance.getDefinition().getId());
        for (WorkflowInstance activeInstance : instances) {
            AbstractWorkflowRestApiTest.assertFalse((boolean)adhocInstance.getId().equals(activeInstance.getId()));
        }
    }

    public void testWorkflowInstanceDelete() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName(this.getAdhocWorkflowDefinitionName());
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        params.put(WorkflowModel.PROP_CONTEXT, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.getId(), params);
        WorkflowTask startTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(adhocPath.getId()).get(0);
        startTask = this.workflowService.endTask(startTask.getId(), null);
        WorkflowInstance adhocInstance = startTask.getPath().getInstance();
        this.personManager.setUser(USER3);
        String instanceId = adhocInstance.getId();
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/workflow-instances/" + instanceId), 403);
        AbstractWorkflowRestApiTest.assertNotNull((Object)this.workflowService.getWorkflowById(instanceId));
        this.personManager.setUser(USER1);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/workflow-instances/" + instanceId), 200);
        WorkflowInstance instance = this.workflowService.getWorkflowById(instanceId);
        if (instance != null) {
            AbstractWorkflowRestApiTest.assertFalse((String)"The deleted workflow is still active!", (boolean)instance.isActive());
        }
        List instances = this.workflowService.getActiveWorkflows(adhocInstance.getDefinition().getId());
        for (WorkflowInstance activeInstance : instances) {
            AbstractWorkflowRestApiTest.assertFalse((boolean)instanceId.equals(activeInstance.getId()));
        }
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/workflow-instances/" + instanceId), 404);
    }

    public void testWorkflowInstanceDeleteAsRecreatedUser() throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition adhocDef = this.workflowService.getDefinitionByName(this.getAdhocWorkflowDefinitionName());
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        params.put(WorkflowModel.PROP_CONTEXT, this.packageRef);
        WorkflowPath adhocPath = this.workflowService.startWorkflow(adhocDef.getId(), params);
        AbstractWorkflowRestApiTest.assertNotNull((Object)this.workflowService.getWorkflowById(adhocPath.getInstance().getId()));
        this.personManager.deletePerson(USER1);
        this.personManager.createPerson(USER1);
        this.personManager.setUser(USER1);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/workflow-instances/" + adhocPath.getInstance().getId()), 200);
        AbstractWorkflowRestApiTest.assertNull((Object)this.workflowService.getWorkflowById(adhocPath.getInstance().getId()));
    }

    public void testReviewProcessFlow() throws Exception {
        this.runReviewFlow(true);
        this.packageRef = this.workflowService.createPackage(null);
        this.runReviewFlow(false);
    }

    public void testReviewPooledProcessFlow() throws Exception {
        this.runReviewPooledFlow(true);
        this.packageRef = this.workflowService.createPackage(null);
        this.runReviewPooledFlow(false);
    }

    protected void runReviewFlow(boolean approve) throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition reviewDef = this.workflowService.getDefinitionByName(this.getReviewWorkflowDefinitionName());
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_ASSIGNEE, this.personManager.get(USER2));
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        params.put(WorkflowModel.PROP_CONTEXT, this.packageRef);
        WorkflowPath reviewPath = this.workflowService.startWorkflow(reviewDef.getId(), params);
        String workflowId = reviewPath.getInstance().getId();
        this.workflows.add(workflowId);
        WorkflowTask startTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(reviewPath.getId()).get(0);
        startTask = this.workflowService.endTask(startTask.getId(), null);
        this.personManager.setUser(USER2);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2)), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        AbstractWorkflowRestApiTest.assertEquals((int)1, (int)results.length());
        String taskId = results.getJSONObject(0).getString("id");
        if (approve) {
            this.approveTask(taskId);
        } else {
            this.rejectTask(taskId);
        }
        this.personManager.setUser(USER1);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER1)), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        AbstractWorkflowRestApiTest.assertEquals((int)1, (int)results.length());
        String taskType = results.getJSONObject(0).getString("name");
        if (approve) {
            AbstractWorkflowRestApiTest.assertEquals((String)"wf:approvedTask", (String)taskType);
        } else {
            AbstractWorkflowRestApiTest.assertEquals((String)"wf:rejectedTask", (String)taskType);
        }
        this.workflowService.cancelWorkflow(workflowId);
    }

    protected void runReviewPooledFlow(boolean approve) throws Exception {
        this.personManager.setUser(USER1);
        WorkflowDefinition reviewDef = this.workflowService.getDefinitionByName(this.getReviewPooledWorkflowDefinitionName());
        HashMap<QName, Object> params = new HashMap<QName, Object>();
        params.put(WorkflowModel.ASSOC_GROUP_ASSIGNEE, this.groupManager.get(GROUP));
        Date dueDate = new Date();
        params.put(WorkflowModel.PROP_DUE_DATE, dueDate);
        params.put(WorkflowModel.PROP_PRIORITY, 1);
        params.put(WorkflowModel.ASSOC_PACKAGE, this.packageRef);
        params.put(WorkflowModel.PROP_CONTEXT, this.packageRef);
        WorkflowPath reviewPath = this.workflowService.startWorkflow(reviewDef.getId(), params);
        String workflowId = reviewPath.getInstance().getId();
        this.workflows.add(workflowId);
        WorkflowTask startTask = (WorkflowTask)this.workflowService.getTasksForWorkflowPath(reviewPath.getId()).get(0);
        startTask = this.workflowService.endTask(startTask.getId(), null);
        this.personManager.setUser(USER3);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER3)), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        AbstractWorkflowRestApiTest.assertEquals((int)0, (int)results.length());
        this.personManager.setUser(USER2);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2)), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        AbstractWorkflowRestApiTest.assertEquals((int)1, (int)results.length());
        JSONObject taskJson = results.getJSONObject(0);
        String taskId = taskJson.getString("id");
        AbstractWorkflowRestApiTest.assertTrue((boolean)taskJson.getBoolean("isClaimable"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)taskJson.getBoolean("isPooled"));
        JSONObject properties = new JSONObject();
        properties.put(this.qnameToString(ContentModel.PROP_OWNER), (Object)USER2);
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PutRequest("api/task-instances/" + taskId, properties.toString(), "application/json"), 200);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER2)), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        AbstractWorkflowRestApiTest.assertEquals((int)1, (int)results.length());
        taskJson = results.getJSONObject(0);
        AbstractWorkflowRestApiTest.assertFalse((boolean)taskJson.getBoolean("isClaimable"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)taskJson.getBoolean("isPooled"));
        if (approve) {
            this.approveTask(taskId);
        } else {
            this.rejectTask(taskId);
        }
        this.personManager.setUser(USER1);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(MessageFormat.format(URL_USER_TASKS, USER1)), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        AbstractWorkflowRestApiTest.assertEquals((int)1, (int)results.length());
        String taskType = results.getJSONObject(0).getString("name");
        if (approve) {
            AbstractWorkflowRestApiTest.assertEquals((String)"wf:approvedTask", (String)taskType);
        } else {
            AbstractWorkflowRestApiTest.assertEquals((String)"wf:rejectedTask", (String)taskType);
        }
        this.workflowService.cancelWorkflow(workflowId);
    }

    protected abstract void approveTask(String var1) throws Exception;

    protected abstract void rejectTask(String var1) throws Exception;

    protected abstract String getAdhocWorkflowDefinitionName();

    protected abstract String getAdhocWorkflowDefinitionTitle();

    protected abstract String getAdhocWorkflowDefinitionDescription();

    protected abstract String getReviewWorkflowDefinitionName();

    protected abstract String getReviewPooledWorkflowDefinitionName();

    protected void setUp() throws Exception {
        super.setUp();
        ApplicationContext appContext = this.getServer().getApplicationContext();
        this.namespaceService = (NamespaceService)appContext.getBean("NamespaceService");
        this.workflowService = (WorkflowService)appContext.getBean("WorkflowService");
        MutableAuthenticationService authenticationService = (MutableAuthenticationService)appContext.getBean("AuthenticationService");
        PersonService personService = (PersonService)appContext.getBean("PersonService");
        SearchService searchService = (SearchService)appContext.getBean("SearchService");
        FileFolderService fileFolderService = (FileFolderService)appContext.getBean("FileFolderService");
        this.nodeService = (NodeService)appContext.getBean("NodeService");
        WorkflowAdminServiceImpl workflowAdminService = (WorkflowAdminServiceImpl)appContext.getBean("workflowAdminService");
        this.wfTestHelper = new WorkflowTestHelper(workflowAdminService, this.getEngine(), true);
        AuthorityService authorityService = (AuthorityService)appContext.getBean("AuthorityService");
        this.personManager = new TestPersonManager(authenticationService, personService, this.nodeService);
        this.groupManager = new TestGroupManager(authorityService);
        this.authenticationComponent = (AuthenticationComponent)appContext.getBean("authenticationComponent");
        this.dictionaryService = (DictionaryService)appContext.getBean("dictionaryService");
        this.personManager.createPerson(USER1);
        this.personManager.createPerson(USER2);
        this.personManager.createPerson(USER3);
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.groupManager.addUserToGroup(GROUP, USER2);
        this.packageRef = this.workflowService.createPackage(null);
        NodeRef companyHome = (NodeRef)searchService.selectNodes(this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE), COMPANY_HOME, null, (NamespacePrefixResolver)this.namespaceService, false).get(0);
        this.contentNodeRef = fileFolderService.create(companyHome, TEST_CONTENT + System.currentTimeMillis(), ContentModel.TYPE_CONTENT).getNodeRef();
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        for (String id : this.workflows) {
            try {
                this.workflowService.cancelWorkflow(id);
            }
            catch (Throwable throwable) {}
        }
        this.wfTestHelper.tearDown();
        this.groupManager.clearGroups();
        this.personManager.clearPeople();
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    private String qnameToString(QName qName) {
        String separator = Character.toString(':');
        return qName.toPrefixString((NamespacePrefixResolver)this.namespaceService).replaceFirst(separator, "_");
    }

    private void compareProperties(JSONObject before, JSONObject after) throws JSONException {
        for (String name : JSONObject.getNames((JSONObject)after)) {
            if (!before.has(name)) continue;
            if (before.get(name) instanceof JSONArray) {
                for (int i = 0; i < before.getJSONArray(name).length(); ++i) {
                    AbstractWorkflowRestApiTest.assertEquals((Object)before.getJSONArray(name).get(i), (Object)after.getJSONArray(name).get(i));
                }
                continue;
            }
            AbstractWorkflowRestApiTest.assertEquals((Object)before.get(name), (Object)after.get(name));
        }
    }

    private void checkSimpleWorkflowInstanceResponse(JSONObject json) throws JSONException {
        AbstractWorkflowRestApiTest.assertTrue((boolean)json.has("id"));
        AbstractWorkflowRestApiTest.assertTrue((json.getString("id").length() > 0 ? 1 : 0) != 0);
        AbstractWorkflowRestApiTest.assertTrue((boolean)json.has("url"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)json.getString("url").startsWith(URL_WORKFLOW_INSTANCES));
        AbstractWorkflowRestApiTest.assertTrue((boolean)json.has("name"));
        AbstractWorkflowRestApiTest.assertTrue((json.getString("name").length() > 0 ? 1 : 0) != 0);
        AbstractWorkflowRestApiTest.assertTrue((boolean)json.has("title"));
        AbstractWorkflowRestApiTest.assertTrue((json.getString("title").length() > 0 ? 1 : 0) != 0);
        AbstractWorkflowRestApiTest.assertTrue((boolean)json.has("description"));
        AbstractWorkflowRestApiTest.assertTrue((json.getString("description").length() > 0 ? 1 : 0) != 0);
        AbstractWorkflowRestApiTest.assertTrue((boolean)json.has("isActive"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)json.has("startDate"));
        AbstractWorkflowRestApiTest.assertTrue((json.getString("startDate").length() > 0 ? 1 : 0) != 0);
        AbstractWorkflowRestApiTest.assertTrue((boolean)json.has("endDate"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)json.has("initiator"));
        Object initiator = json.get("initiator");
        if (!initiator.equals(JSONObject.NULL)) {
            AbstractWorkflowRestApiTest.assertTrue((boolean)((JSONObject)initiator).has("userName"));
            AbstractWorkflowRestApiTest.assertTrue((boolean)((JSONObject)initiator).has("firstName"));
            AbstractWorkflowRestApiTest.assertTrue((boolean)((JSONObject)initiator).has("lastName"));
        }
        AbstractWorkflowRestApiTest.assertTrue((boolean)json.has("definitionUrl"));
        AbstractWorkflowRestApiTest.assertTrue((boolean)json.getString("definitionUrl").startsWith(URL_WORKFLOW_DEFINITIONS));
    }

    private void checkPriorityFiltering(String url) throws Exception {
        JSONObject json = this.getDataFromRequest(url);
        JSONArray result = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        AbstractWorkflowRestApiTest.assertTrue((result.length() > 0 ? 1 : 0) != 0);
        for (int i = 0; i < result.length(); ++i) {
            JSONObject taskObject = result.getJSONObject(i);
            AbstractWorkflowRestApiTest.assertEquals((Object)2, (Object)taskObject.getJSONObject("properties").get("bpm_priority"));
        }
    }

    private void checkTasksPresent(String url, boolean mustBePresent, String ... ids) throws Exception {
        List<String> taskIds = Arrays.asList(ids);
        JSONObject json = this.getDataFromRequest(url);
        JSONArray result = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        ArrayList<String> resultIds = new ArrayList<String>(result.length());
        for (int i = 0; i < result.length(); ++i) {
            JSONObject taskObject = result.getJSONObject(i);
            String taskId = taskObject.getString("id");
            resultIds.add(taskId);
            if (mustBePresent || !taskIds.contains(taskId)) continue;
            AbstractWorkflowRestApiTest.fail((String)("The results should not contain id: " + taskId));
        }
        if (mustBePresent && !resultIds.containsAll(taskIds)) {
            AbstractWorkflowRestApiTest.fail((String)("Not all task Ids were present!\nExpected: " + taskIds + "\nActual: " + resultIds));
        }
    }

    private void checkTasksMatch(String url, String ... ids) throws Exception {
        List<String> taskIds = Arrays.asList(ids);
        JSONObject json = this.getDataFromRequest(url);
        JSONArray result = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        ArrayList<String> resultIds = new ArrayList<String>(result.length());
        for (int i = 0; i < result.length(); ++i) {
            JSONObject taskObject = result.getJSONObject(i);
            String taskId = taskObject.getString("id");
            resultIds.add(taskId);
        }
        AbstractWorkflowRestApiTest.assertTrue((String)("Expected: " + taskIds + "\nActual: " + resultIds), (boolean)resultIds.containsAll(taskIds));
        AbstractWorkflowRestApiTest.assertTrue((String)("Expected: " + taskIds + "\nActual: " + resultIds), (boolean)taskIds.containsAll(resultIds));
    }

    private void checkTasksState(String url, WorkflowTaskState expectedState) throws Exception {
        JSONObject json = this.getDataFromRequest(url);
        JSONArray result = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        for (int i = 0; i < result.length(); ++i) {
            JSONObject taskObject = result.getJSONObject(i);
            String state = taskObject.getString("state");
            AbstractWorkflowRestApiTest.assertEquals((String)expectedState.toString(), (String)state);
        }
    }

    private JSONObject getDataFromRequest(String url) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        return json;
    }

    private void checkTaskPropertyFiltering(String propertiesParamValue, List<String> expectedProperties) throws Exception {
        JSONObject data = this.getDataFromRequest(MessageFormat.format(URL_USER_TASKS_PROPERTIES, USER2, propertiesParamValue));
        JSONArray taskArray = data.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertEquals((int)1, (int)taskArray.length());
        JSONObject taskProperties = taskArray.getJSONObject(0).getJSONObject("properties");
        AbstractWorkflowRestApiTest.assertNotNull((Object)taskProperties);
        int expectedNumberOfProperties = 0;
        if (expectedProperties != null) {
            expectedNumberOfProperties = expectedProperties.size();
        }
        AbstractWorkflowRestApiTest.assertEquals((int)expectedNumberOfProperties, (int)taskProperties.length());
        if (expectedProperties != null) {
            for (String prop : expectedProperties) {
                AbstractWorkflowRestApiTest.assertTrue((boolean)taskProperties.has(prop));
            }
        }
    }

    private void checkFiltering(String url) throws Exception {
        JSONObject json = this.getDataFromRequest(url);
        JSONArray result = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)result);
        AbstractWorkflowRestApiTest.assertTrue((result.length() > 0 ? 1 : 0) != 0);
    }

    private void checkPaging(String url, int totalItems, int maxItems, int skipCount) throws Exception {
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(url), 200);
        AbstractWorkflowRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray data = json.getJSONArray("data");
        JSONObject paging = json.getJSONObject("paging");
        AbstractWorkflowRestApiTest.assertNotNull((Object)data);
        AbstractWorkflowRestApiTest.assertNotNull((Object)paging);
        AbstractWorkflowRestApiTest.assertTrue((data.length() >= 0 ? 1 : 0) != 0);
        AbstractWorkflowRestApiTest.assertTrue((data.length() <= maxItems ? 1 : 0) != 0);
        AbstractWorkflowRestApiTest.assertEquals((int)totalItems, (int)paging.getInt("totalItems"));
        AbstractWorkflowRestApiTest.assertEquals((int)maxItems, (int)paging.getInt("maxItems"));
        AbstractWorkflowRestApiTest.assertEquals((int)skipCount, (int)paging.getInt("skipCount"));
    }

    private JSONArray getJsonArray(TestWebScriptServer.Response response, int expectedLength) throws Exception {
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray results = json.getJSONArray("data");
        AbstractWorkflowRestApiTest.assertNotNull((Object)results);
        AbstractWorkflowRestApiTest.assertEquals((int)expectedLength, (int)results.length());
        return results;
    }

    protected abstract String getEngine();
}

