/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.solr;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.search.SearchTrackingComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.solr.Acl;
import org.alfresco.repo.solr.AclChangeSet;
import org.alfresco.repo.solr.AclReaders;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.repo.web.scripts.solr.GetNodesParameters;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.Pair;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class SOLRWebScriptTest
extends BaseWebScriptTest {
    protected static final Log logger = LogFactory.getLog(SOLRWebScriptTest.class);
    private ApplicationContext ctx;
    private SearchTrackingComponent searchTrackingComponent;
    private NodeDAO nodeDAO;
    private TransactionService transactionService;
    private NodeService nodeService;
    private FileFolderService fileFolderService;
    private RetryingTransactionHelper txnHelper;
    private NamespaceService namespaceService;
    private String admin;
    private StoreRef storeRef;
    private NodeRef rootNodeRef;
    private NodeRef container3;
    private ArrayList<NodeRef> contents = new ArrayList(100);
    private List<Long> nodeIDs = new ArrayList<Long>(100);
    private NodeRef container6;
    private NodeRef container7;

    protected void setUp() throws Exception {
        super.setUp();
        this.ctx = this.getServer().getApplicationContext();
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.nodeService = serviceRegistry.getNodeService();
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.namespaceService = serviceRegistry.getNamespaceService();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        this.nodeDAO = (NodeDAO)this.ctx.getBean("nodeDAO");
        this.searchTrackingComponent = (SearchTrackingComponent)this.ctx.getBean("searchTrackingComponent");
        this.admin = AuthenticationUtil.getAdminUserName();
        AuthenticationUtil.setFullyAuthenticatedUser((String)this.admin);
        this.storeRef = this.nodeService.createStore("workspace", this.getName() + ".1." + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private JSONArray getTransactions(long fromCommitTime) throws Exception {
        String url = "/api/solr/transactions?fromCommitTime=" + fromCommitTime;
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(url);
        long startTime = System.currentTimeMillis();
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        long endTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)response.getContentAsString());
        }
        JSONObject json = new JSONObject(response.getContentAsString());
        JSONArray transactions = json.getJSONArray("transactions");
        logger.debug((Object)("Got " + transactions.length() + " txns in " + (endTime - startTime) + " ms"));
        return transactions;
    }

    public void testAclChangeSetsGet() throws Exception {
        String url = "/api/solr/aclchangesets?fromTime=0&fromId=0";
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(url);
        long startTime = System.currentTimeMillis();
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        long endTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)response.getContentAsString());
        }
        JSONObject json = new JSONObject(response.getContentAsString());
        JSONArray aclChangeSets = json.getJSONArray("aclChangeSets");
        logger.debug((Object)("Got " + aclChangeSets.length() + " txns in " + (endTime - startTime) + " ms"));
    }

    public void testAclsGet() throws Exception {
        List aclChangeSets = this.searchTrackingComponent.getAclChangeSets(null, null, null, null, 100);
        if (aclChangeSets.size() == 0) {
            return;
        }
        JSONObject json = new JSONObject();
        JSONArray aclChangeSetIdsJSON = new JSONArray();
        int count = 0;
        ArrayList<Long> aclChangeSetIds = new ArrayList<Long>();
        for (AclChangeSet aclChangeSet : aclChangeSets) {
            if (count >= 512) break;
            if (aclChangeSet.getAclCount() == 0) continue;
            Long aclChangeSetId = aclChangeSet.getId();
            aclChangeSetIdsJSON.put((Object)aclChangeSetId);
            aclChangeSetIds.add(aclChangeSetId);
            ++count;
        }
        json.put("aclChangeSetIds", (Object)aclChangeSetIdsJSON);
        String url = "/api/solr/acls";
        TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(url, json.toString(), "application/json");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)response.getContentAsString());
        }
        json = new JSONObject(response.getContentAsString());
        JSONArray acls = json.getJSONArray("acls");
        List aclsCheck = this.searchTrackingComponent.getAcls(aclChangeSetIds, null, 512);
        SOLRWebScriptTest.assertEquals((String)"Script and API returned different number of results", (int)aclsCheck.size(), (int)acls.length());
    }

    public void testAclReadersGet() throws Exception {
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                SOLRWebScriptTest.this.aclReadersGetImpl();
                return null;
            }
        });
    }

    private void aclReadersGetImpl() throws Exception {
        List aclChangeSets = this.searchTrackingComponent.getAclChangeSets(null, null, null, null, 1024);
        ArrayList<Long> aclChangeSetIds = new ArrayList<Long>(50);
        for (AclChangeSet aclChangeSet : aclChangeSets) {
            if (aclChangeSet.getAclCount() <= 0) continue;
            aclChangeSetIds.add(aclChangeSet.getId());
            break;
        }
        if (aclChangeSetIds.size() == 0) {
            // empty if block
        }
        List acls = this.searchTrackingComponent.getAcls(aclChangeSetIds, null, 1024);
        ArrayList<Long> aclIds = new ArrayList<Long>(acls.size());
        JSONObject json = new JSONObject();
        JSONArray aclIdsJSON = new JSONArray();
        for (Acl acl : acls) {
            Long aclId = acl.getId();
            aclIds.add(aclId);
            aclIdsJSON.put((Object)aclId);
        }
        json.put("aclIds", (Object)aclIdsJSON);
        List aclsReaders = this.searchTrackingComponent.getAclsReaders(aclIds);
        SOLRWebScriptTest.assertEquals((String)"Should have same number of ACLs as supplied", (int)aclIds.size(), (int)aclsReaders.size());
        SOLRWebScriptTest.assertTrue((String)"Must have *some* ACLs here", (aclIds.size() > 0 ? 1 : 0) != 0);
        HashMap<Long, Set> readersByAclId = new HashMap<Long, Set>();
        for (Object aclReaders : aclsReaders) {
            readersByAclId.put(aclReaders.getAclId(), aclReaders.getReaders());
        }
        HashMap<Long, Set> deniedByAclId = new HashMap<Long, Set>();
        for (AclReaders aclReaders : aclsReaders) {
            SOLRWebScriptTest.assertNotNull((String)"AclReaders should not contain null denial set", (Object)aclReaders.getDenied());
            deniedByAclId.put(aclReaders.getAclId(), aclReaders.getDenied());
        }
        String url = "/api/solr/aclsReaders";
        TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(url, json.toString(), "application/json");
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)response.getContentAsString());
        }
        json = new JSONObject(response.getContentAsString());
        JSONArray aclsReadersJSON = json.getJSONArray("aclsReaders");
        SOLRWebScriptTest.assertEquals((String)"Script and API returned different number of results", (int)readersByAclId.size(), (int)aclsReadersJSON.length());
        for (int i = 0; i < aclsReadersJSON.length(); ++i) {
            JSONObject aclReadersJSON = aclsReadersJSON.getJSONObject(i);
            Long aclIdJSON = aclReadersJSON.getLong("aclId");
            Set readersCheck = (Set)readersByAclId.get(aclIdJSON);
            JSONArray readersJSON = aclReadersJSON.getJSONArray("readers");
            SOLRWebScriptTest.assertEquals((String)("Readers list for ACL " + aclIdJSON + " is wrong. "), (int)readersCheck.size(), (int)readersJSON.length());
            for (int j = 0; j < readersJSON.length(); ++j) {
                String readerJSON = readersJSON.getString(j);
                SOLRWebScriptTest.assertTrue((String)("Found reader not in check set: " + readerJSON), (boolean)readersCheck.contains(readerJSON));
            }
            Set deniedCheck = (Set)deniedByAclId.get(aclIdJSON);
            JSONArray deniedJSON = aclReadersJSON.getJSONArray("denied");
            SOLRWebScriptTest.assertEquals((String)("Denied list for ACL " + aclIdJSON + " is wrong. "), (int)deniedCheck.size(), (int)deniedJSON.length());
            for (int j = 0; j < deniedJSON.length(); ++j) {
                String denyJSON = deniedJSON.getString(j);
                SOLRWebScriptTest.assertTrue((String)("Found denied authority not in check set: " + denyJSON), (boolean)deniedCheck.contains(denyJSON));
            }
        }
    }

    private JSONArray getNodes(GetNodesParameters parameters, int maxResults, int expectedNumNodes) throws Exception {
        JSONArray array;
        StringBuilder url = new StringBuilder("/api/solr/nodes");
        JSONObject json = new JSONObject();
        if (parameters.getTransactionIds() != null) {
            array = new JSONArray();
            for (Long txnId : parameters.getTransactionIds()) {
                array.put((Object)txnId);
            }
            json.put("txnIds", (Object)array);
        }
        if (parameters.getFromNodeId() != null) {
            json.put("fromNodeId", (Object)parameters.getFromNodeId());
        }
        if (parameters.getToNodeId() != null) {
            json.put("toNodeId", (Object)parameters.getToNodeId());
        }
        if (parameters.getExcludeAspects() != null) {
            array = new JSONArray();
            for (QName excludeAspect : parameters.getExcludeAspects()) {
                array.put((Object)excludeAspect.toString());
            }
            json.put("excludeAspects", (Object)array);
        }
        if (parameters.getIncludeAspects() != null) {
            array = new JSONArray();
            for (QName includeAspect : parameters.getIncludeAspects()) {
                array.put((Object)includeAspect.toString());
            }
            json.put("includeAspects", (Object)array);
        }
        if (parameters.getStoreProtocol() != null) {
            json.put("storeProtocol", (Object)parameters.getStoreProtocol());
        }
        if (parameters.getStoreIdentifier() != null) {
            json.put("storeIdentifier", (Object)parameters.getStoreIdentifier());
        }
        json.put("maxResults", maxResults);
        TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(url.toString(), json.toString(), "application/json");
        long startTime = System.currentTimeMillis();
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        long endTime = System.currentTimeMillis();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)response.getContentAsString());
        }
        JSONObject jsonResponse = new JSONObject(response.getContentAsString());
        jsonResponse.write((Writer)new PrintWriter(System.out));
        JSONArray nodes = jsonResponse.getJSONArray("nodes");
        logger.debug((Object)("Got " + nodes.length() + " nodes in " + (endTime - startTime) + " ms"));
        SOLRWebScriptTest.assertEquals((String)"Number of returned node meta data results is incorrect", (int)expectedNumNodes, (int)nodes.length());
        return nodes;
    }

    private List<Long> getTransactionIds(JSONArray transactions) throws JSONException {
        ArrayList<Long> txnIds = new ArrayList<Long>(transactions.length());
        int numTxns = transactions.length();
        for (int i = 0; i < numTxns; ++i) {
            JSONObject txn = transactions.getJSONObject(i);
            txnIds.add(txn.getLong("id"));
        }
        return txnIds;
    }

    public static String join(Collection<Object> s, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        Iterator<Object> iter = s.iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    private void buildTransactions3() {
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                PropertyMap props = new PropertyMap();
                props.put((Object)ContentModel.PROP_NAME, (Object)"Container3");
                SOLRWebScriptTest.this.container3 = SOLRWebScriptTest.this.nodeService.createNode(SOLRWebScriptTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, (Map)props).getChildRef();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("container3 = " + SOLRWebScriptTest.this.container3));
                }
                for (int i = 0; i < 100; ++i) {
                    FileInfo content1Info = SOLRWebScriptTest.this.fileFolderService.create(SOLRWebScriptTest.this.container3, "Content" + i, ContentModel.TYPE_CONTENT);
                    NodeRef nodeRef = content1Info.getNodeRef();
                    SOLRWebScriptTest.this.contents.add(nodeRef);
                    SOLRWebScriptTest.this.nodeIDs.add(SOLRWebScriptTest.this.getNodeID(nodeRef));
                    if (i % 2 != 1) continue;
                    SOLRWebScriptTest.this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TEMPORARY, null);
                }
                return null;
            }
        });
    }

    private void buildTransactions5() {
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                PropertyMap props = new PropertyMap();
                props.put((Object)ContentModel.PROP_NAME, (Object)"Container6");
                SOLRWebScriptTest.this.container6 = SOLRWebScriptTest.this.nodeService.createNode(SOLRWebScriptTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, (Map)props).getChildRef();
                FileInfo contentInfo = SOLRWebScriptTest.this.fileFolderService.create(SOLRWebScriptTest.this.container6, "Content1", ContentModel.TYPE_CONTENT);
                SOLRWebScriptTest.this.contents.add(contentInfo.getNodeRef());
                HashMap<QName, String> aspectProperties = new HashMap<QName, String>();
                aspectProperties.put(ContentModel.PROP_AUTHOR, "steve");
                SOLRWebScriptTest.this.nodeService.addAspect(contentInfo.getNodeRef(), ContentModel.ASPECT_AUTHOR, aspectProperties);
                return null;
            }
        });
    }

    private JSONArray getNodesMetaData(List<Long> nodeIds, int maxResults, int numMetaDataNodes) throws Exception {
        StringBuilder url = new StringBuilder("/api/solr/metadata");
        JSONObject json = new JSONObject();
        if (nodeIds != null && nodeIds.size() > 0) {
            JSONArray array = new JSONArray();
            for (Long nodeId : nodeIds) {
                array.put((Object)nodeId);
            }
            json.put("nodeIds", (Object)array);
        }
        json.put("maxResults", maxResults);
        TestWebScriptServer.PostRequest req = new TestWebScriptServer.PostRequest(url.toString(), json.toString(), "application/json");
        long startTime = System.currentTimeMillis();
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        long endTime = System.currentTimeMillis();
        String content = response.getContentAsString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("nodesMetaData = " + content));
        }
        JSONObject jsonResponse = null;
        try {
            jsonResponse = new JSONObject(content);
        }
        catch (JSONException e) {
            SOLRWebScriptTest.fail((String)e.getMessage());
        }
        JSONArray nodes = jsonResponse.getJSONArray("nodes");
        logger.debug((Object)("Got metadata for " + nodes.length() + " nodes in " + (endTime - startTime) + " ms"));
        SOLRWebScriptTest.assertEquals((String)"Number of returned nodes is incorrect", (int)numMetaDataNodes, (int)nodes.length());
        return nodes;
    }

    private void buildTransactions6() {
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                PropertyMap props = new PropertyMap();
                props.put((Object)ContentModel.PROP_NAME, (Object)"Container6");
                NodeRef container6 = SOLRWebScriptTest.this.nodeService.createNode(SOLRWebScriptTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, (Map)props).getChildRef();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("container6 = " + container6));
                }
                for (int i = 0; i < 2000; ++i) {
                    FileInfo content1Info = SOLRWebScriptTest.this.fileFolderService.create(container6, "Content" + i, ContentModel.TYPE_CONTENT);
                    NodeRef nodeRef = content1Info.getNodeRef();
                    SOLRWebScriptTest.this.contents.add(nodeRef);
                    if (i % 2 != 1) continue;
                    SOLRWebScriptTest.this.nodeService.addAspect(nodeRef, ContentModel.ASPECT_TEMPORARY, null);
                }
                return null;
            }
        });
    }

    public void testNodeMetaData() throws Exception {
        long fromCommitTime = System.currentTimeMillis();
        this.buildTransactions5();
        JSONArray transactions = this.getTransactions(fromCommitTime);
        SOLRWebScriptTest.assertEquals((String)"Number of transactions is incorrect", (int)1, (int)transactions.length());
        List<Long> transactionIds = this.getTransactionIds(transactions);
        GetNodesParameters params = new GetNodesParameters();
        params.setTransactionIds(transactionIds);
        params.setStoreProtocol(this.storeRef.getProtocol());
        params.setStoreIdentifier(this.storeRef.getIdentifier());
        JSONArray nodes = this.getNodes(params, 0, 2);
        ArrayList<Long> nodeIds = new ArrayList<Long>(nodes.length());
        for (int i = 0; i < nodes.length(); ++i) {
            JSONObject node = nodes.getJSONObject(i);
            nodeIds.add(node.getLong("id"));
        }
        JSONArray nodesMetaData = this.getNodesMetaData(nodeIds, 0, 2);
        NodeRef expectedNodeRef = this.contents.get(0);
        JSONObject node = nodesMetaData.getJSONObject(1);
        NodeRef nodeRef = new NodeRef(node.getString("nodeRef"));
        SOLRWebScriptTest.assertEquals((String)"NodeRef is incorrect", (Object)expectedNodeRef, (Object)nodeRef);
        JSONArray aspects = node.getJSONArray("aspects");
        JSONObject properties = node.getJSONObject("properties");
        Map<QName, String> propertyMap = this.getPropertyMap(properties);
        SOLRWebScriptTest.assertTrue((String)"Expected author aspect", (boolean)this.containsAspect(aspects, ContentModel.ASPECT_AUTHOR));
        SOLRWebScriptTest.assertTrue((String)"Expected author property", (boolean)this.containsProperty(propertyMap, ContentModel.PROP_AUTHOR, "steve"));
        JSONArray paths = node.getJSONArray("paths");
        List expectedPaths = this.nodeService.getPaths(expectedNodeRef, false);
        for (int i = 0; i < paths.length(); ++i) {
            JSONObject o = paths.getJSONObject(i);
            String path = o.getString("path");
            String qname = o.has("qname") ? o.getString("qname") : null;
            String expectedPath = ((Path)expectedPaths.get(i)).toString();
            SOLRWebScriptTest.assertEquals((String)("Path element " + i + " is incorrect"), (String)expectedPath, (String)path);
            SOLRWebScriptTest.assertNull((String)"qname should be null", (Object)qname);
        }
    }

    private void buildTransactions7() {
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                PropertyMap props = new PropertyMap();
                props.put((Object)ContentModel.PROP_NAME, (Object)"Container7");
                SOLRWebScriptTest.this.container7 = SOLRWebScriptTest.this.nodeService.createNode(SOLRWebScriptTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_FOLDER, (Map)props).getChildRef();
                FileInfo contentInfo = SOLRWebScriptTest.this.fileFolderService.create(SOLRWebScriptTest.this.container7, "Content1", ContentModel.TYPE_CONTENT);
                SOLRWebScriptTest.this.contents.add(contentInfo.getNodeRef());
                HashMap<QName, String> aspectProperties = new HashMap<QName, String>();
                aspectProperties.put(ContentModel.PROP_AUTHOR, "ste\"ve");
                SOLRWebScriptTest.this.nodeService.addAspect(contentInfo.getNodeRef(), ContentModel.ASPECT_AUTHOR, aspectProperties);
                return null;
            }
        });
    }

    public void testNodeMetaDataStringEscaping() throws Exception {
        long fromCommitTime = System.currentTimeMillis();
        this.buildTransactions7();
        JSONArray transactions = this.getTransactions(fromCommitTime);
        SOLRWebScriptTest.assertEquals((String)"Number of transactions is incorrect", (int)1, (int)transactions.length());
        List<Long> transactionIds = this.getTransactionIds(transactions);
        GetNodesParameters params = new GetNodesParameters();
        params.setTransactionIds(transactionIds);
        params.setStoreProtocol(this.storeRef.getProtocol());
        params.setStoreIdentifier(this.storeRef.getIdentifier());
        JSONArray nodes = this.getNodes(params, 0, 2);
        ArrayList<Long> nodeIds = new ArrayList<Long>(nodes.length());
        for (int i = 0; i < nodes.length(); ++i) {
            JSONObject node = nodes.getJSONObject(i);
            nodeIds.add(node.getLong("id"));
        }
        JSONArray nodesMetaData = this.getNodesMetaData(nodeIds, 0, 2);
        NodeRef expectedNodeRef = this.contents.get(0);
        JSONObject node = nodesMetaData.getJSONObject(1);
        NodeRef nodeRef = new NodeRef(node.getString("nodeRef"));
        SOLRWebScriptTest.assertEquals((String)"NodeRef is incorrect", (Object)expectedNodeRef, (Object)nodeRef);
        JSONArray aspects = node.getJSONArray("aspects");
        JSONObject properties = node.getJSONObject("properties");
        Map<QName, String> propertyMap = this.getPropertyMap(properties);
        SOLRWebScriptTest.assertTrue((String)"Expected author aspect", (boolean)this.containsAspect(aspects, ContentModel.ASPECT_AUTHOR));
        SOLRWebScriptTest.assertTrue((String)"Expected author property", (boolean)this.containsProperty(propertyMap, ContentModel.PROP_AUTHOR, "ste\"ve"));
    }

    public void testNodeMetaDataManyNodes() throws Exception {
        long fromCommitTime = System.currentTimeMillis();
        this.buildTransactions6();
        JSONArray transactions = this.getTransactions(fromCommitTime);
        SOLRWebScriptTest.assertEquals((String)"Number of transactions is incorrect", (int)1, (int)transactions.length());
        List<Long> transactionIds = this.getTransactionIds(transactions);
        GetNodesParameters params = new GetNodesParameters();
        params.setStoreProtocol(this.storeRef.getProtocol());
        params.setStoreIdentifier(this.storeRef.getIdentifier());
        params.setTransactionIds(transactionIds);
        JSONArray nodes = this.getNodes(params, 0, 2001);
        ArrayList<Long> nodeIds = new ArrayList<Long>(nodes.length());
        for (int i = 0; i < nodes.length(); ++i) {
            JSONObject node = nodes.getJSONObject(i);
            nodeIds.add(node.getLong("id"));
        }
        JSONArray nodesMetaData = this.getNodesMetaData(nodeIds, 0, 2001);
        nodesMetaData = this.getNodesMetaData(nodeIds, 0, 2001);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        nodesMetaData = this.getNodesMetaData(nodeIds, 0, 2001);
        nodesMetaData = this.getNodesMetaData(nodeIds, 1000, 1000);
        nodesMetaData = this.getNodesMetaData(nodeIds, 600, 600);
        nodesMetaData = this.getNodesMetaData(nodeIds, 300, 300);
        nodesMetaData = this.getNodesMetaData(nodeIds, 100, 100);
        nodesMetaData = this.getNodesMetaData(nodeIds, 50, 50);
        this.nodeDAO.clear();
        nodesMetaData = this.getNodesMetaData(nodeIds, 0, 2001);
    }

    private boolean containsAspect(JSONArray aspectsArray, QName aspect) throws Exception {
        if (aspect == null) {
            throw new IllegalArgumentException("aspect cannot be null");
        }
        boolean success = false;
        for (int i = 0; i < aspectsArray.length(); ++i) {
            String qName = aspectsArray.getString(i);
            if (!aspect.equals((Object)QName.createQName((String)qName, (NamespacePrefixResolver)this.namespaceService))) continue;
            success |= true;
            break;
        }
        return success;
    }

    private Map<QName, String> getPropertyMap(JSONObject properties) throws Exception {
        HashMap<QName, String> propertyMap = new HashMap<QName, String>(properties.length());
        Iterator propNames = properties.keys();
        while (propNames.hasNext()) {
            String propName = (String)propNames.next();
            String value = properties.getString(propName);
            propertyMap.put(QName.resolveToQName((NamespacePrefixResolver)this.namespaceService, (String)propName), value);
        }
        return propertyMap;
    }

    private boolean containsProperty(Map<QName, String> propertyMap, QName propName, String propValue) throws Exception {
        if (propName == null) {
            throw new IllegalArgumentException("propName cannot be null");
        }
        String value = propertyMap.get(propName);
        return value == null ? false : value.equals(propValue);
    }

    public void DISABLED_testGetContent() throws Exception {
        long nodeId = -1L;
        String propertyName = ContentModel.PROP_CONTENT.toString();
        this.buildTransactions3();
        String url = "/api/solr/content?nodeId=" + nodeId + "&propertyName=" + propertyName;
        TestWebScriptServer.GetRequest req = new TestWebScriptServer.GetRequest(url);
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)req, 200, this.admin);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("content1 = " + response.getContentAsString()));
        }
        SOLRWebScriptTest.assertEquals((String)"Content length is incorrect", (int)"test content".length(), (int)response.getContentLength());
    }

    private long getNodeID(NodeRef nodeRef) {
        Pair pair = this.nodeDAO.getNodePair(nodeRef);
        SOLRWebScriptTest.assertNotNull((String)("Can't find node " + nodeRef), (Object)pair);
        return (Long)pair.getFirst();
    }
}

