/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.download;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Test;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class DownloadRestApiTest
extends BaseWebScriptTest {
    private static final long MAX_TIME = 5000L;
    private static final long PAUSE_TIME = 1000L;
    private static final String TEST_USERNAME = "downloadTestUser";
    public static final String URL_DOWNLOADS = "/api/internal/downloads";
    public static final String URL_DOWNLOAD_STATUS = "/api/internal/downloads/{0}/{1}/{2}/status";
    private AuthenticationComponent authenticationComponent;
    private MutableAuthenticationService authenticationService;
    private ContentService contentService;
    private NodeService nodeService;
    private PersonService personService;
    private NodeRef rootFolder;
    private NodeRef rootFile;
    private NodeRef level1File;
    private NodeRef level1Folder;
    private NodeRef level2File;

    public void setUp() {
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService", MutableAuthenticationService.class);
        this.authenticationComponent = (AuthenticationComponent)this.getServer().getApplicationContext().getBean("authenticationComponent", AuthenticationComponent.class);
        this.contentService = (ContentService)this.getServer().getApplicationContext().getBean("ContentService", ContentService.class);
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService", NodeService.class);
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService", PersonService.class);
        this.authenticationComponent.setCurrentUser(AuthenticationUtil.getAdminUserName());
        if (!this.authenticationService.authenticationExists(TEST_USERNAME)) {
            this.authenticationService.createAuthentication(TEST_USERNAME, "password".toCharArray());
            PropertyMap personProps = new PropertyMap();
            personProps.put((Object)ContentModel.PROP_USERNAME, (Object)TEST_USERNAME);
            personProps.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"FirstName123");
            personProps.put((Object)ContentModel.PROP_LASTNAME, (Object)"LastName123");
            personProps.put((Object)ContentModel.PROP_EMAIL, (Object)"FirstName123.LastName123@email.com");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"JobTitle123");
            personProps.put((Object)ContentModel.PROP_JOBTITLE, (Object)"Organisation123");
            this.personService.createPerson((Map)personProps);
        }
        Repository repositoryHelper = (Repository)this.getServer().getApplicationContext().getBean("repositoryHelper");
        NodeRef companyHome = repositoryHelper.getCompanyHome();
        this.rootFolder = this.createNode(companyHome, "rootFolder", ContentModel.TYPE_FOLDER, AuthenticationUtil.getAdminUserName());
        this.rootFile = this.createNodeWithTextContent(companyHome, "rootFile", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "Root file content");
        this.level1File = this.createNodeWithTextContent(this.rootFolder, "level1File", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "Level 1 file content");
        this.level1Folder = this.createNode(this.rootFolder, "level1Folder", ContentModel.TYPE_FOLDER, AuthenticationUtil.getAdminUserName());
        this.level2File = this.createNodeWithTextContent(this.level1Folder, "level2File", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName(), "Level 2 file content");
    }

    public void tearDown() {
        this.nodeService.deleteNode(this.level2File);
        this.nodeService.deleteNode(this.level1Folder);
        this.nodeService.deleteNode(this.level1File);
        this.nodeService.deleteNode(this.rootFolder);
        this.nodeService.deleteNode(this.rootFile);
        this.personService.deletePerson(TEST_USERNAME);
        if (this.authenticationService.authenticationExists(TEST_USERNAME)) {
            this.authenticationService.deleteAuthentication(TEST_USERNAME);
        }
    }

    public NodeRef createNodeWithTextContent(NodeRef parentNode, String nodeCmName, QName nodeType, String ownerUserName, String content) {
        NodeRef nodeRef = this.createNode(parentNode, nodeCmName, nodeType, ownerUserName);
        if (content != null) {
            ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
            writer.setMimetype("text/plain");
            writer.setEncoding("UTF-8");
            writer.putContent(content);
        }
        return nodeRef;
    }

    private NodeRef createNode(NodeRef parentNode, String nodeCmName, QName nodeType, String ownerUserName) {
        QName childName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)nodeCmName);
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, nodeCmName);
        ChildAssociationRef childAssoc = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, childName, nodeType, props);
        return childAssoc.getChildRef();
    }

    @Test
    public void testCreateAndGetDownload() throws UnsupportedEncodingException, IOException, JSONException {
        String postData = "[{ \"nodeRef\": \"" + this.rootFile + "\"}, { \"nodeRef\": \"" + this.rootFolder + "\"}]";
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_DOWNLOADS, postData, "application/json"), 200);
        JSONObject result = new JSONObject(response.getContentAsString());
        NodeRef downloadNodeRef = new NodeRef(result.getString("nodeRef"));
        String statusUrl = MessageFormat.format(URL_DOWNLOAD_STATUS, downloadNodeRef.getStoreRef().getProtocol(), downloadNodeRef.getStoreRef().getIdentifier(), downloadNodeRef.getId());
        TestWebScriptServer.Response statusResponse = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(statusUrl), 200);
    }
}

