/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.content;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyMap;
import org.junit.Assert;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class ContentGetTest
extends BaseWebScriptTest {
    private MutableAuthenticationService authenticationService;
    private PersonService personService;
    private NodeService nodeService;
    private ContentService contentService;
    NodeRef rootFolder;
    private static final String USER_ONE = "ContentGetTestOne";
    private static final String URL_CONTENT_DOWNLOAD = "/api/node/content/workspace/SpacesStore/";

    protected void setUp() throws Exception {
        super.setUp();
        this.authenticationService = (MutableAuthenticationService)this.getServer().getApplicationContext().getBean("AuthenticationService");
        this.personService = (PersonService)this.getServer().getApplicationContext().getBean("PersonService");
        this.nodeService = (NodeService)this.getServer().getApplicationContext().getBean("NodeService");
        this.contentService = (ContentService)this.getServer().getApplicationContext().getBean("ContentService");
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.createUser(USER_ONE);
    }

    private void createUser(String userName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "PWD".toCharArray());
            PropertyMap ppOne = new PropertyMap(5);
            ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
            ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
            ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
            ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
            ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
            this.personService.createPerson((Map)ppOne);
        }
    }

    private void deleteUser(String username) {
        this.personService.deletePerson(username);
        if (this.authenticationService.authenticationExists(username)) {
            this.authenticationService.deleteAuthentication(username);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.nodeService.deleteNode(this.rootFolder);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.deleteUser(USER_ONE);
    }

    public void testRelativePath() throws Exception {
        Repository repositoryHelper = (Repository)this.getServer().getApplicationContext().getBean("repositoryHelper");
        NodeRef companyHome = repositoryHelper.getCompanyHome();
        this.rootFolder = this.createNode(companyHome, "rootFolder", ContentModel.TYPE_FOLDER);
        NodeRef doc1 = this.createNodeWithTextContent(this.rootFolder, "doc1", ContentModel.TYPE_CONTENT, "doc1 file content");
        NodeRef folderX = this.createNode(this.rootFolder, "X", ContentModel.TYPE_FOLDER);
        NodeRef folderY = this.createNode(folderX, "Y", ContentModel.TYPE_FOLDER);
        NodeRef folderZ = this.createNode(folderY, "Z", ContentModel.TYPE_FOLDER);
        NodeRef doc2 = this.createNodeWithTextContent(folderZ, "doc2", ContentModel.TYPE_CONTENT, "doc2 file content");
        String uri = URL_CONTENT_DOWNLOAD + doc1.getId() + "/X/Y/Z/doc2";
        TestWebScriptServer.Response resp = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(uri), 200);
        Assert.assertEquals((Object)"doc2 file content", (Object)resp.getContentAsString());
    }

    public NodeRef createNodeWithTextContent(NodeRef parentNode, String nodeCmName, QName nodeType, String content) {
        NodeRef nodeRef = this.createNode(parentNode, nodeCmName, nodeType);
        if (content != null) {
            ContentWriter writer = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
            writer.setMimetype("text/plain");
            writer.setEncoding("UTF-8");
            writer.putContent(content);
        }
        return nodeRef;
    }

    private NodeRef createNode(NodeRef parentNode, String nodeCmName, QName nodeType) {
        QName childName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)nodeCmName);
        HashMap<QName, String> props = new HashMap<QName, String>();
        props.put(ContentModel.PROP_NAME, nodeCmName);
        ChildAssociationRef childAssoc = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, childName, nodeType, props);
        return childAssoc.getChildRef();
    }
}

