/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts.action;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.person.TestPersonManager;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.repo.web.scripts.action.AbstractActionWebscript;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionStatus;
import org.alfresco.service.cmr.action.ActionTrackingService;
import org.alfresco.service.cmr.action.CancellableAction;
import org.alfresco.service.cmr.action.ExecutionDetails;
import org.alfresco.service.cmr.action.ExecutionSummary;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.alfresco.service.cmr.replication.ReplicationService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.alfresco.util.ISO8601DateFormat;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.context.ApplicationContext;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class RunningActionRestApiTest
extends BaseWebScriptTest {
    private static final String URL_RUNNING_ACTION = "api/running-action/";
    private static final String URL_RUNNING_ACTIONS = "api/running-actions";
    private static final String URL_RUNNING_REPLICATION_ACTIONS = "api/running-replication-actions";
    private static final String JSON = "application/json";
    private static final String USER_NORMAL = "Normal" + GUID.generate();
    private NodeService nodeService;
    private TestPersonManager personManager;
    private ReplicationService replicationService;
    private TransactionService transactionService;
    private ActionTrackingService actionTrackingService;
    private SimpleCache<String, ExecutionDetails> executingActionsCache;
    private Repository repositoryHelper;
    private NodeRef dataDictionary;

    public void testEnsureAllQuiet() throws Exception {
        List actions;
        for (int i = 0; i < 200 && (actions = this.actionTrackingService.getAllExecutingActions()).size() != 0; ++i) {
            System.out.println("Waiting on " + actions.size() + " actions to finish, top is " + actions.get(0));
            Thread.sleep(10L);
        }
    }

    public void testRunningActionsGet() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getGuestUserName());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_ACTIONS), 401);
        RunningActionRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NORMAL);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_ACTIONS), 401);
        RunningActionRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_ACTIONS), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)0, (int)results.length());
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("Test1", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        this.actionTrackingService.recordActionExecuting((Action)rd);
        String id = rd.getId();
        String instance = Integer.toString(((ActionImpl)rd).getExecutionInstance());
        String startedAt = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_ACTIONS), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)1, (int)results.length());
        JSONObject jsonRD = (JSONObject)results.get(0);
        RunningActionRestApiTest.assertNotNull((Object)jsonRD);
        RunningActionRestApiTest.assertEquals((Object)id, (Object)jsonRD.get("actionId"));
        RunningActionRestApiTest.assertEquals((Object)"replicationActionExecutor", (Object)jsonRD.get("actionType"));
        RunningActionRestApiTest.assertEquals((Object)instance, (Object)jsonRD.get("actionInstance"));
        RunningActionRestApiTest.assertEquals((Object)rd.getNodeRef().toString(), (Object)jsonRD.get("actionNodeRef"));
        RunningActionRestApiTest.assertEquals((Object)startedAt, (Object)jsonRD.get("startedAt"));
        RunningActionRestApiTest.assertEquals((boolean)false, (boolean)jsonRD.getBoolean("cancelRequested"));
        RunningActionRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + id + "=" + instance), (Object)jsonRD.get("details"));
        JSONArray keys = jsonRD.names();
        for (int i = 0; i < keys.length(); ++i) {
            String key = keys.getString(0);
            if (key.equals("actionId") || key.equals("actionType") || key.equals("actionInstance") || key.equals("actionNodeRef") || key.equals("startedAt") || key.equals("cancelRequested") || key.equals("details")) continue;
            RunningActionRestApiTest.fail((String)("Unexpected key '" + key + "' found in json, raw json is\n" + jsonStr));
        }
        this.actionTrackingService.requestActionCancellation((CancellableAction)rd);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_ACTIONS), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)1, (int)results.length());
        jsonRD = (JSONObject)results.get(0);
        RunningActionRestApiTest.assertNotNull((Object)jsonRD);
        RunningActionRestApiTest.assertEquals((Object)id, (Object)jsonRD.get("actionId"));
        RunningActionRestApiTest.assertEquals((Object)"replicationActionExecutor", (Object)jsonRD.get("actionType"));
        RunningActionRestApiTest.assertEquals((Object)instance, (Object)jsonRD.get("actionInstance"));
        RunningActionRestApiTest.assertEquals((Object)rd.getNodeRef().toString(), (Object)jsonRD.get("actionNodeRef"));
        RunningActionRestApiTest.assertEquals((Object)startedAt, (Object)jsonRD.get("startedAt"));
        RunningActionRestApiTest.assertEquals((boolean)true, (boolean)jsonRD.getBoolean("cancelRequested"));
        RunningActionRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + id + "=" + instance), (Object)jsonRD.get("details"));
        rd = this.replicationService.createReplicationDefinition("Test2", "2nd Testing");
        this.replicationService.saveReplicationDefinition(rd);
        this.actionTrackingService.recordActionExecuting((Action)rd);
        String id2 = rd.getId();
        String instance2 = Integer.toString(((ActionImpl)rd).getExecutionInstance());
        String startedAt2 = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        rd = this.replicationService.createReplicationDefinition("AnotherTest", "3rd Testing");
        this.replicationService.saveReplicationDefinition(rd);
        this.actionTrackingService.recordActionPending((Action)rd);
        String id3 = rd.getId();
        boolean has1 = false;
        boolean has2 = false;
        boolean has3 = false;
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_ACTIONS), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)3, (int)results.length());
        for (int i = 0; i < 3; ++i) {
            jsonRD = (JSONObject)results.get(i);
            if (jsonRD.get("actionId").equals(id)) {
                has1 = true;
            }
            if (jsonRD.get("actionId").equals(id2)) {
                has2 = true;
            }
            if (!jsonRD.get("actionId").equals(id3)) continue;
            has3 = true;
        }
        RunningActionRestApiTest.assertTrue((boolean)has1);
        RunningActionRestApiTest.assertTrue((boolean)has2);
        RunningActionRestApiTest.assertTrue((boolean)has3);
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.actionTrackingService.recordActionComplete((Action)rd);
        txn.commit();
        has1 = false;
        has2 = false;
        has3 = false;
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_ACTIONS), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)2, (int)results.length());
        for (int i = 0; i < 2; ++i) {
            jsonRD = (JSONObject)results.get(i);
            if (jsonRD.get("actionId").equals(id)) {
                has1 = true;
            }
            if (jsonRD.get("actionId").equals(id2)) {
                has2 = true;
            }
            if (!jsonRD.get("actionId").equals(id3)) continue;
            has3 = true;
        }
        RunningActionRestApiTest.assertTrue((boolean)has1);
        RunningActionRestApiTest.assertTrue((boolean)has2);
        RunningActionRestApiTest.assertFalse((boolean)has3);
        rd = this.replicationService.loadReplicationDefinition("Test1");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/running-actions?nodeRef=" + rd.getNodeRef().toString()), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)1, (int)results.length());
        jsonRD = (JSONObject)results.get(0);
        RunningActionRestApiTest.assertNotNull((Object)jsonRD);
        RunningActionRestApiTest.assertEquals((Object)id, (Object)jsonRD.get("actionId"));
        RunningActionRestApiTest.assertEquals((Object)"replicationActionExecutor", (Object)jsonRD.get("actionType"));
        RunningActionRestApiTest.assertEquals((Object)instance, (Object)jsonRD.get("actionInstance"));
        RunningActionRestApiTest.assertEquals((Object)rd.getNodeRef().toString(), (Object)jsonRD.get("actionNodeRef"));
        RunningActionRestApiTest.assertEquals((Object)startedAt, (Object)jsonRD.get("startedAt"));
        RunningActionRestApiTest.assertEquals((boolean)true, (boolean)jsonRD.getBoolean("cancelRequested"));
        RunningActionRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + id + "=" + instance), (Object)jsonRD.get("details"));
        rd = this.replicationService.loadReplicationDefinition("Test2");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/running-actions?nodeRef=" + rd.getNodeRef().toString()), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)1, (int)results.length());
        jsonRD = (JSONObject)results.get(0);
        RunningActionRestApiTest.assertNotNull((Object)jsonRD);
        RunningActionRestApiTest.assertEquals((Object)id2, (Object)jsonRD.get("actionId"));
        RunningActionRestApiTest.assertEquals((Object)"replicationActionExecutor", (Object)jsonRD.get("actionType"));
        RunningActionRestApiTest.assertEquals((Object)instance2, (Object)jsonRD.get("actionInstance"));
        RunningActionRestApiTest.assertEquals((Object)rd.getNodeRef().toString(), (Object)jsonRD.get("actionNodeRef"));
        RunningActionRestApiTest.assertEquals((Object)startedAt2, (Object)jsonRD.get("startedAt"));
        RunningActionRestApiTest.assertEquals((boolean)false, (boolean)jsonRD.getBoolean("cancelRequested"));
        RunningActionRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + id2 + "=" + instance2), (Object)jsonRD.get("details"));
        ActionImpl alt1 = new ActionImpl(null, "12345", "MadeUp1");
        ActionImpl alt2 = new ActionImpl(null, "54321", "MadeUp2");
        this.actionTrackingService.recordActionExecuting((Action)alt1);
        this.actionTrackingService.recordActionExecuting((Action)alt2);
        String startAtAlt2 = ISO8601DateFormat.format((Date)alt2.getExecutionStartDate());
        String instanceAlt2 = Integer.toString(alt2.getExecutionInstance());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_ACTIONS), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)4, (int)results.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/running-actions?type=replicationActionExecutor"), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)2, (int)results.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/running-actions?type=MadeUp4"), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)0, (int)results.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/running-actions?type=MadeUp1"), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)1, (int)results.length());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/running-actions?type=MadeUp2"), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)1, (int)results.length());
        jsonRD = (JSONObject)results.get(0);
        RunningActionRestApiTest.assertNotNull((Object)jsonRD);
        RunningActionRestApiTest.assertEquals((Object)"54321", (Object)jsonRD.get("actionId"));
        RunningActionRestApiTest.assertEquals((Object)"MadeUp2", (Object)jsonRD.get("actionType"));
        RunningActionRestApiTest.assertEquals((Object)instanceAlt2, (Object)jsonRD.get("actionInstance"));
        RunningActionRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)jsonRD.get("actionNodeRef"));
        RunningActionRestApiTest.assertEquals((Object)startAtAlt2, (Object)jsonRD.get("startedAt"));
        RunningActionRestApiTest.assertEquals((boolean)false, (boolean)jsonRD.getBoolean("cancelRequested"));
        RunningActionRestApiTest.assertEquals((Object)("/api/running-action/MadeUp2=54321=" + instanceAlt2), (Object)jsonRD.get("details"));
    }

    public void testRunningReplicationActionsGet() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getGuestUserName());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_REPLICATION_ACTIONS), 401);
        RunningActionRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NORMAL);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_REPLICATION_ACTIONS), 401);
        RunningActionRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_REPLICATION_ACTIONS), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject json = new JSONObject(jsonStr);
        JSONArray results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)0, (int)results.length());
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("Test1", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        this.actionTrackingService.recordActionExecuting((Action)rd);
        String id = rd.getId();
        String instance = Integer.toString(((ActionImpl)rd).getExecutionInstance());
        String startedAt = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_REPLICATION_ACTIONS), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)1, (int)results.length());
        JSONObject jsonRD = (JSONObject)results.get(0);
        RunningActionRestApiTest.assertNotNull((Object)jsonRD);
        RunningActionRestApiTest.assertEquals((Object)id, (Object)jsonRD.get("actionId"));
        RunningActionRestApiTest.assertEquals((Object)"replicationActionExecutor", (Object)jsonRD.get("actionType"));
        RunningActionRestApiTest.assertEquals((Object)instance, (Object)jsonRD.get("actionInstance"));
        RunningActionRestApiTest.assertEquals((Object)rd.getNodeRef().toString(), (Object)jsonRD.get("actionNodeRef"));
        RunningActionRestApiTest.assertEquals((Object)startedAt, (Object)jsonRD.get("startedAt"));
        RunningActionRestApiTest.assertEquals((boolean)false, (boolean)jsonRD.getBoolean("cancelRequested"));
        RunningActionRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + id + "=" + instance), (Object)jsonRD.get("details"));
        JSONArray keys = jsonRD.names();
        for (int i = 0; i < keys.length(); ++i) {
            String key = keys.getString(0);
            if (key.equals("actionId") || key.equals("actionType") || key.equals("actionInstance") || key.equals("actionNodeRef") || key.equals("startedAt") || key.equals("cancelRequested") || key.equals("details")) continue;
            RunningActionRestApiTest.fail((String)("Unexpected key '" + key + "' found in json, raw json is\n" + jsonStr));
        }
        this.actionTrackingService.requestActionCancellation((CancellableAction)rd);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_REPLICATION_ACTIONS), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)1, (int)results.length());
        jsonRD = (JSONObject)results.get(0);
        RunningActionRestApiTest.assertNotNull((Object)jsonRD);
        RunningActionRestApiTest.assertEquals((Object)id, (Object)jsonRD.get("actionId"));
        RunningActionRestApiTest.assertEquals((Object)"replicationActionExecutor", (Object)jsonRD.get("actionType"));
        RunningActionRestApiTest.assertEquals((Object)instance, (Object)jsonRD.get("actionInstance"));
        RunningActionRestApiTest.assertEquals((Object)rd.getNodeRef().toString(), (Object)jsonRD.get("actionNodeRef"));
        RunningActionRestApiTest.assertEquals((Object)startedAt, (Object)jsonRD.get("startedAt"));
        RunningActionRestApiTest.assertEquals((boolean)true, (boolean)jsonRD.getBoolean("cancelRequested"));
        RunningActionRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + id + "=" + instance), (Object)jsonRD.get("details"));
        rd = this.replicationService.createReplicationDefinition("Test2", "2nd Testing");
        this.replicationService.saveReplicationDefinition(rd);
        this.actionTrackingService.recordActionExecuting((Action)rd);
        String id2 = rd.getId();
        String instance2 = Integer.toString(((ActionImpl)rd).getExecutionInstance());
        String startedAt2 = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        rd = this.replicationService.createReplicationDefinition("AnotherTest", "3rd Testing");
        this.replicationService.saveReplicationDefinition(rd);
        this.actionTrackingService.recordActionPending((Action)rd);
        String id3 = rd.getId();
        boolean has1 = false;
        boolean has2 = false;
        boolean has3 = false;
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_REPLICATION_ACTIONS), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)3, (int)results.length());
        for (int i = 0; i < 3; ++i) {
            jsonRD = (JSONObject)results.get(i);
            if (jsonRD.get("actionId").equals(id)) {
                has1 = true;
            }
            if (jsonRD.get("actionId").equals(id2)) {
                has2 = true;
            }
            if (!jsonRD.get("actionId").equals(id3)) continue;
            has3 = true;
        }
        RunningActionRestApiTest.assertTrue((boolean)has1);
        RunningActionRestApiTest.assertTrue((boolean)has2);
        RunningActionRestApiTest.assertTrue((boolean)has3);
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.actionTrackingService.recordActionComplete((Action)rd);
        txn.commit();
        has1 = false;
        has2 = false;
        has3 = false;
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_REPLICATION_ACTIONS), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)2, (int)results.length());
        for (int i = 0; i < 2; ++i) {
            jsonRD = (JSONObject)results.get(i);
            if (jsonRD.get("actionId").equals(id)) {
                has1 = true;
            }
            if (jsonRD.get("actionId").equals(id2)) {
                has2 = true;
            }
            if (!jsonRD.get("actionId").equals(id3)) continue;
            has3 = true;
        }
        RunningActionRestApiTest.assertTrue((boolean)has1);
        RunningActionRestApiTest.assertTrue((boolean)has2);
        RunningActionRestApiTest.assertFalse((boolean)has3);
        rd = this.replicationService.loadReplicationDefinition("Test1");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/running-replication-actions?name=Test1"), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)1, (int)results.length());
        jsonRD = (JSONObject)results.get(0);
        RunningActionRestApiTest.assertNotNull((Object)jsonRD);
        RunningActionRestApiTest.assertEquals((Object)id, (Object)jsonRD.get("actionId"));
        RunningActionRestApiTest.assertEquals((Object)"replicationActionExecutor", (Object)jsonRD.get("actionType"));
        RunningActionRestApiTest.assertEquals((Object)instance, (Object)jsonRD.get("actionInstance"));
        RunningActionRestApiTest.assertEquals((Object)rd.getNodeRef().toString(), (Object)jsonRD.get("actionNodeRef"));
        RunningActionRestApiTest.assertEquals((Object)startedAt, (Object)jsonRD.get("startedAt"));
        RunningActionRestApiTest.assertEquals((boolean)true, (boolean)jsonRD.getBoolean("cancelRequested"));
        RunningActionRestApiTest.assertEquals((Object)("/api/running-action/replicationActionExecutor=" + id + "=" + instance), (Object)jsonRD.get("details"));
        ActionImpl alt1 = new ActionImpl(null, "12345", "MadeUp1");
        ActionImpl alt2 = new ActionImpl(null, "54321", "MadeUp2");
        this.actionTrackingService.recordActionExecuting((Action)alt1);
        this.actionTrackingService.recordActionExecuting((Action)alt2);
        String startAtAlt2 = ISO8601DateFormat.format((Date)alt2.getExecutionStartDate());
        String instanceAlt2 = Integer.toString(alt2.getExecutionInstance());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_REPLICATION_ACTIONS), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        json = new JSONObject(jsonStr);
        results = json.getJSONArray("data");
        RunningActionRestApiTest.assertNotNull((Object)results);
        RunningActionRestApiTest.assertEquals((int)2, (int)results.length());
    }

    public void testRunningActionGet() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getGuestUserName());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/running-action/MadeUp"), 401);
        RunningActionRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NORMAL);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/running-action/MadeUp"), 401);
        RunningActionRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest("api/running-action/MadeUp"), 404);
        RunningActionRestApiTest.assertEquals((int)404, (int)response.getStatus());
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("Test1", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        this.actionTrackingService.recordActionExecuting((Action)rd);
        String id = rd.getId();
        String instance = Integer.toString(((ActionImpl)rd).getExecutionInstance());
        String startedAt = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        String key1 = "replicationActionExecutor=" + id + "=" + instance;
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_ACTION + key1), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject jsonRD = new JSONObject(jsonStr).getJSONObject("data");
        RunningActionRestApiTest.assertNotNull((Object)jsonRD);
        RunningActionRestApiTest.assertEquals((Object)id, (Object)jsonRD.get("actionId"));
        RunningActionRestApiTest.assertEquals((Object)"replicationActionExecutor", (Object)jsonRD.get("actionType"));
        RunningActionRestApiTest.assertEquals((Object)instance, (Object)jsonRD.get("actionInstance"));
        RunningActionRestApiTest.assertEquals((Object)rd.getNodeRef().toString(), (Object)jsonRD.get("actionNodeRef"));
        RunningActionRestApiTest.assertEquals((Object)startedAt, (Object)jsonRD.get("startedAt"));
        RunningActionRestApiTest.assertEquals((boolean)false, (boolean)jsonRD.getBoolean("cancelRequested"));
        RunningActionRestApiTest.assertEquals((Object)("/api/running-action/" + key1), (Object)jsonRD.get("details"));
        JSONArray keys = jsonRD.names();
        for (int i = 0; i < keys.length(); ++i) {
            String key = keys.getString(0);
            if (key.equals("actionId") || key.equals("actionType") || key.equals("actionInstance") || key.equals("actionNodeRef") || key.equals("startedAt") || key.equals("cancelRequested") || key.equals("details")) continue;
            RunningActionRestApiTest.fail((String)("Unexpected key '" + key + "' found in json, raw json is\n" + jsonStr));
        }
        rd = this.replicationService.createReplicationDefinition("Test2", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        this.actionTrackingService.recordActionExecuting((Action)rd);
        this.actionTrackingService.requestActionCancellation((CancellableAction)rd);
        String id2 = rd.getId();
        String instance2 = Integer.toString(((ActionImpl)rd).getExecutionInstance());
        String startedAt2 = ISO8601DateFormat.format((Date)rd.getExecutionStartDate());
        String key2 = "replicationActionExecutor=" + id2 + "=" + instance2;
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_ACTION + key2), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        jsonRD = new JSONObject(jsonStr).getJSONObject("data");
        RunningActionRestApiTest.assertNotNull((Object)jsonRD);
        RunningActionRestApiTest.assertEquals((Object)id2, (Object)jsonRD.get("actionId"));
        RunningActionRestApiTest.assertEquals((Object)"replicationActionExecutor", (Object)jsonRD.get("actionType"));
        RunningActionRestApiTest.assertEquals((Object)instance2, (Object)jsonRD.get("actionInstance"));
        RunningActionRestApiTest.assertEquals((Object)rd.getNodeRef().toString(), (Object)jsonRD.get("actionNodeRef"));
        RunningActionRestApiTest.assertEquals((Object)startedAt2, (Object)jsonRD.get("startedAt"));
        RunningActionRestApiTest.assertEquals((boolean)true, (boolean)jsonRD.getBoolean("cancelRequested"));
        RunningActionRestApiTest.assertEquals((Object)("/api/running-action/" + key2), (Object)jsonRD.get("details"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_ACTION + key1), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        rd = this.replicationService.loadReplicationDefinition("Test1");
        jsonStr = response.getContentAsString();
        jsonRD = new JSONObject(jsonStr).getJSONObject("data");
        RunningActionRestApiTest.assertNotNull((Object)jsonRD);
        RunningActionRestApiTest.assertEquals((Object)id, (Object)jsonRD.get("actionId"));
        RunningActionRestApiTest.assertEquals((Object)"replicationActionExecutor", (Object)jsonRD.get("actionType"));
        RunningActionRestApiTest.assertEquals((Object)instance, (Object)jsonRD.get("actionInstance"));
        RunningActionRestApiTest.assertEquals((Object)rd.getNodeRef().toString(), (Object)jsonRD.get("actionNodeRef"));
        RunningActionRestApiTest.assertEquals((Object)startedAt, (Object)jsonRD.get("startedAt"));
        RunningActionRestApiTest.assertEquals((boolean)false, (boolean)jsonRD.getBoolean("cancelRequested"));
        RunningActionRestApiTest.assertEquals((Object)("/api/running-action/" + key1), (Object)jsonRD.get("details"));
        rd = this.replicationService.createReplicationDefinition("Test3", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        this.actionTrackingService.recordActionPending((Action)rd);
        String id3 = rd.getId();
        String instance3 = Integer.toString(((ActionImpl)rd).getExecutionInstance());
        String key3 = "replicationActionExecutor=" + id3 + "=" + instance3;
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(URL_RUNNING_ACTION + key3), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        jsonStr = response.getContentAsString();
        jsonRD = new JSONObject(jsonStr).getJSONObject("data");
        RunningActionRestApiTest.assertNotNull((Object)jsonRD);
        RunningActionRestApiTest.assertEquals((Object)id3, (Object)jsonRD.get("actionId"));
        RunningActionRestApiTest.assertEquals((Object)"replicationActionExecutor", (Object)jsonRD.get("actionType"));
        RunningActionRestApiTest.assertEquals((Object)instance3, (Object)jsonRD.get("actionInstance"));
        RunningActionRestApiTest.assertEquals((Object)rd.getNodeRef().toString(), (Object)jsonRD.get("actionNodeRef"));
        RunningActionRestApiTest.assertEquals((Object)JSONObject.NULL, (Object)jsonRD.get("startedAt"));
        RunningActionRestApiTest.assertEquals((boolean)false, (boolean)jsonRD.getBoolean("cancelRequested"));
        RunningActionRestApiTest.assertEquals((Object)("/api/running-action/" + key3), (Object)jsonRD.get("details"));
    }

    public void testRunningActionCancel() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getGuestUserName());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/running-action/MadeUp"), 401);
        RunningActionRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NORMAL);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/running-action/MadeUp"), 401);
        RunningActionRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest("api/running-action/MadeUp"), 404);
        RunningActionRestApiTest.assertEquals((int)404, (int)response.getStatus());
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("Test1", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        this.actionTrackingService.recordActionExecuting((Action)rd);
        String id = rd.getId();
        String instance = Integer.toString(((ActionImpl)rd).getExecutionInstance());
        String key = "replicationActionExecutor=" + id + "=" + instance;
        RunningActionRestApiTest.assertEquals((boolean)false, (boolean)this.actionTrackingService.isCancellationRequested((CancellableAction)rd));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(URL_RUNNING_ACTION + key), 204);
        RunningActionRestApiTest.assertEquals((int)204, (int)response.getStatus());
        RunningActionRestApiTest.assertEquals((boolean)true, (boolean)this.actionTrackingService.isCancellationRequested((CancellableAction)rd));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(URL_RUNNING_ACTION + key), 204);
        RunningActionRestApiTest.assertEquals((int)204, (int)response.getStatus());
        RunningActionRestApiTest.assertEquals((boolean)true, (boolean)this.actionTrackingService.isCancellationRequested((CancellableAction)rd));
        rd = this.replicationService.createReplicationDefinition("Test2", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        this.actionTrackingService.recordActionPending((Action)rd);
        String id2 = rd.getId();
        String instance2 = Integer.toString(((ActionImpl)rd).getExecutionInstance());
        String key2 = "replicationActionExecutor=" + id2 + "=" + instance2;
        RunningActionRestApiTest.assertEquals((boolean)false, (boolean)this.actionTrackingService.isCancellationRequested((CancellableAction)rd));
        RunningActionRestApiTest.assertEquals(null, (Object)rd.getExecutionStartDate());
        RunningActionRestApiTest.assertNotNull((Object)this.executingActionsCache.get((Serializable)((Object)key2)));
        RunningActionRestApiTest.assertFalse((boolean)((ExecutionDetails)this.executingActionsCache.get((Serializable)((Object)key2))).isCancelRequested());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.DeleteRequest(URL_RUNNING_ACTION + key2), 204);
        RunningActionRestApiTest.assertEquals((int)204, (int)response.getStatus());
        RunningActionRestApiTest.assertNotNull((Object)this.executingActionsCache.get((Serializable)((Object)key2)));
        RunningActionRestApiTest.assertTrue((boolean)((ExecutionDetails)this.executingActionsCache.get((Serializable)((Object)key2))).isCancelRequested());
        RunningActionRestApiTest.assertEquals((boolean)true, (boolean)this.actionTrackingService.isCancellationRequested((CancellableAction)rd));
        RunningActionRestApiTest.assertEquals(null, (Object)rd.getExecutionStartDate());
    }

    public void testRunningActionsPost() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getGuestUserName());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RUNNING_ACTIONS, "{}", JSON), 401);
        RunningActionRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NORMAL);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RUNNING_ACTIONS, "{}", JSON), 401);
        RunningActionRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RUNNING_ACTIONS, "{}", JSON), 400);
        RunningActionRestApiTest.assertEquals((int)400, (int)response.getStatus());
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("Test1", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        String id = rd.getId();
        txn.commit();
        JSONObject json = new JSONObject();
        json.put("nodeRef", (Object)rd.getNodeRef().toString());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RUNNING_ACTIONS, json.toString(), JSON), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject jsonRD = new JSONObject(jsonStr).getJSONObject("data");
        RunningActionRestApiTest.assertNotNull((Object)jsonRD);
        RunningActionRestApiTest.assertEquals((Object)id, (Object)jsonRD.get("actionId"));
        RunningActionRestApiTest.assertEquals((Object)"replicationActionExecutor", (Object)jsonRD.get("actionType"));
        RunningActionRestApiTest.assertEquals((Object)rd.getNodeRef().toString(), (Object)jsonRD.get("actionNodeRef"));
        RunningActionRestApiTest.assertEquals((boolean)false, (boolean)jsonRD.getBoolean("cancelRequested"));
        for (int i = 0; i < 50; ++i) {
            txn = this.transactionService.getUserTransaction();
            txn.begin();
            rd = this.replicationService.loadReplicationDefinition("Test1");
            txn.commit();
            if (rd.getExecutionStatus() == ActionStatus.New) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (rd.getExecutionStatus() == ActionStatus.Failed) break;
            RunningActionRestApiTest.fail((String)("Unexpected status in repo of " + rd.getExecutionStatus()));
        }
        RunningActionRestApiTest.assertEquals((Object)ActionStatus.Failed, (Object)rd.getExecutionStatus());
        json = new JSONObject();
        json.put("nodeRef", (Object)("XX" + rd.getNodeRef().toString() + "ZZ"));
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RUNNING_ACTIONS, json.toString(), JSON), 404);
        RunningActionRestApiTest.assertEquals((int)404, (int)response.getStatus());
    }

    public void testRunningReplicationsActionsPost() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getGuestUserName());
        TestWebScriptServer.Response response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RUNNING_REPLICATION_ACTIONS, "{}", JSON), 401);
        RunningActionRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NORMAL);
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RUNNING_REPLICATION_ACTIONS, "{}", JSON), 401);
        RunningActionRestApiTest.assertEquals((int)401, (int)response.getStatus());
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RUNNING_REPLICATION_ACTIONS, "{}", JSON), 400);
        RunningActionRestApiTest.assertEquals((int)400, (int)response.getStatus());
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        ReplicationDefinition rd = this.replicationService.createReplicationDefinition("Test1", "Testing");
        this.replicationService.saveReplicationDefinition(rd);
        String id = rd.getId();
        txn.commit();
        JSONObject json = new JSONObject();
        json.put("name", (Object)"Test1");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RUNNING_REPLICATION_ACTIONS, json.toString(), JSON), 200);
        RunningActionRestApiTest.assertEquals((int)200, (int)response.getStatus());
        String jsonStr = response.getContentAsString();
        JSONObject jsonRD = new JSONObject(jsonStr).getJSONObject("data");
        RunningActionRestApiTest.assertNotNull((Object)jsonRD);
        RunningActionRestApiTest.assertEquals((Object)id, (Object)jsonRD.get("actionId"));
        RunningActionRestApiTest.assertEquals((Object)"replicationActionExecutor", (Object)jsonRD.get("actionType"));
        RunningActionRestApiTest.assertEquals((Object)rd.getNodeRef().toString(), (Object)jsonRD.get("actionNodeRef"));
        RunningActionRestApiTest.assertEquals((boolean)false, (boolean)jsonRD.getBoolean("cancelRequested"));
        for (int i = 0; i < 50; ++i) {
            txn = this.transactionService.getUserTransaction();
            txn.begin();
            rd = this.replicationService.loadReplicationDefinition("Test1");
            txn.commit();
            if (rd.getExecutionStatus() == ActionStatus.New) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (rd.getExecutionStatus() == ActionStatus.Failed) break;
            RunningActionRestApiTest.fail((String)("Unexpected status in repo of " + rd.getExecutionStatus()));
        }
        RunningActionRestApiTest.assertEquals((Object)ActionStatus.Failed, (Object)rd.getExecutionStatus());
        json = new JSONObject();
        json.put("name", (Object)"MadeUpName");
        response = this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.PostRequest(URL_RUNNING_REPLICATION_ACTIONS, json.toString(), JSON), 404);
        RunningActionRestApiTest.assertEquals((int)404, (int)response.getStatus());
    }

    protected void setUp() throws Exception {
        super.setUp();
        ApplicationContext appContext = this.getServer().getApplicationContext();
        this.nodeService = (NodeService)appContext.getBean("NodeService");
        this.replicationService = (ReplicationService)appContext.getBean("ReplicationService");
        this.actionTrackingService = (ActionTrackingService)appContext.getBean("actionTrackingService");
        this.repositoryHelper = (Repository)appContext.getBean("repositoryHelper");
        this.transactionService = (TransactionService)appContext.getBean("transactionService");
        this.executingActionsCache = (SimpleCache)appContext.getBean("executingActionsCache");
        MutableAuthenticationService authenticationService = (MutableAuthenticationService)appContext.getBean("AuthenticationService");
        PersonService personService = (PersonService)appContext.getBean("PersonService");
        this.personManager = new TestPersonManager(authenticationService, personService, this.nodeService);
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.personManager.createPerson(USER_NORMAL);
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        for (ReplicationDefinition rd : this.replicationService.loadReplicationDefinitions()) {
            this.replicationService.deleteReplicationDefinition(rd);
        }
        txn.commit();
        this.dataDictionary = this.nodeService.getChildByName(this.repositoryHelper.getCompanyHome(), ContentModel.ASSOC_CONTAINS, "Data Dictionary");
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        UserTransaction txn = this.transactionService.getUserTransaction();
        txn.begin();
        this.personManager.clearPeople();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        for (ReplicationDefinition rd : this.replicationService.loadReplicationDefinitions()) {
            this.replicationService.deleteReplicationDefinition(rd);
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        for (ExecutionSummary es : this.actionTrackingService.getAllExecutingActions()) {
            this.executingActionsCache.remove((Serializable)((Object)AbstractActionWebscript.getRunningId((ExecutionSummary)es)));
        }
        txn.commit();
    }
}

