/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.web.scripts;

import java.lang.invoke.CallSite;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.util.testing.category.LuceneTests;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.experimental.categories.Category;
import org.springframework.extensions.webscripts.DeclarativeRegistry;
import org.springframework.extensions.webscripts.Description;
import org.springframework.extensions.webscripts.TestWebScriptServer;
import org.springframework.extensions.webscripts.WebScript;
import org.springframework.extensions.webscripts.WebScriptException;

@Category(value={LuceneTests.class})
public class XssVulnerabilityTest
extends BaseWebScriptTest {
    private Log logger = LogFactory.getLog(XssVulnerabilityTest.class);
    private DeclarativeRegistry webscriptsRegistry;
    static final String START_ARG = "{";
    static final String END_ARG = "}";
    static final String[] METHODS_TO_CHECK_ARRAY = new String[]{"GET", "DELETE", "POST", "PUT"};
    static final Set<String> METHODS_TO_CHECK_SET = new HashSet<String>(Arrays.asList(METHODS_TO_CHECK_ARRAY));
    static final String[] FORMATS_TO_CHECK_ARRAY = new String[]{"html"};
    static final Set<String> FORMATS_TO_CHECK_SET = new HashSet<String>(Arrays.asList(FORMATS_TO_CHECK_ARRAY));
    static final String[] URI_TO_SKIP_ARRAY = new String[]{".rss", ".atom"};
    static final String MALARG1 = "<script>alert('XSS')</script>";
    static final String MALARG2 = "</script><script>alert('XSS')</script>";
    static final String MALARG3 = "\"</script><script>alert('XSS')</script>";
    static final String MALARG4 = "'\"</style></script><script>alert('XSS')</script>";
    static final String[] MALICIOUS_ARGS = new String[]{"<script>alert('XSS')</script>", "</script><script>alert('XSS')</script>", "\"</script><script>alert('XSS')</script>", "'\"</style></script><script>alert('XSS')</script>"};
    static final String[] SKIP_WEBSCRIPT_CHECK_ARRAY = new String[]{"org/alfresco/cmis/client/cmisbrowser/federatedquery.get", "org/alfresco/cmis/test.post.desc.xml"};
    static final Set<String> SKIP_WEBSCRIPT_CHECK_ID_SET = new HashSet<String>(Arrays.asList(SKIP_WEBSCRIPT_CHECK_ARRAY));

    protected void setUp() throws Exception {
        super.setUp();
        this.webscriptsRegistry = (DeclarativeRegistry)this.getServer().getApplicationContext().getBean("webscripts.registry.prototype");
        this.setDefaultRunAs(AuthenticationUtil.getAdminUserName());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected Log getLogger() {
        return this.logger;
    }

    public void testXssVulnerability() throws Throwable {
        this.webscriptsRegistry.reset();
        int scriptsSize = this.webscriptsRegistry.getWebScripts().size();
        int i = 0;
        int successCount = 0;
        int wserrcount = 0;
        int vulnCount = 0;
        LinkedList<CallSite> vulnerabileURLS = new LinkedList<CallSite>();
        for (WebScript webScript : this.webscriptsRegistry.getWebScripts()) {
            Description wsDesc;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("progress: " + ++i + "/" + scriptsSize));
            }
            if (SKIP_WEBSCRIPT_CHECK_ID_SET.contains((wsDesc = webScript.getDescription()).getId())) continue;
            boolean isMethodCheck = METHODS_TO_CHECK_SET.contains(wsDesc.getMethod());
            boolean isFormatCheck = FORMATS_TO_CHECK_SET.contains(wsDesc.getDefaultFormat());
            if (!isMethodCheck || !isFormatCheck) continue;
            for (String malArg : MALICIOUS_ARGS) {
                String[] uris;
                for (String uri : uris = wsDesc.getURIs()) {
                    TestWebScriptServer.Response resp;
                    List<String> parsedArgs;
                    if (this.isUriSkip(uri) || 0 == (parsedArgs = this.parseArgsFromURI(uri)).size()) continue;
                    String url = this.substituteMaliciousArgInURI(uri, parsedArgs, malArg);
                    try {
                        resp = this.sendRequest(this.createRequest(wsDesc.getMethod(), url), -1);
                    }
                    catch (WebScriptException e) {
                        ++wserrcount;
                        continue;
                    }
                    String respString = resp.getContentAsString();
                    if (resp.getStatus() == 200) {
                        ++successCount;
                    }
                    if (!respString.toLowerCase().contains(malArg.toLowerCase())) continue;
                    vulnerabileURLS.add((CallSite)((Object)(wsDesc.getMethod() + " " + url)));
                    ++vulnCount;
                }
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("OK html responses count: " + successCount));
            this.getLogger().debug((Object)("Webscript errors count: " + wserrcount));
            this.getLogger().debug((Object)("Vulnerabile URLs count: " + vulnCount));
        }
        for (String string : vulnerabileURLS) {
            this.getLogger().warn((Object)("Vulnerabile URL: " + string));
        }
        XssVulnerabilityTest.assertTrue((String)("Vulnerabile URLs found: " + vulnerabileURLS), (vulnerabileURLS.size() == 0 ? 1 : 0) != 0);
    }

    private boolean isUriSkip(String uri) {
        for (String uriPart : URI_TO_SKIP_ARRAY) {
            if (!uri.contains(uriPart)) continue;
            return true;
        }
        return false;
    }

    private List<String> parseArgsFromURI(String uri) {
        LinkedList<String> args = new LinkedList<String>();
        int startBracketInd = uri.indexOf(START_ARG, 0);
        while (startBracketInd != -1) {
            int endBracketInd = uri.indexOf(END_ARG, startBracketInd);
            if (endBracketInd != -1) {
                String arg = uri.substring(startBracketInd + 1, endBracketInd);
                if (arg.endsWith("?")) {
                    arg = arg.substring(0, arg.length() - 1);
                }
                args.add(arg);
                startBracketInd = uri.indexOf(START_ARG, endBracketInd);
                continue;
            }
            throw new AlfrescoRuntimeException("Invalid webscript URI : " + uri);
        }
        return args;
    }

    private TestWebScriptServer.Request createRequest(String method, String url) throws Exception {
        switch (method) {
            case "DELETE": {
                return new TestWebScriptServer.DeleteRequest(url);
            }
            case "GET": {
                return new TestWebScriptServer.GetRequest(url);
            }
            case "PUT": {
                return new TestWebScriptServer.PutRequest(url, "{}", "application/json");
            }
            case "POST": {
                return new TestWebScriptServer.PostRequest(url, "{}", "application/json");
            }
        }
        throw new InvalidArgumentException("HTTP method not supported");
    }

    private String substituteMaliciousArgInURI(String uri, List<String> urlArgs, String malArg) {
        String url = uri;
        for (String arg : urlArgs) {
            url = url.replace(START_ARG + arg + END_ARG, "a" + malArg);
            url = url.replace(START_ARG + arg + "?}", "a" + malArg);
        }
        if (url.contains(START_ARG) || url.contains(END_ARG)) {
            throw new AlfrescoRuntimeException("Arguments were not properly substituted: " + url);
        }
        return url;
    }
}

