/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remoteconnector;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.sf.acegisecurity.Authentication;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.remoteconnector.RemoteConnectorRequestImpl;
import org.alfresco.repo.remoteconnector.RemoteConnectorResponseImpl;
import org.alfresco.repo.remoteconnector.RemoteConnectorServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.web.scripts.BaseWebScriptTest;
import org.alfresco.repo.web.scripts.servlet.BasicHttpAuthenticatorFactory;
import org.alfresco.repo.web.scripts.servlet.LocalTestRunAsAuthenticatorFactory;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorClientException;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorRequest;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorResponse;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorServerException;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorService;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.simple.JSONObject;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.webscripts.Authenticator;
import org.springframework.extensions.webscripts.TestWebScriptServer;
import org.springframework.extensions.webscripts.servlet.ServletAuthenticatorFactory;
import org.springframework.extensions.webscripts.servlet.WebScriptServletRequest;
import org.springframework.extensions.webscripts.servlet.WebScriptServletResponse;

public class LocalWebScriptConnectorServiceImpl
implements RemoteConnectorService {
    private static Log logger = LogFactory.getLog(LocalWebScriptConnectorServiceImpl.class);
    public static final String LOCAL_BASE_URL = "http://localhost:8080/alfresco/";
    private static final String SERVICE_URL = "/service/";
    public static final String LOCAL_SERVICE_URL = "http://localhost:8080/alfresco/service/";
    private WebScriptHelper helper;
    private LocalAndRemoteAuthenticator auth;

    public LocalWebScriptConnectorServiceImpl(BaseWebScriptTest webScriptTest) throws Exception {
        this.helper = new WebScriptHelper(webScriptTest);
        this.auth = new LocalAndRemoteAuthenticator(webScriptTest);
    }

    public RemoteConnectorRequest buildRequest(String url, String method) {
        if (url.startsWith(LOCAL_BASE_URL)) {
            if (!(url = url.substring(LOCAL_BASE_URL.length() - 1)).startsWith(SERVICE_URL)) {
                throw new IllegalArgumentException("Only /service/ local URLs are supported, can't handle " + url);
            }
        } else {
            throw new IllegalArgumentException("Not a local URL: " + url);
        }
        url = url.substring(SERVICE_URL.length() - 1);
        return new RemoteConnectorRequestImpl(url, method);
    }

    public RemoteConnectorRequest buildRequest(String url, Class<? extends HttpMethodBase> method) {
        String methodName;
        try {
            HttpMethodBase httpMethod = method.getConstructor(String.class).newInstance(url);
            methodName = httpMethod.getName();
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Error identifying method name", (Throwable)e);
        }
        return this.buildRequest(url, methodName);
    }

    public RemoteConnectorResponse executeRequest(RemoteConnectorRequest request) throws IOException, AuthenticationException, RemoteConnectorClientException, RemoteConnectorServerException {
        TestWebScriptServer.Response resp;
        RemoteConnectorRequestImpl requestImpl = (RemoteConnectorRequestImpl)request;
        TestWebScriptServer.Request req = new TestWebScriptServer.Request(request.getMethod(), request.getURL());
        req.setType(request.getContentType());
        if (request.getRequestBody() != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            requestImpl.getRequestBody().writeRequest((OutputStream)baos);
            req.setBody(baos.toByteArray());
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Performing local " + request.getMethod() + " request to " + request.getURL()));
        }
        Authentication fullAuth = AuthenticationUtil.getFullAuthentication();
        String runAsUser = AuthenticationUtil.getRunAsUser();
        Header authHeader = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : request.getRequestHeaders()) {
            if (header.getName().equals("Authorization")) {
                authHeader = header;
            }
            headers.put(header.getName(), header.getValue());
        }
        if (authHeader != null) {
            AuthenticationUtil.clearCurrentSecurityContext();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("HTTP Authorization found for the request, clearing security context, Auth is " + authHeader));
            }
        }
        req.setHeaders(headers);
        try {
            resp = this.helper.sendRequest(req, -1);
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Problem requesting", (Throwable)e);
        }
        AuthenticationUtil.setFullAuthentication((Authentication)fullAuth);
        if (runAsUser != null && !runAsUser.equals(fullAuth.getName())) {
            AuthenticationUtil.setRunAsUser((String)runAsUser);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Response to request was " + resp.getStatus() + " - " + resp));
        }
        if (resp.getStatus() == 401) {
            throw new AuthenticationException("Not Authorized to access this resource");
        }
        if (resp.getStatus() == 403) {
            throw new AuthenticationException("Forbidden to access this resource");
        }
        if (resp.getStatus() >= 500 && resp.getStatus() <= 599) {
            throw new RemoteConnectorServerException(resp.getStatus(), "(not available)");
        }
        String charset = null;
        String contentType = resp.getContentType();
        if (contentType != null && contentType.contains("charset=")) {
            int splitAt = contentType.indexOf("charset=") + "charset=".length();
            charset = contentType.substring(splitAt);
        }
        ByteArrayInputStream body = new ByteArrayInputStream(resp.getContentAsByteArray());
        Header[] respHeaders = new Header[]{};
        RemoteConnectorResponseImpl response = new RemoteConnectorResponseImpl(request, contentType, charset, resp.getStatus(), respHeaders, (InputStream)body);
        if (resp.getStatus() >= 400 && resp.getStatus() <= 499) {
            throw new RemoteConnectorClientException(resp.getStatus(), "(not available)", (RemoteConnectorResponse)response);
        }
        return response;
    }

    public JSONObject executeJSONRequest(RemoteConnectorRequest request) throws ParseException, IOException, AuthenticationException {
        return RemoteConnectorServiceImpl.doExecuteJSONRequest((RemoteConnectorRequest)request, (RemoteConnectorService)this);
    }

    private static class LocalAndRemoteAuthenticator
    implements ServletAuthenticatorFactory {
        private BasicHttpAuthenticatorFactory httpAuthFactory;

        private LocalAndRemoteAuthenticator(BaseWebScriptTest test) throws Exception {
            Method getServer = BaseWebScriptTest.class.getDeclaredMethod("getServer", new Class[0]);
            getServer.setAccessible(true);
            TestWebScriptServer server = (TestWebScriptServer)getServer.invoke((Object)test, new Object[0]);
            this.httpAuthFactory = (BasicHttpAuthenticatorFactory)server.getApplicationContext().getBean("webscripts.authenticator.basic");
            test.setCustomAuthenticatorFactory((ServletAuthenticatorFactory)this);
            server.setServletAuthenticatorFactory((ServletAuthenticatorFactory)this);
        }

        public Authenticator create(WebScriptServletRequest req, WebScriptServletResponse res) {
            if (AuthenticationUtil.getFullyAuthenticatedUser() != null) {
                String fullUser = AuthenticationUtil.getFullyAuthenticatedUser();
                logger.debug((Object)("Existing Authentication found, remaining as " + fullUser));
                return new LocalTestRunAsAuthenticatorFactory.LocalTestRunAsAuthenticator(fullUser);
            }
            logger.debug((Object)"No existing Authentication found, using regular HTTP Auth");
            return this.httpAuthFactory.create(req, res);
        }
    }

    private static class WebScriptHelper {
        private BaseWebScriptTest test;
        private Method sendRequest;

        private WebScriptHelper(BaseWebScriptTest test) throws Exception {
            this.test = test;
            this.sendRequest = BaseWebScriptTest.class.getDeclaredMethod("sendRequest", TestWebScriptServer.Request.class, Integer.TYPE);
            this.sendRequest.setAccessible(true);
        }

        private TestWebScriptServer.Response sendRequest(TestWebScriptServer.Request request, int expectedStatus) throws Exception {
            return (TestWebScriptServer.Response)this.sendRequest.invoke((Object)this.test, request, expectedStatus);
        }
    }
}

