/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.client.info.FileInfo;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;
import org.alfresco.jlan.util.MemorySize;
import org.springframework.extensions.config.ConfigElement;

public class WriteSequentialTest
extends Test {
    private static final long DefaultFileSize = 0xA00000L;
    private static final int DefaultWriteSize = 8192;
    private static final long MinimumFileSize = 102400L;
    private static final long MaximumFileSize = 0x80000000L;
    private static final int MinimumWriteSize = 128;
    private static final int MaximumWriteSize = 65536;
    private long m_fileSize = 0xA00000L;
    private int m_writeSize = 8192;
    private static final String _writePattern = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXZ0123456789";

    public WriteSequentialTest() {
        super("SequentialWrite");
    }

    public void configTest(ConfigElement config) throws InvalidConfigurationException {
        String valueStr = config.getAttribute("fileSize");
        if (valueStr != null) {
            try {
                this.m_fileSize = MemorySize.getByteValue(valueStr);
                if (this.m_fileSize < 102400L || this.m_fileSize > 0x80000000L) {
                    throw new InvalidConfigurationException("Invalid file size (102400 - 2147483648)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid file size, " + valueStr);
            }
        }
        if ((valueStr = config.getAttribute("writeSize")) != null) {
            try {
                this.m_writeSize = MemorySize.getByteValueInt(valueStr);
                if (this.m_writeSize < 128 || this.m_writeSize > 65536) {
                    throw new InvalidConfigurationException("Invalid write buffer size (128 - 65536)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid write buffer size, " + valueStr);
            }
        }
    }

    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            long fileSize;
            String testFileName = this.getUniqueFileName(threadId, iteration, sess);
            this.testLog(log, "SequentialWrite Test");
            SMBFile testFile = null;
            if (sess.FileExists(testFileName)) {
                this.testLog(log, "Opening existing file " + testFileName + " via " + sess.getServer());
                testFile = sess.OpenFile(testFileName, 2);
            } else {
                this.testLog(log, "Creating file " + testFileName + " via " + sess.getServer());
                testFile = sess.CreateFile(testFileName);
                if (!sess.FileExists(testFileName)) {
                    this.testLog(log, "** File does not exist after create");
                    result = new BooleanTestResult(false, "File not created, " + testFileName);
                }
            }
            byte[] ioBuf = new byte[this.m_writeSize];
            int patIdx = 0;
            for (fileSize = 0L; fileSize < this.m_fileSize; fileSize += (long)ioBuf.length) {
                if (patIdx == _writePattern.length()) {
                    patIdx = 0;
                }
                byte fillByte = (byte)_writePattern.charAt(patIdx++);
                Arrays.fill(ioBuf, fillByte);
                testFile.Write(ioBuf, ioBuf.length, 0);
            }
            testFile.Flush();
            testFile.refreshFileInformation();
            if (testFile.getFileSize() != this.m_fileSize) {
                result = new BooleanTestResult(false, "File writes to " + MemorySize.asScaledString(this.m_fileSize) + " bytes failed");
                return result;
            }
            patIdx = 0;
            boolean chkFail = false;
            for (long readPos = 0L; readPos < fileSize && !chkFail; readPos += (long)ioBuf.length) {
                int rdlen = testFile.Read(ioBuf);
                if (rdlen != ioBuf.length) {
                    throw new IOException("Read did not match buffer length, rdlen=" + rdlen + ", bufferLen=" + ioBuf.length);
                }
                if (patIdx == _writePattern.length()) {
                    patIdx = 0;
                }
                byte chkByte = (byte)_writePattern.charAt(patIdx++);
                for (int chkIdx = 0; chkIdx < ioBuf.length && !chkFail; ++chkIdx) {
                    if (ioBuf[chkIdx] == chkByte) continue;
                    chkFail = true;
                    result = new BooleanTestResult(false, "Pattern check failed at position " + readPos + chkIdx);
                }
            }
            testFile.Close();
            if (result == null) {
                FileInfo fInfo = sess.getFileInformation(testFileName);
                result = fInfo != null ? (fInfo.getSize() == fileSize ? new BooleanTestResult(true) : new BooleanTestResult(false, "File size mismatch, written=" + fileSize + ", info=" + fInfo.getSize())) : new BooleanTestResult(false, "Failed to get file information for file " + testFileName);
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        sess.DeleteFile(this.getUniqueFileName(threadId, iter, sess));
    }
}

