/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Random;
import org.alfresco.jlan.client.CIFSDiskSession;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.client.info.FileInfo;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;
import org.alfresco.jlan.util.MemorySize;
import org.springframework.extensions.config.ConfigElement;

public class WriteRandomTest
extends Test {
    private static final long DefaultFileSize = 0xA00000L;
    private static final int DefaultWriteSize = 8192;
    private static final int DefaultWriteCount = 100;
    private static final long MinimumFileSize = 102400L;
    private static final long MaximumFileSize = 0x80000000L;
    private static final int MinimumWriteSize = 128;
    private static final int MaximumWriteSize = 65536;
    private static final int MinimumWriteCount = 10;
    private static final int MaximumWriteCount = 100000;
    private long m_fileSize = 0xA00000L;
    private int m_writeSize = 8192;
    private int m_writeCount = 100;
    private static final String _writePattern = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXZ0123456789";

    public WriteRandomTest() {
        super("RandomWrite");
    }

    public void configTest(ConfigElement config) throws InvalidConfigurationException {
        String valueStr = config.getAttribute("fileSize");
        if (valueStr != null) {
            try {
                this.m_fileSize = MemorySize.getByteValue(valueStr);
                if (this.m_fileSize < 102400L || this.m_fileSize > 0x80000000L) {
                    throw new InvalidConfigurationException("Invalid file size (102400 - 2147483648)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid file size, " + valueStr);
            }
        }
        if ((valueStr = config.getAttribute("writeSize")) != null) {
            try {
                this.m_writeSize = MemorySize.getByteValueInt(valueStr);
                if (this.m_writeSize < 128 || this.m_writeSize > 65536) {
                    throw new InvalidConfigurationException("Invalid write buffer size (128 - 65536)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid write buffer size, " + valueStr);
            }
        }
        if ((valueStr = config.getAttribute("writeCount")) != null) {
            try {
                this.m_writeCount = Integer.parseInt(valueStr);
                if (this.m_writeCount < 10 || this.m_writeCount > 100000) {
                    throw new InvalidConfigurationException("Invalid write count (10 - 100000)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid write count, " + valueStr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        void var5_15;
        void var5_10;
        SMBFile testFile;
        block22: {
            BooleanTestResult booleanTestResult;
            CIFSDiskSession cifsSess;
            String testFileName;
            block21: {
                BooleanTestResult booleanTestResult2;
                Object var5_5 = null;
                testFile = null;
                testFileName = this.getUniqueFileName(threadId, iteration, sess);
                this.testLog(log, "RandomWrite Test");
                cifsSess = null;
                if (sess instanceof CIFSDiskSession) {
                    cifsSess = (CIFSDiskSession)sess;
                    break block21;
                }
                BooleanTestResult booleanTestResult3 = booleanTestResult2 = new BooleanTestResult(false, "Not an NT dialect CIFS session");
                Object var21_22 = null;
                if (testFile == null) return booleanTestResult3;
                try {
                    testFile.Close();
                    return booleanTestResult3;
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                return booleanTestResult3;
            }
            if (sess.FileExists(testFileName)) {
                this.testLog(log, "Opening existing file " + testFileName + " via " + sess.getServer());
                testFile = sess.OpenFile(testFileName, 2);
            } else {
                this.testLog(log, "Creating file " + testFileName + " via " + sess.getServer());
                testFile = cifsSess.CreateFile(testFileName);
                if (!sess.FileExists(testFileName)) {
                    this.testLog(log, "** File does not exist after create");
                    BooleanTestResult booleanTestResult4 = new BooleanTestResult(false, "File not created, " + testFileName);
                }
            }
            cifsSess.NTSetEndOfFile(testFile.getFileId(), this.m_fileSize);
            FileInfo fileInfo = cifsSess.getFileInformation(testFileName);
            if (fileInfo.getSize() == this.m_fileSize) break block22;
            BooleanTestResult booleanTestResult5 = booleanTestResult = new BooleanTestResult(false, "File extend to " + MemorySize.asScaledString(this.m_fileSize) + " bytes failed");
            Object var21_23 = null;
            if (testFile == null) return booleanTestResult5;
            try {
                testFile.Close();
                return booleanTestResult5;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            return booleanTestResult5;
        }
        testFile.refreshFileInformation();
        byte[] byArray = new byte[this.m_writeSize];
        Random randomPos = new Random();
        int maxPos = (int)(this.m_fileSize - (long)this.m_writeSize);
        int patIdx = 0;
        long writePos = 0L;
        for (int writeCount = 0; writeCount < this.m_writeCount && var5_10 == null; ++writeCount) {
            if (patIdx == _writePattern.length()) {
                patIdx = 0;
            }
            byte fillByte = (byte)_writePattern.charAt(patIdx++);
            Arrays.fill(byArray, fillByte);
            writePos = randomPos.nextInt(maxPos);
            testFile.Seek(writePos, 0);
            testFile.Write(byArray, byArray.length, 0);
            testFile.Seek(writePos, 0);
            int rdlen = testFile.Read(byArray);
            if (rdlen != byArray.length) {
                throw new IOException("Read did not match buffer length, rdlen=" + rdlen + ", bufferLen=" + byArray.length);
            }
            for (int chkIdx = 0; chkIdx < byArray.length && var5_10 == null; ++chkIdx) {
                if (byArray[chkIdx] == fillByte) continue;
                BooleanTestResult booleanTestResult = new BooleanTestResult(false, "Pattern check failed at position " + writePos + ", writeCount=" + writeCount);
            }
        }
        testFile.Close();
        testFile = null;
        if (var5_10 == null) {
            BooleanTestResult booleanTestResult = new BooleanTestResult(true);
        }
        this.testLog(log, "Test completed");
        Object var21_24 = null;
        if (testFile == null) return var5_15;
        try {
            testFile.Close();
            return var5_15;
        }
        catch (Exception ex2) {}
        return var5_15;
        {
            catch (Exception ex) {
                Debug.println(ex);
                ExceptionTestResult exceptionTestResult = new ExceptionTestResult(ex);
                Object var21_25 = null;
                if (testFile == null) return var5_15;
                try {
                    testFile.Close();
                    return var5_15;
                }
                catch (Exception ex2) {}
                return var5_15;
            }
        }
        catch (Throwable throwable) {
            Object var21_26 = null;
            if (testFile == null) throw throwable;
            try {
                testFile.Close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        sess.DeleteFile(this.getUniqueFileName(threadId, iter, sess));
    }
}

