/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.StringWriter;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;

public class RenameFolderTest
extends Test {
    private static final String TestFolderName = "fromFolder";
    private static final String TestFolderNew = "toFolder";

    public RenameFolderTest() {
        super("RenameFolder");
    }

    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            String testFolderName = "fromFolder_" + threadId + "_" + iteration;
            String newFolderName = "toFolder_" + threadId + "_" + iteration;
            this.testLog(log, "RenameFolder Test");
            if (sess.FileExists(testFolderName)) {
                this.testLog(log, "File " + testFolderName + " exists");
                result = new BooleanTestResult(false, "Folder already exists, " + testFolderName);
            } else {
                this.testLog(log, "Creating folder " + testFolderName + " via " + sess.getServer());
                sess.CreateDirectory(testFolderName);
                if (sess.FileExists(testFolderName)) {
                    sess.RenameFile(testFolderName, newFolderName);
                    result = sess.FileExists(newFolderName) ? (!sess.FileExists(testFolderName) ? new BooleanTestResult(true) : new BooleanTestResult(false, "Old folder exists after rename, " + testFolderName)) : new BooleanTestResult(false, "New folder does not exist after rename, " + newFolderName);
                } else {
                    this.testLog(log, "** Folder does not exist after create");
                    result = new BooleanTestResult(false, "Folder does not exist, " + testFolderName);
                }
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        sess.DeleteDirectory("toFolder_" + threadId + "_" + iter);
    }
}

