/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;
import org.alfresco.jlan.util.MemorySize;
import org.springframework.extensions.config.ConfigElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerfFolderTreeTest
extends Test {
    private static final int DefaultFolderDepth = 5;
    private static final int DefaultFoldersPerLevel = 5;
    private static final int DefaultFilesPerLevel = 5;
    private static final int DefaultFileSize = 80;
    private static final int DefaultWriteSize = 8192;
    private static final int MinimumFolderDepth = 2;
    private static final int MaximumFolderDepth = 10;
    private static final int MinimumFoldersPerLevel = 2;
    private static final int MaximumFoldersPerLevel = 25;
    private static final int MinimumFilesPerLevel = 0;
    private static final int MaximumFilessPerLevel = 25;
    private static final long MinimumFileSize = 1L;
    private static final long MaximumFileSize = 16384L;
    private static final int MinimumWriteSize = 128;
    private static final int MaximumWriteSize = 65536;
    private static final String LevelFolderName = "Folder_";
    private static final String LevelFileName = "File_";
    private static final String LevelFileExt = ".txt";
    private int m_folderDepth = 5;
    private int m_foldersPerLevel = 5;
    private int m_filesPerLevel = 5;
    private long m_fileSize = 80L;
    private int m_writeSize = 8192;
    private ArrayList<String> m_folderPaths;
    private int m_totalFolders;
    private int m_totalFiles;

    public PerfFolderTreeTest() {
        super("PerfFolderTree");
    }

    @Override
    public void configTest(ConfigElement config) throws InvalidConfigurationException {
        String valueStr = config.getAttribute("folderDepth");
        if (valueStr != null) {
            try {
                this.m_folderDepth = Integer.parseInt(valueStr);
                if (this.m_folderDepth < 2 || this.m_folderDepth > 10) {
                    throw new InvalidConfigurationException("Invalid folder depth (2 - 10)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid folder depth, " + valueStr);
            }
        }
        if ((valueStr = config.getAttribute("foldersPerLevel")) != null) {
            try {
                this.m_foldersPerLevel = Integer.parseInt(valueStr);
                if (this.m_foldersPerLevel < 2 || this.m_foldersPerLevel > 25) {
                    throw new InvalidConfigurationException("Invalid folders per level (2 - 25)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid folders per level, " + valueStr);
            }
        }
        if ((valueStr = config.getAttribute("filessPerLevel")) != null) {
            try {
                this.m_filesPerLevel = Integer.parseInt(valueStr);
                if (this.m_filesPerLevel < 0 || this.m_filesPerLevel > 25) {
                    throw new InvalidConfigurationException("Invalid files per level (0 - 25)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid files per level, " + valueStr);
            }
        }
        if ((valueStr = config.getAttribute("fileSize")) != null) {
            try {
                this.m_fileSize = MemorySize.getByteValue(valueStr);
                if (this.m_fileSize < 1L || this.m_fileSize > 16384L) {
                    throw new InvalidConfigurationException("Invalid file size (1 - 16384)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid file size, " + valueStr);
            }
        }
        if ((valueStr = config.getAttribute("writeSize")) != null) {
            try {
                this.m_writeSize = MemorySize.getByteValueInt(valueStr);
                if (this.m_writeSize < 128 || this.m_writeSize > 65536) {
                    throw new InvalidConfigurationException("Invalid write buffer size (128 - 65536)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid write buffer size, " + valueStr);
            }
        }
    }

    @Override
    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        if (threadId > 1) {
            return new BooleanTestResult(true);
        }
        TestResult result = null;
        try {
            this.m_folderPaths = new ArrayList(1000);
            String testFolder = this.getPerTestFolderName(threadId, iteration);
            this.testLog(log, "Folder Tree Performance Test");
            sess.CreateDirectory(testFolder);
            if (!sess.FileExists(testFolder)) {
                this.testLog(log, "Folder " + testFolder + " does not exist");
                result = new BooleanTestResult(true, "Folder does not exist, " + testFolder);
            } else {
                byte[] ioBuf = new byte[this.m_writeSize];
                Arrays.fill(ioBuf, (byte)65);
                this.m_folderPaths.add(testFolder);
                String curFolder = testFolder;
                if (!curFolder.endsWith("\\")) {
                    curFolder = curFolder + "\\";
                }
                long startTime = System.currentTimeMillis();
                long endTime = 0L;
                ArrayList<String> pathStack = new ArrayList<String>(250);
                ArrayList<String> nextStack = new ArrayList<String>(250);
                pathStack.add(curFolder);
                int curLevel = 1;
                while (curLevel <= this.m_folderDepth && result == null) {
                    try {
                        for (int pathIdx = 0; pathIdx < pathStack.size(); ++pathIdx) {
                            String curPath = (String)pathStack.get(pathIdx);
                            if (!curPath.endsWith("\\")) {
                                curPath = curPath + "\\";
                            }
                            this.createFolderLevel(curPath, sess, curLevel, ioBuf, nextStack);
                            this.m_folderPaths.add((String)pathStack.get(pathIdx));
                        }
                        ++curLevel;
                        ArrayList<String> tempStack = pathStack;
                        pathStack = nextStack;
                        nextStack = tempStack;
                        nextStack.clear();
                    }
                    catch (Exception ex) {
                        Debug.println(ex);
                        result = new ExceptionTestResult(ex);
                    }
                }
                endTime = System.currentTimeMillis();
                if (result == null) {
                    long elapsedMs = endTime - startTime;
                    int ms = (int)(elapsedMs % 1000L);
                    long elapsedSecs = elapsedMs / 1000L;
                    int secs = (int)(elapsedSecs % 60L);
                    int mins = (int)(elapsedSecs / 60L % 60L);
                    int hrs = (int)(elapsedSecs / 3600L);
                    this.testLog(log, "Created folder tree " + this.m_folderDepth + " folders deep (" + this.m_foldersPerLevel + " folders/" + this.m_filesPerLevel + " files per level) in " + hrs + ":" + mins + ":" + secs + "." + ms + " (" + elapsedMs + "ms)");
                    this.testLog(log, "Total of " + this.m_totalFolders + " folders, " + this.m_totalFiles + " files");
                    result = new BooleanTestResult(true);
                }
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    private void createFolderLevel(String rootPath, DiskSession sess, int curLevel, byte[] ioBuf, ArrayList<String> pathStack) throws SMBException, IOException {
        StringBuilder pathStr = new StringBuilder(256);
        for (int folderIdx = 1; folderIdx <= this.m_foldersPerLevel; ++folderIdx) {
            pathStr.setLength(0);
            pathStr.append(rootPath);
            pathStr.append(LevelFolderName);
            pathStr.append(curLevel);
            pathStr.append("_");
            pathStr.append(folderIdx);
            String folderName = pathStr.toString();
            try {
                sess.CreateDirectory(folderName);
            }
            catch (SMBException ex) {
                System.out.println("Error cretaing folder " + folderName);
                throw ex;
            }
            pathStack.add(folderName);
            ++this.m_totalFolders;
        }
        if (this.m_filesPerLevel > 0) {
            for (int fileIdx = 1; fileIdx <= this.m_filesPerLevel; ++fileIdx) {
                pathStr.setLength(0);
                pathStr.append(rootPath);
                pathStr.append(LevelFileName);
                pathStr.append(fileIdx);
                pathStr.append(LevelFileExt);
                String fileName = pathStr.toString();
                SMBFile testFile = sess.CreateFile(fileName);
                for (long fileSize = 0L; fileSize < this.m_fileSize; fileSize += (long)ioBuf.length) {
                    testFile.Write(ioBuf, ioBuf.length, 0);
                }
                testFile.Flush();
                testFile.Close();
                ++this.m_totalFiles;
            }
        }
    }

    @Override
    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        if (threadId == 1) {
            StringBuilder pathStr = new StringBuilder(256);
            for (int pathIdx = this.m_folderPaths.size() - 1; pathIdx > 0; --pathIdx) {
                String curPath = this.m_folderPaths.get(pathIdx);
                if (this.m_filesPerLevel > 0) {
                    for (int fileIdx = 1; fileIdx < this.m_filesPerLevel; ++fileIdx) {
                        pathStr.setLength(0);
                        pathStr.append(curPath);
                        if (!curPath.endsWith("\\")) {
                            pathStr.append("\\");
                        }
                        pathStr.append(LevelFileName);
                        pathStr.append(fileIdx);
                        pathStr.append(LevelFileExt);
                        sess.DeleteFile(pathStr.toString());
                    }
                }
                if (curPath.endsWith("\\")) {
                    curPath = curPath.substring(0, curPath.length() - 1);
                }
                sess.DeleteDirectory(curPath);
            }
        }
    }
}

