/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.IOException;
import java.io.StringWriter;
import org.alfresco.jlan.client.CIFSDiskSession;
import org.alfresco.jlan.client.CIFSFile;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.OplockAdapter;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.smb.OpLock;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;

public class OplockGrantTest
extends Test {
    public OplockGrantTest() {
        super("OplockGrant");
    }

    public boolean runInit(int threadId, int curIter, DiskSession sess) {
        boolean initOK = false;
        if (threadId == 1) {
            try {
                String testFileName = this.getPerTestFileName(threadId, curIter);
                if (sess.FileExists(testFileName)) {
                    if (this.isVerbose()) {
                        Debug.println("File " + testFileName + " exists");
                    }
                    initOK = true;
                } else {
                    SMBFile testFile;
                    if (this.isVerbose()) {
                        Debug.println("Creating file " + testFileName + " via " + sess.getServer());
                    }
                    if ((testFile = sess.CreateFile(testFileName)) != null) {
                        testFile.Close();
                    }
                    if (sess.FileExists(testFileName)) {
                        initOK = true;
                    }
                }
            }
            catch (Exception ex) {
                Debug.println(ex);
            }
        } else {
            initOK = true;
        }
        return initOK;
    }

    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            String testFileName = this.getPerTestFileName(threadId, iteration);
            OplockBreakHandler oplockHandler = new OplockBreakHandler(log);
            CIFSDiskSession cifsSess = (CIFSDiskSession)sess;
            CIFSFile oplockFile = cifsSess.NTCreateWithOplock(testFileName, 6, oplockHandler, 3, 128, 7, 5, 0L, 0);
            this.testLog(log, "Oplock granted, type=" + OpLock.getTypeAsString(oplockFile.getOplockType()) + " on server " + sess.getServer());
            for (int i = 0; i < 8; ++i) {
                this.testSleep(250L);
                sess.pingServer();
            }
            oplockFile.Close();
            result = new BooleanTestResult(true);
            this.testLog(log, "Test completed");
        }
        catch (SMBException ex) {
            if (ex.getErrorClass() == 6 && ex.getErrorCode() == -1073741772) {
                this.testLog(log, "Open failed with object not found error (expected)");
                result = new BooleanTestResult(true, "Object not found error (expected)");
            } else {
                this.testLog(log, "Open failed with wrong error, ex=" + ex);
                result = new ExceptionTestResult(ex);
            }
        }
        catch (IOException ex) {
            this.testLog(log, "Open failed with error, ex=" + ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        if (threadId == 1) {
            sess.DeleteFile(this.getPerTestFileName(threadId, iter));
        }
    }

    public class OplockBreakHandler
    extends OplockAdapter {
        private StringWriter m_log;

        public OplockBreakHandler(StringWriter log) {
            this.m_log = log;
        }

        public void oplockBreak(CIFSFile cifsFile) {
            OplockGrantTest.this.testLog(this.m_log, "Oplock break on file " + cifsFile.getFileName());
            try {
                cifsFile.Flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

