/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.StringWriter;
import org.alfresco.jlan.client.CIFSDiskSession;
import org.alfresco.jlan.client.CIFSFile;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;

public class OpenFileTest
extends Test {
    public OpenFileTest() {
        super("OpenFile");
    }

    public boolean runInit(int threadId, int curIter, DiskSession sess) {
        boolean initOK = false;
        if (threadId == 1) {
            try {
                String testFileName = this.getPerTestFileName(threadId, curIter);
                if (sess.FileExists(testFileName)) {
                    if (this.isVerbose()) {
                        Debug.println("File " + testFileName + " exists");
                    }
                    initOK = true;
                } else {
                    SMBFile testFile;
                    if (this.isVerbose()) {
                        Debug.println("Creating file " + testFileName + " via " + sess.getServer());
                    }
                    if ((testFile = sess.CreateFile(testFileName)) != null) {
                        testFile.Close();
                    }
                    if (sess.FileExists(testFileName)) {
                        initOK = true;
                    }
                }
            }
            catch (Exception ex) {
                Debug.println(ex);
            }
        } else {
            initOK = true;
        }
        return initOK;
    }

    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            String testFileName = this.getPerTestFileName(threadId, iteration);
            this.testLog(log, "OpenFile Test");
            this.testLog(log, "Opening file " + testFileName + " via " + sess.getServer());
            CIFSDiskSession cifsSess = (CIFSDiskSession)sess;
            CIFSFile openFile = null;
            try {
                openFile = cifsSess.NTCreate("\\" + testFileName, 3, 128, 0, 1, 0L, 0);
                if (openFile != null) {
                    this.testLog(log, "Opened file " + testFileName + " with no shared access allowed");
                    this.testSleep(2000L);
                    openFile.Close();
                    result = new BooleanTestResult(true);
                }
            }
            catch (SMBException ex) {
                if (ex.getErrorClass() == 6 && ex.getErrorCode() == -1073741790) {
                    this.testLog(log, "Open failed with access denied error (expected)");
                    result = new BooleanTestResult(true, "Access denied exception (expected)");
                }
                this.testLog(log, "Open failed with wrong error, ex=" + ex);
                result = new ExceptionTestResult(ex);
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        if (threadId == 1) {
            sess.DeleteFile(this.getPerTestFileName(threadId, iter));
        }
    }
}

