/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.StringWriter;
import org.alfresco.jlan.client.CIFSDiskSession;
import org.alfresco.jlan.client.CIFSFile;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;

public class NTCreateFileTest
extends Test {
    public NTCreateFileTest() {
        super("NTCreateFile");
    }

    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            String testFileName = this.getPerTestFileName(threadId, iteration);
            this.testLog(log, "NTCreateFile Test");
            CIFSDiskSession cifsSess = null;
            if (!(sess instanceof CIFSDiskSession)) {
                result = new BooleanTestResult(false, "Not an NT dialect CIFS session");
            }
            if (sess.FileExists(testFileName)) {
                this.testLog(log, "File " + testFileName + " exists");
                result = new BooleanTestResult(true, "File already exists, " + testFileName);
            } else {
                cifsSess = (CIFSDiskSession)sess;
                try {
                    this.testLog(log, "Creating file " + testFileName + " via " + sess.getServer());
                    CIFSFile testFile = cifsSess.NTCreate(testFileName, 3, 128, 1, 2, 0L, 0);
                    if (testFile != null) {
                        testFile.Close();
                    }
                    if (result == null) {
                        if (sess.FileExists(testFileName)) {
                            this.testLog(log, "Re-check, file now exists, " + testFileName);
                            result = new BooleanTestResult(true);
                        } else {
                            this.testLog(log, "** File does not exist after create, " + testFileName);
                            result = new BooleanTestResult(false, "File does not exist after create, " + testFileName);
                        }
                    }
                }
                catch (SMBException ex) {
                    if (ex.getErrorClass() == 6 && ex.getErrorCode() == -1073741790) {
                        this.testLog(log, "Create failed with access denied error (expected), " + testFileName);
                        result = new BooleanTestResult(true);
                    }
                    if (ex.getErrorClass() == 6 && ex.getErrorCode() == -1073741771) {
                        this.testLog(log, "Create failed with object name collision (expected), " + testFileName);
                        result = new BooleanTestResult(true);
                    }
                    ex.printStackTrace();
                    result = new ExceptionTestResult(ex);
                }
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        if (threadId == 1) {
            String fName = this.getPerTestFileName(threadId, iter);
            this.testLog(log, "Cleanup test file " + fName);
            sess.DeleteFile(fName);
        }
    }
}

