/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.StringWriter;
import java.util.ArrayList;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.client.SearchContext;
import org.alfresco.jlan.client.info.FileInfo;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;
import org.springframework.extensions.config.ConfigElement;

public class FolderSearchTest
extends Test {
    private static final String TestFileName = "testFile";
    private static final String TestFileExt = ".txt";
    private static final String TestFolderName = "testFolder";
    private static final int DefaultFileCount = 100;
    private static final int DefaultFolderCount = 100;
    private static final int MinimumFileCount = 10;
    private static final int MaximumFileCount = 5000;
    private static final int MinimumFolderCount = 10;
    private static final int MaximumFolderCount = 5000;
    private int m_fileCount = 100;
    private int m_folderCount = 100;

    public FolderSearchTest() {
        super("FolderSearch");
    }

    public void configTest(ConfigElement config) throws InvalidConfigurationException {
        String valueStr = config.getAttribute("numberOfFiles");
        if (valueStr != null) {
            try {
                this.m_fileCount = Integer.parseInt(valueStr);
                if (this.m_fileCount < 10 || this.m_fileCount > 5000) {
                    throw new InvalidConfigurationException("Invalid file count (10 - 5000)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid file count, " + valueStr);
            }
        }
        if ((valueStr = config.getAttribute("numberOfFolders")) != null) {
            try {
                this.m_folderCount = Integer.parseInt(valueStr);
                if (this.m_folderCount < 10 || this.m_folderCount > 5000) {
                    throw new InvalidConfigurationException("Invalid folder count (10 - 5000)");
                }
            }
            catch (NumberFormatException ex) {
                throw new InvalidConfigurationException("Invalid folder count, " + valueStr);
            }
        }
    }

    public boolean runInit(int threadId, int curIter, DiskSession sess) {
        boolean initOK = false;
        if (threadId == 1) {
            try {
                int fileIdx;
                StringBuilder fnameStr = new StringBuilder(64);
                for (fileIdx = 1; fileIdx <= this.m_fileCount; ++fileIdx) {
                    this.buildFileName(fnameStr, curIter, fileIdx);
                    SMBFile testFile = sess.CreateFile(fnameStr.toString());
                    if (testFile == null) continue;
                    testFile.Close();
                }
                for (fileIdx = 1; fileIdx <= this.m_folderCount; ++fileIdx) {
                    this.buildFolderName(fnameStr, curIter, fileIdx);
                    sess.CreateDirectory(fnameStr.toString());
                }
                initOK = true;
            }
            catch (Exception ex) {
                Debug.println(ex);
            }
        } else {
            initOK = true;
        }
        return initOK;
    }

    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            SearchContext search;
            this.testLog(log, "FolderSearch Test");
            String searchPath = "*.*";
            if (this.getPath() != null) {
                StringBuilder pathStr = new StringBuilder();
                pathStr.append(this.getPath());
                pathStr.append("*.*");
                searchPath = pathStr.toString();
            }
            if ((search = sess.StartSearch(searchPath, 16)) == null) {
                return new BooleanTestResult(false, "Search for *.* failed");
            }
            FileInfo fInfo = search.nextFileInfo();
            if (fInfo == null) {
                return new BooleanTestResult(false, "Null entry returned, expected '.' entry");
            }
            if (!fInfo.getFileName().equals(".")) {
                return new BooleanTestResult(false, "Expected '.' entry, got " + fInfo.getFileName());
            }
            if (!fInfo.isDirectory()) {
                return new BooleanTestResult(false, "'.' entry is not a directory");
            }
            fInfo = search.nextFileInfo();
            if (fInfo == null) {
                return new BooleanTestResult(false, "Null entry returned, expected '..' entry");
            }
            if (!fInfo.getFileName().equals("..")) {
                return new BooleanTestResult(false, "Expected '..' entry, got " + fInfo.getFileName());
            }
            if (!fInfo.isDirectory()) {
                return new BooleanTestResult(false, "'..' entry is not a directory");
            }
            ArrayList<String> fileList = new ArrayList<String>(this.m_fileCount);
            ArrayList<String> folderList = new ArrayList<String>(this.m_folderCount);
            do {
                if ((fInfo = search.nextFileInfo()) == null) continue;
                if (fInfo.isDirectory()) {
                    if (fInfo.getFileName().endsWith(TestFileExt)) {
                        result = new BooleanTestResult(false, "File marked as a folder, " + fInfo.getFileName());
                        continue;
                    }
                    folderList.add(fInfo.getFileName());
                    continue;
                }
                if (fInfo.getFileName().startsWith(TestFolderName)) {
                    result = new BooleanTestResult(false, "Folder marked as a file, " + fInfo.getFileName());
                    continue;
                }
                fileList.add(fInfo.getFileName());
            } while (fInfo != null && result == null);
            if (result == null) {
                int fileIdx;
                StringBuilder fnameStr = new StringBuilder(64);
                String fName = null;
                for (fileIdx = 1; fileIdx <= this.m_fileCount && result == null; ++fileIdx) {
                    this.buildFileName(fnameStr, iteration, fileIdx);
                    fName = fnameStr.toString();
                    if (fileList.contains(fName)) {
                        fileList.remove(fName);
                        continue;
                    }
                    if (!folderList.contains(fName)) continue;
                    result = new BooleanTestResult(false, "Found file name in the folder list, " + fName);
                }
                for (fileIdx = 1; fileIdx <= this.m_folderCount && result == null; ++fileIdx) {
                    this.buildFolderName(fnameStr, iteration, fileIdx);
                    fName = fnameStr.toString();
                    if (folderList.contains(fName)) {
                        folderList.remove(fName);
                        continue;
                    }
                    if (!fileList.contains(fName)) continue;
                    result = new BooleanTestResult(false, "Found folder name in the file list, " + fName);
                }
                if (result == null) {
                    result = fileList.size() > 0 ? new BooleanTestResult(false, "File list contains " + fileList.size() + " unexpected entries") : (folderList.size() > 0 ? new BooleanTestResult(false, "Folder list contains " + folderList.size() + " unexpected entries") : new BooleanTestResult(true));
                }
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }

    public void cleanupTest(int threadId, int iter, DiskSession sess, StringWriter log) throws Exception {
        if (threadId == 1) {
            int fileIdx;
            StringBuilder fnameStr = new StringBuilder(64);
            for (fileIdx = 1; fileIdx <= this.m_fileCount; ++fileIdx) {
                this.buildFileName(fnameStr, iter, fileIdx);
                sess.DeleteFile(fnameStr.toString());
            }
            for (fileIdx = 1; fileIdx <= this.m_folderCount; ++fileIdx) {
                this.buildFolderName(fnameStr, iter, fileIdx);
                sess.DeleteDirectory(fnameStr.toString());
            }
        }
    }

    private void buildFileName(StringBuilder str, int iter, int fileIdx) {
        str.setLength(0);
        str.append(TestFileName);
        str.append("_");
        str.append(iter);
        str.append("_");
        str.append(fileIdx);
        str.append(TestFileExt);
    }

    private void buildFolderName(StringBuilder str, int iter, int fldrIdx) {
        str.setLength(0);
        str.append(TestFolderName);
        str.append("_");
        str.append(iter);
        str.append("_");
        str.append(fldrIdx);
    }
}

