/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.StringWriter;
import org.alfresco.jlan.client.CIFSDiskSession;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;

public class DeleteFolderTest
extends Test {
    public DeleteFolderTest() {
        super("DeleteFolder");
    }

    public boolean runInit(int threadId, int curIter, DiskSession sess) {
        boolean initOK = false;
        if (threadId == 1) {
            try {
                String testFolderName = this.getPerTestFolderName(threadId, curIter);
                if (sess.FileExists(testFolderName) && sess.isDirectory(testFolderName)) {
                    Debug.println("Folder " + testFolderName + " exists");
                    initOK = true;
                } else {
                    if (this.isVerbose()) {
                        Debug.println("Creating folder " + testFolderName + " via " + sess.getServer());
                    }
                    sess.CreateDirectory(testFolderName);
                    if (sess.FileExists(testFolderName)) {
                        initOK = true;
                    }
                }
            }
            catch (Exception ex) {
                Debug.println("Init error");
                Debug.println(ex);
            }
        } else {
            initOK = true;
        }
        return initOK;
    }

    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            String testFolderName = this.getPerTestFolderName(threadId, iteration);
            CIFSDiskSession cifsSess = (CIFSDiskSession)sess;
            try {
                cifsSess.DeleteDirectory(testFolderName);
                this.testLog(log, "Deleted folder " + testFolderName + " on server " + sess.getServer());
            }
            catch (Exception ex) {
                this.testLog(log, "Error deleting folder " + testFolderName + " on server " + sess.getServer() + ", ex=" + ex.getMessage());
            }
            if (cifsSess.FileExists(testFolderName) && cifsSess.isDirectory(testFolderName)) {
                this.testLog(log, "Folder status on server " + sess.getServer() + "=Exists");
                result = new BooleanTestResult(false);
            } else {
                this.testLog(log, "Folder status on server " + sess.getServer() + "=NotExist");
                result = new BooleanTestResult(true);
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }
}

