/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.StringWriter;
import org.alfresco.jlan.client.CIFSDiskSession;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;

public class DeleteFileTest
extends Test {
    public DeleteFileTest() {
        super("DeleteFile");
    }

    public boolean runInit(int threadId, int curIter, DiskSession sess) {
        boolean initOK = false;
        if (threadId == 1) {
            try {
                String testFileName = this.getPerTestFileName(threadId, curIter);
                if (sess.FileExists(testFileName)) {
                    Debug.println("File " + testFileName + " exists");
                    initOK = true;
                } else {
                    SMBFile testFile;
                    if (this.isVerbose()) {
                        Debug.println("Creating file " + testFileName + " via " + sess.getServer());
                    }
                    if ((testFile = sess.CreateFile(testFileName)) != null) {
                        testFile.Close();
                    }
                    if (sess.FileExists(testFileName)) {
                        initOK = true;
                    }
                }
            }
            catch (Exception ex) {}
        } else {
            initOK = true;
        }
        return initOK;
    }

    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            String testFileName = this.getPerTestFileName(threadId, iteration);
            CIFSDiskSession cifsSess = (CIFSDiskSession)sess;
            try {
                cifsSess.DeleteFile(testFileName);
                this.testLog(log, "Deleted file " + testFileName + " on server " + sess.getServer());
            }
            catch (Exception ex) {
                this.testLog(log, "Error deleting file " + testFileName + " on server " + sess.getServer() + ", ex=" + ex.getMessage());
            }
            if (cifsSess.FileExists(testFileName)) {
                this.testLog(log, "File status on server " + sess.getServer() + "=Exists");
                result = new BooleanTestResult(false);
            } else {
                this.testLog(log, "File status on server " + sess.getServer() + "=NotExist");
                result = new BooleanTestResult(true);
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }
}

