/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.test.cluster;

import java.io.StringWriter;
import org.alfresco.jlan.client.DiskSession;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.test.cluster.BooleanTestResult;
import org.alfresco.jlan.test.cluster.ExceptionTestResult;
import org.alfresco.jlan.test.cluster.Test;
import org.alfresco.jlan.test.cluster.TestResult;

public class ConcurrentCreateFileTest
extends Test {
    private static final String TestFileName = "createFile";
    private static final String TestFileExt = ".txt";

    public ConcurrentCreateFileTest() {
        super("CreateFile");
    }

    public TestResult runTest(int threadId, int iteration, DiskSession sess, StringWriter log) {
        TestResult result = null;
        try {
            String testFileName = "createFile_" + iteration + TestFileExt;
            this.testLog(log, "CreateFile Test");
            if (sess.FileExists(testFileName)) {
                this.testLog(log, "File " + testFileName + " exists");
            } else {
                this.testLog(log, "Creating file " + testFileName + " via " + sess.getServer());
                SMBFile testFile = sess.CreateFile(testFileName);
                if (testFile != null) {
                    testFile.Close();
                }
                if (sess.FileExists(testFileName)) {
                    this.testLog(log, "Re-check, file now exists");
                    result = new BooleanTestResult(true);
                } else {
                    this.testLog(log, "** File does not exist after create");
                    result = new BooleanTestResult(false);
                }
                if (this.hasTestCleanup() && threadId == 1) {
                    sess.DeleteFile(testFileName);
                }
            }
            this.testLog(log, "Test completed");
        }
        catch (Exception ex) {
            Debug.println(ex);
            result = new ExceptionTestResult(ex);
        }
        return result;
    }
}

