/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.win32;

import java.io.IOException;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.win32.NetBIOS;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.smb.server.CIFSPacketPool;
import org.alfresco.jlan.smb.server.PacketHandler;
import org.alfresco.jlan.smb.server.SMBSrvPacket;

public class Win32NetBIOSPacketHandler
extends PacketHandler {
    private static final int ReceiveErrorMask = -16777216;
    private static final int ReceiveLengthMask = 65535;
    private int m_lana;
    private int m_lsn;

    public Win32NetBIOSPacketHandler(int lana, int lsn, String callerName, CIFSPacketPool packetPool) {
        super(2, "Win32NB", "WNB", callerName, packetPool);
        this.m_lana = lana;
        this.m_lsn = lsn;
    }

    public final int getLANA() {
        return this.m_lana;
    }

    public final int getLSN() {
        return this.m_lsn;
    }

    public int availableBytes() throws IOException {
        return -1;
    }

    public SMBSrvPacket readPacket() throws IOException {
        SMBSrvPacket pkt = this.getPacketPool().allocatePacket(this.getPacketPool().getLargestSize());
        try {
            int rxLen;
            int pktLen = pkt.getBuffer().length;
            if (pktLen > 65535) {
                pktLen = 65535;
            }
            if (((rxLen = Win32NetBIOS.Receive(this.m_lana, this.m_lsn, pkt.getBuffer(), 4, pktLen - 4)) & 0xFF000000) != 0) {
                int sts = (rxLen & 0xFF000000) >> 24;
                if (sts == 6) {
                    int rxLen2;
                    if (this.hasDebug()) {
                        Debug.println("Win32NetBIOSPacketHandle: readPacket() NRC_Incomp error");
                    }
                    if (pkt.getBuffer().length < this.getPacketPool().getMaximumOverSizedAllocation()) {
                        SMBSrvPacket pkt2 = this.getPacketPool().allocatePacket(this.getPacketPool().getMaximumOverSizedAllocation());
                        System.arraycopy(pkt.getBuffer(), 4, pkt2.getBuffer(), 4, pktLen - 4);
                        this.getPacketPool().releasePacket(pkt);
                        pkt = pkt2;
                        if (this.hasDebug()) {
                            Debug.println("readPacket() extended buffer to " + pkt.getBuffer().length);
                        }
                    }
                    if (((rxLen2 = Win32NetBIOS.Receive(this.m_lana, this.m_lsn, pkt.getBuffer(), (rxLen &= 0xFFFF) + 4, 32768)) & 0xFF000000) != 0) {
                        sts = (rxLen2 & 0xFF000000) >> 24;
                        throw new IOException("Win32 NetBIOS multi-part receive failed, sts=0x" + sts + ", err=" + NetBIOS.getErrorString(sts));
                    }
                    if (this.hasDebug()) {
                        Debug.println("readPacket() rxlen2=" + rxLen2 + ", total read len = " + (rxLen + rxLen2));
                    }
                    rxLen += rxLen2;
                } else {
                    throw new IOException(NetBIOS.getErrorString(sts));
                }
            }
            if (pkt != null) {
                pkt.setReceivedLength(rxLen);
            }
        }
        catch (Throwable t) {
            this.getPacketPool().releasePacket(pkt);
            this.rethrowException(t);
        }
        return pkt;
    }

    public void writePacket(SMBSrvPacket pkt, int len, boolean writeRaw) throws IOException {
        Win32NetBIOS.Send(this.m_lana, this.m_lsn, pkt.getBuffer(), 4, len);
    }

    public void flushPacket() throws IOException {
    }

    public void closeHandler() {
        super.closeHandler();
        Win32NetBIOS.Hangup(this.m_lana, this.m_lsn);
    }
}

