/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server;

import java.io.IOException;
import java.net.Socket;
import org.alfresco.jlan.smb.server.CIFSPacketPool;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SocketPacketHandler;
import org.alfresco.jlan.util.DataPacker;

public class NetBIOSPacketHandler
extends SocketPacketHandler {
    private byte[] m_headerBuf = new byte[4];

    public NetBIOSPacketHandler(Socket sock, CIFSPacketPool packetPool) throws IOException {
        super(sock, 0, "NetBIOS", "NB", packetPool);
    }

    public final SMBSrvPacket readPacket() throws IOException {
        int offset;
        int len = this.readBytes(this.m_headerBuf, 0, 4);
        if (len == -1) {
            throw new IOException("Connection closed (header read)");
        }
        if (len < 4) {
            throw new IOException("Invalid NetBIOS header, len=" + len);
        }
        int typ = this.m_headerBuf[0] & 0xFF;
        byte flags = this.m_headerBuf[1];
        int dlen = DataPacker.getShort(this.m_headerBuf, 2);
        if ((flags & 1) != 0) {
            dlen += 65536;
        }
        if (typ == 133) {
            return null;
        }
        SMBSrvPacket pkt = this.getPacketPool().allocatePacket(dlen + 4);
        int totlen = offset = 4;
        try {
            while (dlen > 0) {
                len = this.readBytes(pkt.getBuffer(), offset, dlen);
                if (len == -1) {
                    throw new IOException("Connection closed (request read)");
                }
                totlen += len;
                dlen -= len;
                offset += len;
            }
        }
        catch (Throwable ex) {
            this.getPacketPool().releasePacket(pkt);
            this.rethrowException(ex);
        }
        System.arraycopy(this.m_headerBuf, 0, pkt.getBuffer(), 0, 4);
        pkt.setReceivedLength(totlen);
        return pkt;
    }

    public final void writePacket(SMBSrvPacket pkt, int len, boolean writeRaw) throws IOException {
        byte[] buf = pkt.getBuffer();
        if (!writeRaw) {
            buf[0] = 0;
            buf[1] = 0;
            if (len > 65535) {
                buf[1] = 1;
                DataPacker.putShort((short)(len & 0xFFFF), buf, 2);
            } else {
                DataPacker.putShort((short)len, buf, 2);
            }
            len += 4;
        }
        this.writeBytes(buf, 0, len);
    }
}

